/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.gameengines.vnovels;

import com.badlogic.gdx.math.Rectangle;
import com.youkaicountry.util.config.INILoader;
import com.youkaicountry.vnand.VNAnd;
import com.youkaicountry.vnand.gameengines.vnovels.VNSprite;
import com.youkaicountry.vnand.screens.VNScreen;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;

public class ScreenMode {
    public String name;
    public Mode mode;
    public TextboxMode textbox_mode;
    public Rectangle text_loc;
    public String font;
    public boolean wait_clear;
    public VNSprite default_textbox;

    public ScreenMode(String name, Mode mode, TextboxMode textbox_mode, Rectangle text_loc, String font, boolean wait_clear, String default_textbox) {
        this.name = name;
        this.mode = mode;
        this.textbox_mode = textbox_mode;
        this.text_loc = text_loc;
        this.font = font;
        this.wait_clear = wait_clear;
        if (default_textbox != null) {
            this.default_textbox = ((VNScreen)VNAnd.current_screen).vn.getCustomTextbox(default_textbox);
        }
    }

    public ScreenMode(BufferedReader reader) {
        String t;
        HashMap<String, String> data = null;
        try {
            data = INILoader.loadBasicINI(reader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.name = data.get("name").trim();
        String m = data.get("orientation").trim();
        if (m.equals("single")) {
            this.mode = Mode.SINGLE;
        }
        if (m.equals("dual-bottom")) {
            this.mode = Mode.DUAL_BOTTOM;
        }
        if (m.equals("dual-right")) {
            this.mode = Mode.DUAL_RIGHT;
        }
        if ((t = data.get("textbox").trim()).equals("custom")) {
            this.textbox_mode = TextboxMode.CUSTOM;
        }
        if (t.equals("default-bottom")) {
            this.textbox_mode = TextboxMode.DEFAULT_BOTTOM;
        }
        if (t.equals("default-full")) {
            this.textbox_mode = TextboxMode.DEFAULT_FULL;
        }
        String wc = data.get("waitclear").trim();
        this.wait_clear = wc.equals("true");
        String tl = data.get("textloc").trim();
        String[] tlp = tl.split(",");
        float x = Float.parseFloat(tlp[0]) * ((VNScreen)VNAnd.current_screen).vn.image_scalex;
        float y = (((VNScreen)VNAnd.current_screen).vn.image_height - Float.parseFloat(tlp[1])) * ((VNScreen)VNAnd.current_screen).vn.image_scaley;
        float w = Float.parseFloat(tlp[2]) * ((VNScreen)VNAnd.current_screen).vn.image_scalex;
        float h = Float.parseFloat(tlp[3]) * ((VNScreen)VNAnd.current_screen).vn.image_scaley;
        this.text_loc = new Rectangle(x, y, w, h);
        this.default_textbox = ((VNScreen)VNAnd.current_screen).vn.getCustomTextbox(data.get("defaulttextbox"));
        this.font = data.get("font");
    }

    public static enum TextboxMode {
        DEFAULT_FULL,
        DEFAULT_BOTTOM,
        CUSTOM,
        NONE;

    }

    public static enum Mode {
        DUAL_BOTTOM,
        DUAL_RIGHT,
        SINGLE;

    }
}

