/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.gameengines.vnovels;

import com.youkaicountry.vnand.gameengines.vnovels.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableBox {
    static final Pattern var_re = Pattern.compile("\\{\\$([a-zA-z0-9_\\.\\-]*)\\}|\\$([a-zA-z0-9_]*)");
    HashMap<String, Variable> variables = new HashMap();
    private boolean case_sensitive;

    public VariableBox() {
        this.case_sensitive = true;
    }

    public VariableBox(boolean case_sensitive) {
        this.case_sensitive = case_sensitive;
    }

    public boolean contains(String variable) {
        return this.variables.containsKey(variable);
    }

    public void setVariable(String variable, String value) {
        if (this.variables.containsKey(variable)) {
            Variable v = this.variables.get(variable);
            v.setValue(value);
        } else {
            Variable v = new Variable(variable, value, true);
            this.setVariable(v);
        }
    }

    public void setVariable(String variable, float value) {
        this.setVariable(variable, "" + value);
    }

    public void setVariable(String variable, int value) {
        this.setVariable(variable, "" + value);
    }

    public void setVariable(String variable, String value, boolean local) {
        if (this.variables.containsKey(variable)) {
            Variable v = this.variables.get(variable);
            v.local = local;
            v.setValue(value);
        } else {
            Variable v = new Variable(variable, value, local);
            this.setVariable(v);
        }
    }

    public void setVariable(String variable, float value, boolean local) {
        this.setVariable(variable, "" + value, local);
    }

    public void setVariable(String variable, int value, boolean local) {
        this.setVariable(variable, "" + value, local);
    }

    public void setVariable(Variable v) {
        this.variables.put(v.name, v);
    }

    public Variable getVariable(String variable) {
        if (this.variables.containsKey(variable)) {
            return this.variables.get(variable);
        }
        throw new RuntimeException("Variable " + variable + " hasn't been assigned.");
    }

    public void clearLocalVariables() {
        ArrayList<String> clear = new ArrayList<String>();
        for (String s : this.variables.keySet()) {
            Variable v = this.variables.get(s);
            if (!v.local) continue;
            clear.add(s);
        }
        for (String s : clear) {
            this.variables.remove(s);
        }
    }

    public void clearGlobalVariables() {
        ArrayList<String> clear = new ArrayList<String>();
        for (String s : this.variables.keySet()) {
            Variable v = this.variables.get(s);
            if (v.local) continue;
            clear.add(s);
        }
        for (String s : clear) {
            this.variables.remove(s);
        }
    }

    public void removeVariable(String variable) {
        this.variables.remove(variable);
    }

    public float getVal(String v) {
        float ov;
        if (this.contains(v)) {
            return this.getVariable(v).getNumericValue();
        }
        try {
            ov = Float.parseFloat(v);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
        return ov;
    }

    public String getValAsString(String v) {
        if (v.charAt(0) == '\"') {
            v = v.replace("\"", "");
            return v;
        }
        if (this.contains(v)) {
            Variable var = this.getVariable(v);
            String val = var.getValue();
            return val;
        }
        String ov = "";
        try {
            ov = "" + Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            return "0";
        }
        return ov;
    }

    public String replaceVars(String s) {
        Matcher m = var_re.matcher(s);
        StringBuffer sb = new StringBuffer(s.length());
        while (m.find()) {
            String varname = m.group(1) == null ? m.group(2) : m.group(1);
            m.appendReplacement(sb, Matcher.quoteReplacement("" + this.getValAsString(varname)));
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

