/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.gameengines.vnovels;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.utils.Json;
import com.youkaicountry.vnand.VNAnd;
import com.youkaicountry.vnand.actors.VNButton;
import com.youkaicountry.vnand.gameengines.vnovels.ScreenModeManager;
import com.youkaicountry.vnand.gameengines.vnovels.VNMusic;
import com.youkaicountry.vnand.gameengines.vnovels.VNSave;
import com.youkaicountry.vnand.gameengines.vnovels.VNSettings;
import com.youkaicountry.vnand.gameengines.vnovels.VNSprite;
import com.youkaicountry.vnand.gameengines.vnovels.VariableBox;
import com.youkaicountry.vnand.gameengines.vnovels.script.InstructionSet;
import com.youkaicountry.vnand.screens.VNScreen;
import com.youkaicountry.vnand.utils.ImageUtils;
import com.youkaicountry.vnand.utils.assethandling.assets.FontAsset;
import com.youkaicountry.vnand.utils.assethandling.assets.ImageAsset;
import com.youkaicountry.vnand.utils.assethandling.assets.SpriteAsset;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Random;

public abstract class VisualNovel {
    public FileHandle novel_fh;
    public VNSettings settings;
    public VariableBox variables;
    public InstructionSet instructionset;
    public boolean blocked;
    public float image_width;
    public float image_height;
    public float image_scalex;
    public float image_scaley;
    String jump_script;
    String jump_label;
    int jump_position;
    public Random r;

    public VisualNovel(FileHandle novel_fh) {
        this.novel_fh = novel_fh;
        this.r = new Random();
        this.variables = new VariableBox();
        this.instructionset = new InstructionSet(this);
        this.blocked = false;
    }

    protected abstract void makeSettings();

    public abstract void init();

    public abstract void cleanup();

    public abstract VNSprite getFullTextbox();

    public abstract VNSprite getPartialTextbox();

    public abstract VNSprite getCustomTextbox(String var1);

    public abstract FileHandle getSaveLoc();

    public void fullSave(String base_name) {
        FileHandle savedir = this.getSaveLoc();
        ImageUtils.saveScreenshot(savedir.child(base_name + ".png"), 256, 192);
        this.save(base_name + ".sav");
    }

    public void fullSave(String base_name, Pixmap thumbnail) {
        FileHandle savedir = this.getSaveLoc();
        ImageUtils.saveScreenshot(savedir.child(base_name + ".png"), thumbnail, 256, 192);
        this.save(base_name + ".sav");
    }

    public void save(String filename) {
        FileHandle savedir = this.getSaveLoc();
        FileHandle fh = savedir.child(filename);
        Writer writer = fh.writer(false);
        this.save(writer);
        try {
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save(Writer writer) {
        String latest;
        VNSave save = new VNSave();
        save.script = this.instructionset.current_script;
        save.position = this.instructionset.getReportedInstructionLocation();
        save.backgrounds = ((VNScreen)VNAnd.current_screen).background_locs;
        save.music = ((VNScreen)VNAnd.current_screen).audio.music_loc;
        save.music_looping = ((VNScreen)VNAnd.current_screen).audio.current_music == null ? false : ((VNScreen)VNAnd.current_screen).audio.music_looping;
        ((VNScreen)VNAnd.current_screen).sprites.fillSave(save);
        save.show_text = ((VNScreen)VNAnd.current_screen).text.textbox_enabled;
        save.latest_text = latest = ((VNScreen)VNAnd.current_screen).text.getLatestLinesAsText(3);
        save.latest_font = "default";
        save.buttons = ((VNScreen)VNAnd.current_screen).buttons.getButtons();
        save.saveVariables(this.variables);
        Json json = new Json();
        String data = json.toJson(save);
        try {
            writer.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load(String filename) {
        FileHandle savedir = this.getSaveLoc();
        FileHandle fh = savedir.child(filename);
        if (!fh.exists()) {
            return;
        }
        Reader r = fh.reader();
        this.load(r);
        try {
            r.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load(Reader reader) {
        Json json = new Json();
        VNSave save = json.fromJson(VNSave.class, reader);
        this.load(save);
    }

    public void load(VNSave save) {
        ((VNScreen)VNAnd.current_screen).buttons.clear();
        this.setJump(save.script, null, save.position);
        ((VNScreen)VNAnd.current_screen).clearBackgrounds();
        for (String string : save.backgrounds) {
            ((VNScreen)VNAnd.current_screen).addBackground(this.getBackground(string), string);
        }
        if (save.music != null) {
            ((VNScreen)VNAnd.current_screen).audio.playMusic(this.getMusic(save.music), save.music, save.music_looping);
        }
        ((VNScreen)VNAnd.current_screen).clearSprites();
        for (int i = 0; i < save.sprites.size(); ++i) {
            SpriteAsset spriteAsset = new SpriteAsset(save.sprites.get(i));
            this.positionImage(spriteAsset, save.sprite_x.get(i).floatValue(), save.sprite_y.get(i).floatValue());
            ((VNScreen)VNAnd.current_screen).addSprite(spriteAsset, spriteAsset.x_pos, spriteAsset.y_pos);
        }
        this.variables.clearLocalVariables();
        save.loadVariables(this.variables);
        if (save.show_text) {
            ((VNScreen)VNAnd.current_screen).text.showTextbox();
        } else {
            ((VNScreen)VNAnd.current_screen).text.hideTextbox();
        }
        ((VNScreen)VNAnd.current_screen).text.clearText();
        if (save.latest_text != null) {
            ((VNScreen)VNAnd.current_screen).text.setCurrentFont(save.latest_font);
            ((VNScreen)VNAnd.current_screen).text.addText(save.latest_text);
        }
        ((VNScreen)VNAnd.current_screen).buttons.clear();
        if (save.buttons != null) {
            for (VNButton vNButton : save.buttons) {
                ((VNScreen)VNAnd.current_screen).buttons.addButton(vNButton);
            }
        }
    }

    public void setJump(String script) {
        this.setJump(script, null);
    }

    public void setJump(String script, String label) {
        this.setJump(script, label, 0);
    }

    public void setJump(String script, String label, int position) {
        this.jump_script = script;
        this.blocked = true;
        this.jump_label = label;
        this.jump_position = position;
    }

    public void update() {
        if (this.jump_script != null) {
            ((VNScreen)VNAnd.current_screen).assets.sounds.unloadAllAssets();
            if (((VNScreen)VNAnd.current_screen).audio.current_music != null) {
                ((VNScreen)VNAnd.current_screen).assets.music.unloadAllBut(((VNScreen)VNAnd.current_screen).audio.music_loc);
            }
            ((VNScreen)VNAnd.current_screen).deflateAssets();
            try {
                this.loadScript(this.jump_script);
                this.instructionset.current_script = this.jump_script;
                this.instructionset.changeInstructionLocation(this.jump_position);
                if (this.jump_label != null) {
                    this.instructionset.gotoLabel(this.jump_label);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.jump_script = null;
            this.jump_label = null;
            this.jump_position = 0;
            this.blocked = false;
            ((VNScreen)VNAnd.current_screen).inflateAssets();
        }
        this.instructionset.update();
    }

    protected FontAsset getFont(FileHandle fh, int width, int supersample, FreeTypeFontGenerator.FreeTypeFontParameter param) {
        int font_width = width;
        FontAsset fa = new FontAsset("");
        fa.setData(fh, width, supersample, param);
        return fa;
    }

    public abstract void loadScript(String var1) throws IOException;

    public abstract VNSprite getBackground(String var1);

    public abstract VNSprite getBackgroundAnimation(String[] var1, float var2, int var3);

    public abstract Sound getSound(String var1);

    public abstract VNMusic getMusic(String var1);

    public abstract VNSprite getImage(String var1, String var2);

    public abstract VNSprite getAnimation(String[] var1, float var2);

    public abstract void positionImage(ImageAsset var1, float var2, float var3);

    public abstract ScreenModeManager makeScreenModeManager();

    public abstract String getDefaultScreenMode();

    public abstract void loadFonts();
}

