/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.gameengines.vnovels;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.math.Rectangle;
import com.youkaicountry.vnand.VNAnd;
import com.youkaicountry.vnand.gameengines.vnovels.ScreenMode;
import com.youkaicountry.vnand.gameengines.vnovels.ScreenModeManager;
import com.youkaicountry.vnand.gameengines.vnovels.VNMusic;
import com.youkaicountry.vnand.gameengines.vnovels.VNSettings;
import com.youkaicountry.vnand.gameengines.vnovels.VNSprite;
import com.youkaicountry.vnand.gameengines.vnovels.VisualNovel;
import com.youkaicountry.vnand.gameengines.vnovels.script.InstructionSet;
import com.youkaicountry.vnand.gameengines.vnovels.script.kamishibaiparse.KamishibaiParser;
import com.youkaicountry.vnand.gameengines.vnovels.vnsprites.VNAnimatedSprite;
import com.youkaicountry.vnand.screens.VNScreen;
import com.youkaicountry.vnand.utils.assethandling.assets.FontAsset;
import com.youkaicountry.vnand.utils.assethandling.assets.ImageAsset;
import com.youkaicountry.vnand.utils.text.VNFont;
import com.youkaicountry.vnand.utils.wave8.Wave8Sound;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.zip.ZipFile;

public class VisualNovelKamishibai
extends VisualNovel {
    boolean has_music_zip;
    ZipFile music_zip;
    FileHandle music_dir;
    boolean has_sound_zip;
    ZipFile sound_zip;
    FileHandle sound_dir;
    boolean has_image_zip;
    ZipFile image_zip;
    FileHandle image_dir;
    String default_screen_mode;

    public VisualNovelKamishibai(FileHandle novel_fh) {
        super(novel_fh);
        this.makeSettings();
        try {
            this.loadScript(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() {
        this.loadFonts();
    }

    @Override
    public void cleanup() {
    }

    @Override
    public VNSprite getFullTextbox() {
        return null;
    }

    @Override
    public VNSprite getPartialTextbox() {
        return null;
    }

    @Override
    public VNSprite getCustomTextbox(String name) {
        return null;
    }

    @Override
    public FileHandle getSaveLoc() {
        return null;
    }

    @Override
    public void loadScript(String script) throws IOException {
        FileHandle scriptfh = this.novel_fh.child("gamefile.txt");
        KamishibaiParser kp = new KamishibaiParser(new InstructionSet(this));
        kp.parseScript(new BufferedReader(scriptfh.reader()));
        this.instructionset = kp.iset;
        this.image_dir = this.getAnyCaseFile(this.novel_fh, kp.image_loc);
        this.music_dir = this.getAnyCaseFile(this.novel_fh, kp.music_loc);
        this.sound_dir = this.getAnyCaseFile(this.novel_fh, kp.sound_loc);
    }

    @Override
    public VNSprite getBackground(String name) {
        return null;
    }

    @Override
    public VNSprite getBackgroundAnimation(String[] names, float delay, int loop_times) {
        System.out.println("REACH");
        Sprite[] sprites = new Sprite[names.length];
        for (int i = 0; i < names.length; ++i) {
            sprites[i] = this.loadImage(names[i]);
        }
        return new VNAnimatedSprite(sprites, delay, loop_times);
    }

    private Sprite loadImage(String name) {
        FileHandle rf = this.getAnyCaseFile(this.image_dir, name);
        Pixmap p = VNAnd.bitmap_loader.load(rf);
        Texture t = new Texture(p);
        Sprite s = new Sprite(t);
        s.setPosition(0.0f, 0.0f);
        s.setOrigin(0.0f, 0.0f);
        s.setScale(1.0f);
        return s;
    }

    private FileHandle getAnyCaseFile(FileHandle fh, String name) {
        FileHandle ufh = fh.child(name);
        if (ufh.exists()) {
            return ufh;
        }
        String cname = name.toLowerCase();
        FileHandle[] files = fh.list();
        for (int i = 0; i < files.length; ++i) {
            String rname = files[i].name().toLowerCase();
            if (!rname.equals(cname)) continue;
            return files[i];
        }
        return null;
    }

    @Override
    public Sound getSound(String name) {
        System.out.println("Loading sound from dir " + this.sound_dir.name());
        System.out.println("Loading sound " + name);
        FileHandle mfh = this.getAnyCaseFile(this.sound_dir, name);
        Sound s = null;
        try {
            s = Gdx.audio.newSound(mfh);
        }
        catch (Exception e) {
            s = new Wave8Sound(mfh);
        }
        return s;
    }

    @Override
    public VNMusic getMusic(String name) {
        FileHandle mfh = this.getAnyCaseFile(this.music_dir, name);
        VNAnd.midi_player.load(mfh);
        return VNAnd.midi_player;
    }

    @Override
    public VNSprite getImage(String name, String params) {
        return null;
    }

    @Override
    public VNSprite getAnimation(String[] names, float delay) {
        return null;
    }

    @Override
    public void positionImage(ImageAsset asset, float x, float y) {
    }

    @Override
    public ScreenModeManager makeScreenModeManager() {
        ScreenModeManager out = new ScreenModeManager();
        out.addMode(new ScreenMode("ds_right", ScreenMode.Mode.DUAL_RIGHT, ScreenMode.TextboxMode.NONE, new Rectangle(10.0f, 110.0f, 180.0f, 108.0f), "default", false, null));
        return out;
    }

    @Override
    public String getDefaultScreenMode() {
        return "ds_right";
    }

    @Override
    protected void makeSettings() {
        this.settings = new VNSettings();
        this.settings.setSetting("width", 200.0f);
        this.settings.setSetting("height", 112.0f);
        this.settings.setSetting("dual_screen", 1.0f);
        this.settings.setSetting("text_screen", 1.0f);
    }

    @Override
    public void loadFonts() {
        FileHandle fh = Gdx.files.internal("fonts/sazanami.ttf");
        FreeTypeFontGenerator.FreeTypeFontParameter param = VNFont.getDefaultParams(8);
        param.size = 8;
        FontAsset fa = this.getFont(fh, 4, 4, param);
        ((VNScreen)VNAnd.current_screen).text.addFont("default", fa);
    }
}

