/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.gameengines.vnovels;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.MusicLoader;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.math.Rectangle;
import com.youkaicountry.util.config.INILoader;
import com.youkaicountry.vnand.VNAnd;
import com.youkaicountry.vnand.gameengines.vnovels.ScreenMode;
import com.youkaicountry.vnand.gameengines.vnovels.ScreenModeManager;
import com.youkaicountry.vnand.gameengines.vnovels.VNMusic;
import com.youkaicountry.vnand.gameengines.vnovels.VNSettings;
import com.youkaicountry.vnand.gameengines.vnovels.VNSprite;
import com.youkaicountry.vnand.gameengines.vnovels.VisualNovel;
import com.youkaicountry.vnand.gameengines.vnovels.script.InstructionSet;
import com.youkaicountry.vnand.gameengines.vnovels.script.vndsparse.VNDSLiteParser;
import com.youkaicountry.vnand.gameengines.vnovels.vnmusics.VNNormalMusic;
import com.youkaicountry.vnand.gameengines.vnovels.vnsprites.VNSingleSprite;
import com.youkaicountry.vnand.screens.VNScreen;
import com.youkaicountry.vnand.utils.ArchiveFileHandleResolver;
import com.youkaicountry.vnand.utils.FileUtil;
import com.youkaicountry.vnand.utils.assethandling.assets.FontAsset;
import com.youkaicountry.vnand.utils.assethandling.assets.ImageAsset;
import com.youkaicountry.vnand.utils.text.VNFont;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class VisualNovelVNAnd
extends VisualNovel {
    FreeTypeFontGenerator fffg;
    boolean has_foreground_zip;
    ZipFile foreground_zip;
    boolean has_background_zip;
    ZipFile background_zip;
    boolean has_script_zip;
    ZipFile script_zip;
    boolean has_sound_zip;
    ZipFile sound_zip;
    AssetManager soundman;
    String default_screen_mode;
    static String[] sound_exts = new String[]{"ogg", "mp3", "wav", "aac", "mid"};
    static String[] image_exts = new String[]{"png", "jpg", "jpeg", "bmp"};

    public VisualNovelVNAnd(FileHandle novel_fh) {
        super(novel_fh);
        this.makeSettings();
        this.variables.setVariable("selected", 0, true);
        this.setJump("main.scr");
        FileHandle sz = this.novel_fh.child("script.zip");
        FileHandle bz = this.novel_fh.child("background.zip");
        FileHandle fz = this.novel_fh.child("foreground.zip");
        FileHandle oz = this.novel_fh.child("sound.zip");
        try {
            if (sz.exists()) {
                this.has_script_zip = true;
                this.script_zip = new ZipFile(sz.file());
            } else {
                this.has_script_zip = false;
            }
            if (bz.exists()) {
                this.has_background_zip = true;
                this.background_zip = new ZipFile(bz.file());
            } else {
                this.has_background_zip = false;
            }
            if (fz.exists()) {
                this.has_foreground_zip = true;
                this.foreground_zip = new ZipFile(fz.file());
            } else {
                this.has_foreground_zip = false;
            }
            if (oz.exists()) {
                this.has_sound_zip = true;
                this.sound_zip = new ZipFile(oz.file());
                ArchiveFileHandleResolver resolver = new ArchiveFileHandleResolver(this.sound_zip);
                this.soundman = new AssetManager(resolver);
                this.soundman.setLoader(Music.class, new MusicLoader(resolver));
            } else {
                this.has_sound_zip = false;
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.readImageRes();
        this.loadVNAndSettings();
    }

    public void readImageRes() {
        HashMap<String, String> image_ini;
        this.image_width = 256.0f;
        this.image_height = 192.0f;
        this.image_scalex = 1.0f;
        this.image_scaley = 1.0f;
        FileHandle fh = this.novel_fh.child("img.ini");
        if (!fh.exists()) {
            return;
        }
        try {
            image_ini = INILoader.loadBasicINI(new BufferedReader(fh.reader()));
        }
        catch (IOException e) {
            return;
        }
        for (String key : image_ini.keySet()) {
            if (key.toLowerCase().equals("width")) {
                this.image_width = Integer.parseInt(image_ini.get(key));
                continue;
            }
            if (!key.toLowerCase().equals("height")) continue;
            this.image_height = Integer.parseInt(image_ini.get(key));
        }
        this.image_scalex = 256.0f / this.image_width;
        this.image_scaley = 192.0f / this.image_height;
    }

    @Override
    public void init() {
        this.loadFonts();
        FileUtil.cleanAndroidTempDirectory();
    }

    @Override
    public void cleanup() {
        FileUtil.cleanAndroidTempDirectory();
    }

    @Override
    public VNSprite getFullTextbox() {
        Texture texture = new Texture(Gdx.files.internal("sprites/textbox.png"));
        texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Sprite ts = new Sprite(texture);
        VNSingleSprite s = new VNSingleSprite(ts);
        this.scaleSprite(s);
        ((VNSprite)s).setPosition(0.0f, 0.0f);
        return s;
    }

    @Override
    public VNSprite getPartialTextbox() {
        Texture texture = new Texture(Gdx.files.internal("sprites/partial_textbox.png"));
        texture.setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
        Sprite s = new Sprite(texture);
        s.setOrigin(0.0f, 0.0f);
        s.setPosition(0.0f, 0.0f);
        return new VNSingleSprite(s);
    }

    @Override
    public VNSprite getCustomTextbox(String name) {
        FileHandle fh = this.novel_fh.child("ui/" + name);
        Texture texture = new Texture(fh);
        texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Sprite ts = new Sprite(texture);
        VNSingleSprite s = new VNSingleSprite(ts);
        this.scaleSprite(s);
        ((VNSprite)s).setPosition(0.0f, 0.0f);
        return s;
    }

    @Override
    public FileHandle getSaveLoc() {
        return Gdx.files.external("vnand/save/vnds/" + this.novel_fh.name());
    }

    @Override
    public void loadScript(String script) throws IOException {
        BufferedReader reader;
        try {
            if (this.has_script_zip) {
                InputStream is = this.script_zip.getInputStream(this.script_zip.getEntry("script/" + script));
                reader = new BufferedReader(new InputStreamReader(is));
            } else {
                FileHandle fh = this.novel_fh.child("script/" + script);
                reader = new BufferedReader(fh.reader());
            }
        }
        catch (Exception e) {
            Gdx.app.error("Script", "Script " + script + " not found. Going to main.scr", e);
            this.loadScript("main.scr");
            return;
        }
        this.loadScript(reader);
        reader.close();
    }

    private void loadScript(BufferedReader reader) throws IOException {
        VNDSLiteParser p = new VNDSLiteParser(new InstructionSet(this));
        p.parseScript(reader);
        this.instructionset = p.iset;
    }

    private void scaleSprite(VNSprite s) {
        if (this.image_scalex == 1.0f && this.image_scaley == 1.0f) {
            return;
        }
        s.setScale(this.image_scalex, this.image_scaley);
    }

    @Override
    public VNSprite getBackground(String name) {
        VNSingleSprite s = null;
        try {
            FileHandle fh = this.has_background_zip ? FileUtil.getFileFromZip(this.background_zip, "background/" + name, image_exts, null) : this.novel_fh.child("background/" + name);
            Texture texture = new Texture(fh);
            texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            Sprite ts = new Sprite(texture);
            s = new VNSingleSprite(ts);
            this.scaleSprite(s);
        }
        catch (Exception e) {
            Texture texture = new Texture(Gdx.files.internal("sprites/io_error.png"));
            texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            Sprite ts = new Sprite(texture);
            ts.setOrigin(0.0f, 0.0f);
            ts.setScale(0.5f);
            s = new VNSingleSprite(ts);
            Gdx.app.error("Background", "Error loading background " + name, e);
        }
        return s;
    }

    @Override
    public Sound getSound(String name) {
        Sound sound;
        try {
            FileHandle fh = this.has_sound_zip ? FileUtil.getFileFromZip(this.sound_zip, "sound/" + name, sound_exts, FileUtil.getAndroidTempDirectory()) : this.novel_fh.child("sound/" + name);
            sound = Gdx.audio.newSound(fh);
        }
        catch (Exception e) {
            sound = null;
            System.out.println("SOUND LOAD ERROR: " + e.getMessage());
        }
        return sound;
    }

    @Override
    public VNMusic getMusic(String name) {
        Music music;
        try {
            if (this.has_sound_zip) {
                FileHandle sz = FileUtil.getFileFromZip(this.sound_zip, "sound/" + name, sound_exts, FileUtil.getAndroidTempDirectory());
                Music m = Gdx.audio.newMusic(sz);
                return new VNNormalMusic(m);
            }
            FileHandle fh = FileUtil.getFileFromDir(this.novel_fh, "sound/" + name, sound_exts);
            music = Gdx.audio.newMusic(fh);
        }
        catch (Exception e) {
            music = null;
            System.out.println("MUSIC LOAD ERROR: " + e.getMessage());
        }
        return new VNNormalMusic(music);
    }

    @Override
    public VNSprite getImage(String name, String params) {
        if (params.equals("foreground")) {
            return this.getSprite(name);
        }
        if (params.equals("background")) {
            return this.getBackground(name);
        }
        return null;
    }

    private VNSprite getSprite(String name) {
        VNSingleSprite s;
        try {
            FileHandle fh = this.has_foreground_zip ? FileUtil.getFileFromZip(this.foreground_zip, "foreground/" + name, image_exts, null) : this.novel_fh.child("foreground/" + name);
            Texture texture = new Texture(fh);
            texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            Sprite ts = new Sprite(texture);
            s = new VNSingleSprite(ts);
            this.scaleSprite(s);
        }
        catch (Exception e) {
            Texture texture = new Texture(Gdx.files.internal("sprites/error_sprite.png"));
            texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            Sprite ts = new Sprite(texture);
            ts.setOrigin(0.0f, 0.0f);
            ts.setScale(0.5f);
            s = new VNSingleSprite(ts);
            System.out.println("IMG LOAD ERROR: " + e.getMessage());
        }
        return s;
    }

    @Override
    public void positionImage(ImageAsset asset, float x, float y) {
        float ny = VNAnd.settings.getSetting("height") - ((VNSprite)asset.getAsset()).getScaleY() * asset.getHeight() - y;
        asset.setPosition(x, ny);
    }

    @Override
    public ScreenModeManager makeScreenModeManager() {
        ScreenModeManager out = new ScreenModeManager();
        out.addMode(new ScreenMode("full", ScreenMode.Mode.SINGLE, ScreenMode.TextboxMode.DEFAULT_FULL, new Rectangle(20.0f, 170.0f, 210.0f, 150.0f), "default", false, null));
        out.addMode(new ScreenMode("ds_right", ScreenMode.Mode.DUAL_RIGHT, ScreenMode.TextboxMode.NONE, new Rectangle(20.0f, 170.0f, 210.0f, 150.0f), "default", false, null));
        out.addMode(new ScreenMode("full_bottom", ScreenMode.Mode.SINGLE, ScreenMode.TextboxMode.DEFAULT_BOTTOM, new Rectangle(20.0f, 60.0f, 210.0f, 60.0f), "default", true, null));
        FileHandle fh = this.novel_fh.child("ui/modes");
        if (fh.exists()) {
            for (FileHandle mode : fh.list()) {
                out.addMode(new ScreenMode(new BufferedReader(mode.reader())));
            }
        }
        return out;
    }

    @Override
    public String getDefaultScreenMode() {
        return this.default_screen_mode;
    }

    private void loadVNAndSettings() {
        FileHandle fh = this.novel_fh.child("vnand.ini");
        if (fh.exists()) {
            HashMap<String, String> data = null;
            try {
                data = INILoader.loadBasicINI(new BufferedReader(fh.reader()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.default_screen_mode = data.get("defaultmode").trim();
        } else {
            this.default_screen_mode = "ds_right";
        }
    }

    @Override
    public void loadFonts() {
        FileHandle fh = this.novel_fh.child("default.ttf");
        if (!fh.exists()) {
            fh = Gdx.files.internal("fonts/sazanami.ttf");
        }
        this.makeFontParam(fh, "default", 12);
        FileHandle fontini = this.novel_fh.child("ui/fonts.ini");
        if (fontini.exists()) {
            HashMap<String, String> data = null;
            try {
                data = INILoader.loadBasicINI(new BufferedReader(fontini.reader()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (String key : data.keySet()) {
                String[] fontinfo = data.get(key).split(",");
                String name = key;
                String f = fontinfo[0].trim();
                int size = Integer.parseInt(fontinfo[1].trim());
                FileHandle fontfh = f.equals("default") ? fh : this.novel_fh.child("ui/fonts/" + f);
                this.makeFontParam(fh, name, size);
            }
        }
    }

    private void makeFontParam(FileHandle fh, String name, int size) {
        FreeTypeFontGenerator.FreeTypeFontParameter param = VNFont.getDefaultParams(size);
        param.borderWidth = 0.5f;
        FontAsset fa = this.getFont(fh, size / 2, 4, param);
        ((VNScreen)VNAnd.current_screen).text.addFont(name, fa);
    }

    @Override
    public VNSprite getAnimation(String[] names, float delay) {
        return null;
    }

    @Override
    public VNSprite getBackgroundAnimation(String[] names, float delay, int loop_times) {
        return null;
    }

    @Override
    protected void makeSettings() {
        this.settings = new VNSettings();
        this.settings.setSetting("width", 256.0f);
        this.settings.setSetting("height", 192.0f);
        this.settings.setSetting("dual_screen", 1.0f);
        this.settings.setSetting("text_screen", 1.0f);
    }
}

