/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.gameengines.vnovels.script;

import com.youkaicountry.vnand.gameengines.vnovels.VisualNovel;
import com.youkaicountry.vnand.gameengines.vnovels.script.VNInstruction;
import java.util.ArrayList;
import java.util.HashMap;

public class InstructionSet {
    public VisualNovel vn;
    public String current_script;
    private ArrayList<VNInstruction> instructions;
    private int current_inst = 0;
    private int reported_inst = 0;
    private HashMap<String, Integer> labels;

    public InstructionSet(VisualNovel vn) {
        this.vn = vn;
        this.current_inst = 0;
        this.reported_inst = 0;
        this.instructions = new ArrayList();
        this.labels = new HashMap();
    }

    public void addInstruction(VNInstruction inst) {
        this.instructions.add(inst);
        inst.setVisualNovel();
    }

    public void changeInstructionLocation(int num) {
        this.current_inst = num;
        this.reported_inst = num;
    }

    public int getActualInstructionLocation() {
        return this.current_inst;
    }

    public int getReportedInstructionLocation() {
        return this.reported_inst;
    }

    public int size() {
        return this.instructions.size();
    }

    public void update() {
        while (!this.vn.blocked && this.current_inst < this.instructions.size()) {
            VNInstruction inst = this.instructions.get(this.current_inst);
            if (inst.report()) {
                this.reported_inst = this.current_inst;
            }
            ++this.current_inst;
            inst.execute();
        }
    }

    public void addLabel(String label) {
        this.labels.put(label, this.instructions.size());
    }

    public void gotoLabel(String label) {
        this.current_inst = this.labels.get(label);
    }
}

