/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.gameengines.vnovels.script.instructions;

import com.youkaicountry.vnand.VNAnd;
import com.youkaicountry.vnand.gameengines.vnovels.script.VNInstruction;
import com.youkaicountry.vnand.screens.VNScreen;

public class CompareInstruction
extends VNInstruction {
    private String v1;
    private String v2;
    private String label;
    private BoolOp op;

    public CompareInstruction(String v1, String op, String v2, String label) {
        this(v1, CompareInstruction.getOp(op), v2, label);
    }

    public CompareInstruction(String v1, BoolOp op, String v2, String label) {
        this.v1 = v1;
        this.v2 = v2;
        this.op = op;
        this.label = label;
    }

    @Override
    public void execute() {
        float val1 = ((VNScreen)VNAnd.current_screen).vn.variables.getVal(this.v1);
        float val2 = ((VNScreen)VNAnd.current_screen).vn.variables.getVal(this.v2);
        boolean cval = false;
        switch (this.op) {
            case GT: {
                cval = val1 > val2;
                break;
            }
            case LT: {
                cval = val1 < val2;
                break;
            }
            case EQ: {
                cval = val1 == val2;
                break;
            }
            case LTEQ: {
                cval = val1 <= val2;
                break;
            }
            case GTEQ: {
                cval = val1 >= val2;
                break;
            }
            case NEQ: {
                boolean bl = cval = val1 != val2;
            }
        }
        if (cval) {
            ((VNScreen)VNAnd.current_screen).vn.instructionset.gotoLabel(this.label);
        }
    }

    @Override
    protected void init() {
    }

    public static BoolOp getOp(String op) {
        if (op.equals("==")) {
            return BoolOp.EQ;
        }
        if (op.equals("<")) {
            return BoolOp.LT;
        }
        if (op.equals(">")) {
            return BoolOp.GT;
        }
        if (op.equals("<=") || op.equals("=<")) {
            return BoolOp.LTEQ;
        }
        if (op.equals(">=") || op.equals("=>")) {
            return BoolOp.GTEQ;
        }
        if (op.equals("!=") || op.equals("<>") || op.equals("><")) {
            return BoolOp.NEQ;
        }
        return null;
    }

    @Override
    public boolean report() {
        return false;
    }

    public static enum BoolOp {
        LT,
        GT,
        LTEQ,
        GTEQ,
        NEQ,
        EQ;

    }
}

