/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.gameengines.vnovels.script.instructions;

import com.youkaicountry.vnand.VNAnd;
import com.youkaicountry.vnand.gameengines.vnovels.script.VNInstruction;
import com.youkaicountry.vnand.screens.VNScreen;

public class SetVariableInstruction
extends VNInstruction {
    private String varname;
    private String sval;
    private float fval;
    private int ival;
    private boolean is_string;
    private boolean is_int;
    private boolean local;
    private Mode mode;

    public SetVariableInstruction(String varname, float value, String mode, boolean local) {
        this.varname = varname;
        this.local = local;
        this.fval = value;
        this.is_string = false;
        this.mode = this.string2Mode(mode);
    }

    public SetVariableInstruction(String varname, String value, String mode, boolean local) {
        this.varname = varname;
        this.local = local;
        this.sval = value;
        this.is_string = true;
        this.mode = this.string2Mode(mode);
    }

    public SetVariableInstruction(String varname, int value, String mode, boolean local) {
        this.varname = varname;
        this.local = local;
        this.ival = value;
        this.is_string = true;
        this.mode = this.string2Mode(mode);
    }

    private Mode string2Mode(String mode) {
        if (mode.equals("=")) {
            return Mode.EQL;
        }
        if (mode.equals("+")) {
            return Mode.ADD;
        }
        if (mode.equals("-")) {
            return Mode.SUB;
        }
        return null;
    }

    @Override
    public void execute() {
        if (this.is_string) {
            ((VNScreen)VNAnd.current_screen).vn.variables.setVariable(this.varname, this.handleModeString(), this.local);
        } else if (this.is_int) {
            ((VNScreen)VNAnd.current_screen).vn.variables.setVariable(this.varname, this.handleModeString(), this.local);
        } else {
            ((VNScreen)VNAnd.current_screen).vn.variables.setVariable(this.varname, this.handleModeString(), this.local);
        }
    }

    private String handleModeString() {
        switch (this.mode) {
            case EQL: {
                return ((VNScreen)VNAnd.current_screen).vn.variables.getValAsString(this.sval);
            }
            case ADD: {
                int v = Integer.parseInt(((VNScreen)VNAnd.current_screen).vn.variables.getValAsString(this.varname));
                return "" + (v += Integer.parseInt(((VNScreen)VNAnd.current_screen).vn.variables.getValAsString(this.sval)));
            }
            case SUB: {
                int v = Integer.parseInt(((VNScreen)VNAnd.current_screen).vn.variables.getValAsString(this.varname));
                return "" + (v -= Integer.parseInt(((VNScreen)VNAnd.current_screen).vn.variables.getValAsString(this.sval)));
            }
        }
        return "";
    }

    private int handleModeInt() {
        switch (this.mode) {
            case EQL: {
                return this.ival;
            }
            case ADD: {
                int v = (int)((VNScreen)VNAnd.current_screen).vn.variables.getVal(this.varname);
                return v += this.ival;
            }
            case SUB: {
                int v = (int)((VNScreen)VNAnd.current_screen).vn.variables.getVal(this.varname);
                return v += this.ival;
            }
        }
        return -1;
    }

    private float handleModeFloat() {
        switch (this.mode) {
            case EQL: {
                return this.fval;
            }
            case ADD: {
                float v = ((VNScreen)VNAnd.current_screen).vn.variables.getVal(this.varname);
                return v += this.fval;
            }
            case SUB: {
                float v = ((VNScreen)VNAnd.current_screen).vn.variables.getVal(this.varname);
                return v += this.fval;
            }
        }
        return -1.0f;
    }

    @Override
    protected void init() {
    }

    @Override
    public boolean report() {
        return false;
    }

    public static enum Mode {
        ADD,
        SUB,
        MUL,
        DIV,
        EQL;

    }
}

