/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.gameengines.vnovels.script.kamishibaiparse;

import com.youkaicountry.util.config.INILoader;
import com.youkaicountry.vnand.actors.buttonactions.SetVarButtonAction;
import com.youkaicountry.vnand.gameengines.vnovels.script.InstructionSet;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.AddTextButtonInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.AnimatedTextInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.ClearBGInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.ClearButtonsInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.ClearTextInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.CompareInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.GotoInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.PlayMusicInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.PlaySoundInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.SetBGInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.StopMusicInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.WaitForButtonInstruction;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class KamishibaiParser {
    public InstructionSet iset;
    public String sound_loc;
    public String image_loc;
    public String music_loc;
    public String start_loc;
    private static final HashMap<String, Integer> animspeeds = new HashMap();

    public KamishibaiParser(InstructionSet iset) {
        this.iset = iset;
    }

    public void parseScript(BufferedReader reader) throws IOException {
        HashMap<String, ArrayList<String>> sections = this.findSections(reader);
        this.parseSetup(sections.get("setup"));
        this.parseTitle(sections.get("title"));
        this.iset.addInstruction(new GotoInstruction(this.start_loc));
        for (String key : sections.keySet()) {
            if (key.equals("setup") || key.equals("title")) continue;
            this.parseSection(key.toLowerCase(), sections.get(key));
        }
    }

    private void parseSetup(ArrayList<String> setup) {
        HashMap<String, String> ini = INILoader.loadBasicINI(setup);
        for (String key : ini.keySet()) {
            String ukey = key.toLowerCase();
            if (ukey.equals("musicdir")) {
                this.music_loc = ini.get(key);
                continue;
            }
            if (ukey.equals("sounddir")) {
                this.sound_loc = ini.get(key);
                continue;
            }
            if (ukey.equals("imagedir")) {
                this.image_loc = ini.get(key);
                continue;
            }
            if (!ukey.equals("firstscene")) continue;
            this.start_loc = ini.get(key).toLowerCase();
        }
    }

    private void parseTitle(ArrayList<String> title) {
    }

    private void parseSection(String scene_name, ArrayList<String> scene) {
        String[] anim = new String[1];
        float fps = animspeeds.get("medium").intValue();
        int loop_times = -1;
        String music = null;
        String sound = null;
        String[] option_text = new String[]{null, null, null, null};
        String[] option_label = new String[]{null, null, null, null};
        String description = "";
        HashMap<String, String> data = INILoader.loadBasicINI(scene);
        for (String key : data.keySet()) {
            String result = data.get(key);
            String ukey = key.toLowerCase();
            if (ukey.equals("anim")) {
                anim = result.split(",");
                for (int i = 0; i < anim.length; ++i) {
                    anim[i] = anim[i].trim();
                }
                continue;
            }
            if (ukey.equals("image")) {
                anim = new String[]{result.trim()};
                continue;
            }
            if (ukey.equals("music")) {
                music = result.trim();
                continue;
            }
            if (ukey.equals("sound")) {
                sound = result;
                continue;
            }
            if (ukey.startsWith("option")) {
                int i = Integer.parseInt(ukey.substring(6)) - 1;
                option_text[i] = result;
                continue;
            }
            if (ukey.startsWith("link")) {
                int i = Integer.parseInt(ukey.substring(4)) - 1;
                option_label[i] = result.trim().toLowerCase();
                continue;
            }
            if (ukey.equals("animspeed")) {
                String lres = result.toLowerCase().trim();
                fps = animspeeds.containsKey(lres) ? (float)animspeeds.get(lres).intValue() : (float)Integer.parseInt(lres);
                if (!(fps <= 0.0f)) continue;
                fps = 1.0E-5f;
                continue;
            }
            if (ukey.equals("animloop")) {
                String lres = result.toLowerCase().trim();
                if (lres.equals("forever")) continue;
                if (lres.equals("once")) {
                    loop_times = 1;
                    continue;
                }
                loop_times = Integer.parseInt(lres);
                continue;
            }
            if (!ukey.equals("description")) continue;
            description = result;
        }
        this.iset.addLabel(scene_name);
        this.iset.addInstruction(new ClearBGInstruction());
        this.iset.addInstruction(new ClearTextInstruction());
        float anim_delay = 1.0f / fps;
        this.iset.addInstruction(new SetBGInstruction(anim, anim_delay, loop_times, 0.17f));
        if (music != null) {
            this.iset.addInstruction(new StopMusicInstruction());
            if (!music.equals("stop")) {
                this.iset.addInstruction(new PlayMusicInstruction(music, true));
            }
        }
        if (sound != null) {
            this.iset.addInstruction(new PlaySoundInstruction(sound, 0, 0));
        }
        this.iset.addInstruction(new AnimatedTextInstruction(description, "default", 50.0f));
        this.makeButtons(scene_name, option_text, option_label);
    }

    private void makeButtons(String scene, String[] option_text, String[] option_label) {
        int i;
        for (i = 0; i < option_text.length; ++i) {
            if (option_text[i] == null) continue;
            SetVarButtonAction action = new SetVarButtonAction("selected", i);
            this.iset.addInstruction(new AddTextButtonInstruction(option_text[i], "default", action, 10.0f, 10 * i));
        }
        this.iset.addInstruction(new WaitForButtonInstruction());
        this.iset.addInstruction(new ClearButtonsInstruction());
        for (i = 0; i < option_text.length; ++i) {
            if (option_text[i] == null) continue;
            this.iset.addInstruction(new CompareInstruction("selected", "==", "" + i, "@OPBTN_" + scene + "__" + i));
        }
        for (i = 0; i < option_label.length; ++i) {
            if (option_label[i] == null) continue;
            this.iset.addLabel("@OPBTN_" + scene + "__" + i);
            this.iset.addInstruction(new GotoInstruction(option_label[i]));
        }
    }

    private HashMap<String, ArrayList<String>> findSections(BufferedReader reader) throws IOException {
        String fline;
        HashMap<String, ArrayList<String>> sections = new HashMap<String, ArrayList<String>>();
        String current_section = null;
        while ((fline = reader.readLine()) != null) {
            String tline = fline.trim();
            int comment = tline.indexOf("//");
            if (comment >= 0) {
                tline = tline.substring(0, tline.indexOf("//"));
            }
            if (tline.equals("")) continue;
            if (tline.charAt(0) == '[') {
                current_section = tline.substring(1, tline.length() - 1).toLowerCase();
                sections.put(current_section, new ArrayList());
                continue;
            }
            if (tline.charAt(0) != '@') {
                ArrayList<String> heresection = sections.get(current_section);
                String fp = heresection.remove(heresection.size() - 1);
                heresection.add(fp + "\n" + tline);
                continue;
            }
            sections.get(current_section).add(tline.substring(1));
        }
        return sections;
    }

    static {
        animspeeds.put("slow", 1);
        animspeeds.put("medium", 6);
        animspeeds.put("fast", 12);
    }
}

