/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.gameengines.vnovels.script.vndsparse;

import com.youkaicountry.vnand.actors.buttonactions.SetVarButtonAction;
import com.youkaicountry.vnand.gameengines.vnovels.script.InstructionSet;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.AddTextButtonInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.AnimatedTextInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.ArrangeButtonsInListInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.ClearBGInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.ClearButtonsInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.ClearLocalVariablesInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.ClearSomeBackgroundsInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.ClearTextInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.CompareInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.GotoInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.HideTextboxInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.IfBGClearSprites;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.JumpInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.PlayMusicInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.PlaySoundInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.QueueImageInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.SetBGInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.SetVariableInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.ShowTextboxInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.SpriteTransitionInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.StopAllSoundsInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.StopMusicInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.StopSoundChannelInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.WaitForButtonInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.WaitInstruction;
import com.youkaicountry.vnand.gameengines.vnovels.script.vndsparse.BadScriptException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Stack;

public class VNDSLiteParser {
    static HashMap<String, INSTRUCTION> kw2inst = new HashMap();
    public InstructionSet iset;
    int label_num;
    boolean tb_hidden = true;
    boolean tb_dirty;
    int if_depth;
    Stack<Integer> if_stack;
    boolean in_sprite_chain;
    boolean destructive_chain;

    public VNDSLiteParser(InstructionSet iset) {
        this.iset = iset;
        this.label_num = 0;
        this.tb_dirty = true;
        this.if_depth = 0;
        this.if_stack = new Stack();
        this.in_sprite_chain = false;
        this.destructive_chain = false;
    }

    private String cleanLine(String line) {
        int i;
        for (i = 0; i < line.length() && line.charAt(i) >= '\u0080'; ++i) {
        }
        if (i == 0) {
            return line;
        }
        return line.substring(i);
    }

    public void parseScript(BufferedReader reader) throws IOException {
        boolean first = true;
        String line = reader.readLine();
        while (line != null) {
            line = line.trim();
            if (first) {
                line = this.cleanLine(line);
                first = false;
            }
            if (line.length() == 0) {
                line = reader.readLine();
                continue;
            }
            int p = line.indexOf(32);
            String instruction = p < 0 ? line : line.substring(0, p);
            if (instruction.charAt(0) == '#') {
                line = reader.readLine();
                continue;
            }
            INSTRUCTION inst = kw2inst.get(instruction);
            if (inst == null) {
                throw new BadScriptException("Instruction: " + instruction + " not recognized.");
            }
            switch (inst) {
                case TEXT: {
                    this.parseText(line, p + 1);
                    break;
                }
                case SOUND: {
                    this.parseSound(line, p + 1);
                    break;
                }
                case MUSIC: {
                    this.parseMusic(line, p + 1);
                    break;
                }
                case IF: {
                    this.parseIf(line, p + 1);
                    break;
                }
                case FI: {
                    this.parseFi();
                    break;
                }
                case SETVAR: {
                    this.parseSetVar(line, p + 1);
                    break;
                }
                case GSETVAR: {
                    this.parseGSetVar(line, p + 1);
                    break;
                }
                case JUMP: {
                    this.parseJump(line, p + 1);
                    break;
                }
                case CHOICE: {
                    this.parseChoice(line, p + 1);
                    break;
                }
                case BGLOAD: {
                    this.parseBGLoad(line, p + 1);
                    break;
                }
                case DELAY: {
                    this.parseDelay(line, p + 1);
                    break;
                }
                case SETIMG: {
                    this.parseSetIMG(line, p + 1);
                    break;
                }
                case LABEL: {
                    this.parseLabel(line, p + 1);
                    break;
                }
                case GOTO: {
                    this.parseGoto(line, p + 1);
                    break;
                }
                case CLEARTEXT: {
                    this.parseClearText(line, p + 1);
                }
            }
            line = reader.readLine();
        }
    }

    private void startSpriteChain(boolean destructive) {
        this.in_sprite_chain = true;
        this.destructive_chain = destructive;
    }

    private void cutSpriteChain() {
        if (this.in_sprite_chain) {
            this.iset.addInstruction(new SpriteTransitionInstruction(0.33f, this.destructive_chain));
            this.in_sprite_chain = false;
            this.destructive_chain = false;
        }
    }

    private String discardComment(String line) {
        int p = line.indexOf(35);
        if (p >= 0) {
            return line.substring(p);
        }
        return line;
    }

    private String[] getParams(String line, int param_start) {
        String ps = line.substring(param_start).trim();
        String[] params = ps.split("\\s+");
        return params;
    }

    protected void parseClearText(String line, int param_start) {
        this.cutSpriteChain();
        line = this.discardComment(line);
        this.iset.addInstruction(new ClearTextInstruction());
    }

    protected void parseGoto(String line, int param_start) {
        line = this.discardComment(line);
        String param = line.substring(param_start).trim();
        this.iset.addInstruction(new GotoInstruction("VNDS_L_" + param));
    }

    protected void parseLabel(String line, int param_start) {
        line = this.discardComment(line);
        String param = line.substring(param_start).trim();
        this.iset.addLabel("VNDS_L_" + param);
    }

    protected void parseSetIMG(String line, int param_start) {
        this.startSpriteChain(true);
        line = this.discardComment(line);
        String[] params = this.getParams(line, param_start);
        String img = params[0];
        float x = Float.parseFloat(params[1]);
        float y = Float.parseFloat(params[2]);
        this.iset.addInstruction(new QueueImageInstruction(img, x, y));
    }

    protected void parseDelay(String line, int param_start) {
        this.cutSpriteChain();
        line = this.discardComment(line);
        String param = line.substring(param_start).trim();
        float time = Float.parseFloat(param) / 60.0f;
        this.iset.addInstruction(new WaitInstruction(false, time));
    }

    protected void parseJump(String line, int param_start) {
        this.cutSpriteChain();
        line = this.discardComment(line);
        String[] params = this.getParams(line, param_start);
        if (params.length == 1) {
            this.iset.addInstruction(new JumpInstruction(params[0]));
            return;
        }
        this.iset.addInstruction(new JumpInstruction(params[0], "VNDS_L_" + params[1]));
    }

    protected void parseChoice(String line, int param_start) {
        this.cutSpriteChain();
        String param = line.substring(param_start).trim();
        String[] choices = param.split("\\|");
        this.showTB();
        this.iset.addInstruction(new ClearTextInstruction());
        for (int i = 0; i < choices.length; ++i) {
            SetVarButtonAction action = new SetVarButtonAction("selected", i + 1);
            this.iset.addInstruction(new AddTextButtonInstruction(choices[i], "default", action, 0.0f, 0.0f));
        }
        this.iset.addInstruction(new ArrangeButtonsInListInstruction());
        this.iset.addInstruction(new WaitForButtonInstruction());
        this.iset.addInstruction(new ClearButtonsInstruction());
        this.hideTB();
    }

    protected void parseBGLoad(String line, int param_start) {
        this.cutSpriteChain();
        line = this.discardComment(line);
        String[] params = this.getParams(line, param_start);
        this.iset.addInstruction(new ClearTextInstruction());
        this.hideTB();
        this.iset.addInstruction(new IfBGClearSprites(params[0]));
        if (params[0].equals("~")) {
            return;
        }
        float time = 0.26666668f;
        if (params.length >= 2) {
            if (Integer.parseInt(params[1]) <= 1) {
                this.iset.addInstruction(new ClearBGInstruction());
                this.iset.addInstruction(new SetBGInstruction(params[0]));
                return;
            }
            time = Float.parseFloat(params[1]) / 60.0f;
        }
        this.iset.addInstruction(new SetBGInstruction(params[0], time));
        this.iset.addInstruction(new ClearSomeBackgroundsInstruction(1));
        this.startSpriteChain(true);
    }

    protected void parseSetVar(String line, int param_start) {
        this.cutSpriteChain();
        line = this.discardComment(line);
        String[] params = this.getParams(line, param_start);
        if (params[0].equals("~") && params[1].equals("~")) {
            this.iset.addInstruction(new ClearLocalVariablesInstruction());
            return;
        }
        this.iset.addInstruction(new SetVariableInstruction(params[0], params[2], params[1], true));
    }

    protected void parseGSetVar(String line, int param_start) {
        this.cutSpriteChain();
        line = this.discardComment(line);
        String[] params = this.getParams(line, param_start);
        if (params[0].equals("~") && params[1].equals("~")) {
            this.iset.addInstruction(new ClearLocalVariablesInstruction());
            return;
        }
        this.iset.addInstruction(new SetVariableInstruction(params[0], params[2], params[1], false));
    }

    protected void parseFi() {
        String label2 = "IF" + this.if_stack.pop() + "_END";
        this.iset.addLabel(label2);
        this.tb_dirty = true;
    }

    protected void parseIf(String line, int param_start) {
        line = this.discardComment(line);
        String[] params = this.getParams(line, param_start);
        this.tb_dirty = true;
        int num = this.label_num++;
        this.if_stack.push(num);
        String label1 = "IF" + num + "_START";
        String label2 = "IF" + num + "_END";
        this.iset.addInstruction(new CompareInstruction(params[0], params[1], params[2], label1));
        this.iset.addInstruction(new GotoInstruction(label2));
        this.iset.addLabel(label1);
    }

    protected void parseMusic(String line, int param_start) {
        this.cutSpriteChain();
        line = this.discardComment(line);
        String param = line.substring(param_start).trim();
        this.iset.addInstruction(new StopMusicInstruction());
        if (param.equals("~")) {
            return;
        }
        this.iset.addInstruction(new PlayMusicInstruction(param, true));
    }

    protected void parseSound(String line, int param_start) {
        this.cutSpriteChain();
        line = this.discardComment(line);
        String[] params = this.getParams(line, param_start);
        if (params[0].equals("~")) {
            this.iset.addInstruction(new StopAllSoundsInstruction());
            return;
        }
        int loop = 0;
        int channel = 0;
        if (params.length > 1 && (loop = Integer.parseInt(params[1])) < 0) {
            System.out.println("CHANNEL 1 NEWS");
            channel = 1;
        }
        if (channel == 0) {
            this.iset.addInstruction(new StopSoundChannelInstruction(0));
        }
        this.iset.addInstruction(new PlaySoundInstruction(params[0], channel, loop));
    }

    protected void parseText(String line, int param_start) {
        this.cutSpriteChain();
        String text = line.substring(param_start).trim();
        if (text.length() == 0) {
            this.iset.addInstruction(new AnimatedTextInstruction(" ", "default", 15.0f));
            return;
        }
        if (text.equals("~")) {
            return;
        }
        if (text.equals("!")) {
            return;
        }
        this.showTB();
        boolean noclick = false;
        if (text.startsWith("@")) {
            noclick = true;
            text = text.substring(1);
        }
        this.iset.addInstruction(new AnimatedTextInstruction(text, "default", 15.0f));
        if (!noclick) {
            this.iset.addInstruction(new WaitInstruction());
        }
    }

    private void hideTB() {
        if (!this.tb_hidden || this.tb_dirty) {
            this.tb_hidden = true;
            this.iset.addInstruction(new HideTextboxInstruction());
            this.tb_dirty = false;
        }
    }

    private void showTB() {
        if (this.tb_hidden || this.tb_dirty) {
            this.tb_hidden = false;
            this.iset.addInstruction(new ShowTextboxInstruction());
            this.tb_dirty = false;
        }
    }

    static {
        kw2inst.put("text", INSTRUCTION.TEXT);
        kw2inst.put("sound", INSTRUCTION.SOUND);
        kw2inst.put("music", INSTRUCTION.MUSIC);
        kw2inst.put("if", INSTRUCTION.IF);
        kw2inst.put("fi", INSTRUCTION.FI);
        kw2inst.put("setvar", INSTRUCTION.SETVAR);
        kw2inst.put("gsetvar", INSTRUCTION.GSETVAR);
        kw2inst.put("bgload", INSTRUCTION.BGLOAD);
        kw2inst.put("choice", INSTRUCTION.CHOICE);
        kw2inst.put("jump", INSTRUCTION.JUMP);
        kw2inst.put("delay", INSTRUCTION.DELAY);
        kw2inst.put("setimg", INSTRUCTION.SETIMG);
        kw2inst.put("label", INSTRUCTION.LABEL);
        kw2inst.put("goto", INSTRUCTION.GOTO);
        kw2inst.put("cleartext", INSTRUCTION.CLEARTEXT);
    }

    static enum INSTRUCTION {
        TEXT,
        SOUND,
        MUSIC,
        IF,
        FI,
        SETVAR,
        BGLOAD,
        CHOICE,
        JUMP,
        DELAY,
        SETIMG,
        LABEL,
        GOTO,
        CLEARTEXT,
        GSETVAR;

    }
}

