/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.gameengines.vnovels.vnsprites;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.youkaicountry.vnand.gameengines.vnovels.VNSprite;

public class VNAnimatedSprite
extends VNSprite {
    private float time = 0.0f;
    private Animation anim;
    private Sprite[] sprites;
    private int loop_times;
    private boolean do_loop;

    public VNAnimatedSprite(Sprite[] sprites, float time, int loop_times) {
        this.anim = new Animation<Sprite>(time, sprites);
        this.sprites = sprites;
        this.loop_times = loop_times;
        this.do_loop = loop_times < 0 ? true : loop_times != 0;
        this.current_sprite = this.sprites[0];
    }

    @Override
    public void update(float dt) {
        float duration;
        this.time += dt;
        if (this.loop_times > 0 && this.time > (float)this.loop_times * (duration = this.anim.getAnimationDuration())) {
            this.time = (float)this.loop_times * duration;
        }
        this.current_sprite = (Sprite)this.anim.getKeyFrame(this.time, this.do_loop);
    }

    @Override
    public void setX(float x) {
        for (int i = 0; i < this.sprites.length; ++i) {
            this.sprites[i].setX(x);
        }
    }

    @Override
    public void setY(float y) {
        for (int i = 0; i < this.sprites.length; ++i) {
            this.sprites[i].setY(y);
        }
    }

    @Override
    public void setPosition(float x, float y) {
        for (int i = 0; i < this.sprites.length; ++i) {
            this.sprites[i].setPosition(x, y);
        }
    }

    @Override
    public void setScale(float scalex, float scaley) {
        for (int i = 0; i < this.sprites.length; ++i) {
            this.sprites[i].setOrigin(0.0f, 0.0f);
            this.sprites[i].setScale(scalex, scaley);
        }
    }

    @Override
    public void setColor(float r, float g, float b, float a) {
        for (int i = 0; i < this.sprites.length; ++i) {
            this.sprites[i].setColor(r, g, b, a);
        }
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.sprites.length; ++i) {
            this.sprites[i].getTexture().dispose();
        }
    }
}

