/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.gameloader;

import com.badlogic.gdx.files.FileHandle;
import com.youkaicountry.vnand.VNGameEngine;
import com.youkaicountry.vnand.actors.VNDirectory;
import com.youkaicountry.vnand.actors.VNEntry;
import com.youkaicountry.vnand.actors.VNGame;
import com.youkaicountry.vnand.gameloader.VNFormatChooser;
import com.youkaicountry.vnand.gameloader.VNFormatInstance;
import com.youkaicountry.vnand.screens.GameMenuScreen;
import com.youkaicountry.vnand.utils.text.VNFont;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AsyncRecognizer {
    final ExecutorService executor;
    VNFormatChooser chooser;
    VNFont font;
    GameMenuScreen screen;

    public AsyncRecognizer(int worker_threads, VNFont font, GameMenuScreen screen, VNGameEngine[] engines) {
        this.font = font;
        this.screen = screen;
        this.executor = Executors.newFixedThreadPool(worker_threads);
        this.chooser = new VNFormatChooser(engines);
    }

    public void startRecognition(ArrayList<FileHandle> files) {
        for (int i = 0; i < files.size(); ++i) {
            this.executor.execute(new WorkerRunnable(files.get(i)));
        }
    }

    public class WorkerRunnable
    implements Runnable {
        FileHandle fh;

        public WorkerRunnable(FileHandle fh) {
            this.fh = fh;
        }

        @Override
        public void run() {
            VNFormatInstance format = AsyncRecognizer.this.chooser.chooseFormat(this.fh);
            VNEntry novel = null;
            if (format != null) {
                novel = new VNGame(this.fh, AsyncRecognizer.this.screen, AsyncRecognizer.this.font, format);
            } else if (this.fh.isDirectory()) {
                novel = new VNDirectory(this.fh.name(), this.fh, AsyncRecognizer.this.font, AsyncRecognizer.this.screen);
            }
            if (novel != null) {
                AsyncRecognizer.this.screen.addGame(novel);
            }
        }
    }
}

