/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.gameloader;

import com.badlogic.gdx.files.FileHandle;
import com.youkaicountry.vnand.VNGameEngine;
import com.youkaicountry.vnand.gameloader.VNFormatInstance;
import com.youkaicountry.vnand.gameloader.VNFormatRecognizer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class VNFormatChooser {
    HashMap<String, ArrayList<VNFormatRecognizer>> recognizers = new HashMap();

    public VNFormatChooser(VNGameEngine[] engines) {
        for (int i = 0; i < engines.length; ++i) {
            VNFormatRecognizer recognizer = engines[i].getRecognizer();
            String[] exts = recognizer.extensions_accepted;
            for (int j = 0; j < exts.length; ++j) {
                String ext = exts[j];
                if (!this.recognizers.containsKey(ext)) {
                    this.recognizers.put(ext, new ArrayList());
                }
                this.recognizers.get(ext).add(recognizer);
            }
        }
    }

    public VNFormatInstance chooseFormat(FileHandle fh) {
        String ext = VNFormatRecognizer.getExtension(fh);
        ArrayList<VNFormatRecognizer> lr = this.recognizers.get(ext);
        if (lr == null) {
            return null;
        }
        VNFormatRecognizer chosen = null;
        for (int i = 0; i < lr.size(); ++i) {
            VNFormatRecognizer r = lr.get(i);
            if (!r.isFormat(fh, ext)) continue;
            chosen = r;
            break;
        }
        if (fh.extension().toLowerCase().equals("zip")) {
            chosen = null;
            VNFormatRecognizer zr = this.tryZip(fh, lr);
            if (zr != null) {
                chosen = zr;
            }
        }
        if (chosen == null) {
            return null;
        }
        return chosen.createFormatInstance(fh);
    }

    private VNFormatRecognizer tryZip(FileHandle fh, ArrayList<VNFormatRecognizer> recognizers) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            ZipFile zf = new ZipFile(fh.file());
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                names.add(ze.getName());
            }
            zf.close();
        }
        catch (Exception e) {
            return null;
        }
        for (int i = 0; i < recognizers.size(); ++i) {
            VNFormatRecognizer r = recognizers.get(i);
            if (!r.zip_check || !r.checkArchiveEntry(names)) continue;
            return r;
        }
        return null;
    }
}

