/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.gameloader;

import com.badlogic.gdx.files.FileHandle;
import com.youkaicountry.vnand.gameloader.VNFormatInstance;
import java.util.ArrayList;

public abstract class VNFormatRecognizer {
    public String[] extensions_accepted;
    boolean zip_check;

    public VNFormatRecognizer(String[] extensions_accepted) {
        this.extensions_accepted = extensions_accepted;
    }

    protected void enableZipCheck() {
        this.zip_check = true;
    }

    public boolean isFormat(FileHandle fh, String ext) {
        if (fh.isDirectory()) {
            return this.isDirectoryFormat(fh);
        }
        return this.isFileFormat(fh, ext);
    }

    public boolean checkArchiveEntry(ArrayList<String> files) {
        return false;
    }

    protected boolean isDirectoryFormat(FileHandle fh) {
        return false;
    }

    protected boolean isFileFormat(FileHandle fh, String ext) {
        return true;
    }

    public abstract VNFormatInstance createFormatInstance(FileHandle var1);

    public static String getExtension(FileHandle fh) {
        if (fh.isDirectory()) {
            return "<d>";
        }
        return fh.extension().toLowerCase();
    }

    private boolean matchFormats(String extension) {
        for (int i = 0; i < this.extensions_accepted.length; ++i) {
            if (!extension.equals(this.extensions_accepted[i])) continue;
            return true;
        }
        return false;
    }
}

