/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.gameloader.formats;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.youkaicountry.vnand.VNAnd;
import com.youkaicountry.vnand.gameengines.vnovels.VisualNovelKamishibai;
import com.youkaicountry.vnand.gameloader.VNFormatInstance;
import com.youkaicountry.vnand.screens.VNScreen;
import java.io.BufferedReader;
import java.io.IOException;

public class KamishibaiInstance
extends VNFormatInstance {
    public KamishibaiInstance(FileHandle fh) {
        super(fh, "Kamishibai");
    }

    @Override
    public void activate(VNAnd vnand, SpriteBatch batch) {
        VNScreen vns = new VNScreen(vnand, batch);
        vns.setVisualNovel(new VisualNovelKamishibai(this.fh));
        vnand.startNewFormat(vns);
    }

    @Override
    public Sprite getThumbnail() {
        Texture t = new Texture(Gdx.files.internal("sprites/kamishibai_thumb.png"));
        t.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Sprite s = new Sprite(t);
        s.setOrigin(0.0f, 0.0f);
        s.setScale(0.403f, 0.469f);
        return s;
    }

    @Override
    public void cacheThumbnail() {
    }

    @Override
    public String getGameName() {
        FileHandle f = this.fh.child("gamefile.txt");
        return this.findNameLine(new BufferedReader(f.reader()));
    }

    private String findNameLine(BufferedReader reader) {
        block3: {
            String line;
            String[] sides;
            do {
                line = "";
                try {
                    line = reader.readLine();
                }
                catch (IOException e) {
                    break block3;
                }
            } while (!(sides = (line = line.trim()).split("=", 2))[0].toLowerCase().trim().equals("@name"));
            return sides[1].trim();
        }
        return "";
    }
}

