/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.gameloader.formats;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.youkaicountry.util.config.INILoader;
import com.youkaicountry.vnand.VNAnd;
import com.youkaicountry.vnand.gameengines.vnovels.VisualNovelVNAnd;
import com.youkaicountry.vnand.gameloader.VNFormatInstance;
import com.youkaicountry.vnand.screens.VNScreen;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;

public class VNDSInstance
extends VNFormatInstance {
    public VNDSInstance(FileHandle fh, String type_name) {
        super(fh, type_name);
    }

    @Override
    public void activate(VNAnd vnand, SpriteBatch batch) {
        VNScreen vns = new VNScreen(vnand, batch);
        vns.setVisualNovel(new VisualNovelVNAnd(this.fh));
        vnand.startNewFormat(vns);
    }

    @Override
    public Sprite getThumbnail() {
        Texture texture = new Texture(this.fh.child("thumbnail.png"));
        texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Sprite s = new Sprite(texture);
        return s;
    }

    @Override
    public void cacheThumbnail() {
    }

    @Override
    public String getGameName() {
        HashMap<String, String> data;
        FileHandle f = this.fh.child("info.txt");
        try {
            data = INILoader.loadBasicINI(new BufferedReader(f.reader()));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get game title of " + this.fh.path());
        }
        return data.get("title");
    }
}

