/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.screens;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SplitPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.youkaicountry.vnand.VNAnd;
import com.youkaicountry.vnand.VNGameEngine;
import com.youkaicountry.vnand.actors.VNEntry;
import com.youkaicountry.vnand.gameengines.loader.LocationListItem;
import com.youkaicountry.vnand.gameengines.loader.TrailButton;
import com.youkaicountry.vnand.gameloader.AsyncRecognizer;
import com.youkaicountry.vnand.utils.text.VNFont;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.LinkedBlockingQueue;

public class GameMenuScreen
implements Screen,
InputProcessor {
    public Stage stage;
    private SpriteBatch batch;
    private ShapeRenderer shape;
    FileHandle current_directory;
    private int dragging;
    private VNEntry novel_over;
    ArrayList<VNEntry> novels;
    private Vector3 tempv;
    private VNAnd game;
    VNFont font;
    String loader_config;
    AsyncRecognizer async;
    boolean force_check = false;
    public static final int POP_CYCLE = 32;
    public static final float SIZE_CONSTANT = 96.0f;
    private static final int TOP_SIZE = 64;
    public float w_div;
    public int dy = 0;
    SplitPane split;
    Table file_table;
    ScrollPane sp;
    HorizontalGroup trail;
    ArrayList<String> locations;
    Window location_window;
    LinkedBlockingQueue<VNEntry> q_entries;

    public GameMenuScreen(String default_directory, String loader_config, SpriteBatch batch, ShapeRenderer shape, VNAnd game, VNGameEngine[] engines) {
        Gdx.app.setLogLevel(3);
        this.game = game;
        this.shape = shape;
        this.tempv = new Vector3(0.0f, 0.0f, 0.0f);
        this.batch = batch;
        this.loader_config = loader_config;
        this.q_entries = new LinkedBlockingQueue();
        this.dragging = 0;
        this.novel_over = null;
        this.w_div = 96.0f / Gdx.graphics.getPpiX();
        if (Gdx.app.getType() == Application.ApplicationType.Android) {
            this.w_div *= 1.5f;
        }
        ScreenViewport svp = new ScreenViewport();
        svp.setUnitsPerPixel(this.w_div);
        this.stage = new Stage(svp);
        this.novels = new ArrayList();
        FreeTypeFontGenerator.FreeTypeFontParameter param = VNFont.getDefaultParams(16);
        param.incremental = true;
        this.font = new VNFont(Gdx.files.internal("fonts/sazanami-j.ttf"), "sazanami", 8, 2, param);
        this.async = new AsyncRecognizer(VNAnd.cores, this.font, this, engines);
        this.setupLayout();
        this.setupLocations();
        FileHandle fh = this.calcInitialDirectory(default_directory);
        this.enterDirectory(fh);
    }

    private void setupLayout() {
        this.file_table = new Table();
        this.sp = new ScrollPane((Actor)this.file_table, VNAnd.skin);
        this.sp.setScrollingDisabled(true, false);
        this.sp.setFadeScrollBars(false);
        this.sp.setFillParent(false);
        this.split = new SplitPane(this.setupTopBar(), (Actor)this.sp, true, VNAnd.skin);
        this.split.setFillParent(true);
        this.stage.addActor(this.split);
        this.stage.setScrollFocus(this.sp);
    }

    private Actor setupTopBar() {
        VerticalGroup vg = new VerticalGroup();
        HorizontalGroup hg1 = new HorizontalGroup();
        TextButton t = new TextButton(">", VNAnd.skin);
        t.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                System.out.println("Toggle typing");
            }
        });
        hg1.addActor(t);
        this.trail = new HorizontalGroup();
        ScrollPane scroll_trail = new ScrollPane((Actor)this.trail, VNAnd.skin);
        hg1.addActor(this.trail);
        HorizontalGroup hg2 = new HorizontalGroup();
        TextButton bloc = new TextButton("<Locations>", VNAnd.skin);
        bloc.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                GameMenuScreen.this.toggleLocationWindow();
            }
        });
        hg2.addActor(bloc);
        vg.addActor(hg1);
        vg.addActor(hg2);
        return vg;
    }

    public void toggleLocationWindow() {
        if (this.location_window == null) {
            this.showLocationWindow();
        } else {
            this.closeLocationWindow();
        }
    }

    public void showLocationWindow() {
        this.location_window = new Window("Locations", VNAnd.skin);
        List list = new List(VNAnd.skin);
        Array<LocationListItem> a = new Array<LocationListItem>();
        for (int i = 0; i < this.locations.size(); ++i) {
            FileHandle fh = Gdx.files.absolute(this.locations.get(i));
            a.add(new LocationListItem(fh));
        }
        list.setItems(a);
        list.setSelectedIndex(-1);
        list.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                GameMenuScreen.this.enterDirectory(((LocationListItem)((List)actor).getSelected()).file);
                GameMenuScreen.this.closeLocationWindow();
            }
        });
        ScrollPane scroll = new ScrollPane(list, VNAnd.skin);
        scroll.setScrollingDisabled(true, false);
        scroll.setFadeScrollBars(false);
        scroll.setScrollbarsOnTop(false);
        this.location_window.add(scroll).maxHeight(200.0f).maxWidth(200.0f);
        this.location_window.setScale(1.5f);
        this.location_window.pack();
        this.location_window.layout();
        this.stage.addActor(this.location_window);
    }

    public void closeLocationWindow() {
        this.location_window.remove();
        this.location_window = null;
    }

    private void setupLocations() {
        String[] lines;
        this.locations = new ArrayList();
        FileHandle cc = VNAnd.getLoaderConfigDirectory(this.loader_config).child("locations.txt");
        boolean save = false;
        if (cc.exists()) {
            lines = cc.readString().split("\n");
        } else {
            save = true;
            if (Gdx.app.getType() == Application.ApplicationType.Android) {
                lines = new String[]{"/storage/emulated/0/vnand", "/storage/extSdCard/vnand/"};
            } else {
                ArrayList<String> l = new ArrayList<String>();
                l.add(new FileHandle("").file().getAbsolutePath());
                l.add(Gdx.files.external("vnand").file().getAbsolutePath());
                lines = new String[l.size()];
                for (int i = 0; i < l.size(); ++i) {
                    lines[i] = (String)l.get(i);
                }
            }
        }
        this.addLocations(lines, true);
    }

    public void addLocations(String[] loc, boolean save) {
        for (int i = 0; i < loc.length; ++i) {
            String cleaned = loc[i].trim();
            if (cleaned.length() <= 0) continue;
            this.locations.add(cleaned);
        }
        if (save) {
            FileHandle cc = VNAnd.getLoaderConfigDirectory(this.loader_config).child("locations.txt");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.locations.size(); ++i) {
                sb.append(this.locations.get(i));
                sb.append("\n");
            }
            cc.writeString(sb.toString(), false);
        }
    }

    private void createTrail(FileHandle fh) {
        this.trail.clear();
        ArrayList<TrailButton> t_list = new ArrayList<TrailButton>();
        FileHandle current_fh = fh;
        while (true) {
            TrailButton tb = new TrailButton(this, current_fh, VNAnd.skin);
            t_list.add(tb);
            FileHandle nfh = current_fh.parent();
            if (nfh.equals(current_fh)) break;
            current_fh = nfh;
        }
        for (int i = t_list.size() - 1; i >= 0; --i) {
            this.trail.addActor((Actor)t_list.get(i));
        }
    }

    private FileHandle calcInitialDirectory(String default_directory) {
        FileHandle fh = null;
        FileHandle cc = VNAnd.getLoaderConfigDirectory(this.loader_config).child("last_dir.txt");
        if (cc.exists()) {
            fh = Gdx.files.absolute(cc.readString());
        } else if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
            fh = new FileHandle(new FileHandle(default_directory).file().getAbsolutePath());
        } else if (Gdx.app.getType() == Application.ApplicationType.Android && default_directory.equals("")) {
            fh = VNAnd.vnand_root;
        }
        return fh;
    }

    private void discoverNovels(FileHandle dir) {
        this.novels.clear();
        ArrayList<FileHandle> files = new ArrayList<FileHandle>();
        FileHandle[] list = dir.list();
        for (int i = 0; i < list.length; ++i) {
            files.add(list[i]);
        }
        this.q_entries.clear();
        this.async.startRecognition(files);
        this.force_check = true;
    }

    public void addGame(VNEntry entry) {
        try {
            this.q_entries.put(entry);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void positionNovels(int width, int height) {
        int columns = width / 320;
        if (columns <= 0) {
            columns = 1;
        }
        this.file_table.clear();
        for (int i = 0; i < this.novels.size(); ++i) {
            if (i % columns == 0 && i != 0) {
                this.file_table.row();
            }
            this.file_table.add((Actor)this.novels.get(i));
        }
        this.file_table.layout();
    }

    public void makeGame(VNEntry novel) {
        novel.activate(this.game, this.batch);
    }

    private void checkEntries() {
        if (!this.force_check && this.q_entries.size() == 0) {
            return;
        }
        this.force_check = false;
        int i = 0;
        while (this.q_entries.size() > 0 && i < 32) {
            try {
                VNEntry ent = this.q_entries.take();
                ent.loadThumbnail();
                this.novels.add(ent);
                ++i;
            }
            catch (Exception exception) {}
        }
        Collections.sort(this.novels, VNEntry.ALPHABETIZE);
        this.positionNovels((int)((float)Gdx.graphics.getWidth() * this.w_div), Gdx.graphics.getHeight());
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.act(delta);
        this.checkEntries();
        this.batch.begin();
        this.stage.draw();
        this.batch.end();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
        this.split.setSplitAmount(64.0f / (float)height);
        this.positionNovels((int)((float)width * this.w_div), height);
    }

    @Override
    public void show() {
        InputMultiplexer mult = new InputMultiplexer(this.stage, this);
        Gdx.input.setInputProcessor(mult);
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean keyDown(int keycode) {
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        if (keycode == 4) {
            Gdx.app.exit();
        }
        return true;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    public void enterDirectory(FileHandle fh) {
        this.current_directory = fh;
        this.loadCurrentDirectory();
        this.stage.getViewport().update(Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), true);
    }

    public void backDirectory() {
        System.out.println(this.current_directory.path());
        System.out.println(this.current_directory.parent().path());
        this.current_directory = this.current_directory.parent();
        this.loadCurrentDirectory();
        this.stage.getViewport().update(Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), true);
    }

    private void loadCurrentDirectory() {
        FileHandle c = VNAnd.getLoaderConfigDirectory(this.loader_config);
        c.child("last_dir.txt").writeString(this.current_directory.path(), false);
        this.createTrail(this.current_directory);
        this.discoverNovels(this.current_directory);
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        if (this.dragging > 0) {
            return true;
        }
        this.tempv.x = screenX;
        this.tempv.y = screenY;
        this.tempv.z = 0.0f;
        this.stage.getViewport().unproject(this.tempv);
        return true;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }
}

