/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.viewport.ExtendViewport;
import com.youkaicountry.vnand.VNAnd;
import com.youkaicountry.vnand.actors.RectangleActor;
import com.youkaicountry.vnand.actors.SpriteActor;
import com.youkaicountry.vnand.actors.VNSaveSlot;
import com.youkaicountry.vnand.gameengines.vnovels.VNSave;
import com.youkaicountry.vnand.gameengines.vnovels.vnsprites.VNSingleSprite;
import com.youkaicountry.vnand.screens.VNScreen;
import com.youkaicountry.vnand.utils.text.VNFont;

public class SaveLoadScreen
implements Screen,
InputProcessor {
    private FileHandle savedir;
    public Stage stage;
    private SpriteBatch batch;
    private ShapeRenderer shape;
    private RectangleActor rects;
    private Sprite[] buttons;
    private int dragging;
    private VNSaveSlot save_over;
    private VNSaveSlot[] slots;
    private Vector3 tempv;
    private VNAnd game;
    public int current_page;
    public static final int slots_per_page = 6;
    VNFont font;
    private Pixmap thumbnail;
    private FILEMODE mode;

    public SaveLoadScreen(FileHandle savedir, SpriteBatch batch, ShapeRenderer shape, VNAnd game) {
        this.savedir = savedir;
        this.slots = new VNSaveSlot[6];
        this.game = game;
        this.shape = shape;
        this.tempv = new Vector3(0.0f, 0.0f, 0.0f);
        this.batch = batch;
        this.font = new VNFont(Gdx.files.internal("fonts/sazanami.ttf"), "sazanami", 16, 8, 2);
    }

    public void processSaveSlot(VNSaveSlot slot) {
        if (this.mode == FILEMODE.SAVE) {
            this.save(slot);
            return;
        }
        this.load(slot);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.stage.draw();
        this.batch.end();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void show() {
        this.dragging = 0;
        this.save_over = null;
        this.stage = new Stage(new ExtendViewport(640.0f, 480.0f));
        this.rects = new RectangleActor(this.shape);
        this.stage.addActor(this.rects);
        for (int i = 0; i < 6; ++i) {
            this.slots[i] = null;
        }
        this.font = new VNFont(Gdx.files.internal("fonts/sazanami.ttf"), "sazanami", 12, 4, 3);
        Gdx.input.setInputProcessor(this);
        this.loadPage(this.current_page);
        Texture t = new Texture(Gdx.files.internal("sprites/arrow.png"));
        t.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Sprite ra = new Sprite(t);
        ra.setOrigin(0.0f, 0.0f);
        ra.setScale(0.5f);
        ra.setPosition(400.0f, 390.0f);
        Sprite la = new Sprite(ra);
        la.flip(true, false);
        la.setPosition(300.0f, 390.0f);
        SpriteActor sa = new SpriteActor();
        sa.addSprite(new VNSingleSprite(la));
        sa.addSprite(new VNSingleSprite(ra));
        Texture tback = new Texture(Gdx.files.internal("sprites/back.png"));
        tback.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Sprite sback = new Sprite(tback);
        sback.setOrigin(0.0f, 0.0f);
        sback.setScale(0.5f);
        sback.setPosition(500.0f, 390.0f);
        sa.addSprite(new VNSingleSprite(sback));
        this.stage.addActor(sa);
        this.buttons = new Sprite[]{la, ra, sback};
    }

    private void loadPage(int pagenum) {
        this.current_page = pagenum;
        int x = 0;
        int y = 284;
        int start = pagenum * 6;
        int lsnum = 0;
        for (int i = pagenum * 6 + 1; i <= start + 6; ++i) {
            FileHandle fh;
            if (this.slots[lsnum] != null) {
                this.slots[lsnum].remove();
            }
            if ((fh = this.savedir.child(i + ".sav")).exists()) {
                Json json = new Json();
                VNSave save = json.fromJson(VNSave.class, fh.reader());
                Texture thumbnail = new Texture(this.savedir.child(i + ".png"));
                thumbnail.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                Sprite s = new Sprite(thumbnail);
                s.setOrigin(0.0f, 0.0f);
                s.setScale(0.5f);
                this.slots[lsnum] = new VNSaveSlot(save, s, i, this.font);
            } else {
                Texture thumbnail = new Texture(Gdx.files.internal("sprites/none_thumbnail.png"));
                thumbnail.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                Sprite s = new Sprite(thumbnail);
                s.setOrigin(0.0f, 0.0f);
                s.setScale(0.5f);
                this.slots[lsnum] = new VNSaveSlot(null, s, i, this.font);
            }
            this.slots[lsnum].setPosition(x % 2 * 320, y);
            this.stage.addActor(this.slots[lsnum]);
            if (x % 2 == 1) {
                y -= 104;
            }
            ++x;
            ++lsnum;
        }
    }

    @Override
    public void hide() {
        for (int i = 0; i < 6; ++i) {
            this.slots[i].remove();
            this.slots[i].thumbnail.getTexture().dispose();
        }
        this.stage.dispose();
        this.stage = null;
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean keyDown(int keycode) {
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        if (keycode == 4) {
            Gdx.app.exit();
        }
        return true;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        VNSaveSlot save;
        ++this.dragging;
        this.tempv.x = screenX;
        this.tempv.y = screenY;
        this.tempv.z = 0.0f;
        this.stage.getCamera().unproject(this.tempv);
        int button_hit = this.buttonIn(this.tempv);
        if (button_hit >= 0) {
            this.buttonHandle(button_hit);
        }
        this.save_over = save = this.checkNovelOver(this.tempv);
        this.highlightNovel(save, 1.0f, 0.6f, 0.6f);
        return true;
    }

    public void buttonHandle(int num) {
        switch (num) {
            case 0: {
                this.turnPage(-1);
                break;
            }
            case 1: {
                this.turnPage(1);
                break;
            }
            case 2: {
                this.quitMenu();
            }
        }
    }

    private void turnPage(int delta) {
        int newpage = this.current_page + delta;
        if (newpage < 0) {
            return;
        }
        this.loadPage(newpage);
    }

    private void quitMenu() {
        if (this.thumbnail != null) {
            this.thumbnail.dispose();
            this.thumbnail = null;
        }
        this.game.gotoNovel();
    }

    private int buttonIn(Vector3 loc) {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].getBoundingRectangle().contains(loc.x, loc.y)) continue;
            return i;
        }
        return -1;
    }

    private void highlightNovel(VNSaveSlot novel, float r, float g, float b) {
        if (novel == null) {
            return;
        }
        this.rects.clearRectangles();
        this.rects.addRectangle(novel.getX(), novel.getY(), 315.0f, 75.0f, r, g, b, 1.0f);
    }

    public VNSaveSlot checkNovelOver(Vector3 click) {
        for (VNSaveSlot save : this.slots) {
            if (save == null) continue;
            float bottom = save.getY() - 5.0f;
            float top = save.getY() + 80.0f;
            float left = save.getX() - 5.0f;
            float right = save.getX() + 320.0f;
            if (!(click.x <= right) || !(click.x >= left) || !(click.y <= top) || !(click.y >= bottom)) continue;
            return save;
        }
        return null;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        --this.dragging;
        this.tempv.x = screenX;
        this.tempv.y = screenY;
        this.tempv.z = 0.0f;
        if (this.stage == null) {
            return false;
        }
        this.stage.getCamera().unproject(this.tempv);
        VNSaveSlot novel = this.checkNovelOver(this.tempv);
        if (novel == this.save_over && novel != null) {
            this.processSaveSlot(novel);
        }
        this.rects.clear();
        return true;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        this.tempv.x = screenX;
        this.tempv.y = screenY;
        this.tempv.z = 0.0f;
        if (this.stage == null) {
            return false;
        }
        this.stage.getCamera().unproject(this.tempv);
        VNSaveSlot novel = this.checkNovelOver(this.tempv);
        if (this.save_over == novel) {
            this.highlightNovel(novel, 1.0f, 0.6f, 0.6f);
        } else {
            this.rects.clearRectangles();
        }
        return true;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        if (this.dragging > 0) {
            return true;
        }
        this.tempv.x = screenX;
        this.tempv.y = screenY;
        this.tempv.z = 0.0f;
        if (this.stage == null) {
            return false;
        }
        this.stage.getCamera().unproject(this.tempv);
        this.dragOver(this.tempv, 0.8f, 0.4f, 0.4f);
        return true;
    }

    private void dragOver(Vector3 loc, float r, float g, float b) {
        VNSaveSlot novel = this.checkNovelOver(this.tempv);
        if (novel == null && this.save_over != null) {
            this.rects.clearRectangles();
            this.save_over = null;
        } else if (novel != this.save_over) {
            this.highlightNovel(novel, r, g, b);
            this.save_over = novel;
        }
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }

    public void enterSaveMode(Pixmap thumbnail) {
        this.mode = FILEMODE.SAVE;
        this.thumbnail = thumbnail;
    }

    public void enterLoadMode() {
        this.mode = FILEMODE.LOAD;
    }

    private void save(VNSaveSlot slot) {
        if (slot.data == null) {
            // empty if block
        }
        ((VNScreen)VNAnd.current_screen).vn.fullSave("" + slot.num, this.thumbnail);
        this.loadPage(this.current_page);
    }

    private void load(VNSaveSlot slot) {
        if (slot.data == null) {
            return;
        }
        ((VNScreen)VNAnd.current_screen).vn.load(slot.data);
        this.quitMenu();
    }

    public static enum FILEMODE {
        SAVE,
        LOAD;

    }
}

