/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.youkaicountry.vnand.VNAnd;
import com.youkaicountry.vnand.actors.ButtonActor;
import com.youkaicountry.vnand.actors.IFadeEvent;
import com.youkaicountry.vnand.actors.IMenuSelection;
import com.youkaicountry.vnand.actors.MenuActor;
import com.youkaicountry.vnand.actors.SlottedAssetActor;
import com.youkaicountry.vnand.actors.SpriteActor;
import com.youkaicountry.vnand.gameengines.vnovels.AudioManager;
import com.youkaicountry.vnand.gameengines.vnovels.ScreenMode;
import com.youkaicountry.vnand.gameengines.vnovels.ScreenModeManager;
import com.youkaicountry.vnand.gameengines.vnovels.VNSprite;
import com.youkaicountry.vnand.gameengines.vnovels.VisualNovel;
import com.youkaicountry.vnand.gameengines.vnovels.effect.IEffectEvent;
import com.youkaicountry.vnand.gameengines.vnovels.effect.VNEffect;
import com.youkaicountry.vnand.gameengines.vnovels.effect.effects.FadeEffect;
import com.youkaicountry.vnand.screens.SaveLoadScreen;
import com.youkaicountry.vnand.utils.ImageUtils;
import com.youkaicountry.vnand.utils.assethandling.AssetManager;
import com.youkaicountry.vnand.utils.assethandling.assets.SpriteAsset;
import com.youkaicountry.vnand.utils.text.TextHandler;
import java.util.ArrayList;

public class VNScreen
implements Screen,
InputProcessor,
IMenuSelection,
IEffectEvent,
IFadeEvent {
    static final String MENU_CANCEL = "Cancel";
    static final String MENU_TEXTBOX = "Toggle Textbox (SPACE)";
    static final String MENU_SAVE = "Save";
    static final String MENU_LOAD = "Load";
    static final String MENU_SCREENMODE = "Cycle Screen Mode";
    static final String MENU_RETURN = "Return to Main Menu";
    public ScreenModeManager screen_modes;
    public VNAnd game;
    public Stage stage;
    public VisualNovel vn;
    private SpriteBatch batch;
    private SpriteActor backgrounds;
    public ArrayList<String> background_locs;
    public SlottedAssetActor sprites;
    public AssetManager assets;
    public TextHandler text;
    public ButtonActor buttons;
    public boolean keypress_waiting;
    public boolean delay_waiting;
    public float delay;
    private Vector3 tempv;
    private SaveLoadScreen sls;
    public AudioManager audio;
    private ArrayList<VNEffect> effects;
    boolean do_save;
    private MenuActor menu;
    public float width;
    public float height;
    private boolean initialized = false;

    public VNScreen(VNAnd game, SpriteBatch batch) {
        VNAnd.current_screen = this;
        this.initialized = false;
        this.effects = new ArrayList();
        this.do_save = false;
        Gdx.input.setCatchBackKey(true);
        this.background_locs = new ArrayList();
        this.buttons = new ButtonActor(this);
        this.backgrounds = new SpriteActor();
        this.sprites = new SlottedAssetActor(this, this);
        this.sprites.setReplacementPolicy(true, true, true, 0.1f);
        this.batch = batch;
        this.assets = new AssetManager();
        this.keypress_waiting = false;
        this.delay_waiting = false;
        this.delay = 0.0f;
        this.tempv = new Vector3(0.0f, 0.0f, 0.0f);
        this.game = game;
        this.audio = new AudioManager();
    }

    public void addFadeInBackground(VNSprite s, String background_loc, float fade_in_time) {
        this.vn.blocked = true;
        this.effects.add(new FadeEffect(s, this, 0.0f, 1.0f, fade_in_time, ""));
        this.addBackground(s);
        this.background_locs.add(background_loc);
    }

    public void addBackground(VNSprite s, String background_loc) {
        this.addBackground(s);
        this.background_locs.add(background_loc);
    }

    public void addBackground(VNSprite s) {
        this.backgrounds.addSprite(s);
    }

    public void clearBackgrounds() {
        this.backgrounds.clearSprites();
        this.background_locs.clear();
    }

    public void clearAllButTopNBackgrounds(int n) {
        this.backgrounds.clearAllButN(n);
        this.background_locs = new ArrayList<String>(this.background_locs.subList(this.background_locs.size() - n, this.background_locs.size()));
    }

    public void addSprite(SpriteAsset s, float x, float y) {
        this.vn.positionImage(s, x, y);
        this.sprites.addImageAsset(s);
    }

    public void transitionSprites(float time, boolean destructive) {
        this.sprites.transitionQueuedSprites(time, destructive);
    }

    public void deflateAssets() {
        this.backgrounds.clearSprites();
        this.sprites.deflateAssets();
    }

    public void inflateAssets() {
        for (int i = 0; i < this.background_locs.size(); ++i) {
            VNSprite s = this.vn.getImage(this.background_locs.get(i), "background");
            this.addBackground(s);
        }
        this.sprites.inflateAssets();
    }

    public void clearSprites() {
        this.sprites.clearSprites();
    }

    public void setVisualNovel(VisualNovel vn) {
        this.vn = vn;
        System.out.println("VN");
        VNAnd.settings.addChild(vn.settings);
        this.width = VNAnd.settings.getSetting("width");
        this.height = VNAnd.settings.getSetting("height");
        this.screen_modes = this.vn.makeScreenModeManager();
        this.screen_modes.setScreenMode(vn.getDefaultScreenMode());
        this.text = new TextHandler();
        this.stage = new Stage(new FitViewport(this.width * 2.0f, this.height));
        System.out.println(this.width + "x" + this.height);
        this.stage.addActor(this.backgrounds);
        this.stage.addActor(this.sprites);
        this.stage.addActor(this.text);
        this.stage.addActor(this.buttons);
        this.vn.init();
        this.refreshScreenMode();
        this.sls = new SaveLoadScreen(this.vn.getSaveLoc(), this.batch, this.game.shape, this.game);
        Gdx.input.setInputProcessor(this);
        this.menu = new MenuActor(new String[]{MENU_CANCEL, MENU_TEXTBOX, MENU_SAVE, MENU_LOAD, MENU_SCREENMODE, MENU_RETURN}, this, 50.0f, 50.0f);
        this.stage.addActor(this.menu);
        this.initialized = true;
    }

    private void refreshScreenMode() {
        this.refreshStageScreenMode();
        this.text.refreshScreenMode();
        this.buttons.repositionButtons();
    }

    private void refreshStageScreenMode() {
        ScreenMode sm = this.screen_modes.getCurrentScreenMode();
        if (sm.mode == ScreenMode.Mode.DUAL_BOTTOM) {
            this.stage.setViewport(new FitViewport(this.width, this.height * 2.0f));
        } else if (sm.mode == ScreenMode.Mode.DUAL_RIGHT) {
            this.stage.setViewport(new FitViewport(this.width * 2.0f, this.height));
        } else if (sm.mode == ScreenMode.Mode.SINGLE) {
            this.stage.setViewport(new FitViewport(this.width, this.height));
        }
        this.stage.getViewport().update(Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), true);
    }

    @Override
    public void render(float delta) {
        this.sprites.update(delta);
        this.backgrounds.update(delta);
        if (this.effects.size() > 0) {
            int i;
            ArrayList<Integer> removal = new ArrayList<Integer>();
            for (i = 0; i < this.effects.size(); ++i) {
                if (!this.effects.get(i).update(delta)) continue;
                removal.add(i);
            }
            for (i = 0; i < removal.size(); ++i) {
                this.effects.remove(i - i);
            }
        }
        if (this.do_save) {
            this.toggleTextHidden();
        }
        if (!this.text.hidden) {
            if (this.delay_waiting) {
                this.delay -= delta;
                if (this.delay <= 0.0f) {
                    this.stopWaiting();
                }
            }
            this.text.update(delta);
            this.vn.update();
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.stage.draw();
        this.batch.end();
        if (this.do_save) {
            Pixmap thumbnail = ImageUtils.getScreenshot(0, 0, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), true);
            this.toggleTextHidden();
            this.save(thumbnail);
        }
    }

    public void startWaiting(boolean keypress, float delay) {
        this.keypress_waiting = keypress;
        if (delay > 0.0f) {
            this.delay = delay;
            this.delay_waiting = true;
        }
        this.vn.blocked = true;
    }

    public void stopWaiting() {
        this.keypress_waiting = false;
        this.delay_waiting = false;
        this.delay = 0.0f;
        this.vn.blocked = false;
        if (this.screen_modes.getCurrentScreenMode().wait_clear) {
            this.text.clearText();
        }
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this);
        this.refreshScreenMode();
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public boolean keyDown(int keycode) {
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        if (keycode == 62) {
            this.toggleTextHidden();
            this.menu.disable();
        } else if (keycode == 31) {
            ImageUtils.saveScreenshot(Gdx.files.external("vnand/picpic.png"), 256, 192);
            this.menu.enable();
        } else if (keycode == 4) {
            if (this.menu.isEnabled()) {
                this.returnMain();
                return true;
            }
            this.toggleMenu();
        } else if (keycode == 131) {
            this.toggleMenu();
        }
        return false;
    }

    private void toggleTextHidden() {
        this.text.toggleTextHidden();
        boolean hidden = this.text.hidden;
        this.text.setTextboxEnabled(!hidden);
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (button == 1) {
            this.toggleMenu();
            return true;
        }
        if (this.menu.isEnabled()) {
            this.menu.touchDown(screenX, screenY, pointer, button);
            return true;
        }
        if (this.text.hidden) {
            this.toggleTextHidden();
            return true;
        }
        this.tempv.x = screenX;
        this.tempv.y = screenY;
        this.tempv.z = 0.0f;
        this.stage.getViewport().unproject(this.tempv);
        if (this.buttons.size() > 0) {
            this.buttons.touchDown(this.tempv.x, this.tempv.y);
            return true;
        }
        this.text.flushAll();
        if (this.keypress_waiting) {
            this.stopWaiting();
        }
        return true;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (!this.initialized) {
            return false;
        }
        if (this.menu.isEnabled()) {
            this.menu.touchUp(screenX, screenY, pointer, button);
            return true;
        }
        if (this.buttons.size() > 0) {
            this.tempv.x = screenX;
            this.tempv.y = screenY;
            this.tempv.z = 0.0f;
            this.stage.getViewport().unproject(this.tempv);
            this.buttons.touchUp(this.tempv.x, this.tempv.y);
            return true;
        }
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        if (!this.initialized) {
            return false;
        }
        if (this.menu.isEnabled()) {
            this.menu.touchDragged(screenX, screenY, pointer);
            return true;
        }
        if (this.buttons.size() > 0) {
            this.tempv.x = screenX;
            this.tempv.y = screenY;
            this.tempv.z = 0.0f;
            this.stage.getCamera().unproject(this.tempv);
            this.buttons.touchDragged(this.tempv.x, this.tempv.y);
        }
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        if (!this.initialized) {
            return false;
        }
        if (this.menu.isEnabled()) {
            this.menu.mouseMoved(screenX, screenY);
            return true;
        }
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }

    @Override
    public void menuSelection(String selection, int id) {
        this.menu.disable();
        if (selection.equals(MENU_TEXTBOX)) {
            this.toggleTextHidden();
        } else if (selection.equals(MENU_SAVE)) {
            this.startSave();
        } else if (selection.equals(MENU_LOAD)) {
            this.load();
        } else if (selection.equals(MENU_RETURN)) {
            this.returnMain();
        } else if (selection.equals(MENU_SCREENMODE)) {
            this.screen_modes.nextScreenMode();
            this.refreshScreenMode();
        }
    }

    public void startSave() {
        this.do_save = true;
        this.menu.disable();
    }

    public void save(Pixmap thumbnail) {
        this.do_save = false;
        this.sls.enterSaveMode(thumbnail);
        this.game.setScreen(this.sls);
    }

    public void load() {
        this.sls.enterLoadMode();
        this.game.setScreen(this.sls);
    }

    public void returnMain() {
        this.game.quitGame();
    }

    public void toggleMenu() {
        if (this.menu.toggleEnabled()) {
            this.menu.remove();
            this.stage.addActor(this.menu);
        }
    }

    @Override
    public void effectFinished(VNEffect effect) {
        if (this.effects.size() == 1) {
            this.vn.blocked = false;
        }
    }

    @Override
    public void fadeChainStarted() {
        this.vn.blocked = true;
    }

    @Override
    public void fadeChainComplete() {
        this.vn.blocked = false;
    }

    @Override
    public void dispose() {
        this.audio.stopAllAudio();
        this.assets.unloadAll();
        this.deflateAssets();
        this.vn.cleanup();
    }
}

