/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.utils;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ArchiveFileHandle
extends FileHandle {
    final ZipFile archive;
    final ZipEntry archiveEntry;

    public ArchiveFileHandle(ZipFile archive, File file) {
        super(file, Files.FileType.External);
        this.archive = archive;
        this.archiveEntry = this.archive.getEntry(file.getPath());
    }

    public ArchiveFileHandle(ZipFile archive, String fileName) {
        super(fileName.replace('\\', '/'), Files.FileType.External);
        this.archive = archive;
        this.archiveEntry = archive.getEntry(fileName.replace('\\', '/'));
    }

    @Override
    public FileHandle child(String name) {
        name = name.replace('\\', '/');
        if (this.file.getPath().length() == 0) {
            return new ArchiveFileHandle(this.archive, new File(name));
        }
        return new ArchiveFileHandle(this.archive, new File(this.file, name));
    }

    @Override
    public FileHandle sibling(String name) {
        name = name.replace('\\', '/');
        if (this.file.getPath().length() == 0) {
            throw new GdxRuntimeException("Cannot get the sibling of the root.");
        }
        return new ArchiveFileHandle(this.archive, new File(this.file.getParent(), name));
    }

    @Override
    public FileHandle parent() {
        File parent = this.file.getParentFile();
        if (parent == null) {
            parent = this.type == Files.FileType.Absolute ? new File("/") : new File("");
        }
        return new ArchiveFileHandle(this.archive, parent);
    }

    @Override
    public InputStream read() {
        try {
            return this.archive.getInputStream(this.archiveEntry);
        }
        catch (IOException e) {
            throw new GdxRuntimeException("File not found: " + this.file + " (Archive)");
        }
    }

    @Override
    public boolean exists() {
        return this.archiveEntry != null;
    }

    @Override
    public long length() {
        return this.archiveEntry.getSize();
    }

    @Override
    public long lastModified() {
        return this.archiveEntry.getTime();
    }
}

