/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.utils;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.youkaicountry.vnand.utils.InputStreamFileHandle;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtil {
    public static FileHandle getAndroidTempDirectory() {
        return Gdx.app.getType() == Application.ApplicationType.Android ? Gdx.files.external("vnand/temp") : null;
    }

    public static void cleanAndroidTempDirectory() {
        FileHandle temp = FileUtil.getAndroidTempDirectory();
        if (temp == null || !temp.exists()) {
            return;
        }
        temp.emptyDirectory();
    }

    public static FileHandle getFileFromZip(ZipFile zip, String filename, String[] alternate_extensions, FileHandle writeTempDir) {
        FileHandle fh;
        ZipEntry entry = com.youkaicountry.util.FileUtil.getEntryFromZip(zip, filename, alternate_extensions);
        if (entry == null) {
            return null;
        }
        if (writeTempDir != null) {
            fh = writeTempDir.child(filename);
            if (!fh.exists()) {
                try {
                    fh.write(zip.getInputStream(entry), false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            fh = new InputStreamFileHandle(entry.getName(), zip, entry);
        }
        return fh;
    }

    public static FileHandle getFileFromDir(FileHandle dir, String filename, String[] alternate_extensions) {
        FileHandle fh = null;
        int i = -1;
        String current_name = filename;
        String base_name = null;
        while (!(fh != null && fh.exists() || (fh = dir.child(current_name)).exists() || ++i >= alternate_extensions.length)) {
            if (base_name == null) {
                base_name = com.youkaicountry.util.FileUtil.removeExtension(filename);
            }
            current_name = base_name + "." + alternate_extensions[i];
        }
        return fh;
    }

    public static String getDirectoryName(FileHandle fh) {
        int i;
        String s = fh.path();
        if (s.length() == 0) {
            return s;
        }
        if (s.charAt(s.length() - 1) == '/' && s.length() > 1) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.length() > 1 && (i = s.lastIndexOf("/")) >= 0) {
            s = s.substring(i + 1);
        }
        return s;
    }
}

