/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.utils;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import java.util.ArrayList;

public class ImageHull {
    public static float[] generateScanHull(TextureRegion tr) {
        tr.getTexture().getTextureData().prepare();
        Pixmap pm = tr.getTexture().getTextureData().consumePixmap();
        return ImageHull.generateScanHull(pm, tr);
    }

    public static float[] generateScanHull(Pixmap pm, TextureRegion tr) {
        ArrayList<Integer> points = new ArrayList<Integer>();
        boolean y_top = false;
        boolean y_bottom = false;
        boolean x_right = false;
        boolean x_left = false;
        for (int y = 0; y < tr.getRegionHeight(); ++y) {
            boolean found = false;
            int last_x = -1;
            int last_y = -1;
            for (int x = 0; x < tr.getRegionWidth(); ++x) {
                int c = pm.getPixel(tr.getRegionX() + x, tr.getRegionY() + y);
                if (c == 0) continue;
                if (!found) {
                    points.add(x);
                    points.add(y);
                } else {
                    last_x = x;
                    last_y = y;
                }
                found = true;
            }
            if (!found) continue;
            if (last_x < 0) break;
            points.add(last_x);
            points.add(last_y);
            break;
        }
        return null;
    }
}

