/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ImageUtils {
    private static final int BUFFER_SIZE = 8192;

    public static Pixmap getScreenshot(int x, int y, int w, int h, boolean flipY) {
        Gdx.gl.glPixelStorei(3333, 1);
        Pixmap pixmap = new Pixmap(w, h, Pixmap.Format.RGBA8888);
        ByteBuffer pixels = pixmap.getPixels();
        Gdx.gl.glReadPixels(x, y, w, h, 6408, 5121, pixels);
        int numBytes = w * h * 4;
        byte[] lines = new byte[numBytes];
        if (flipY) {
            int numBytesPerLine = w * 4;
            for (int i = 0; i < h; ++i) {
                pixels.position((h - i - 1) * numBytesPerLine);
                pixels.get(lines, i * numBytesPerLine, numBytesPerLine);
            }
            pixels.clear();
            pixels.put(lines);
        } else {
            pixels.clear();
            pixels.get(lines);
        }
        return pixmap;
    }

    public static void saveScreenshot(FileHandle file, int x, int y, int w, int h) {
        Pixmap pixmap = ImageUtils.getScreenshot(x, y, w, h, true);
        ImageUtils.saveScreenshot(file, pixmap);
        pixmap.dispose();
    }

    public static void saveScreenshot(FileHandle file, Pixmap pixmap) {
        PixmapIO.writePNG(file, pixmap);
    }

    public static void saveScreenshot(FileHandle file, Pixmap pixmap, int width, int height) {
        Pixmap scaled = new Pixmap(width, height, Pixmap.Format.RGBA8888);
        scaled.drawPixmap(pixmap, 0, 0, pixmap.getWidth(), pixmap.getHeight(), 0, 0, width, height);
        ImageUtils.saveScreenshot(file, scaled);
        scaled.dispose();
    }

    public static void saveScreenshot(FileHandle file, int width, int height) {
        Pixmap raw = ImageUtils.getScreenshot(0, 0, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), true);
        Pixmap scaled = new Pixmap(width, height, Pixmap.Format.RGBA8888);
        scaled.drawPixmap(raw, 0, 0, raw.getWidth(), raw.getHeight(), 0, 0, width, height);
        ImageUtils.saveScreenshot(file, scaled);
        raw.dispose();
        scaled.dispose();
    }

    public static void saveScreenshot(FileHandle file, int clipx, int clipy, int clipwidth, int clipheight, int width, int height) {
        Pixmap raw = ImageUtils.getScreenshot(clipx, clipy, clipwidth, clipheight, true);
        Pixmap scaled = new Pixmap(width, height, Pixmap.Format.RGBA8888);
        scaled.drawPixmap(raw, 0, 0, raw.getWidth(), raw.getHeight(), 0, 0, width, height);
        ImageUtils.saveScreenshot(file, scaled);
        raw.dispose();
        scaled.dispose();
    }

    public static Pixmap scalePixmap(Pixmap original, int new_width, int new_height) {
        Pixmap scaled = new Pixmap(new_width, new_height, original.getFormat());
        scaled.drawPixmap(original, 0, 0, original.getWidth(), original.getHeight(), 0, 0, new_width, new_height);
        return scaled;
    }

    public static Pixmap scalePixmapRatio(Pixmap original, int target_width, int target_height) {
        float scale = ImageUtils.getScaleFactor(original.getWidth(), original.getHeight(), target_width, target_height);
        int w = (int)(scale * (float)original.getWidth());
        int h = (int)(scale * (float)original.getHeight());
        Pixmap scaled = new Pixmap(target_width, target_height, original.getFormat());
        int woff = (target_width - w) / 2;
        int hoff = (target_height - h) / 2;
        scaled.drawPixmap(original, 0, 0, original.getWidth(), original.getHeight(), woff, hoff, w, h);
        return scaled;
    }

    public static float getScaleFactor(float iwidth, float iheight, float twidth, float theight) {
        if (iwidth > twidth || iheight > theight) {
            if (iwidth - twidth > iheight - theight) {
                return twidth / iwidth;
            }
            return theight / iheight;
        }
        if (twidth - iwidth < theight - iheight) {
            return twidth / iwidth;
        }
        return theight / iheight;
    }

    public static Pixmap streamToPixmap(InputStream stream) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            int length;
            byte[] buf = new byte[8192];
            while ((length = stream.read(buf, 0, buf.length)) >= 0) {
                bytes.write(buf, 0, length);
            }
        }
        catch (IOException buf) {
            // empty catch block
        }
        byte[] fdata = bytes.toByteArray();
        Pixmap pix = new Pixmap(fdata, 0, fdata.length);
        return pix;
    }
}

