/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.utils;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.youkaicountry.vnand.utils.ArchiveFileHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class InputStreamFileHandle
extends FileHandle {
    private String filename;
    private ZipFile zipfile;
    private ZipEntry entry;

    public InputStreamFileHandle(String filename, ZipFile zip, ZipEntry entry) {
        super(filename.replace('\\', '/'), Files.FileType.Internal);
        this.filename = filename;
        this.zipfile = zip;
        this.entry = entry;
    }

    @Override
    public String extension() {
        String name = this.filename;
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return "";
        }
        return name.substring(dotIndex + 1);
    }

    @Override
    public InputStream read() {
        try {
            return this.zipfile.getInputStream(this.entry);
        }
        catch (IOException e) {
            throw new GdxRuntimeException("File not found: " + this.file + " (Archive)");
        }
    }

    @Override
    public boolean exists() {
        return this.entry != null;
    }

    @Override
    public long length() {
        return this.entry.getSize();
    }

    @Override
    public FileHandle child(String name) {
        name = name.replace('\\', '/');
        if (this.file.getPath().length() == 0) {
            return new ArchiveFileHandle(this.zipfile, new File(name));
        }
        return new ArchiveFileHandle(this.zipfile, new File(this.file, name));
    }

    @Override
    public FileHandle sibling(String name) {
        name = name.replace('\\', '/');
        if (this.file.getPath().length() == 0) {
            throw new GdxRuntimeException("Cannot get the sibling of the root.");
        }
        return new ArchiveFileHandle(this.zipfile, new File(this.file.getParent(), name));
    }

    @Override
    public FileHandle parent() {
        File parent = this.file.getParentFile();
        if (parent == null) {
            parent = this.type == Files.FileType.Absolute ? new File("/") : new File("");
        }
        return new ArchiveFileHandle(this.zipfile, parent);
    }

    @Override
    public long lastModified() {
        return this.entry.getTime();
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        byte[] buf;
        int size = 1024;
        if (is instanceof ByteArrayInputStream) {
            size = is.available();
            buf = new byte[size];
            int len = is.read(buf, 0, size);
        } else {
            int len;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            buf = new byte[size];
            while ((len = is.read(buf, 0, size)) != -1) {
                bos.write(buf, 0, len);
            }
            buf = bos.toByteArray();
        }
        return buf;
    }
}

