/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.utils;

import com.badlogic.gdx.files.FileHandle;
import java.io.InputStream;
import java.util.HashMap;

public class TempFileManager {
    FileHandle temp_dir;
    HashMap<String, FileHandle> name2fh;
    int nextfile = 0;

    public TempFileManager(FileHandle tempdir) {
        this.temp_dir = tempdir;
        this.name2fh = new HashMap();
        this.flushFiles();
    }

    public FileHandle getTempFile(String name) {
        System.out.println("GET " + name);
        return this.name2fh.get(name);
    }

    public void removeAllTempFiles() {
        this.name2fh.clear();
        this.flushFiles();
    }

    private void flushFiles() {
        for (FileHandle fh : this.temp_dir.list()) {
            fh.delete();
        }
    }

    private String getExtension(String name) {
        String[] parts = name.split("\\.");
        String ext = parts[parts.length - 1];
        return ext;
    }

    private String getTempFileName(String name) {
        String ext = this.getExtension(name);
        String base = "" + this.nextfile;
        ++this.nextfile;
        String fname = ext == null ? base : base + "." + ext;
        return fname;
    }

    public FileHandle addTempFile(String name, InputStream inp) {
        String fname = this.getTempFileName(name);
        FileHandle fh = this.temp_dir.child(fname);
        fh.write(inp, false);
        this.name2fh.put(name, fh);
        return fh;
    }
}

