/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.utils.pcspeaker;

public class PCSpeakerClip {
    private short[] clip;
    private int sample_rate;
    private double time;

    public PCSpeakerClip(int sample_rate, double[] frequencies, double[] time) {
        this.sample_rate = sample_rate;
        double time_sum = 0.0;
        for (int i = 0; i < time.length; ++i) {
            time_sum += time[i];
        }
        this.time = time_sum;
        int length = (int)((double)sample_rate * time_sum);
        double[] sample = new double[length];
        int offset = 0;
        for (int i = 0; i < frequencies.length; ++i) {
            int num_samples = (int)(time[i] * (double)sample_rate);
            if (num_samples > length - offset) {
                num_samples -= num_samples - (length - offset);
            }
            this.genSquareSample(sample, offset, num_samples, sample_rate, frequencies[i]);
            offset += num_samples;
        }
        this.clip = this.sample2PCM(sample);
    }

    public short[] getSample() {
        return this.clip;
    }

    public int getSampleRate() {
        return this.sample_rate;
    }

    public int getNumberSamples() {
        return this.clip.length;
    }

    public double getLength() {
        return this.time;
    }

    private short[] sample2PCM(double[] sample) {
        int idx = 0;
        short[] pcm = new short[sample.length];
        for (double dVal : sample) {
            short val = (short)(dVal * 32767.0);
            pcm[idx++] = val;
        }
        return pcm;
    }

    private double[] genSquareSample(double[] buffer, int offset, int numSamples, double sampleRate, double freqOfTone) {
        double mul = -1.0;
        int flip = 0;
        for (int i = 0; i < numSamples; ++i) {
            if (flip <= 0) {
                mul *= -1.0;
                flip = (int)(sampleRate / freqOfTone / 2.0);
            }
            buffer[i + offset] = mul;
            --flip;
        }
        return buffer;
    }
}

