/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.utils.pcspeaker;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.AudioDevice;

public class PCSpeakerTest {
    AudioDevice device = Gdx.audio.newAudioDevice(8000, true);

    public void testSin(double freq) {
        short[] pcm = this.genSinPCM(16000, 8000.0, freq);
        this.device.writeSamples(pcm, 0, pcm.length);
    }

    public void testSaw(double freq) {
        short[] pcm = this.genSawPCM(16000, 8000.0, freq);
        this.device.writeSamples(pcm, 0, pcm.length);
    }

    public void testSquare(double freq) {
        short[] pcm = this.genSquarePCM(16000, 8000.0, freq);
        this.device.writeSamples(pcm, 0, pcm.length);
    }

    private short[] sample2PCM(double[] sample) {
        int idx = 0;
        short[] pcm = new short[sample.length];
        for (double dVal : sample) {
            short val = (short)(dVal * 4095.0);
            pcm[idx++] = val;
        }
        return pcm;
    }

    private short[] genSinPCM(int numSamples, double sampleRate, double freqOfTone) {
        double[] sample = this.genSinSample(numSamples, sampleRate, freqOfTone);
        return this.sample2PCM(sample);
    }

    private double[] genSinSample(int numSamples, double sampleRate, double freqOfTone) {
        double[] sample = new double[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            sample[i] = Math.sin(Math.PI * 2 * (double)i / (sampleRate / freqOfTone));
        }
        return sample;
    }

    private short[] genSquarePCM(int numSamples, double sampleRate, double freqOfTone) {
        double[] sample = this.genSquareSample(numSamples, sampleRate, freqOfTone);
        return this.sample2PCM(sample);
    }

    private double[] genSquareSample(int numSamples, double sampleRate, double freqOfTone) {
        double[] sample = new double[numSamples];
        double mul = -1.0;
        int flip = 0;
        for (int i = 0; i < numSamples; ++i) {
            if (flip <= 0) {
                mul *= -1.0;
                flip = (int)(sampleRate / freqOfTone / 2.0);
            }
            sample[i] = mul;
            --flip;
        }
        return sample;
    }

    private short[] genSawPCM(int numSamples, double sampleRate, double freqOfTone) {
        double[] sample = this.genSawSample(numSamples, sampleRate, freqOfTone);
        return this.sample2PCM(sample);
    }

    private double[] genSawSample(int numSamples, double sampleRate, double freqOfTone) {
        double[] sample = new double[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            sample[i] = 2.0 * ((double)i % (sampleRate / freqOfTone)) / (sampleRate / freqOfTone) - 1.0;
        }
        return sample;
    }
}

