/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.utils.text;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.youkaicountry.util.TextUtils;
import com.youkaicountry.vnand.VNAnd;
import com.youkaicountry.vnand.actors.VNText;
import com.youkaicountry.vnand.gameengines.vnovels.ScreenMode;
import com.youkaicountry.vnand.gameengines.vnovels.VNSprite;
import com.youkaicountry.vnand.screens.VNScreen;
import com.youkaicountry.vnand.utils.assethandling.assets.FontAsset;
import com.youkaicountry.vnand.utils.text.ITextRenderEvent;
import com.youkaicountry.vnand.utils.text.VNFont;
import java.util.ArrayList;
import java.util.HashMap;

public class TextHandler
extends Actor
implements ITextRenderEvent {
    public HashMap<String, FontAsset> fonts;
    public boolean hidden = false;
    private float tb_base_x;
    private float tb_base_y;
    private float tb_x;
    private float tb_y;
    private float tb_width;
    private float tb_height;
    ArrayList<VNText> tb_text = new ArrayList();
    int tb_index_top;
    private ScreenMode mode;
    public boolean textbox_enabled = false;
    int animation_loc;
    public VNSprite textbox_full;
    public VNSprite textbox_bottom;
    public VNSprite textbox_custom;
    public VNSprite current_textbox;
    String current_font;

    public TextHandler() {
        this.setTextbox(10.0f, 180.0f, 200.0f, 170.0f);
        this.clearText();
        this.fonts = new HashMap();
        this.textbox_full = ((VNScreen)VNAnd.current_screen).vn.getFullTextbox();
        this.textbox_bottom = ((VNScreen)VNAnd.current_screen).vn.getPartialTextbox();
        this.textbox_custom = this.textbox_full;
    }

    public void setTextbox(float x, float y, float width, float height) {
        this.tb_base_x = x;
        this.tb_base_y = y;
        this.tb_width = width;
        this.tb_height = height;
        this.refreshScreenMode();
    }

    public void setTextboxFromMode() {
        this.mode = ((VNScreen)VNAnd.current_screen).screen_modes.getCurrentScreenMode();
        Rectangle tbr = this.mode.text_loc;
        this.tb_base_x = tbr.x;
        this.tb_base_y = tbr.y;
        this.tb_width = tbr.width;
        this.tb_height = tbr.height;
        this.setCurrentFont(this.mode.font);
        this.refontAll(this.current_font);
        switch (this.mode.textbox_mode) {
            case NONE: {
                break;
            }
            case DEFAULT_FULL: {
                this.current_textbox = this.textbox_full;
                break;
            }
            case DEFAULT_BOTTOM: {
                this.current_textbox = this.textbox_bottom;
                break;
            }
            case CUSTOM: {
                if (this.mode.default_textbox == null) break;
                this.setCustomTextbox(this.mode.default_textbox);
            }
        }
        this.resetTextLoc();
    }

    public void setCustomTextbox(VNSprite custom) {
        this.textbox_custom = custom;
        if (this.mode.textbox_mode == ScreenMode.TextboxMode.CUSTOM) {
            this.current_textbox = custom;
        }
    }

    public void setTextboxEnabled(boolean enabled) {
        this.textbox_enabled = enabled;
    }

    public void showTextbox() {
        this.textbox_enabled = true;
    }

    public void hideTextbox() {
        this.textbox_enabled = false;
    }

    public float getTextboxX() {
        return this.tb_x;
    }

    public float getTextboxY() {
        return this.tb_y;
    }

    public float getTextboxWidth() {
        return this.tb_width;
    }

    public float getTextboxHeight() {
        return this.tb_height;
    }

    public void resetTextLoc() {
        this.mode = ((VNScreen)VNAnd.current_screen).screen_modes.getCurrentScreenMode();
        this.tb_x = this.tb_base_x;
        this.tb_y = this.tb_base_y;
    }

    public void refreshScreenMode() {
        this.setTextboxFromMode();
        if (this.mode.mode == ScreenMode.Mode.DUAL_BOTTOM) {
            this.tb_y -= VNAnd.settings.getSetting("height");
        } else if (this.mode.mode == ScreenMode.Mode.DUAL_RIGHT) {
            this.tb_x += VNAnd.settings.getSetting("width");
        } else if (this.mode.mode == ScreenMode.Mode.SINGLE) {
            // empty if block
        }
    }

    public VNText[] getLatestLines(int lines) {
        int num = Math.max(this.tb_text.size() - lines, 0);
        VNText[] s = new VNText[this.tb_text.size() - num];
        int tn = 0;
        for (int i = num; i < this.tb_text.size(); ++i) {
            s[tn] = this.tb_text.get(i);
            ++tn;
        }
        return s;
    }

    public String getLatestLinesAsText(int lines) {
        StringBuilder sb = new StringBuilder();
        VNText[] vta = this.getLatestLines(lines);
        for (int i = 0; i < vta.length; ++i) {
            sb.append(vta[i].text);
            sb.append("\n");
        }
        return sb.toString();
    }

    public void addFont(String name, FontAsset font) {
        this.fonts.put(name, font);
    }

    public void refontAll(String font) {
        if (this.tb_text.size() == 0) {
            return;
        }
        FontAsset fa = this.fonts.get(font);
        for (int i = 0; i < this.tb_text.size(); ++i) {
            this.tb_text.get(i).setFont(fa);
        }
    }

    public void setCurrentFont(String font) {
        this.current_font = font;
    }

    public void addAdnimatedText(String text) {
        this.addAnimatedText(text, VNAnd.settings.getSetting("text_speed"));
    }

    public void addAnimatedText(String text, float char_per_sec) {
        ((VNScreen)VNAnd.current_screen).vn.blocked = true;
        FontAsset vfont = this.fonts.get(this.current_font);
        VNText[] vt = this.makeTextObjects(text, vfont, char_per_sec);
        this.addText(vt);
    }

    private VNText[] makeTextObjects(String text, FontAsset font, float char_per_sec) {
        String[] sp = TextUtils.wrapSplitText(text, (int)(this.tb_width / (float)((VNFont)font.getAsset()).width));
        VNText[] out = new VNText[sp.length];
        for (int i = 0; i < sp.length; ++i) {
            out[i] = new VNText(sp[i], font, this, char_per_sec);
        }
        return out;
    }

    private VNText[] makeTextObjects(String text, FontAsset font) {
        String[] sp = TextUtils.wrapSplitText(text, (int)(this.tb_width / (float)((VNFont)font.getAsset()).width));
        VNText[] out = new VNText[sp.length];
        for (int i = 0; i < sp.length; ++i) {
            out[i] = new VNText(sp[i], font);
        }
        return out;
    }

    public void addAnimatedText(VNText text) {
        this.addText(text);
    }

    public void addText(String text) {
        FontAsset vfont = this.fonts.get(this.current_font);
        VNText[] vt = this.makeTextObjects(text, vfont);
        this.addText(vt);
    }

    private void addText(VNText[] text) {
        for (int i = 0; i < text.length; ++i) {
            this.addText(text[i]);
        }
    }

    private void addText(VNText text) {
        this.tb_text.add(text);
        this.advanceAnimationLoc();
        int sum = this.showingSum();
        while ((float)sum > this.tb_height) {
            int here_height = this.tb_text.get((int)this.tb_index_top).height;
            sum -= here_height;
            ++this.tb_index_top;
        }
    }

    private int showingSum() {
        int adder = 0;
        for (int i = this.tb_index_top; i < this.tb_text.size(); ++i) {
            adder += this.tb_text.get((int)i).height;
        }
        return adder;
    }

    public void advanceAnimationLoc() {
        while (this.animation_loc < this.tb_text.size() && !this.tb_text.get((int)this.animation_loc).animating) {
            ++this.animation_loc;
        }
    }

    public void clearText() {
        this.animation_loc = 0;
        this.tb_index_top = 0;
        this.tb_text.clear();
    }

    public void toggleTextHidden() {
        this.hidden = !this.hidden;
    }

    @Override
    public void finishedRender(VNText vntext) {
        this.advanceAnimationLoc();
        if (this.animation_loc >= this.tb_text.size()) {
            ((VNScreen)VNAnd.current_screen).vn.blocked = false;
        }
    }

    public void flushAll() {
        for (VNText vt : this.tb_text) {
            vt.flush();
        }
    }

    public void update(float dt) {
        if (this.tb_text.size() > this.animation_loc && this.tb_text.get((int)this.animation_loc).animating) {
            this.tb_text.get(this.animation_loc).update(dt);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.textbox_enabled && this.mode.textbox_mode != ScreenMode.TextboxMode.NONE) {
            VNSprite s = this.current_textbox;
            s.setPosition(0.0f, 0.0f);
            s.draw(batch);
        }
        if (!this.hidden) {
            float y = this.tb_y;
            for (int i = this.tb_index_top; i < this.tb_text.size(); ++i) {
                VNText t = this.tb_text.get(i);
                t.draw(batch, this.tb_x, y);
                y -= (float)t.height;
            }
        }
    }
}

