/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.utils.wave8;

import com.badlogic.gdx.files.FileHandle;
import com.youkaicountry.vnand.utils.wave8.WavFileException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class WavFile {
    private static final int BUFFER_SIZE = 4096;
    private static final int FMT_CHUNK_ID = 544501094;
    private static final int DATA_CHUNK_ID = 1635017060;
    private static final int RIFF_CHUNK_ID = 1179011410;
    private static final int RIFF_TYPE_ID = 1163280727;
    private File file;
    private IOState ioState;
    private int bytesPerSample;
    private long numFrames;
    private FileOutputStream oStream;
    private InputStream iStream;
    private double floatScale;
    private double floatOffset;
    private boolean wordAlignAdjust;
    private int numChannels;
    private long sampleRate;
    private int blockAlign;
    private int validBits;
    private byte[] buffer = new byte[4096];
    private int bufferPointer;
    private int bytesRead;
    private long frameCounter;

    private WavFile() {
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public long getNumFrames() {
        return this.numFrames;
    }

    public long getFramesRemaining() {
        return this.numFrames - this.frameCounter;
    }

    public long getSampleRate() {
        return this.sampleRate;
    }

    public int getValidBits() {
        return this.validBits;
    }

    public static WavFile newWavFile(File file, int numChannels, long numFrames, int validBits, long sampleRate) throws IOException, WavFileException {
        WavFile wavFile = new WavFile();
        wavFile.file = file;
        wavFile.numChannels = numChannels;
        wavFile.numFrames = numFrames;
        wavFile.sampleRate = sampleRate;
        wavFile.bytesPerSample = (validBits + 7) / 8;
        wavFile.blockAlign = wavFile.bytesPerSample * numChannels;
        wavFile.validBits = validBits;
        if (numChannels < 1 || numChannels > 65535) {
            throw new WavFileException("Illegal number of channels, valid range 1 to 65536");
        }
        if (numFrames < 0L) {
            throw new WavFileException("Number of frames must be positive");
        }
        if (validBits < 2 || validBits > 65535) {
            throw new WavFileException("Illegal number of valid bits, valid range 2 to 65536");
        }
        if (sampleRate < 0L) {
            throw new WavFileException("Sample rate must be positive");
        }
        wavFile.oStream = new FileOutputStream(file);
        long dataChunkSize = (long)wavFile.blockAlign * numFrames;
        long mainChunkSize = 36L + dataChunkSize;
        if (dataChunkSize % 2L == 1L) {
            ++mainChunkSize;
            wavFile.wordAlignAdjust = true;
        } else {
            wavFile.wordAlignAdjust = false;
        }
        WavFile.putLE(1179011410L, wavFile.buffer, 0, 4);
        WavFile.putLE(mainChunkSize, wavFile.buffer, 4, 4);
        WavFile.putLE(1163280727L, wavFile.buffer, 8, 4);
        wavFile.oStream.write(wavFile.buffer, 0, 12);
        long averageBytesPerSecond = sampleRate * (long)wavFile.blockAlign;
        WavFile.putLE(544501094L, wavFile.buffer, 0, 4);
        WavFile.putLE(16L, wavFile.buffer, 4, 4);
        WavFile.putLE(1L, wavFile.buffer, 8, 2);
        WavFile.putLE(numChannels, wavFile.buffer, 10, 2);
        WavFile.putLE(sampleRate, wavFile.buffer, 12, 4);
        WavFile.putLE(averageBytesPerSecond, wavFile.buffer, 16, 4);
        WavFile.putLE(wavFile.blockAlign, wavFile.buffer, 20, 2);
        WavFile.putLE(validBits, wavFile.buffer, 22, 2);
        wavFile.oStream.write(wavFile.buffer, 0, 24);
        WavFile.putLE(1635017060L, wavFile.buffer, 0, 4);
        WavFile.putLE(dataChunkSize, wavFile.buffer, 4, 4);
        wavFile.oStream.write(wavFile.buffer, 0, 8);
        if (wavFile.validBits > 8) {
            wavFile.floatOffset = 0.0;
            wavFile.floatScale = Long.MAX_VALUE >> 64 - wavFile.validBits;
        } else {
            wavFile.floatOffset = 1.0;
            wavFile.floatScale = 0.5 * (double)((1 << wavFile.validBits) - 1);
        }
        wavFile.bufferPointer = 0;
        wavFile.bytesRead = 0;
        wavFile.frameCounter = 0L;
        wavFile.ioState = IOState.WRITING;
        return wavFile;
    }

    public static WavFile openWavFile(FileHandle file) throws IOException, WavFileException {
        WavFile wavFile = new WavFile();
        wavFile.file = file.file();
        wavFile.iStream = file.read();
        int bytesRead = wavFile.iStream.read(wavFile.buffer, 0, 12);
        if (bytesRead != 12) {
            throw new WavFileException("Not enough wav file bytes for header");
        }
        long riffChunkID = WavFile.getLE(wavFile.buffer, 0, 4);
        long chunkSize = WavFile.getLE(wavFile.buffer, 4, 4);
        long riffTypeID = WavFile.getLE(wavFile.buffer, 8, 4);
        if (riffChunkID != 1179011410L) {
            throw new WavFileException("Invalid Wav Header data, incorrect riff chunk ID");
        }
        if (riffTypeID != 1163280727L) {
            throw new WavFileException("Invalid Wav Header data, incorrect riff type ID");
        }
        if (file.length() != chunkSize + 8L) {
            throw new WavFileException("Header chunk size (" + chunkSize + ") does not match file size (" + file.length() + ")");
        }
        boolean foundFormat = false;
        boolean foundData = false;
        while (true) {
            long numChunkBytes;
            if ((bytesRead = wavFile.iStream.read(wavFile.buffer, 0, 8)) == -1) {
                throw new WavFileException("Reached end of file without finding format chunk");
            }
            if (bytesRead != 8) {
                throw new WavFileException("Could not read chunk header");
            }
            long chunkID = WavFile.getLE(wavFile.buffer, 0, 4);
            chunkSize = WavFile.getLE(wavFile.buffer, 4, 4);
            long l = numChunkBytes = chunkSize % 2L == 1L ? chunkSize + 1L : chunkSize;
            if (chunkID == 544501094L) {
                foundFormat = true;
                bytesRead = wavFile.iStream.read(wavFile.buffer, 0, 16);
                int compressionCode = (int)WavFile.getLE(wavFile.buffer, 0, 2);
                if (compressionCode != 1) {
                    throw new WavFileException("Compression Code " + compressionCode + " not supported");
                }
                wavFile.numChannels = (int)WavFile.getLE(wavFile.buffer, 2, 2);
                wavFile.sampleRate = WavFile.getLE(wavFile.buffer, 4, 4);
                wavFile.blockAlign = (int)WavFile.getLE(wavFile.buffer, 12, 2);
                wavFile.validBits = (int)WavFile.getLE(wavFile.buffer, 14, 2);
                if (wavFile.numChannels == 0) {
                    throw new WavFileException("Number of channels specified in header is equal to zero");
                }
                if (wavFile.blockAlign == 0) {
                    throw new WavFileException("Block Align specified in header is equal to zero");
                }
                if (wavFile.validBits < 2) {
                    throw new WavFileException("Valid Bits specified in header is less than 2");
                }
                if (wavFile.validBits > 64) {
                    throw new WavFileException("Valid Bits specified in header is greater than 64, this is greater than a long can hold");
                }
                wavFile.bytesPerSample = (wavFile.validBits + 7) / 8;
                if (wavFile.bytesPerSample * wavFile.numChannels != wavFile.blockAlign) {
                    throw new WavFileException("Block Align does not agree with bytes required for validBits and number of channels");
                }
                if ((numChunkBytes -= 16L) <= 0L) continue;
                wavFile.iStream.skip(numChunkBytes);
                continue;
            }
            if (chunkID == 1635017060L) {
                if (!foundFormat) {
                    throw new WavFileException("Data chunk found before Format chunk");
                }
                if (chunkSize % (long)wavFile.blockAlign != 0L) {
                    throw new WavFileException("Data Chunk size is not multiple of Block Align");
                }
                break;
            }
            wavFile.iStream.skip(numChunkBytes);
        }
        wavFile.numFrames = chunkSize / (long)wavFile.blockAlign;
        foundData = true;
        if (!foundData) {
            throw new WavFileException("Did not find a data chunk");
        }
        if (wavFile.validBits > 8) {
            wavFile.floatOffset = 0.0;
            wavFile.floatScale = 1 << wavFile.validBits - 1;
        } else {
            wavFile.floatOffset = -1.0;
            wavFile.floatScale = 0.5 * (double)((1 << wavFile.validBits) - 1);
        }
        wavFile.bufferPointer = 0;
        wavFile.bytesRead = 0;
        wavFile.frameCounter = 0L;
        wavFile.ioState = IOState.READING;
        return wavFile;
    }

    private static long getLE(byte[] buffer, int pos, int numBytes) {
        long val = buffer[pos += --numBytes] & 0xFF;
        for (int b = 0; b < numBytes; ++b) {
            val = (val << 8) + (long)(buffer[--pos] & 0xFF);
        }
        return val;
    }

    private static void putLE(long val, byte[] buffer, int pos, int numBytes) {
        for (int b = 0; b < numBytes; ++b) {
            buffer[pos] = (byte)(val & 0xFFL);
            val >>= 8;
            ++pos;
        }
    }

    private void writeSample(long val) throws IOException {
        for (int b = 0; b < this.bytesPerSample; ++b) {
            if (this.bufferPointer == 4096) {
                this.oStream.write(this.buffer, 0, 4096);
                this.bufferPointer = 0;
            }
            this.buffer[this.bufferPointer] = (byte)(val & 0xFFL);
            val >>= 8;
            ++this.bufferPointer;
        }
    }

    private long readSample() throws IOException, WavFileException {
        long val = 0L;
        for (int b = 0; b < this.bytesPerSample; ++b) {
            if (this.bufferPointer == this.bytesRead) {
                int read = this.iStream.read(this.buffer, 0, 4096);
                if (read == -1) {
                    throw new WavFileException("Not enough data available");
                }
                this.bytesRead = read;
                this.bufferPointer = 0;
            }
            int v = this.buffer[this.bufferPointer];
            if (b < this.bytesPerSample - 1 || this.bytesPerSample == 1) {
                v &= 0xFF;
            }
            val += (long)(v << b * 8);
            ++this.bufferPointer;
        }
        return val;
    }

    public int readFrames(int[] sampleBuffer, int numFramesToRead) throws IOException, WavFileException {
        return this.readFrames(sampleBuffer, 0, numFramesToRead);
    }

    public int readFrames(int[] sampleBuffer, int offset, int numFramesToRead) throws IOException, WavFileException {
        if (this.ioState != IOState.READING) {
            throw new IOException("Cannot read from WavFile instance");
        }
        for (int f = 0; f < numFramesToRead; ++f) {
            if (this.frameCounter == this.numFrames) {
                return f;
            }
            for (int c = 0; c < this.numChannels; ++c) {
                sampleBuffer[offset] = (int)this.readSample();
                ++offset;
            }
            ++this.frameCounter;
        }
        return numFramesToRead;
    }

    public int readFrames(int[][] sampleBuffer, int numFramesToRead) throws IOException, WavFileException {
        return this.readFrames(sampleBuffer, 0, numFramesToRead);
    }

    public int readFrames(int[][] sampleBuffer, int offset, int numFramesToRead) throws IOException, WavFileException {
        if (this.ioState != IOState.READING) {
            throw new IOException("Cannot read from WavFile instance");
        }
        for (int f = 0; f < numFramesToRead; ++f) {
            if (this.frameCounter == this.numFrames) {
                return f;
            }
            for (int c = 0; c < this.numChannels; ++c) {
                sampleBuffer[c][offset] = (int)this.readSample();
            }
            ++offset;
            ++this.frameCounter;
        }
        return numFramesToRead;
    }

    public int writeFrames(int[] sampleBuffer, int numFramesToWrite) throws IOException, WavFileException {
        return this.writeFrames(sampleBuffer, 0, numFramesToWrite);
    }

    public int writeFrames(int[] sampleBuffer, int offset, int numFramesToWrite) throws IOException, WavFileException {
        if (this.ioState != IOState.WRITING) {
            throw new IOException("Cannot write to WavFile instance");
        }
        for (int f = 0; f < numFramesToWrite; ++f) {
            if (this.frameCounter == this.numFrames) {
                return f;
            }
            for (int c = 0; c < this.numChannels; ++c) {
                this.writeSample(sampleBuffer[offset]);
                ++offset;
            }
            ++this.frameCounter;
        }
        return numFramesToWrite;
    }

    public int writeFrames(int[][] sampleBuffer, int numFramesToWrite) throws IOException, WavFileException {
        return this.writeFrames(sampleBuffer, 0, numFramesToWrite);
    }

    public int writeFrames(int[][] sampleBuffer, int offset, int numFramesToWrite) throws IOException, WavFileException {
        if (this.ioState != IOState.WRITING) {
            throw new IOException("Cannot write to WavFile instance");
        }
        for (int f = 0; f < numFramesToWrite; ++f) {
            if (this.frameCounter == this.numFrames) {
                return f;
            }
            for (int c = 0; c < this.numChannels; ++c) {
                this.writeSample(sampleBuffer[c][offset]);
            }
            ++offset;
            ++this.frameCounter;
        }
        return numFramesToWrite;
    }

    public int readFrames(long[] sampleBuffer, int numFramesToRead) throws IOException, WavFileException {
        return this.readFrames(sampleBuffer, 0, numFramesToRead);
    }

    public int readFrames(long[] sampleBuffer, int offset, int numFramesToRead) throws IOException, WavFileException {
        if (this.ioState != IOState.READING) {
            throw new IOException("Cannot read from WavFile instance");
        }
        for (int f = 0; f < numFramesToRead; ++f) {
            if (this.frameCounter == this.numFrames) {
                return f;
            }
            for (int c = 0; c < this.numChannels; ++c) {
                sampleBuffer[offset] = this.readSample();
                ++offset;
            }
            ++this.frameCounter;
        }
        return numFramesToRead;
    }

    public int readFrames(long[][] sampleBuffer, int numFramesToRead) throws IOException, WavFileException {
        return this.readFrames(sampleBuffer, 0, numFramesToRead);
    }

    public int readFrames(long[][] sampleBuffer, int offset, int numFramesToRead) throws IOException, WavFileException {
        if (this.ioState != IOState.READING) {
            throw new IOException("Cannot read from WavFile instance");
        }
        for (int f = 0; f < numFramesToRead; ++f) {
            if (this.frameCounter == this.numFrames) {
                return f;
            }
            for (int c = 0; c < this.numChannels; ++c) {
                sampleBuffer[c][offset] = this.readSample();
            }
            ++offset;
            ++this.frameCounter;
        }
        return numFramesToRead;
    }

    public int writeFrames(long[] sampleBuffer, int numFramesToWrite) throws IOException, WavFileException {
        return this.writeFrames(sampleBuffer, 0, numFramesToWrite);
    }

    public int writeFrames(long[] sampleBuffer, int offset, int numFramesToWrite) throws IOException, WavFileException {
        if (this.ioState != IOState.WRITING) {
            throw new IOException("Cannot write to WavFile instance");
        }
        for (int f = 0; f < numFramesToWrite; ++f) {
            if (this.frameCounter == this.numFrames) {
                return f;
            }
            for (int c = 0; c < this.numChannels; ++c) {
                this.writeSample(sampleBuffer[offset]);
                ++offset;
            }
            ++this.frameCounter;
        }
        return numFramesToWrite;
    }

    public int writeFrames(long[][] sampleBuffer, int numFramesToWrite) throws IOException, WavFileException {
        return this.writeFrames(sampleBuffer, 0, numFramesToWrite);
    }

    public int writeFrames(long[][] sampleBuffer, int offset, int numFramesToWrite) throws IOException, WavFileException {
        if (this.ioState != IOState.WRITING) {
            throw new IOException("Cannot write to WavFile instance");
        }
        for (int f = 0; f < numFramesToWrite; ++f) {
            if (this.frameCounter == this.numFrames) {
                return f;
            }
            for (int c = 0; c < this.numChannels; ++c) {
                this.writeSample(sampleBuffer[c][offset]);
            }
            ++offset;
            ++this.frameCounter;
        }
        return numFramesToWrite;
    }

    public int readFrames(double[] sampleBuffer, int numFramesToRead) throws IOException, WavFileException {
        return this.readFrames(sampleBuffer, 0, numFramesToRead);
    }

    public int readFrames(double[] sampleBuffer, int offset, int numFramesToRead) throws IOException, WavFileException {
        if (this.ioState != IOState.READING) {
            throw new IOException("Cannot read from WavFile instance");
        }
        for (int f = 0; f < numFramesToRead; ++f) {
            if (this.frameCounter == this.numFrames) {
                return f;
            }
            for (int c = 0; c < this.numChannels; ++c) {
                sampleBuffer[offset] = this.floatOffset + (double)this.readSample() / this.floatScale;
                ++offset;
            }
            ++this.frameCounter;
        }
        return numFramesToRead;
    }

    public int readFrames(double[][] sampleBuffer, int numFramesToRead) throws IOException, WavFileException {
        return this.readFrames(sampleBuffer, 0, numFramesToRead);
    }

    public int readFrames(double[][] sampleBuffer, int offset, int numFramesToRead) throws IOException, WavFileException {
        if (this.ioState != IOState.READING) {
            throw new IOException("Cannot read from WavFile instance");
        }
        for (int f = 0; f < numFramesToRead; ++f) {
            if (this.frameCounter == this.numFrames) {
                return f;
            }
            for (int c = 0; c < this.numChannels; ++c) {
                sampleBuffer[c][offset] = this.floatOffset + (double)this.readSample() / this.floatScale;
            }
            ++offset;
            ++this.frameCounter;
        }
        return numFramesToRead;
    }

    public int writeFrames(double[] sampleBuffer, int numFramesToWrite) throws IOException, WavFileException {
        return this.writeFrames(sampleBuffer, 0, numFramesToWrite);
    }

    public int writeFrames(double[] sampleBuffer, int offset, int numFramesToWrite) throws IOException, WavFileException {
        if (this.ioState != IOState.WRITING) {
            throw new IOException("Cannot write to WavFile instance");
        }
        for (int f = 0; f < numFramesToWrite; ++f) {
            if (this.frameCounter == this.numFrames) {
                return f;
            }
            for (int c = 0; c < this.numChannels; ++c) {
                this.writeSample((long)(this.floatScale * (this.floatOffset + sampleBuffer[offset])));
                ++offset;
            }
            ++this.frameCounter;
        }
        return numFramesToWrite;
    }

    public int writeFrames(double[][] sampleBuffer, int numFramesToWrite) throws IOException, WavFileException {
        return this.writeFrames(sampleBuffer, 0, numFramesToWrite);
    }

    public int writeFrames(double[][] sampleBuffer, int offset, int numFramesToWrite) throws IOException, WavFileException {
        if (this.ioState != IOState.WRITING) {
            throw new IOException("Cannot write to WavFile instance");
        }
        for (int f = 0; f < numFramesToWrite; ++f) {
            if (this.frameCounter == this.numFrames) {
                return f;
            }
            for (int c = 0; c < this.numChannels; ++c) {
                this.writeSample((long)(this.floatScale * (this.floatOffset + sampleBuffer[c][offset])));
            }
            ++offset;
            ++this.frameCounter;
        }
        return numFramesToWrite;
    }

    public void close() throws IOException {
        if (this.iStream != null) {
            this.iStream.close();
            this.iStream = null;
        }
        if (this.oStream != null) {
            if (this.bufferPointer > 0) {
                this.oStream.write(this.buffer, 0, this.bufferPointer);
            }
            if (this.wordAlignAdjust) {
                this.oStream.write(0);
            }
            this.oStream.close();
            this.oStream = null;
        }
        this.ioState = IOState.CLOSED;
    }

    public void display() {
        this.display(System.out);
    }

    public void display(PrintStream out) {
        out.printf("File: %s\n", this.file);
        out.printf("Channels: %d, Frames: %d\n", this.numChannels, this.numFrames);
        out.printf("IO State: %s\n", new Object[]{this.ioState});
        out.printf("Sample Rate: %d, Block Align: %d\n", this.sampleRate, this.blockAlign);
        out.printf("Valid Bits: %d, Bytes per sample: %d\n", this.validBits, this.bytesPerSample);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Must supply filename");
            System.exit(1);
        }
        try {
            for (String filename : args) {
                WavFile readWavFile = WavFile.openWavFile(null);
                readWavFile.display();
                long numFrames = readWavFile.getNumFrames();
                int numChannels = readWavFile.getNumChannels();
                int validBits = readWavFile.getValidBits();
                long sampleRate = readWavFile.getSampleRate();
                WavFile writeWavFile = WavFile.newWavFile(new File("out.wav"), numChannels, numFrames, validBits, sampleRate);
                int BUF_SIZE = 5001;
                double[] buffer = new double[5001 * numChannels];
                int framesRead = 0;
                int framesWritten = 0;
                do {
                    framesRead = readWavFile.readFrames(buffer, 5001);
                    framesWritten = writeWavFile.writeFrames(buffer, 5001);
                    System.out.printf("%d %d\n", framesRead, framesWritten);
                } while (framesRead != 0);
                readWavFile.close();
                writeWavFile.close();
            }
            WavFile writeWavFile = WavFile.newWavFile(new File("out2.wav"), 1, 10L, 23, 44100L);
            double[] buffer = new double[10];
            writeWavFile.writeFrames(buffer, 10);
            writeWavFile.close();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    private static enum IOState {
        READING,
        WRITING,
        CLOSED;

    }
}

