/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTCapture {
    public static final int ALC_CAPTURE_DEVICE_SPECIFIER = 784;
    public static final int ALC_CAPTURE_DEFAULT_DEVICE_SPECIFIER = 785;
    public static final int ALC_CAPTURE_SAMPLES = 786;

    protected EXTCapture() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(ALCCapabilities caps) {
        return Checks.checkFunctions(caps.alcCaptureOpenDevice, caps.alcCaptureCloseDevice, caps.alcCaptureStart, caps.alcCaptureStop, caps.alcCaptureSamples);
    }

    public static long nalcCaptureOpenDevice(long devicename, int frequency, int format, int buffersize) {
        long __functionAddress = ALC.getICD().alcCaptureOpenDevice;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.invokePP(__functionAddress, devicename, frequency, format, buffersize);
    }

    public static long alcCaptureOpenDevice(ByteBuffer devicename, int frequency, int format, int buffersize) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(devicename);
        }
        return EXTCapture.nalcCaptureOpenDevice(MemoryUtil.memAddressSafe(devicename), frequency, format, buffersize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long alcCaptureOpenDevice(CharSequence devicename, int frequency, int format, int buffersize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer devicenameEncoded = stack.UTF8(devicename);
            long l = EXTCapture.nalcCaptureOpenDevice(MemoryUtil.memAddressSafe(devicenameEncoded), frequency, format, buffersize);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean alcCaptureCloseDevice(long device) {
        long __functionAddress = ALC.getICD().alcCaptureCloseDevice;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        return JNI.invokePZ(__functionAddress, device);
    }

    public static void alcCaptureStart(long device) {
        long __functionAddress = ALC.getICD().alcCaptureStart;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        JNI.invokePV(__functionAddress, device);
    }

    public static void alcCaptureStop(long device) {
        long __functionAddress = ALC.getICD().alcCaptureStop;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        JNI.invokePV(__functionAddress, device);
    }

    public static void nalcCaptureSamples(long device, long buffer, int samples) {
        long __functionAddress = ALC.getICD().alcCaptureSamples;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        JNI.invokePPV(__functionAddress, device, buffer, samples);
    }

    public static void alcCaptureSamples(long device, ByteBuffer buffer) {
        EXTCapture.nalcCaptureSamples(device, MemoryUtil.memAddress(buffer), buffer.remaining());
    }
}

