/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBDrawIndirect {
    public static final int GL_DRAW_INDIRECT_BUFFER = 36671;
    public static final int GL_DRAW_INDIRECT_BUFFER_BINDING = 36675;

    protected ARBDrawIndirect() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glDrawArraysIndirect, caps.glDrawElementsIndirect);
    }

    public static void nglDrawArraysIndirect(int mode, long indirect) {
        long __functionAddress = GL.getCapabilities().glDrawArraysIndirect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, indirect);
    }

    public static void glDrawArraysIndirect(int mode, ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 16);
        }
        ARBDrawIndirect.nglDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawArraysIndirect(int mode, long indirect) {
        ARBDrawIndirect.nglDrawArraysIndirect(mode, indirect);
    }

    public static void glDrawArraysIndirect(int mode, IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 4);
        }
        ARBDrawIndirect.nglDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect));
    }

    public static void nglDrawElementsIndirect(int mode, int type, long indirect) {
        long __functionAddress = GL.getCapabilities().glDrawElementsIndirect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, type, indirect);
    }

    public static void glDrawElementsIndirect(int mode, int type, ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 20);
        }
        ARBDrawIndirect.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawElementsIndirect(int mode, int type, long indirect) {
        ARBDrawIndirect.nglDrawElementsIndirect(mode, type, indirect);
    }

    public static void glDrawElementsIndirect(int mode, int type, IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 5);
        }
        ARBDrawIndirect.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawArraysIndirect(int mode, int[] indirect) {
        long __functionAddress = GL.getCapabilities().glDrawArraysIndirect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(indirect, 4);
        }
        JNI.callPV(__functionAddress, mode, indirect);
    }

    public static void glDrawElementsIndirect(int mode, int type, int[] indirect) {
        long __functionAddress = GL.getCapabilities().glDrawElementsIndirect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(indirect, 5);
        }
        JNI.callPV(__functionAddress, mode, type, indirect);
    }
}

