/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBIndirectParameters {
    public static final int GL_PARAMETER_BUFFER_ARB = 33006;
    public static final int GL_PARAMETER_BUFFER_BINDING_ARB = 33007;

    protected ARBIndirectParameters() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glMultiDrawArraysIndirectCountARB, caps.glMultiDrawElementsIndirectCountARB);
    }

    public static void nglMultiDrawArraysIndirectCountARB(int mode, long indirect, long drawcount, int maxdrawcount, int stride) {
        long __functionAddress = GL.getCapabilities().glMultiDrawArraysIndirectCountARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, mode, indirect, drawcount, maxdrawcount, stride);
    }

    public static void glMultiDrawArraysIndirectCountARB(int mode, ByteBuffer indirect, long drawcount, int maxdrawcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, maxdrawcount * (stride == 0 ? 16 : stride));
        }
        ARBIndirectParameters.nglMultiDrawArraysIndirectCountARB(mode, MemoryUtil.memAddress(indirect), drawcount, maxdrawcount, stride);
    }

    public static void glMultiDrawArraysIndirectCountARB(int mode, long indirect, long drawcount, int maxdrawcount, int stride) {
        ARBIndirectParameters.nglMultiDrawArraysIndirectCountARB(mode, indirect, drawcount, maxdrawcount, stride);
    }

    public static void glMultiDrawArraysIndirectCountARB(int mode, IntBuffer indirect, long drawcount, int maxdrawcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, maxdrawcount * (stride == 0 ? 16 : stride) >> 2);
        }
        ARBIndirectParameters.nglMultiDrawArraysIndirectCountARB(mode, MemoryUtil.memAddress(indirect), drawcount, maxdrawcount, stride);
    }

    public static void nglMultiDrawElementsIndirectCountARB(int mode, int type, long indirect, long drawcount, int maxdrawcount, int stride) {
        long __functionAddress = GL.getCapabilities().glMultiDrawElementsIndirectCountARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, mode, type, indirect, drawcount, maxdrawcount, stride);
    }

    public static void glMultiDrawElementsIndirectCountARB(int mode, int type, ByteBuffer indirect, long drawcount, int maxdrawcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, maxdrawcount * (stride == 0 ? 20 : stride));
        }
        ARBIndirectParameters.nglMultiDrawElementsIndirectCountARB(mode, type, MemoryUtil.memAddress(indirect), drawcount, maxdrawcount, stride);
    }

    public static void glMultiDrawElementsIndirectCountARB(int mode, int type, long indirect, long drawcount, int maxdrawcount, int stride) {
        ARBIndirectParameters.nglMultiDrawElementsIndirectCountARB(mode, type, indirect, drawcount, maxdrawcount, stride);
    }

    public static void glMultiDrawElementsIndirectCountARB(int mode, int type, IntBuffer indirect, long drawcount, int maxdrawcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, maxdrawcount * (stride == 0 ? 20 : stride) >> 2);
        }
        ARBIndirectParameters.nglMultiDrawElementsIndirectCountARB(mode, type, MemoryUtil.memAddress(indirect), drawcount, maxdrawcount, stride);
    }

    public static void glMultiDrawArraysIndirectCountARB(int mode, int[] indirect, long drawcount, int maxdrawcount, int stride) {
        long __functionAddress = GL.getCapabilities().glMultiDrawArraysIndirectCountARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(indirect, maxdrawcount * (stride == 0 ? 16 : stride) >> 2);
        }
        JNI.callPPV(__functionAddress, mode, indirect, drawcount, maxdrawcount, stride);
    }

    public static void glMultiDrawElementsIndirectCountARB(int mode, int type, int[] indirect, long drawcount, int maxdrawcount, int stride) {
        long __functionAddress = GL.getCapabilities().glMultiDrawElementsIndirectCountARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(indirect, maxdrawcount * (stride == 0 ? 20 : stride) >> 2);
        }
        JNI.callPPV(__functionAddress, mode, type, indirect, drawcount, maxdrawcount, stride);
    }
}

