/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBMultiDrawIndirect {
    protected ARBMultiDrawIndirect() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glMultiDrawArraysIndirect, caps.glMultiDrawElementsIndirect);
    }

    public static void nglMultiDrawArraysIndirect(int mode, long indirect, int primcount, int stride) {
        long __functionAddress = GL.getCapabilities().glMultiDrawArraysIndirect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, indirect, primcount, stride);
    }

    public static void glMultiDrawArraysIndirect(int mode, ByteBuffer indirect, int primcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, primcount * (stride == 0 ? 16 : stride));
        }
        ARBMultiDrawIndirect.nglMultiDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect), primcount, stride);
    }

    public static void glMultiDrawArraysIndirect(int mode, long indirect, int primcount, int stride) {
        ARBMultiDrawIndirect.nglMultiDrawArraysIndirect(mode, indirect, primcount, stride);
    }

    public static void glMultiDrawArraysIndirect(int mode, IntBuffer indirect, int primcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, primcount * (stride == 0 ? 16 : stride) >> 2);
        }
        ARBMultiDrawIndirect.nglMultiDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect), primcount, stride);
    }

    public static void nglMultiDrawElementsIndirect(int mode, int type, long indirect, int primcount, int stride) {
        long __functionAddress = GL.getCapabilities().glMultiDrawElementsIndirect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, type, indirect, primcount, stride);
    }

    public static void glMultiDrawElementsIndirect(int mode, int type, ByteBuffer indirect, int primcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, primcount * (stride == 0 ? 20 : stride));
        }
        ARBMultiDrawIndirect.nglMultiDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect), primcount, stride);
    }

    public static void glMultiDrawElementsIndirect(int mode, int type, long indirect, int primcount, int stride) {
        ARBMultiDrawIndirect.nglMultiDrawElementsIndirect(mode, type, indirect, primcount, stride);
    }

    public static void glMultiDrawElementsIndirect(int mode, int type, IntBuffer indirect, int primcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, primcount * (stride == 0 ? 20 : stride) >> 2);
        }
        ARBMultiDrawIndirect.nglMultiDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect), primcount, stride);
    }

    public static void glMultiDrawArraysIndirect(int mode, int[] indirect, int primcount, int stride) {
        long __functionAddress = GL.getCapabilities().glMultiDrawArraysIndirect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(indirect, primcount * (stride == 0 ? 16 : stride) >> 2);
        }
        JNI.callPV(__functionAddress, mode, indirect, primcount, stride);
    }

    public static void glMultiDrawElementsIndirect(int mode, int type, int[] indirect, int primcount, int stride) {
        long __functionAddress = GL.getCapabilities().glMultiDrawElementsIndirect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(indirect, primcount * (stride == 0 ? 20 : stride) >> 2);
        }
        JNI.callPV(__functionAddress, mode, type, indirect, primcount, stride);
    }
}

