/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBRobustness {
    public static final int GL_GUILTY_CONTEXT_RESET_ARB = 33363;
    public static final int GL_INNOCENT_CONTEXT_RESET_ARB = 33364;
    public static final int GL_UNKNOWN_CONTEXT_RESET_ARB = 33365;
    public static final int GL_RESET_NOTIFICATION_STRATEGY_ARB = 33366;
    public static final int GL_LOSE_CONTEXT_ON_RESET_ARB = 33362;
    public static final int GL_NO_RESET_NOTIFICATION_ARB = 33377;
    public static final int GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB = 4;

    protected ARBRobustness() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps, Set<String> ext) {
        return Checks.checkFunctions(caps.glGetGraphicsResetStatusARB, caps.glGetMapdv != 0L ? caps.glGetnMapdvARB : -1L, caps.glGetMapfv != 0L ? caps.glGetnMapfvARB : -1L, caps.glGetMapiv != 0L ? caps.glGetnMapivARB : -1L, caps.glGetPixelMapfv != 0L ? caps.glGetnPixelMapfvARB : -1L, caps.glGetPixelMapuiv != 0L ? caps.glGetnPixelMapuivARB : -1L, caps.glGetPixelMapusv != 0L ? caps.glGetnPixelMapusvARB : -1L, caps.glGetPolygonStipple != 0L ? caps.glGetnPolygonStippleARB : -1L, caps.glGetnTexImageARB, caps.glReadnPixelsARB, ext.contains("GL_ARB_imaging") && caps.glGetColorTable != 0L ? caps.glGetnColorTableARB : -1L, ext.contains("GL_ARB_imaging") && caps.glGetConvolutionFilter != 0L ? caps.glGetnConvolutionFilterARB : -1L, ext.contains("GL_ARB_imaging") && caps.glGetSeparableFilter != 0L ? caps.glGetnSeparableFilterARB : -1L, ext.contains("GL_ARB_imaging") && caps.glGetHistogram != 0L ? caps.glGetnHistogramARB : -1L, ext.contains("GL_ARB_imaging") && caps.glGetMinmax != 0L ? caps.glGetnMinmaxARB : -1L, ext.contains("OpenGL13") ? caps.glGetnCompressedTexImageARB : -1L, ext.contains("OpenGL20") ? caps.glGetnUniformfvARB : -1L, ext.contains("OpenGL20") ? caps.glGetnUniformivARB : -1L, ext.contains("OpenGL30") ? caps.glGetnUniformuivARB : -1L, ext.contains("OpenGL40") ? caps.glGetnUniformdvARB : -1L);
    }

    public static int glGetGraphicsResetStatusARB() {
        long __functionAddress = GL.getCapabilities().glGetGraphicsResetStatusARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static void nglGetnMapdvARB(int target, int query, int bufSize, long data) {
        long __functionAddress = GL.getCapabilities().glGetnMapdvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, query, bufSize, data);
    }

    public static void glGetnMapdvARB(int target, int query, DoubleBuffer data) {
        ARBRobustness.nglGetnMapdvARB(target, query, data.remaining(), MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double glGetnMapdARB(int target, int query) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer data = stack.callocDouble(1);
            ARBRobustness.nglGetnMapdvARB(target, query, 1, MemoryUtil.memAddress(data));
            double d = data.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetnMapfvARB(int target, int query, int bufSize, long data) {
        long __functionAddress = GL.getCapabilities().glGetnMapfvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, query, bufSize, data);
    }

    public static void glGetnMapfvARB(int target, int query, FloatBuffer data) {
        ARBRobustness.nglGetnMapfvARB(target, query, data.remaining(), MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnMapfARB(int target, int query) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer data = stack.callocFloat(1);
            ARBRobustness.nglGetnMapfvARB(target, query, 1, MemoryUtil.memAddress(data));
            float f = data.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetnMapivARB(int target, int query, int bufSize, long data) {
        long __functionAddress = GL.getCapabilities().glGetnMapivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, query, bufSize, data);
    }

    public static void glGetnMapivARB(int target, int query, IntBuffer data) {
        ARBRobustness.nglGetnMapivARB(target, query, data.remaining(), MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetnMapiARB(int target, int query) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer data = stack.callocInt(1);
            ARBRobustness.nglGetnMapivARB(target, query, 1, MemoryUtil.memAddress(data));
            int n = data.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetnPixelMapfvARB(int map, int bufSize, long data) {
        long __functionAddress = GL.getCapabilities().glGetnPixelMapfvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, map, bufSize, data);
    }

    public static void glGetnPixelMapfvARB(int map, FloatBuffer data) {
        ARBRobustness.nglGetnPixelMapfvARB(map, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglGetnPixelMapuivARB(int map, int bufSize, long data) {
        long __functionAddress = GL.getCapabilities().glGetnPixelMapuivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, map, bufSize, data);
    }

    public static void glGetnPixelMapuivARB(int map, IntBuffer data) {
        ARBRobustness.nglGetnPixelMapuivARB(map, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglGetnPixelMapusvARB(int map, int bufSize, long data) {
        long __functionAddress = GL.getCapabilities().glGetnPixelMapusvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, map, bufSize, data);
    }

    public static void glGetnPixelMapusvARB(int map, ShortBuffer data) {
        ARBRobustness.nglGetnPixelMapusvARB(map, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglGetnPolygonStippleARB(int bufSize, long pattern) {
        long __functionAddress = GL.getCapabilities().glGetnPolygonStippleARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, bufSize, pattern);
    }

    public static void glGetnPolygonStippleARB(int bufSize, long pattern) {
        ARBRobustness.nglGetnPolygonStippleARB(bufSize, pattern);
    }

    public static void glGetnPolygonStippleARB(ByteBuffer pattern) {
        ARBRobustness.nglGetnPolygonStippleARB(pattern.remaining(), MemoryUtil.memAddress(pattern));
    }

    public static void nglGetnTexImageARB(int tex, int level, int format, int type, int bufSize, long img) {
        long __functionAddress = GL.getCapabilities().glGetnTexImageARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, tex, level, format, type, bufSize, img);
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, int bufSize, long img) {
        ARBRobustness.nglGetnTexImageARB(tex, level, format, type, bufSize, img);
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, ByteBuffer img) {
        ARBRobustness.nglGetnTexImageARB(tex, level, format, type, img.remaining(), MemoryUtil.memAddress(img));
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, ShortBuffer img) {
        ARBRobustness.nglGetnTexImageARB(tex, level, format, type, img.remaining() << 1, MemoryUtil.memAddress(img));
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, IntBuffer img) {
        ARBRobustness.nglGetnTexImageARB(tex, level, format, type, img.remaining() << 2, MemoryUtil.memAddress(img));
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, FloatBuffer img) {
        ARBRobustness.nglGetnTexImageARB(tex, level, format, type, img.remaining() << 2, MemoryUtil.memAddress(img));
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, DoubleBuffer img) {
        ARBRobustness.nglGetnTexImageARB(tex, level, format, type, img.remaining() << 3, MemoryUtil.memAddress(img));
    }

    public static void nglReadnPixelsARB(int x, int y, int width, int height, int format, int type, int bufSize, long data) {
        long __functionAddress = GL.getCapabilities().glReadnPixelsARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, bufSize, data);
    }

    public static void glReadnPixelsARB(int x, int y, int width, int height, int format, int type, int bufSize, long data) {
        ARBRobustness.nglReadnPixelsARB(x, y, width, height, format, type, bufSize, data);
    }

    public static void glReadnPixelsARB(int x, int y, int width, int height, int format, int type, ByteBuffer data) {
        ARBRobustness.nglReadnPixelsARB(x, y, width, height, format, type, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glReadnPixelsARB(int x, int y, int width, int height, int format, int type, ShortBuffer data) {
        ARBRobustness.nglReadnPixelsARB(x, y, width, height, format, type, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glReadnPixelsARB(int x, int y, int width, int height, int format, int type, IntBuffer data) {
        ARBRobustness.nglReadnPixelsARB(x, y, width, height, format, type, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glReadnPixelsARB(int x, int y, int width, int height, int format, int type, FloatBuffer data) {
        ARBRobustness.nglReadnPixelsARB(x, y, width, height, format, type, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void nglGetnColorTableARB(int target, int format, int type, int bufSize, long table) {
        long __functionAddress = GL.getCapabilities().glGetnColorTableARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, format, type, bufSize, table);
    }

    public static void glGetnColorTableARB(int target, int format, int type, int bufSize, long table) {
        ARBRobustness.nglGetnColorTableARB(target, format, type, bufSize, table);
    }

    public static void glGetnColorTableARB(int target, int format, int type, ByteBuffer table) {
        ARBRobustness.nglGetnColorTableARB(target, format, type, table.remaining(), MemoryUtil.memAddress(table));
    }

    public static void glGetnColorTableARB(int target, int format, int type, ShortBuffer table) {
        ARBRobustness.nglGetnColorTableARB(target, format, type, table.remaining() << 1, MemoryUtil.memAddress(table));
    }

    public static void glGetnColorTableARB(int target, int format, int type, IntBuffer table) {
        ARBRobustness.nglGetnColorTableARB(target, format, type, table.remaining() << 2, MemoryUtil.memAddress(table));
    }

    public static void glGetnColorTableARB(int target, int format, int type, FloatBuffer table) {
        ARBRobustness.nglGetnColorTableARB(target, format, type, table.remaining() << 2, MemoryUtil.memAddress(table));
    }

    public static void nglGetnConvolutionFilterARB(int target, int format, int type, int bufSize, long image) {
        long __functionAddress = GL.getCapabilities().glGetnConvolutionFilterARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, format, type, bufSize, image);
    }

    public static void glGetnConvolutionFilterARB(int target, int format, int type, int bufSize, long image) {
        ARBRobustness.nglGetnConvolutionFilterARB(target, format, type, bufSize, image);
    }

    public static void glGetnConvolutionFilterARB(int target, int format, int type, ByteBuffer image) {
        ARBRobustness.nglGetnConvolutionFilterARB(target, format, type, image.remaining(), MemoryUtil.memAddress(image));
    }

    public static void nglGetnSeparableFilterARB(int target, int format, int type, int rowBufSize, long row, int columnBufSize, long column, long span) {
        long __functionAddress = GL.getCapabilities().glGetnSeparableFilterARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, target, format, type, rowBufSize, row, columnBufSize, column, span);
    }

    public static void glGetnSeparableFilterARB(int target, int format, int type, int rowBufSize, long row, int columnBufSize, long column, ByteBuffer span) {
        ARBRobustness.nglGetnSeparableFilterARB(target, format, type, rowBufSize, row, columnBufSize, column, MemoryUtil.memAddressSafe(span));
    }

    public static void glGetnSeparableFilterARB(int target, int format, int type, ByteBuffer row, ByteBuffer column, ByteBuffer span) {
        ARBRobustness.nglGetnSeparableFilterARB(target, format, type, row.remaining(), MemoryUtil.memAddress(row), column.remaining(), MemoryUtil.memAddress(column), MemoryUtil.memAddressSafe(span));
    }

    public static void nglGetnHistogramARB(int target, boolean reset, int format, int type, int bufSize, long values) {
        long __functionAddress = GL.getCapabilities().glGetnHistogramARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, reset, format, type, bufSize, values);
    }

    public static void glGetnHistogramARB(int target, boolean reset, int format, int type, int bufSize, long values) {
        ARBRobustness.nglGetnHistogramARB(target, reset, format, type, bufSize, values);
    }

    public static void glGetnHistogramARB(int target, boolean reset, int format, int type, ByteBuffer values) {
        ARBRobustness.nglGetnHistogramARB(target, reset, format, type, values.remaining(), MemoryUtil.memAddress(values));
    }

    public static void nglGetnMinmaxARB(int target, boolean reset, int format, int type, int bufSize, long values) {
        long __functionAddress = GL.getCapabilities().glGetnMinmaxARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, reset, format, type, bufSize, values);
    }

    public static void glGetnMinmaxARB(int target, boolean reset, int format, int type, int bufSize, long values) {
        ARBRobustness.nglGetnMinmaxARB(target, reset, format, type, bufSize, values);
    }

    public static void glGetnMinmaxARB(int target, boolean reset, int format, int type, ByteBuffer values) {
        ARBRobustness.nglGetnMinmaxARB(target, reset, format, type, values.remaining(), MemoryUtil.memAddress(values));
    }

    public static void nglGetnCompressedTexImageARB(int target, int level, int bufSize, long img) {
        long __functionAddress = GL.getCapabilities().glGetnCompressedTexImageARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, level, bufSize, img);
    }

    public static void glGetnCompressedTexImageARB(int target, int level, int bufSize, long img) {
        ARBRobustness.nglGetnCompressedTexImageARB(target, level, bufSize, img);
    }

    public static void glGetnCompressedTexImageARB(int target, int level, ByteBuffer img) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.checkBuffer((Buffer)img, GL11.glGetTexLevelParameteri(target, level, 34464));
        }
        ARBRobustness.nglGetnCompressedTexImageARB(target, level, img.remaining(), MemoryUtil.memAddress(img));
    }

    public static void nglGetnUniformfvARB(int program, int location, int bufSize, long params) {
        long __functionAddress = GL.getCapabilities().glGetnUniformfvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformfvARB(int program, int location, FloatBuffer params) {
        ARBRobustness.nglGetnUniformfvARB(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformfARB(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            ARBRobustness.nglGetnUniformfvARB(program, location, 1, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetnUniformivARB(int program, int location, int bufSize, long params) {
        long __functionAddress = GL.getCapabilities().glGetnUniformivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformivARB(int program, int location, IntBuffer params) {
        ARBRobustness.nglGetnUniformivARB(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetnUniformiARB(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBRobustness.nglGetnUniformivARB(program, location, 1, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetnUniformuivARB(int program, int location, int bufSize, long params) {
        long __functionAddress = GL.getCapabilities().glGetnUniformuivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformuivARB(int program, int location, IntBuffer params) {
        ARBRobustness.nglGetnUniformuivARB(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetnUniformuiARB(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBRobustness.nglGetnUniformuivARB(program, location, 1, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetnUniformdvARB(int program, int location, int bufSize, long params) {
        long __functionAddress = GL.getCapabilities().glGetnUniformdvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformdvARB(int program, int location, DoubleBuffer params) {
        ARBRobustness.nglGetnUniformdvARB(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double glGetnUniformdARB(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer params = stack.callocDouble(1);
            ARBRobustness.nglGetnUniformdvARB(program, location, 1, MemoryUtil.memAddress(params));
            double d = params.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGetnMapdvARB(int target, int query, double[] data) {
        long __functionAddress = GL.getCapabilities().glGetnMapdvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, query, data.length, data);
    }

    public static void glGetnMapfvARB(int target, int query, float[] data) {
        long __functionAddress = GL.getCapabilities().glGetnMapfvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, query, data.length, data);
    }

    public static void glGetnMapivARB(int target, int query, int[] data) {
        long __functionAddress = GL.getCapabilities().glGetnMapivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, query, data.length, data);
    }

    public static void glGetnPixelMapfvARB(int map, float[] data) {
        long __functionAddress = GL.getCapabilities().glGetnPixelMapfvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, map, data.length, data);
    }

    public static void glGetnPixelMapuivARB(int map, int[] data) {
        long __functionAddress = GL.getCapabilities().glGetnPixelMapuivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, map, data.length, data);
    }

    public static void glGetnPixelMapusvARB(int map, short[] data) {
        long __functionAddress = GL.getCapabilities().glGetnPixelMapusvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, map, data.length, data);
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, short[] img) {
        long __functionAddress = GL.getCapabilities().glGetnTexImageARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, tex, level, format, type, img.length << 1, img);
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, int[] img) {
        long __functionAddress = GL.getCapabilities().glGetnTexImageARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, tex, level, format, type, img.length << 2, img);
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, float[] img) {
        long __functionAddress = GL.getCapabilities().glGetnTexImageARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, tex, level, format, type, img.length << 2, img);
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, double[] img) {
        long __functionAddress = GL.getCapabilities().glGetnTexImageARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, tex, level, format, type, img.length << 3, img);
    }

    public static void glReadnPixelsARB(int x, int y, int width, int height, int format, int type, short[] data) {
        long __functionAddress = GL.getCapabilities().glReadnPixelsARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, data.length << 1, data);
    }

    public static void glReadnPixelsARB(int x, int y, int width, int height, int format, int type, int[] data) {
        long __functionAddress = GL.getCapabilities().glReadnPixelsARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, data.length << 2, data);
    }

    public static void glReadnPixelsARB(int x, int y, int width, int height, int format, int type, float[] data) {
        long __functionAddress = GL.getCapabilities().glReadnPixelsARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, data.length << 2, data);
    }

    public static void glGetnColorTableARB(int target, int format, int type, short[] table) {
        long __functionAddress = GL.getCapabilities().glGetnColorTableARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, format, type, table.length << 1, table);
    }

    public static void glGetnColorTableARB(int target, int format, int type, int[] table) {
        long __functionAddress = GL.getCapabilities().glGetnColorTableARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, format, type, table.length << 2, table);
    }

    public static void glGetnColorTableARB(int target, int format, int type, float[] table) {
        long __functionAddress = GL.getCapabilities().glGetnColorTableARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, format, type, table.length << 2, table);
    }

    public static void glGetnUniformfvARB(int program, int location, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetnUniformfvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, params.length, params);
    }

    public static void glGetnUniformivARB(int program, int location, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetnUniformivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, params.length, params);
    }

    public static void glGetnUniformuivARB(int program, int location, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetnUniformuivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, params.length, params);
    }

    public static void glGetnUniformdvARB(int program, int location, double[] params) {
        long __functionAddress = GL.getCapabilities().glGetnUniformdvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, params.length, params);
    }
}

