/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBShaderSubroutine {
    public static final int GL_ACTIVE_SUBROUTINES = 36325;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORMS = 36326;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = 36423;
    public static final int GL_ACTIVE_SUBROUTINE_MAX_LENGTH = 36424;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = 36425;
    public static final int GL_MAX_SUBROUTINES = 36327;
    public static final int GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS = 36328;
    public static final int GL_NUM_COMPATIBLE_SUBROUTINES = 36426;
    public static final int GL_COMPATIBLE_SUBROUTINES = 36427;

    protected ARBShaderSubroutine() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glGetSubroutineUniformLocation, caps.glGetSubroutineIndex, caps.glGetActiveSubroutineUniformiv, caps.glGetActiveSubroutineUniformName, caps.glGetActiveSubroutineName, caps.glUniformSubroutinesuiv, caps.glGetUniformSubroutineuiv, caps.glGetProgramStageiv);
    }

    public static int nglGetSubroutineUniformLocation(int program, int shadertype, long name) {
        long __functionAddress = GL.getCapabilities().glGetSubroutineUniformLocation;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, program, shadertype, name);
    }

    public static int glGetSubroutineUniformLocation(int program, int shadertype, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ARBShaderSubroutine.nglGetSubroutineUniformLocation(program, shadertype, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSubroutineUniformLocation(int program, int shadertype, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = ARBShaderSubroutine.nglGetSubroutineUniformLocation(program, shadertype, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nglGetSubroutineIndex(int program, int shadertype, long name) {
        long __functionAddress = GL.getCapabilities().glGetSubroutineIndex;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, program, shadertype, name);
    }

    public static int glGetSubroutineIndex(int program, int shadertype, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ARBShaderSubroutine.nglGetSubroutineIndex(program, shadertype, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSubroutineIndex(int program, int shadertype, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = ARBShaderSubroutine.nglGetSubroutineIndex(program, shadertype, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveSubroutineUniformiv(int program, int shadertype, int index, int pname, long values) {
        long __functionAddress = GL.getCapabilities().glGetActiveSubroutineUniformiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, shadertype, index, pname, values);
    }

    public static void glGetActiveSubroutineUniformiv(int program, int shadertype, int index, int pname, IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        ARBShaderSubroutine.nglGetActiveSubroutineUniformiv(program, shadertype, index, pname, MemoryUtil.memAddress(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetActiveSubroutineUniformi(int program, int shadertype, int index, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer values = stack.callocInt(1);
            ARBShaderSubroutine.nglGetActiveSubroutineUniformiv(program, shadertype, index, pname, MemoryUtil.memAddress(values));
            int n = values.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveSubroutineUniformName(int program, int shadertype, int index, int bufsize, long length, long name) {
        long __functionAddress = GL.getCapabilities().glGetActiveSubroutineUniformName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, program, shadertype, index, bufsize, length, name);
    }

    public static void glGetActiveSubroutineUniformName(int program, int shadertype, int index, IntBuffer length, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)length, 1);
        }
        ARBShaderSubroutine.nglGetActiveSubroutineUniformName(program, shadertype, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveSubroutineUniformName(int program, int shadertype, int index, int bufsize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufsize);
            ARBShaderSubroutine.nglGetActiveSubroutineUniformName(program, shadertype, index, bufsize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveSubroutineUniformName(int program, int shadertype, int index) {
        int bufsize = ARBShaderSubroutine.glGetActiveSubroutineUniformi(program, shadertype, index, 35385);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufsize);
            ARBShaderSubroutine.nglGetActiveSubroutineUniformName(program, shadertype, index, bufsize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveSubroutineName(int program, int shadertype, int index, int bufsize, long length, long name) {
        long __functionAddress = GL.getCapabilities().glGetActiveSubroutineName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, program, shadertype, index, bufsize, length, name);
    }

    public static void glGetActiveSubroutineName(int program, int shadertype, int index, IntBuffer length, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)length, 1);
        }
        ARBShaderSubroutine.nglGetActiveSubroutineName(program, shadertype, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveSubroutineName(int program, int shadertype, int index, int bufsize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufsize);
            ARBShaderSubroutine.nglGetActiveSubroutineName(program, shadertype, index, bufsize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveSubroutineName(int program, int shadertype, int index) {
        int bufsize = ARBShaderSubroutine.glGetProgramStagei(program, shadertype, 36424);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufsize);
            ARBShaderSubroutine.nglGetActiveSubroutineName(program, shadertype, index, bufsize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglUniformSubroutinesuiv(int shadertype, int count, long indices) {
        long __functionAddress = GL.getCapabilities().glUniformSubroutinesuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, shadertype, count, indices);
    }

    public static void glUniformSubroutinesuiv(int shadertype, IntBuffer indices) {
        ARBShaderSubroutine.nglUniformSubroutinesuiv(shadertype, indices.remaining(), MemoryUtil.memAddress(indices));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glUniformSubroutinesui(int shadertype, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer indices = stack.ints(index);
            ARBShaderSubroutine.nglUniformSubroutinesuiv(shadertype, 1, MemoryUtil.memAddress(indices));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetUniformSubroutineuiv(int shadertype, int location, long params) {
        long __functionAddress = GL.getCapabilities().glGetUniformSubroutineuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, shadertype, location, params);
    }

    public static void glGetUniformSubroutineuiv(int shadertype, int location, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBShaderSubroutine.nglGetUniformSubroutineuiv(shadertype, location, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformSubroutineui(int shadertype, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBShaderSubroutine.nglGetUniformSubroutineuiv(shadertype, location, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetProgramStageiv(int program, int shadertype, int pname, long values) {
        long __functionAddress = GL.getCapabilities().glGetProgramStageiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, shadertype, pname, values);
    }

    public static void glGetProgramStageiv(int program, int shadertype, int pname, IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        ARBShaderSubroutine.nglGetProgramStageiv(program, shadertype, pname, MemoryUtil.memAddress(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetProgramStagei(int program, int shadertype, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer values = stack.callocInt(1);
            ARBShaderSubroutine.nglGetProgramStageiv(program, shadertype, pname, MemoryUtil.memAddress(values));
            int n = values.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGetActiveSubroutineUniformiv(int program, int shadertype, int index, int pname, int[] values) {
        long __functionAddress = GL.getCapabilities().glGetActiveSubroutineUniformiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(values, 1);
        }
        JNI.callPV(__functionAddress, program, shadertype, index, pname, values);
    }

    public static void glGetActiveSubroutineUniformName(int program, int shadertype, int index, int[] length, ByteBuffer name) {
        long __functionAddress = GL.getCapabilities().glGetActiveSubroutineUniformName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBufferSafe(length, 1);
        }
        JNI.callPPV(__functionAddress, program, shadertype, index, name.remaining(), length, MemoryUtil.memAddress(name));
    }

    public static void glGetActiveSubroutineName(int program, int shadertype, int index, int[] length, ByteBuffer name) {
        long __functionAddress = GL.getCapabilities().glGetActiveSubroutineName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBufferSafe(length, 1);
        }
        JNI.callPPV(__functionAddress, program, shadertype, index, name.remaining(), length, MemoryUtil.memAddress(name));
    }

    public static void glUniformSubroutinesuiv(int shadertype, int[] indices) {
        long __functionAddress = GL.getCapabilities().glUniformSubroutinesuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, shadertype, indices.length, indices);
    }

    public static void glGetUniformSubroutineuiv(int shadertype, int location, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetUniformSubroutineuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, shadertype, location, params);
    }

    public static void glGetProgramStageiv(int program, int shadertype, int pname, int[] values) {
        long __functionAddress = GL.getCapabilities().glGetProgramStageiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(values, 1);
        }
        JNI.callPV(__functionAddress, program, shadertype, pname, values);
    }
}

