/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTDirectStateAccess {
    public static final int GL_PROGRAM_MATRIX_EXT = 36397;
    public static final int GL_TRANSPOSE_PROGRAM_MATRIX_EXT = 36398;
    public static final int GL_PROGRAM_MATRIX_STACK_DEPTH_EXT = 36399;

    protected EXTDirectStateAccess() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps, Set<String> ext) {
        return Checks.checkFunctions(caps.glClientAttribDefaultEXT, caps.glPushClientAttribDefaultEXT, caps.glMatrixLoadfEXT, caps.glMatrixLoaddEXT, caps.glMatrixMultfEXT, caps.glMatrixMultdEXT, caps.glMatrixLoadIdentityEXT, caps.glMatrixRotatefEXT, caps.glMatrixRotatedEXT, caps.glMatrixScalefEXT, caps.glMatrixScaledEXT, caps.glMatrixTranslatefEXT, caps.glMatrixTranslatedEXT, caps.glMatrixOrthoEXT, caps.glMatrixFrustumEXT, caps.glMatrixPushEXT, caps.glMatrixPopEXT, caps.glTextureParameteriEXT, caps.glTextureParameterivEXT, caps.glTextureParameterfEXT, caps.glTextureParameterfvEXT, caps.glTextureImage1DEXT, caps.glTextureImage2DEXT, caps.glTextureSubImage1DEXT, caps.glTextureSubImage2DEXT, caps.glCopyTextureImage1DEXT, caps.glCopyTextureImage2DEXT, caps.glCopyTextureSubImage1DEXT, caps.glCopyTextureSubImage2DEXT, caps.glGetTextureImageEXT, caps.glGetTextureParameterfvEXT, caps.glGetTextureParameterivEXT, caps.glGetTextureLevelParameterfvEXT, caps.glGetTextureLevelParameterivEXT, ext.contains("OpenGL12") ? caps.glTextureImage3DEXT : -1L, ext.contains("OpenGL12") ? caps.glTextureSubImage3DEXT : -1L, ext.contains("OpenGL12") ? caps.glCopyTextureSubImage3DEXT : -1L, ext.contains("OpenGL13") ? caps.glBindMultiTextureEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexCoordPointerEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexEnvfEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexEnvfvEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexEnviEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexEnvivEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexGendEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexGendvEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexGenfEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexGenfvEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexGeniEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexGenivEXT : -1L, ext.contains("OpenGL13") ? caps.glGetMultiTexEnvfvEXT : -1L, ext.contains("OpenGL13") ? caps.glGetMultiTexEnvivEXT : -1L, ext.contains("OpenGL13") ? caps.glGetMultiTexGendvEXT : -1L, ext.contains("OpenGL13") ? caps.glGetMultiTexGenfvEXT : -1L, ext.contains("OpenGL13") ? caps.glGetMultiTexGenivEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexParameteriEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexParameterivEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexParameterfEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexParameterfvEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexImage1DEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexImage2DEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexSubImage1DEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexSubImage2DEXT : -1L, ext.contains("OpenGL13") ? caps.glCopyMultiTexImage1DEXT : -1L, ext.contains("OpenGL13") ? caps.glCopyMultiTexImage2DEXT : -1L, ext.contains("OpenGL13") ? caps.glCopyMultiTexSubImage1DEXT : -1L, ext.contains("OpenGL13") ? caps.glCopyMultiTexSubImage2DEXT : -1L, ext.contains("OpenGL13") ? caps.glGetMultiTexImageEXT : -1L, ext.contains("OpenGL13") ? caps.glGetMultiTexParameterfvEXT : -1L, ext.contains("OpenGL13") ? caps.glGetMultiTexParameterivEXT : -1L, ext.contains("OpenGL13") ? caps.glGetMultiTexLevelParameterfvEXT : -1L, ext.contains("OpenGL13") ? caps.glGetMultiTexLevelParameterivEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexImage3DEXT : -1L, ext.contains("OpenGL13") ? caps.glMultiTexSubImage3DEXT : -1L, ext.contains("OpenGL13") ? caps.glCopyMultiTexSubImage3DEXT : -1L, ext.contains("OpenGL13") ? caps.glEnableClientStateIndexedEXT : -1L, ext.contains("OpenGL13") ? caps.glDisableClientStateIndexedEXT : -1L, ext.contains("OpenGL13") ? caps.glGetFloatIndexedvEXT : -1L, ext.contains("OpenGL13") ? caps.glGetDoubleIndexedvEXT : -1L, ext.contains("OpenGL13") ? caps.glGetPointerIndexedvEXT : -1L, ext.contains("OpenGL13") ? caps.glEnableIndexedEXT : -1L, ext.contains("OpenGL13") ? caps.glDisableIndexedEXT : -1L, ext.contains("OpenGL13") ? caps.glIsEnabledIndexedEXT : -1L, ext.contains("OpenGL13") ? caps.glGetIntegerIndexedvEXT : -1L, ext.contains("OpenGL13") ? caps.glGetBooleanIndexedvEXT : -1L, ext.contains("GL_ARB_vertex_program") ? caps.glNamedProgramStringEXT : -1L, ext.contains("GL_ARB_vertex_program") ? caps.glNamedProgramLocalParameter4dEXT : -1L, ext.contains("GL_ARB_vertex_program") ? caps.glNamedProgramLocalParameter4dvEXT : -1L, ext.contains("GL_ARB_vertex_program") ? caps.glNamedProgramLocalParameter4fEXT : -1L, ext.contains("GL_ARB_vertex_program") ? caps.glNamedProgramLocalParameter4fvEXT : -1L, ext.contains("GL_ARB_vertex_program") ? caps.glGetNamedProgramLocalParameterdvEXT : -1L, ext.contains("GL_ARB_vertex_program") ? caps.glGetNamedProgramLocalParameterfvEXT : -1L, ext.contains("GL_ARB_vertex_program") ? caps.glGetNamedProgramivEXT : -1L, ext.contains("GL_ARB_vertex_program") ? caps.glGetNamedProgramStringEXT : -1L, ext.contains("OpenGL13") ? caps.glCompressedTextureImage3DEXT : -1L, ext.contains("OpenGL13") ? caps.glCompressedTextureImage2DEXT : -1L, ext.contains("OpenGL13") ? caps.glCompressedTextureImage1DEXT : -1L, ext.contains("OpenGL13") ? caps.glCompressedTextureSubImage3DEXT : -1L, ext.contains("OpenGL13") ? caps.glCompressedTextureSubImage2DEXT : -1L, ext.contains("OpenGL13") ? caps.glCompressedTextureSubImage1DEXT : -1L, ext.contains("OpenGL13") ? caps.glGetCompressedTextureImageEXT : -1L, ext.contains("OpenGL13") ? caps.glCompressedMultiTexImage3DEXT : -1L, ext.contains("OpenGL13") ? caps.glCompressedMultiTexImage2DEXT : -1L, ext.contains("OpenGL13") ? caps.glCompressedMultiTexImage1DEXT : -1L, ext.contains("OpenGL13") ? caps.glCompressedMultiTexSubImage3DEXT : -1L, ext.contains("OpenGL13") ? caps.glCompressedMultiTexSubImage2DEXT : -1L, ext.contains("OpenGL13") ? caps.glCompressedMultiTexSubImage1DEXT : -1L, ext.contains("OpenGL13") ? caps.glGetCompressedMultiTexImageEXT : -1L, ext.contains("OpenGL13") ? caps.glMatrixLoadTransposefEXT : -1L, ext.contains("OpenGL13") ? caps.glMatrixLoadTransposedEXT : -1L, ext.contains("OpenGL13") ? caps.glMatrixMultTransposefEXT : -1L, ext.contains("OpenGL13") ? caps.glMatrixMultTransposedEXT : -1L, ext.contains("OpenGL15") ? caps.glNamedBufferDataEXT : -1L, ext.contains("OpenGL15") ? caps.glNamedBufferSubDataEXT : -1L, ext.contains("OpenGL15") ? caps.glMapNamedBufferEXT : -1L, ext.contains("OpenGL15") ? caps.glUnmapNamedBufferEXT : -1L, ext.contains("OpenGL15") ? caps.glGetNamedBufferParameterivEXT : -1L, ext.contains("OpenGL15") ? caps.glGetNamedBufferSubDataEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniform1fEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniform2fEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniform3fEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniform4fEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniform1iEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniform2iEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniform3iEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniform4iEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniform1fvEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniform2fvEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniform3fvEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniform4fvEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniform1ivEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniform2ivEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniform3ivEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniform4ivEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniformMatrix2fvEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniformMatrix3fvEXT : -1L, ext.contains("OpenGL20") ? caps.glProgramUniformMatrix4fvEXT : -1L, ext.contains("OpenGL21") ? caps.glProgramUniformMatrix2x3fvEXT : -1L, ext.contains("OpenGL21") ? caps.glProgramUniformMatrix3x2fvEXT : -1L, ext.contains("OpenGL21") ? caps.glProgramUniformMatrix2x4fvEXT : -1L, ext.contains("OpenGL21") ? caps.glProgramUniformMatrix4x2fvEXT : -1L, ext.contains("OpenGL21") ? caps.glProgramUniformMatrix3x4fvEXT : -1L, ext.contains("OpenGL21") ? caps.glProgramUniformMatrix4x3fvEXT : -1L, ext.contains("GL_EXT_texture_buffer_object") ? caps.glTextureBufferEXT : -1L, ext.contains("GL_EXT_texture_buffer_object") ? caps.glMultiTexBufferEXT : -1L, ext.contains("GL_EXT_texture_integer") ? caps.glTextureParameterIivEXT : -1L, ext.contains("GL_EXT_texture_integer") ? caps.glTextureParameterIuivEXT : -1L, ext.contains("GL_EXT_texture_integer") ? caps.glGetTextureParameterIivEXT : -1L, ext.contains("GL_EXT_texture_integer") ? caps.glGetTextureParameterIuivEXT : -1L, ext.contains("GL_EXT_texture_integer") ? caps.glMultiTexParameterIivEXT : -1L, ext.contains("GL_EXT_texture_integer") ? caps.glMultiTexParameterIuivEXT : -1L, ext.contains("GL_EXT_texture_integer") ? caps.glGetMultiTexParameterIivEXT : -1L, ext.contains("GL_EXT_texture_integer") ? caps.glGetMultiTexParameterIuivEXT : -1L, ext.contains("GL_EXT_gpu_shader4") ? caps.glProgramUniform1uiEXT : -1L, ext.contains("GL_EXT_gpu_shader4") ? caps.glProgramUniform2uiEXT : -1L, ext.contains("GL_EXT_gpu_shader4") ? caps.glProgramUniform3uiEXT : -1L, ext.contains("GL_EXT_gpu_shader4") ? caps.glProgramUniform4uiEXT : -1L, ext.contains("GL_EXT_gpu_shader4") ? caps.glProgramUniform1uivEXT : -1L, ext.contains("GL_EXT_gpu_shader4") ? caps.glProgramUniform2uivEXT : -1L, ext.contains("GL_EXT_gpu_shader4") ? caps.glProgramUniform3uivEXT : -1L, ext.contains("GL_EXT_gpu_shader4") ? caps.glProgramUniform4uivEXT : -1L, ext.contains("GL_EXT_gpu_program_parameters") ? caps.glNamedProgramLocalParameters4fvEXT : -1L, ext.contains("GL_NV_gpu_program4") ? caps.glNamedProgramLocalParameterI4iEXT : -1L, ext.contains("GL_NV_gpu_program4") ? caps.glNamedProgramLocalParameterI4ivEXT : -1L, ext.contains("GL_NV_gpu_program4") ? caps.glNamedProgramLocalParametersI4ivEXT : -1L, ext.contains("GL_NV_gpu_program4") ? caps.glNamedProgramLocalParameterI4uiEXT : -1L, ext.contains("GL_NV_gpu_program4") ? caps.glNamedProgramLocalParameterI4uivEXT : -1L, ext.contains("GL_NV_gpu_program4") ? caps.glNamedProgramLocalParametersI4uivEXT : -1L, ext.contains("GL_NV_gpu_program4") ? caps.glGetNamedProgramLocalParameterIivEXT : -1L, ext.contains("GL_NV_gpu_program4") ? caps.glGetNamedProgramLocalParameterIuivEXT : -1L, ext.contains("OpenGL30") ? caps.glNamedRenderbufferStorageEXT : -1L, ext.contains("OpenGL30") ? caps.glGetNamedRenderbufferParameterivEXT : -1L, ext.contains("OpenGL30") ? caps.glNamedRenderbufferStorageMultisampleEXT : -1L, ext.contains("GL_NV_framebuffer_multisample_coverage") ? caps.glNamedRenderbufferStorageMultisampleCoverageEXT : -1L, ext.contains("OpenGL30") ? caps.glCheckNamedFramebufferStatusEXT : -1L, ext.contains("OpenGL30") ? caps.glNamedFramebufferTexture1DEXT : -1L, ext.contains("OpenGL30") ? caps.glNamedFramebufferTexture2DEXT : -1L, ext.contains("OpenGL30") ? caps.glNamedFramebufferTexture3DEXT : -1L, ext.contains("OpenGL30") ? caps.glNamedFramebufferRenderbufferEXT : -1L, ext.contains("OpenGL30") ? caps.glGetNamedFramebufferAttachmentParameterivEXT : -1L, ext.contains("OpenGL30") ? caps.glGenerateTextureMipmapEXT : -1L, ext.contains("OpenGL30") ? caps.glGenerateMultiTexMipmapEXT : -1L, ext.contains("OpenGL30") ? caps.glFramebufferDrawBufferEXT : -1L, ext.contains("OpenGL30") ? caps.glFramebufferDrawBuffersEXT : -1L, ext.contains("OpenGL30") ? caps.glFramebufferReadBufferEXT : -1L, ext.contains("OpenGL30") ? caps.glGetFramebufferParameterivEXT : -1L, ext.contains("OpenGL30") ? caps.glNamedCopyBufferSubDataEXT : -1L, ext.contains("GL_EXT_geometry_shader4") || ext.contains("GL_NV_gpu_program4") ? caps.glNamedFramebufferTextureEXT : -1L, ext.contains("GL_EXT_geometry_shader4") || ext.contains("GL_NV_gpu_program4") ? caps.glNamedFramebufferTextureLayerEXT : -1L, ext.contains("GL_EXT_geometry_shader4") || ext.contains("GL_NV_gpu_program4") ? caps.glNamedFramebufferTextureFaceEXT : -1L, ext.contains("GL_NV_explicit_multisample") ? caps.glTextureRenderbufferEXT : -1L, ext.contains("GL_NV_explicit_multisample") ? caps.glMultiTexRenderbufferEXT : -1L, ext.contains("OpenGL30") ? caps.glVertexArrayVertexOffsetEXT : -1L, ext.contains("OpenGL30") ? caps.glVertexArrayColorOffsetEXT : -1L, ext.contains("OpenGL30") ? caps.glVertexArrayEdgeFlagOffsetEXT : -1L, ext.contains("OpenGL30") ? caps.glVertexArrayIndexOffsetEXT : -1L, ext.contains("OpenGL30") ? caps.glVertexArrayNormalOffsetEXT : -1L, ext.contains("OpenGL30") ? caps.glVertexArrayTexCoordOffsetEXT : -1L, ext.contains("OpenGL30") ? caps.glVertexArrayMultiTexCoordOffsetEXT : -1L, ext.contains("OpenGL30") ? caps.glVertexArrayFogCoordOffsetEXT : -1L, ext.contains("OpenGL30") ? caps.glVertexArraySecondaryColorOffsetEXT : -1L, ext.contains("OpenGL30") ? caps.glVertexArrayVertexAttribOffsetEXT : -1L, ext.contains("OpenGL30") ? caps.glVertexArrayVertexAttribIOffsetEXT : -1L, ext.contains("OpenGL30") ? caps.glEnableVertexArrayEXT : -1L, ext.contains("OpenGL30") ? caps.glDisableVertexArrayEXT : -1L, ext.contains("OpenGL30") ? caps.glEnableVertexArrayAttribEXT : -1L, ext.contains("OpenGL30") ? caps.glDisableVertexArrayAttribEXT : -1L, ext.contains("OpenGL30") ? caps.glGetVertexArrayIntegervEXT : -1L, ext.contains("OpenGL30") ? caps.glGetVertexArrayPointervEXT : -1L, ext.contains("OpenGL30") ? caps.glGetVertexArrayIntegeri_vEXT : -1L, ext.contains("OpenGL30") ? caps.glGetVertexArrayPointeri_vEXT : -1L, ext.contains("OpenGL30") ? caps.glMapNamedBufferRangeEXT : -1L, ext.contains("OpenGL30") ? caps.glFlushMappedNamedBufferRangeEXT : -1L);
    }

    public static void glClientAttribDefaultEXT(int mask) {
        long __functionAddress = GL.getCapabilities().glClientAttribDefaultEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, mask);
    }

    public static void glPushClientAttribDefaultEXT(int mask) {
        long __functionAddress = GL.getCapabilities().glPushClientAttribDefaultEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, mask);
    }

    public static void nglMatrixLoadfEXT(int matrixMode, long m) {
        long __functionAddress = GL.getCapabilities().glMatrixLoadfEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixLoadfEXT(int matrixMode, FloatBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 16);
        }
        EXTDirectStateAccess.nglMatrixLoadfEXT(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void nglMatrixLoaddEXT(int matrixMode, long m) {
        long __functionAddress = GL.getCapabilities().glMatrixLoaddEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixLoaddEXT(int matrixMode, DoubleBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 16);
        }
        EXTDirectStateAccess.nglMatrixLoaddEXT(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void nglMatrixMultfEXT(int matrixMode, long m) {
        long __functionAddress = GL.getCapabilities().glMatrixMultfEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixMultfEXT(int matrixMode, FloatBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 16);
        }
        EXTDirectStateAccess.nglMatrixMultfEXT(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void nglMatrixMultdEXT(int matrixMode, long m) {
        long __functionAddress = GL.getCapabilities().glMatrixMultdEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixMultdEXT(int matrixMode, DoubleBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 16);
        }
        EXTDirectStateAccess.nglMatrixMultdEXT(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void glMatrixLoadIdentityEXT(int matrixMode) {
        long __functionAddress = GL.getCapabilities().glMatrixLoadIdentityEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, matrixMode);
    }

    public static void glMatrixRotatefEXT(int matrixMode, float angle, float x, float y, float z) {
        long __functionAddress = GL.getCapabilities().glMatrixRotatefEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, matrixMode, angle, x, y, z);
    }

    public static void glMatrixRotatedEXT(int matrixMode, double angle, double x, double y, double z) {
        long __functionAddress = GL.getCapabilities().glMatrixRotatedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, matrixMode, angle, x, y, z);
    }

    public static void glMatrixScalefEXT(int matrixMode, float x, float y, float z) {
        long __functionAddress = GL.getCapabilities().glMatrixScalefEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, matrixMode, x, y, z);
    }

    public static void glMatrixScaledEXT(int matrixMode, double x, double y, double z) {
        long __functionAddress = GL.getCapabilities().glMatrixScaledEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, matrixMode, x, y, z);
    }

    public static void glMatrixTranslatefEXT(int matrixMode, float x, float y, float z) {
        long __functionAddress = GL.getCapabilities().glMatrixTranslatefEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, matrixMode, x, y, z);
    }

    public static void glMatrixTranslatedEXT(int matrixMode, double x, double y, double z) {
        long __functionAddress = GL.getCapabilities().glMatrixTranslatedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, matrixMode, x, y, z);
    }

    public static void glMatrixOrthoEXT(int matrixMode, double l, double r, double b, double t, double n, double f) {
        long __functionAddress = GL.getCapabilities().glMatrixOrthoEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, matrixMode, l, r, b, t, n, f);
    }

    public static void glMatrixFrustumEXT(int matrixMode, double l, double r, double b, double t, double n, double f) {
        long __functionAddress = GL.getCapabilities().glMatrixFrustumEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, matrixMode, l, r, b, t, n, f);
    }

    public static void glMatrixPushEXT(int matrixMode) {
        long __functionAddress = GL.getCapabilities().glMatrixPushEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, matrixMode);
    }

    public static void glMatrixPopEXT(int matrixMode) {
        long __functionAddress = GL.getCapabilities().glMatrixPopEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, matrixMode);
    }

    public static void glTextureParameteriEXT(int texture, int target, int pname, int param) {
        long __functionAddress = GL.getCapabilities().glTextureParameteriEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texture, target, pname, param);
    }

    public static void nglTextureParameterivEXT(int texture, int target, int pname, long param) {
        long __functionAddress = GL.getCapabilities().glTextureParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, pname, param);
    }

    public static void glTextureParameterivEXT(int texture, int target, int pname, IntBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 4);
        }
        EXTDirectStateAccess.nglTextureParameterivEXT(texture, target, pname, MemoryUtil.memAddress(param));
    }

    public static void glTextureParameterfEXT(int texture, int target, int pname, float param) {
        long __functionAddress = GL.getCapabilities().glTextureParameterfEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texture, target, pname, param);
    }

    public static void nglTextureParameterfvEXT(int texture, int target, int pname, long param) {
        long __functionAddress = GL.getCapabilities().glTextureParameterfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, pname, param);
    }

    public static void glTextureParameterfvEXT(int texture, int target, int pname, FloatBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 4);
        }
        EXTDirectStateAccess.nglTextureParameterfvEXT(texture, target, pname, MemoryUtil.memAddress(param));
    }

    public static void nglTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glTextureImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, border, format, type, pixels);
    }

    public static void glTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int format, int type, ByteBuffer pixels) {
        EXTDirectStateAccess.nglTextureImage1DEXT(texture, target, level, internalformat, width, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int format, int type, long pixels) {
        EXTDirectStateAccess.nglTextureImage1DEXT(texture, target, level, internalformat, width, border, format, type, pixels);
    }

    public static void glTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int format, int type, ShortBuffer pixels) {
        EXTDirectStateAccess.nglTextureImage1DEXT(texture, target, level, internalformat, width, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int format, int type, IntBuffer pixels) {
        EXTDirectStateAccess.nglTextureImage1DEXT(texture, target, level, internalformat, width, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int format, int type, FloatBuffer pixels) {
        EXTDirectStateAccess.nglTextureImage1DEXT(texture, target, level, internalformat, width, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int format, int type, DoubleBuffer pixels) {
        EXTDirectStateAccess.nglTextureImage1DEXT(texture, target, level, internalformat, width, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void nglTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glTextureImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, ByteBuffer pixels) {
        EXTDirectStateAccess.nglTextureImage2DEXT(texture, target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, long pixels) {
        EXTDirectStateAccess.nglTextureImage2DEXT(texture, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, ShortBuffer pixels) {
        EXTDirectStateAccess.nglTextureImage2DEXT(texture, target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        EXTDirectStateAccess.nglTextureImage2DEXT(texture, target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, FloatBuffer pixels) {
        EXTDirectStateAccess.nglTextureImage2DEXT(texture, target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, DoubleBuffer pixels) {
        EXTDirectStateAccess.nglTextureImage2DEXT(texture, target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void nglTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glTextureSubImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, width, format, type, pixels);
    }

    public static void glTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int type, ByteBuffer pixels) {
        EXTDirectStateAccess.nglTextureSubImage1DEXT(texture, target, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int type, long pixels) {
        EXTDirectStateAccess.nglTextureSubImage1DEXT(texture, target, level, xoffset, width, format, type, pixels);
    }

    public static void glTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int type, ShortBuffer pixels) {
        EXTDirectStateAccess.nglTextureSubImage1DEXT(texture, target, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int type, IntBuffer pixels) {
        EXTDirectStateAccess.nglTextureSubImage1DEXT(texture, target, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int type, FloatBuffer pixels) {
        EXTDirectStateAccess.nglTextureSubImage1DEXT(texture, target, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int type, DoubleBuffer pixels) {
        EXTDirectStateAccess.nglTextureSubImage1DEXT(texture, target, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void nglTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glTextureSubImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer pixels) {
        EXTDirectStateAccess.nglTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        EXTDirectStateAccess.nglTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ShortBuffer pixels) {
        EXTDirectStateAccess.nglTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        EXTDirectStateAccess.nglTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, FloatBuffer pixels) {
        EXTDirectStateAccess.nglTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, DoubleBuffer pixels) {
        EXTDirectStateAccess.nglTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glCopyTextureImage1DEXT(int texture, int target, int level, int internalformat, int x, int y, int width, int border) {
        long __functionAddress = GL.getCapabilities().glCopyTextureImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texture, target, level, internalformat, x, y, width, border);
    }

    public static void glCopyTextureImage2DEXT(int texture, int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        long __functionAddress = GL.getCapabilities().glCopyTextureImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texture, target, level, internalformat, x, y, width, height, border);
    }

    public static void glCopyTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int x, int y, int width) {
        long __functionAddress = GL.getCapabilities().glCopyTextureSubImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texture, target, level, xoffset, x, y, width);
    }

    public static void glCopyTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        long __functionAddress = GL.getCapabilities().glCopyTextureSubImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texture, target, level, xoffset, yoffset, x, y, width, height);
    }

    public static void nglGetTextureImageEXT(int texture, int target, int level, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glGetTextureImageEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, format, type, pixels);
    }

    public static void glGetTextureImageEXT(int texture, int target, int level, int format, int type, ByteBuffer pixels) {
        EXTDirectStateAccess.nglGetTextureImageEXT(texture, target, level, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureImageEXT(int texture, int target, int level, int format, int type, long pixels) {
        EXTDirectStateAccess.nglGetTextureImageEXT(texture, target, level, format, type, pixels);
    }

    public static void glGetTextureImageEXT(int texture, int target, int level, int format, int type, ShortBuffer pixels) {
        EXTDirectStateAccess.nglGetTextureImageEXT(texture, target, level, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureImageEXT(int texture, int target, int level, int format, int type, IntBuffer pixels) {
        EXTDirectStateAccess.nglGetTextureImageEXT(texture, target, level, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureImageEXT(int texture, int target, int level, int format, int type, FloatBuffer pixels) {
        EXTDirectStateAccess.nglGetTextureImageEXT(texture, target, level, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureImageEXT(int texture, int target, int level, int format, int type, DoubleBuffer pixels) {
        EXTDirectStateAccess.nglGetTextureImageEXT(texture, target, level, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void nglGetTextureParameterfvEXT(int texture, int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetTextureParameterfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, pname, params);
    }

    public static void glGetTextureParameterfvEXT(int texture, int target, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetTextureParameterfvEXT(texture, target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetTextureParameterfEXT(int texture, int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            EXTDirectStateAccess.nglGetTextureParameterfvEXT(texture, target, pname, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetTextureParameterivEXT(int texture, int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetTextureParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, pname, params);
    }

    public static void glGetTextureParameterivEXT(int texture, int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetTextureParameterivEXT(texture, target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTextureParameteriEXT(int texture, int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDirectStateAccess.nglGetTextureParameterivEXT(texture, target, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetTextureLevelParameterfvEXT(int texture, int target, int level, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetTextureLevelParameterfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, pname, params);
    }

    public static void glGetTextureLevelParameterfvEXT(int texture, int target, int level, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetTextureLevelParameterfvEXT(texture, target, level, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetTextureLevelParameterfEXT(int texture, int target, int level, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            EXTDirectStateAccess.nglGetTextureLevelParameterfvEXT(texture, target, level, pname, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetTextureLevelParameterivEXT(int texture, int target, int level, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetTextureLevelParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, pname, params);
    }

    public static void glGetTextureLevelParameterivEXT(int texture, int target, int level, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetTextureLevelParameterivEXT(texture, target, level, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTextureLevelParameteriEXT(int texture, int target, int level, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDirectStateAccess.nglGetTextureLevelParameterivEXT(texture, target, level, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glTextureImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, ByteBuffer pixels) {
        EXTDirectStateAccess.nglTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, long pixels) {
        EXTDirectStateAccess.nglTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, ShortBuffer pixels) {
        EXTDirectStateAccess.nglTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, IntBuffer pixels) {
        EXTDirectStateAccess.nglTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, FloatBuffer pixels) {
        EXTDirectStateAccess.nglTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, DoubleBuffer pixels) {
        EXTDirectStateAccess.nglTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void nglTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glTextureSubImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer pixels) {
        EXTDirectStateAccess.nglTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixels) {
        EXTDirectStateAccess.nglTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        EXTDirectStateAccess.nglTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        EXTDirectStateAccess.nglTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        EXTDirectStateAccess.nglTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, DoubleBuffer pixels) {
        EXTDirectStateAccess.nglTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glCopyTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height) {
        long __functionAddress = GL.getCapabilities().glCopyTextureSubImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texture, target, level, xoffset, yoffset, zoffset, x, y, width, height);
    }

    public static void glBindMultiTextureEXT(int texunit, int target, int texture) {
        long __functionAddress = GL.getCapabilities().glBindMultiTextureEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texunit, target, texture);
    }

    public static void nglMultiTexCoordPointerEXT(int texunit, int size, int type, int stride, long pointer) {
        long __functionAddress = GL.getCapabilities().glMultiTexCoordPointerEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, size, type, stride, pointer);
    }

    public static void glMultiTexCoordPointerEXT(int texunit, int size, int type, int stride, ByteBuffer pointer) {
        EXTDirectStateAccess.nglMultiTexCoordPointerEXT(texunit, size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glMultiTexCoordPointerEXT(int texunit, int size, int type, int stride, long pointer) {
        EXTDirectStateAccess.nglMultiTexCoordPointerEXT(texunit, size, type, stride, pointer);
    }

    public static void glMultiTexCoordPointerEXT(int texunit, int size, int type, int stride, ShortBuffer pointer) {
        EXTDirectStateAccess.nglMultiTexCoordPointerEXT(texunit, size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glMultiTexCoordPointerEXT(int texunit, int size, int type, int stride, IntBuffer pointer) {
        EXTDirectStateAccess.nglMultiTexCoordPointerEXT(texunit, size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glMultiTexCoordPointerEXT(int texunit, int size, int type, int stride, FloatBuffer pointer) {
        EXTDirectStateAccess.nglMultiTexCoordPointerEXT(texunit, size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glMultiTexEnvfEXT(int texunit, int target, int pname, float param) {
        long __functionAddress = GL.getCapabilities().glMultiTexEnvfEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texunit, target, pname, param);
    }

    public static void nglMultiTexEnvfvEXT(int texunit, int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glMultiTexEnvfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glMultiTexEnvfvEXT(int texunit, int target, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDirectStateAccess.nglMultiTexEnvfvEXT(texunit, target, pname, MemoryUtil.memAddress(params));
    }

    public static void glMultiTexEnviEXT(int texunit, int target, int pname, int param) {
        long __functionAddress = GL.getCapabilities().glMultiTexEnviEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texunit, target, pname, param);
    }

    public static void nglMultiTexEnvivEXT(int texunit, int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glMultiTexEnvivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glMultiTexEnvivEXT(int texunit, int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDirectStateAccess.nglMultiTexEnvivEXT(texunit, target, pname, MemoryUtil.memAddress(params));
    }

    public static void glMultiTexGendEXT(int texunit, int coord, int pname, double param) {
        long __functionAddress = GL.getCapabilities().glMultiTexGendEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texunit, coord, pname, param);
    }

    public static void nglMultiTexGendvEXT(int texunit, int coord, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glMultiTexGendvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, coord, pname, params);
    }

    public static void glMultiTexGendvEXT(int texunit, int coord, int pname, DoubleBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDirectStateAccess.nglMultiTexGendvEXT(texunit, coord, pname, MemoryUtil.memAddress(params));
    }

    public static void glMultiTexGenfEXT(int texunit, int coord, int pname, float param) {
        long __functionAddress = GL.getCapabilities().glMultiTexGenfEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texunit, coord, pname, param);
    }

    public static void nglMultiTexGenfvEXT(int texunit, int coord, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glMultiTexGenfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, coord, pname, params);
    }

    public static void glMultiTexGenfvEXT(int texunit, int coord, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDirectStateAccess.nglMultiTexGenfvEXT(texunit, coord, pname, MemoryUtil.memAddress(params));
    }

    public static void glMultiTexGeniEXT(int texunit, int coord, int pname, int param) {
        long __functionAddress = GL.getCapabilities().glMultiTexGeniEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texunit, coord, pname, param);
    }

    public static void nglMultiTexGenivEXT(int texunit, int coord, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glMultiTexGenivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, coord, pname, params);
    }

    public static void glMultiTexGenivEXT(int texunit, int coord, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDirectStateAccess.nglMultiTexGenivEXT(texunit, coord, pname, MemoryUtil.memAddress(params));
    }

    public static void nglGetMultiTexEnvfvEXT(int texunit, int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexEnvfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glGetMultiTexEnvfvEXT(int texunit, int target, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetMultiTexEnvfvEXT(texunit, target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetMultiTexEnvfEXT(int texunit, int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            EXTDirectStateAccess.nglGetMultiTexEnvfvEXT(texunit, target, pname, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetMultiTexEnvivEXT(int texunit, int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexEnvivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glGetMultiTexEnvivEXT(int texunit, int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetMultiTexEnvivEXT(texunit, target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetMultiTexEnviEXT(int texunit, int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDirectStateAccess.nglGetMultiTexEnvivEXT(texunit, target, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetMultiTexGendvEXT(int texunit, int coord, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexGendvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, coord, pname, params);
    }

    public static void glGetMultiTexGendvEXT(int texunit, int coord, int pname, DoubleBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetMultiTexGendvEXT(texunit, coord, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double glGetMultiTexGendEXT(int texunit, int coord, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer params = stack.callocDouble(1);
            EXTDirectStateAccess.nglGetMultiTexGendvEXT(texunit, coord, pname, MemoryUtil.memAddress(params));
            double d = params.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetMultiTexGenfvEXT(int texunit, int coord, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexGenfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, coord, pname, params);
    }

    public static void glGetMultiTexGenfvEXT(int texunit, int coord, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetMultiTexGenfvEXT(texunit, coord, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetMultiTexGenfEXT(int texunit, int coord, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            EXTDirectStateAccess.nglGetMultiTexGenfvEXT(texunit, coord, pname, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetMultiTexGenivEXT(int texunit, int coord, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexGenivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, coord, pname, params);
    }

    public static void glGetMultiTexGenivEXT(int texunit, int coord, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetMultiTexGenivEXT(texunit, coord, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetMultiTexGeniEXT(int texunit, int coord, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDirectStateAccess.nglGetMultiTexGenivEXT(texunit, coord, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glMultiTexParameteriEXT(int texunit, int target, int pname, int param) {
        long __functionAddress = GL.getCapabilities().glMultiTexParameteriEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texunit, target, pname, param);
    }

    public static void nglMultiTexParameterivEXT(int texunit, int target, int pname, long param) {
        long __functionAddress = GL.getCapabilities().glMultiTexParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, param);
    }

    public static void glMultiTexParameterivEXT(int texunit, int target, int pname, IntBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 4);
        }
        EXTDirectStateAccess.nglMultiTexParameterivEXT(texunit, target, pname, MemoryUtil.memAddress(param));
    }

    public static void glMultiTexParameterfEXT(int texunit, int target, int pname, float param) {
        long __functionAddress = GL.getCapabilities().glMultiTexParameterfEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texunit, target, pname, param);
    }

    public static void nglMultiTexParameterfvEXT(int texunit, int target, int pname, long param) {
        long __functionAddress = GL.getCapabilities().glMultiTexParameterfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, param);
    }

    public static void glMultiTexParameterfvEXT(int texunit, int target, int pname, FloatBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 4);
        }
        EXTDirectStateAccess.nglMultiTexParameterfvEXT(texunit, target, pname, MemoryUtil.memAddress(param));
    }

    public static void nglMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, border, format, type, pixels);
    }

    public static void glMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int format, int type, ByteBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int format, int type, long pixels) {
        EXTDirectStateAccess.nglMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, format, type, pixels);
    }

    public static void glMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int format, int type, ShortBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int format, int type, IntBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int format, int type, FloatBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int format, int type, DoubleBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void nglMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int format, int type, ByteBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int format, int type, long pixels) {
        EXTDirectStateAccess.nglMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int format, int type, ShortBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int format, int type, FloatBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int format, int type, DoubleBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void nglMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexSubImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, width, format, type, pixels);
    }

    public static void glMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int type, ByteBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int type, long pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, type, pixels);
    }

    public static void glMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int type, ShortBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int type, IntBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int type, FloatBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int type, DoubleBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void nglMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexSubImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ShortBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, FloatBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, DoubleBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glCopyMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int x, int y, int width, int border) {
        long __functionAddress = GL.getCapabilities().glCopyMultiTexImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texunit, target, level, internalformat, x, y, width, border);
    }

    public static void glCopyMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        long __functionAddress = GL.getCapabilities().glCopyMultiTexImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texunit, target, level, internalformat, x, y, width, height, border);
    }

    public static void glCopyMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int x, int y, int width) {
        long __functionAddress = GL.getCapabilities().glCopyMultiTexSubImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texunit, target, level, xoffset, x, y, width);
    }

    public static void glCopyMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        long __functionAddress = GL.getCapabilities().glCopyMultiTexSubImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texunit, target, level, xoffset, yoffset, x, y, width, height);
    }

    public static void nglGetMultiTexImageEXT(int texunit, int target, int level, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexImageEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, format, type, pixels);
    }

    public static void glGetMultiTexImageEXT(int texunit, int target, int level, int format, int type, ByteBuffer pixels) {
        EXTDirectStateAccess.nglGetMultiTexImageEXT(texunit, target, level, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glGetMultiTexImageEXT(int texunit, int target, int level, int format, int type, long pixels) {
        EXTDirectStateAccess.nglGetMultiTexImageEXT(texunit, target, level, format, type, pixels);
    }

    public static void glGetMultiTexImageEXT(int texunit, int target, int level, int format, int type, ShortBuffer pixels) {
        EXTDirectStateAccess.nglGetMultiTexImageEXT(texunit, target, level, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glGetMultiTexImageEXT(int texunit, int target, int level, int format, int type, IntBuffer pixels) {
        EXTDirectStateAccess.nglGetMultiTexImageEXT(texunit, target, level, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glGetMultiTexImageEXT(int texunit, int target, int level, int format, int type, FloatBuffer pixels) {
        EXTDirectStateAccess.nglGetMultiTexImageEXT(texunit, target, level, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glGetMultiTexImageEXT(int texunit, int target, int level, int format, int type, DoubleBuffer pixels) {
        EXTDirectStateAccess.nglGetMultiTexImageEXT(texunit, target, level, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void nglGetMultiTexParameterfvEXT(int texunit, int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexParameterfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glGetMultiTexParameterfvEXT(int texunit, int target, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetMultiTexParameterfvEXT(texunit, target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetMultiTexParameterfEXT(int texunit, int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            EXTDirectStateAccess.nglGetMultiTexParameterfvEXT(texunit, target, pname, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetMultiTexParameterivEXT(int texunit, int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glGetMultiTexParameterivEXT(int texunit, int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetMultiTexParameterivEXT(texunit, target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetMultiTexParameteriEXT(int texunit, int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDirectStateAccess.nglGetMultiTexParameterivEXT(texunit, target, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetMultiTexLevelParameterfvEXT(int texunit, int target, int level, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexLevelParameterfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, pname, params);
    }

    public static void glGetMultiTexLevelParameterfvEXT(int texunit, int target, int level, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetMultiTexLevelParameterfvEXT(texunit, target, level, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetMultiTexLevelParameterfEXT(int texunit, int target, int level, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            EXTDirectStateAccess.nglGetMultiTexLevelParameterfvEXT(texunit, target, level, pname, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetMultiTexLevelParameterivEXT(int texunit, int target, int level, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexLevelParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, pname, params);
    }

    public static void glGetMultiTexLevelParameterivEXT(int texunit, int target, int level, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetMultiTexLevelParameterivEXT(texunit, target, level, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetMultiTexLevelParameteriEXT(int texunit, int target, int level, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDirectStateAccess.nglGetMultiTexLevelParameterivEXT(texunit, target, level, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, ByteBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, long pixels) {
        EXTDirectStateAccess.nglMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, ShortBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, IntBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, FloatBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, DoubleBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void nglMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexSubImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, DoubleBuffer pixels) {
        EXTDirectStateAccess.nglMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glCopyMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height) {
        long __functionAddress = GL.getCapabilities().glCopyMultiTexSubImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texunit, target, level, xoffset, yoffset, zoffset, x, y, width, height);
    }

    public static void glEnableClientStateIndexedEXT(int array, int index) {
        long __functionAddress = GL.getCapabilities().glEnableClientStateIndexedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, array, index);
    }

    public static void glDisableClientStateIndexedEXT(int array, int index) {
        long __functionAddress = GL.getCapabilities().glDisableClientStateIndexedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, array, index);
    }

    public static void glEnableClientStateiEXT(int array, int index) {
        long __functionAddress = GL.getCapabilities().glEnableClientStateiEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, array, index);
    }

    public static void glDisableClientStateiEXT(int array, int index) {
        long __functionAddress = GL.getCapabilities().glDisableClientStateiEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, array, index);
    }

    public static void nglGetFloatIndexedvEXT(int target, int index, long params) {
        long __functionAddress = GL.getCapabilities().glGetFloatIndexedvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, index, params);
    }

    public static void glGetFloatIndexedvEXT(int target, int index, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetFloatIndexedvEXT(target, index, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetFloatIndexedEXT(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            EXTDirectStateAccess.nglGetFloatIndexedvEXT(target, index, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetDoubleIndexedvEXT(int target, int index, long params) {
        long __functionAddress = GL.getCapabilities().glGetDoubleIndexedvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, index, params);
    }

    public static void glGetDoubleIndexedvEXT(int target, int index, DoubleBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetDoubleIndexedvEXT(target, index, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double glGetDoubleIndexedEXT(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer params = stack.callocDouble(1);
            EXTDirectStateAccess.nglGetDoubleIndexedvEXT(target, index, MemoryUtil.memAddress(params));
            double d = params.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetPointerIndexedvEXT(int target, int index, long params) {
        long __functionAddress = GL.getCapabilities().glGetPointerIndexedvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, index, params);
    }

    public static void glGetPointerIndexedvEXT(int target, int index, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        EXTDirectStateAccess.nglGetPointerIndexedvEXT(target, index, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetPointerIndexedEXT(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer params = stack.callocPointer(1);
            EXTDirectStateAccess.nglGetPointerIndexedvEXT(target, index, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetFloati_vEXT(int pname, int index, long params) {
        long __functionAddress = GL.getCapabilities().glGetFloati_vEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, pname, index, params);
    }

    public static void glGetFloati_vEXT(int pname, int index, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetFloati_vEXT(pname, index, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetFloatiEXT(int pname, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            EXTDirectStateAccess.nglGetFloati_vEXT(pname, index, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetDoublei_vEXT(int pname, int index, long params) {
        long __functionAddress = GL.getCapabilities().glGetDoublei_vEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, pname, index, params);
    }

    public static void glGetDoublei_vEXT(int pname, int index, DoubleBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetDoublei_vEXT(pname, index, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double glGetDoubleiEXT(int pname, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer params = stack.callocDouble(1);
            EXTDirectStateAccess.nglGetDoublei_vEXT(pname, index, MemoryUtil.memAddress(params));
            double d = params.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetPointeri_vEXT(int pname, int index, long params) {
        long __functionAddress = GL.getCapabilities().glGetPointeri_vEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, pname, index, params);
    }

    public static void glGetPointeri_vEXT(int pname, int index, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        EXTDirectStateAccess.nglGetPointeri_vEXT(pname, index, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetPointeriEXT(int pname, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer params = stack.callocPointer(1);
            EXTDirectStateAccess.nglGetPointeri_vEXT(pname, index, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glEnableIndexedEXT(int cap, int index) {
        long __functionAddress = GL.getCapabilities().glEnableIndexedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, cap, index);
    }

    public static void glDisableIndexedEXT(int cap, int index) {
        long __functionAddress = GL.getCapabilities().glDisableIndexedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, cap, index);
    }

    public static boolean glIsEnabledIndexedEXT(int target, int index) {
        long __functionAddress = GL.getCapabilities().glIsEnabledIndexedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callZ(__functionAddress, target, index);
    }

    public static void nglGetIntegerIndexedvEXT(int target, int index, long params) {
        long __functionAddress = GL.getCapabilities().glGetIntegerIndexedvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, index, params);
    }

    public static void glGetIntegerIndexedvEXT(int target, int index, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetIntegerIndexedvEXT(target, index, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetIntegerIndexedEXT(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDirectStateAccess.nglGetIntegerIndexedvEXT(target, index, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetBooleanIndexedvEXT(int target, int index, long params) {
        long __functionAddress = GL.getCapabilities().glGetBooleanIndexedvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, index, params);
    }

    public static void glGetBooleanIndexedvEXT(int target, int index, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetBooleanIndexedvEXT(target, index, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean glGetBooleanIndexedEXT(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer params = stack.calloc(1);
            EXTDirectStateAccess.nglGetBooleanIndexedvEXT(target, index, MemoryUtil.memAddress(params));
            boolean bl = params.get(0) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglNamedProgramStringEXT(int program, int target, int format, int len, long string) {
        long __functionAddress = GL.getCapabilities().glNamedProgramStringEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, target, format, len, string);
    }

    public static void glNamedProgramStringEXT(int program, int target, int format, ByteBuffer string) {
        EXTDirectStateAccess.nglNamedProgramStringEXT(program, target, format, string.remaining(), MemoryUtil.memAddress(string));
    }

    public static void glNamedProgramLocalParameter4dEXT(int program, int target, int index, double x, double y, double z, double w) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParameter4dEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, target, index, x, y, z, w);
    }

    public static void nglNamedProgramLocalParameter4dvEXT(int program, int target, int index, long params) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParameter4dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, target, index, params);
    }

    public static void glNamedProgramLocalParameter4dvEXT(int program, int target, int index, DoubleBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDirectStateAccess.nglNamedProgramLocalParameter4dvEXT(program, target, index, MemoryUtil.memAddress(params));
    }

    public static void glNamedProgramLocalParameter4fEXT(int program, int target, int index, float x, float y, float z, float w) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParameter4fEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, target, index, x, y, z, w);
    }

    public static void nglNamedProgramLocalParameter4fvEXT(int program, int target, int index, long params) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParameter4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, target, index, params);
    }

    public static void glNamedProgramLocalParameter4fvEXT(int program, int target, int index, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDirectStateAccess.nglNamedProgramLocalParameter4fvEXT(program, target, index, MemoryUtil.memAddress(params));
    }

    public static void nglGetNamedProgramLocalParameterdvEXT(int program, int target, int index, long params) {
        long __functionAddress = GL.getCapabilities().glGetNamedProgramLocalParameterdvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, target, index, params);
    }

    public static void glGetNamedProgramLocalParameterdvEXT(int program, int target, int index, DoubleBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDirectStateAccess.nglGetNamedProgramLocalParameterdvEXT(program, target, index, MemoryUtil.memAddress(params));
    }

    public static void nglGetNamedProgramLocalParameterfvEXT(int program, int target, int index, long params) {
        long __functionAddress = GL.getCapabilities().glGetNamedProgramLocalParameterfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, target, index, params);
    }

    public static void glGetNamedProgramLocalParameterfvEXT(int program, int target, int index, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDirectStateAccess.nglGetNamedProgramLocalParameterfvEXT(program, target, index, MemoryUtil.memAddress(params));
    }

    public static void nglGetNamedProgramivEXT(int program, int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetNamedProgramivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, target, pname, params);
    }

    public static void glGetNamedProgramivEXT(int program, int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetNamedProgramivEXT(program, target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetNamedProgramiEXT(int program, int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDirectStateAccess.nglGetNamedProgramivEXT(program, target, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetNamedProgramStringEXT(int program, int target, int pname, long string) {
        long __functionAddress = GL.getCapabilities().glGetNamedProgramStringEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, target, pname, string);
    }

    public static void glGetNamedProgramStringEXT(int program, int target, int pname, ByteBuffer string) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.checkBuffer((Buffer)string, EXTDirectStateAccess.glGetNamedProgramiEXT(program, target, 34343));
        }
        EXTDirectStateAccess.nglGetNamedProgramStringEXT(program, target, pname, MemoryUtil.memAddress(string));
    }

    public static void nglCompressedTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, long data) {
        long __functionAddress = GL.getCapabilities().glCompressedTextureImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, height, depth, border, imageSize, data);
    }

    public static void glCompressedTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, long data) {
        EXTDirectStateAccess.nglCompressedTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, imageSize, data);
    }

    public static void glCompressedTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, ByteBuffer data) {
        EXTDirectStateAccess.nglCompressedTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, Checks.remainingSafe(data), MemoryUtil.memAddressSafe(data));
    }

    public static void nglCompressedTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int imageSize, long data) {
        long __functionAddress = GL.getCapabilities().glCompressedTextureImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, height, border, imageSize, data);
    }

    public static void glCompressedTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int imageSize, long data) {
        EXTDirectStateAccess.nglCompressedTextureImage2DEXT(texture, target, level, internalformat, width, height, border, imageSize, data);
    }

    public static void glCompressedTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, ByteBuffer data) {
        EXTDirectStateAccess.nglCompressedTextureImage2DEXT(texture, target, level, internalformat, width, height, border, Checks.remainingSafe(data), MemoryUtil.memAddressSafe(data));
    }

    public static void nglCompressedTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int imageSize, long data) {
        long __functionAddress = GL.getCapabilities().glCompressedTextureImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, border, imageSize, data);
    }

    public static void glCompressedTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int imageSize, long data) {
        EXTDirectStateAccess.nglCompressedTextureImage1DEXT(texture, target, level, internalformat, width, border, imageSize, data);
    }

    public static void glCompressedTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, ByteBuffer data) {
        EXTDirectStateAccess.nglCompressedTextureImage1DEXT(texture, target, level, internalformat, width, border, Checks.remainingSafe(data), MemoryUtil.memAddressSafe(data));
    }

    public static void nglCompressedTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long data) {
        long __functionAddress = GL.getCapabilities().glCompressedTextureSubImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }

    public static void glCompressedTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long data) {
        EXTDirectStateAccess.nglCompressedTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }

    public static void glCompressedTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, ByteBuffer data) {
        EXTDirectStateAccess.nglCompressedTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglCompressedTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long data) {
        long __functionAddress = GL.getCapabilities().glCompressedTextureSubImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }

    public static void glCompressedTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long data) {
        EXTDirectStateAccess.nglCompressedTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }

    public static void glCompressedTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, ByteBuffer data) {
        EXTDirectStateAccess.nglCompressedTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglCompressedTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int imageSize, long data) {
        long __functionAddress = GL.getCapabilities().glCompressedTextureSubImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, width, format, imageSize, data);
    }

    public static void glCompressedTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int imageSize, long data) {
        EXTDirectStateAccess.nglCompressedTextureSubImage1DEXT(texture, target, level, xoffset, width, format, imageSize, data);
    }

    public static void glCompressedTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, ByteBuffer data) {
        EXTDirectStateAccess.nglCompressedTextureSubImage1DEXT(texture, target, level, xoffset, width, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglGetCompressedTextureImageEXT(int texture, int target, int level, long img) {
        long __functionAddress = GL.getCapabilities().glGetCompressedTextureImageEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, img);
    }

    public static void glGetCompressedTextureImageEXT(int texture, int target, int level, ByteBuffer img) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.checkBuffer((Buffer)img, EXTDirectStateAccess.glGetTextureLevelParameteriEXT(texture, target, level, 34464));
        }
        EXTDirectStateAccess.nglGetCompressedTextureImageEXT(texture, target, level, MemoryUtil.memAddress(img));
    }

    public static void glGetCompressedTextureImageEXT(int texture, int target, int level, long img) {
        EXTDirectStateAccess.nglGetCompressedTextureImageEXT(texture, target, level, img);
    }

    public static void nglCompressedMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, long data) {
        long __functionAddress = GL.getCapabilities().glCompressedMultiTexImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, height, depth, border, imageSize, data);
    }

    public static void glCompressedMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, long data) {
        EXTDirectStateAccess.nglCompressedMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, imageSize, data);
    }

    public static void glCompressedMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, ByteBuffer data) {
        EXTDirectStateAccess.nglCompressedMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, Checks.remainingSafe(data), MemoryUtil.memAddressSafe(data));
    }

    public static void nglCompressedMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int imageSize, long data) {
        long __functionAddress = GL.getCapabilities().glCompressedMultiTexImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, height, border, imageSize, data);
    }

    public static void glCompressedMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int imageSize, long data) {
        EXTDirectStateAccess.nglCompressedMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, imageSize, data);
    }

    public static void glCompressedMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, ByteBuffer data) {
        EXTDirectStateAccess.nglCompressedMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, Checks.remainingSafe(data), MemoryUtil.memAddressSafe(data));
    }

    public static void nglCompressedMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int imageSize, long data) {
        long __functionAddress = GL.getCapabilities().glCompressedMultiTexImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, border, imageSize, data);
    }

    public static void glCompressedMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int imageSize, long data) {
        EXTDirectStateAccess.nglCompressedMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, imageSize, data);
    }

    public static void glCompressedMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, ByteBuffer data) {
        EXTDirectStateAccess.nglCompressedMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, Checks.remainingSafe(data), MemoryUtil.memAddressSafe(data));
    }

    public static void nglCompressedMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long data) {
        long __functionAddress = GL.getCapabilities().glCompressedMultiTexSubImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }

    public static void glCompressedMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long data) {
        EXTDirectStateAccess.nglCompressedMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }

    public static void glCompressedMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, ByteBuffer data) {
        EXTDirectStateAccess.nglCompressedMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglCompressedMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long data) {
        long __functionAddress = GL.getCapabilities().glCompressedMultiTexSubImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }

    public static void glCompressedMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long data) {
        EXTDirectStateAccess.nglCompressedMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }

    public static void glCompressedMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, ByteBuffer data) {
        EXTDirectStateAccess.nglCompressedMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglCompressedMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int imageSize, long data) {
        long __functionAddress = GL.getCapabilities().glCompressedMultiTexSubImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, width, format, imageSize, data);
    }

    public static void glCompressedMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int imageSize, long data) {
        EXTDirectStateAccess.nglCompressedMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, imageSize, data);
    }

    public static void glCompressedMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, ByteBuffer data) {
        EXTDirectStateAccess.nglCompressedMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglGetCompressedMultiTexImageEXT(int texunit, int target, int level, long img) {
        long __functionAddress = GL.getCapabilities().glGetCompressedMultiTexImageEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, img);
    }

    public static void glGetCompressedMultiTexImageEXT(int texunit, int target, int level, ByteBuffer img) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.checkBuffer((Buffer)img, EXTDirectStateAccess.glGetMultiTexLevelParameteriEXT(texunit, target, level, 34464));
        }
        EXTDirectStateAccess.nglGetCompressedMultiTexImageEXT(texunit, target, level, MemoryUtil.memAddress(img));
    }

    public static void glGetCompressedMultiTexImageEXT(int texunit, int target, int level, long img) {
        EXTDirectStateAccess.nglGetCompressedMultiTexImageEXT(texunit, target, level, img);
    }

    public static void nglMatrixLoadTransposefEXT(int matrixMode, long m) {
        long __functionAddress = GL.getCapabilities().glMatrixLoadTransposefEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixLoadTransposefEXT(int matrixMode, FloatBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 16);
        }
        EXTDirectStateAccess.nglMatrixLoadTransposefEXT(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void nglMatrixLoadTransposedEXT(int matrixMode, long m) {
        long __functionAddress = GL.getCapabilities().glMatrixLoadTransposedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixLoadTransposedEXT(int matrixMode, DoubleBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 16);
        }
        EXTDirectStateAccess.nglMatrixLoadTransposedEXT(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void nglMatrixMultTransposefEXT(int matrixMode, long m) {
        long __functionAddress = GL.getCapabilities().glMatrixMultTransposefEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixMultTransposefEXT(int matrixMode, FloatBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 16);
        }
        EXTDirectStateAccess.nglMatrixMultTransposefEXT(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void nglMatrixMultTransposedEXT(int matrixMode, long m) {
        long __functionAddress = GL.getCapabilities().glMatrixMultTransposedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixMultTransposedEXT(int matrixMode, DoubleBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 16);
        }
        EXTDirectStateAccess.nglMatrixMultTransposedEXT(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void nglNamedBufferDataEXT(int buffer, long size, long data, int usage) {
        long __functionAddress = GL.getCapabilities().glNamedBufferDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, buffer, size, data, usage);
    }

    public static void glNamedBufferDataEXT(int buffer, long size, int usage) {
        EXTDirectStateAccess.nglNamedBufferDataEXT(buffer, size, 0L, usage);
    }

    public static void glNamedBufferDataEXT(int buffer, ByteBuffer data, int usage) {
        EXTDirectStateAccess.nglNamedBufferDataEXT(buffer, data.remaining(), MemoryUtil.memAddress(data), usage);
    }

    public static void glNamedBufferDataEXT(int buffer, ShortBuffer data, int usage) {
        EXTDirectStateAccess.nglNamedBufferDataEXT(buffer, data.remaining() << 1, MemoryUtil.memAddress(data), usage);
    }

    public static void glNamedBufferDataEXT(int buffer, IntBuffer data, int usage) {
        EXTDirectStateAccess.nglNamedBufferDataEXT(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void glNamedBufferDataEXT(int buffer, FloatBuffer data, int usage) {
        EXTDirectStateAccess.nglNamedBufferDataEXT(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void glNamedBufferDataEXT(int buffer, DoubleBuffer data, int usage) {
        EXTDirectStateAccess.nglNamedBufferDataEXT(buffer, data.remaining() << 3, MemoryUtil.memAddress(data), usage);
    }

    public static void nglNamedBufferSubDataEXT(int buffer, long offset, long size, long data) {
        long __functionAddress = GL.getCapabilities().glNamedBufferSubDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, buffer, offset, size, data);
    }

    public static void glNamedBufferSubDataEXT(int buffer, long offset, ByteBuffer data) {
        EXTDirectStateAccess.nglNamedBufferSubDataEXT(buffer, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubDataEXT(int buffer, long offset, ShortBuffer data) {
        EXTDirectStateAccess.nglNamedBufferSubDataEXT(buffer, offset, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubDataEXT(int buffer, long offset, IntBuffer data) {
        EXTDirectStateAccess.nglNamedBufferSubDataEXT(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubDataEXT(int buffer, long offset, FloatBuffer data) {
        EXTDirectStateAccess.nglNamedBufferSubDataEXT(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubDataEXT(int buffer, long offset, DoubleBuffer data) {
        EXTDirectStateAccess.nglNamedBufferSubDataEXT(buffer, offset, data.remaining() << 3, MemoryUtil.memAddress(data));
    }

    public static long nglMapNamedBufferEXT(int buffer, int access) {
        long __functionAddress = GL.getCapabilities().glMapNamedBufferEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callP(__functionAddress, buffer, access);
    }

    public static ByteBuffer glMapNamedBufferEXT(int buffer, int access) {
        long __result = EXTDirectStateAccess.nglMapNamedBufferEXT(buffer, access);
        return MemoryUtil.memByteBuffer(__result, EXTDirectStateAccess.glGetNamedBufferParameteriEXT(buffer, 34660));
    }

    public static ByteBuffer glMapNamedBufferEXT(int buffer, int access, ByteBuffer old_buffer) {
        long __result = EXTDirectStateAccess.nglMapNamedBufferEXT(buffer, access);
        int length = EXTDirectStateAccess.glGetNamedBufferParameteriEXT(buffer, 34660);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, length) : MemoryUtil.memSetupBuffer(old_buffer, __result, length);
    }

    public static ByteBuffer glMapNamedBufferEXT(int buffer, int access, long length, ByteBuffer old_buffer) {
        long __result = EXTDirectStateAccess.nglMapNamedBufferEXT(buffer, access);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, (int)length) : MemoryUtil.memSetupBuffer(old_buffer, __result, (int)length);
    }

    public static boolean glUnmapNamedBufferEXT(int buffer) {
        long __functionAddress = GL.getCapabilities().glUnmapNamedBufferEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callZ(__functionAddress, buffer);
    }

    public static void nglGetNamedBufferParameterivEXT(int buffer, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetNamedBufferParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, buffer, pname, params);
    }

    public static void glGetNamedBufferParameterivEXT(int buffer, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetNamedBufferParameterivEXT(buffer, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetNamedBufferParameteriEXT(int buffer, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDirectStateAccess.nglGetNamedBufferParameterivEXT(buffer, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetNamedBufferSubDataEXT(int buffer, long offset, long size, long data) {
        long __functionAddress = GL.getCapabilities().glGetNamedBufferSubDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, buffer, offset, size, data);
    }

    public static void glGetNamedBufferSubDataEXT(int buffer, long offset, ByteBuffer data) {
        EXTDirectStateAccess.nglGetNamedBufferSubDataEXT(buffer, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubDataEXT(int buffer, long offset, ShortBuffer data) {
        EXTDirectStateAccess.nglGetNamedBufferSubDataEXT(buffer, offset, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubDataEXT(int buffer, long offset, IntBuffer data) {
        EXTDirectStateAccess.nglGetNamedBufferSubDataEXT(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubDataEXT(int buffer, long offset, FloatBuffer data) {
        EXTDirectStateAccess.nglGetNamedBufferSubDataEXT(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubDataEXT(int buffer, long offset, DoubleBuffer data) {
        EXTDirectStateAccess.nglGetNamedBufferSubDataEXT(buffer, offset, data.remaining() << 3, MemoryUtil.memAddress(data));
    }

    public static void glProgramUniform1fEXT(int program, int location, float v0) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1fEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0);
    }

    public static void glProgramUniform2fEXT(int program, int location, float v0, float v1) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2fEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1);
    }

    public static void glProgramUniform3fEXT(int program, int location, float v0, float v1, float v2) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3fEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1, v2);
    }

    public static void glProgramUniform4fEXT(int program, int location, float v0, float v1, float v2, float v3) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4fEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1, v2, v3);
    }

    public static void glProgramUniform1iEXT(int program, int location, int v0) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1iEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0);
    }

    public static void glProgramUniform2iEXT(int program, int location, int v0, int v1) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2iEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1);
    }

    public static void glProgramUniform3iEXT(int program, int location, int v0, int v1, int v2) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3iEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1, v2);
    }

    public static void glProgramUniform4iEXT(int program, int location, int v0, int v1, int v2, int v3) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4iEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1, v2, v3);
    }

    public static void nglProgramUniform1fvEXT(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform1fvEXT(int program, int location, FloatBuffer value) {
        EXTDirectStateAccess.nglProgramUniform1fvEXT(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform2fvEXT(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform2fvEXT(int program, int location, FloatBuffer value) {
        EXTDirectStateAccess.nglProgramUniform2fvEXT(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform3fvEXT(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform3fvEXT(int program, int location, FloatBuffer value) {
        EXTDirectStateAccess.nglProgramUniform3fvEXT(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform4fvEXT(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform4fvEXT(int program, int location, FloatBuffer value) {
        EXTDirectStateAccess.nglProgramUniform4fvEXT(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform1ivEXT(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform1ivEXT(int program, int location, IntBuffer value) {
        EXTDirectStateAccess.nglProgramUniform1ivEXT(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform2ivEXT(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform2ivEXT(int program, int location, IntBuffer value) {
        EXTDirectStateAccess.nglProgramUniform2ivEXT(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform3ivEXT(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform3ivEXT(int program, int location, IntBuffer value) {
        EXTDirectStateAccess.nglProgramUniform3ivEXT(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform4ivEXT(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform4ivEXT(int program, int location, IntBuffer value) {
        EXTDirectStateAccess.nglProgramUniform4ivEXT(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTDirectStateAccess.nglProgramUniformMatrix2fvEXT(program, location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTDirectStateAccess.nglProgramUniformMatrix3fvEXT(program, location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTDirectStateAccess.nglProgramUniformMatrix4fvEXT(program, location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2x3fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2x3fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2x3fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTDirectStateAccess.nglProgramUniformMatrix2x3fvEXT(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3x2fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3x2fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3x2fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTDirectStateAccess.nglProgramUniformMatrix3x2fvEXT(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2x4fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2x4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2x4fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTDirectStateAccess.nglProgramUniformMatrix2x4fvEXT(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4x2fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4x2fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4x2fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTDirectStateAccess.nglProgramUniformMatrix4x2fvEXT(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3x4fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3x4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3x4fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTDirectStateAccess.nglProgramUniformMatrix3x4fvEXT(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4x3fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4x3fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4x3fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTDirectStateAccess.nglProgramUniformMatrix4x3fvEXT(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void glTextureBufferEXT(int texture, int target, int internalformat, int buffer) {
        long __functionAddress = GL.getCapabilities().glTextureBufferEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texture, target, internalformat, buffer);
    }

    public static void glMultiTexBufferEXT(int texunit, int target, int internalformat, int buffer) {
        long __functionAddress = GL.getCapabilities().glMultiTexBufferEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texunit, target, internalformat, buffer);
    }

    public static void nglTextureParameterIivEXT(int texture, int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glTextureParameterIivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, pname, params);
    }

    public static void glTextureParameterIivEXT(int texture, int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDirectStateAccess.nglTextureParameterIivEXT(texture, target, pname, MemoryUtil.memAddress(params));
    }

    public static void nglTextureParameterIuivEXT(int texture, int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glTextureParameterIuivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, pname, params);
    }

    public static void glTextureParameterIuivEXT(int texture, int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDirectStateAccess.nglTextureParameterIuivEXT(texture, target, pname, MemoryUtil.memAddress(params));
    }

    public static void nglGetTextureParameterIivEXT(int texture, int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetTextureParameterIivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, pname, params);
    }

    public static void glGetTextureParameterIivEXT(int texture, int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetTextureParameterIivEXT(texture, target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTextureParameterIiEXT(int texture, int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDirectStateAccess.nglGetTextureParameterIivEXT(texture, target, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetTextureParameterIuivEXT(int texture, int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetTextureParameterIuivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, pname, params);
    }

    public static void glGetTextureParameterIuivEXT(int texture, int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetTextureParameterIuivEXT(texture, target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTextureParameterIuiEXT(int texture, int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDirectStateAccess.nglGetTextureParameterIuivEXT(texture, target, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglMultiTexParameterIivEXT(int texunit, int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glMultiTexParameterIivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glMultiTexParameterIivEXT(int texunit, int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDirectStateAccess.nglMultiTexParameterIivEXT(texunit, target, pname, MemoryUtil.memAddress(params));
    }

    public static void nglMultiTexParameterIuivEXT(int texunit, int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glMultiTexParameterIuivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glMultiTexParameterIuivEXT(int texunit, int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDirectStateAccess.nglMultiTexParameterIuivEXT(texunit, target, pname, MemoryUtil.memAddress(params));
    }

    public static void nglGetMultiTexParameterIivEXT(int texunit, int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexParameterIivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glGetMultiTexParameterIivEXT(int texunit, int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetMultiTexParameterIivEXT(texunit, target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetMultiTexParameterIiEXT(int texunit, int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDirectStateAccess.nglGetMultiTexParameterIivEXT(texunit, target, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetMultiTexParameterIuivEXT(int texunit, int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexParameterIuivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glGetMultiTexParameterIuivEXT(int texunit, int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetMultiTexParameterIuivEXT(texunit, target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetMultiTexParameterIuiEXT(int texunit, int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDirectStateAccess.nglGetMultiTexParameterIuivEXT(texunit, target, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glProgramUniform1uiEXT(int program, int location, int v0) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1uiEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0);
    }

    public static void glProgramUniform2uiEXT(int program, int location, int v0, int v1) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2uiEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1);
    }

    public static void glProgramUniform3uiEXT(int program, int location, int v0, int v1, int v2) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3uiEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1, v2);
    }

    public static void glProgramUniform4uiEXT(int program, int location, int v0, int v1, int v2, int v3) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4uiEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1, v2, v3);
    }

    public static void nglProgramUniform1uivEXT(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform1uivEXT(int program, int location, IntBuffer value) {
        EXTDirectStateAccess.nglProgramUniform1uivEXT(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform2uivEXT(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform2uivEXT(int program, int location, IntBuffer value) {
        EXTDirectStateAccess.nglProgramUniform2uivEXT(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform3uivEXT(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform3uivEXT(int program, int location, IntBuffer value) {
        EXTDirectStateAccess.nglProgramUniform3uivEXT(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform4uivEXT(int program, int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform4uivEXT(int program, int location, IntBuffer value) {
        EXTDirectStateAccess.nglProgramUniform4uivEXT(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglNamedProgramLocalParameters4fvEXT(int program, int target, int index, int count, long params) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParameters4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, target, index, count, params);
    }

    public static void glNamedProgramLocalParameters4fvEXT(int program, int target, int index, FloatBuffer params) {
        EXTDirectStateAccess.nglNamedProgramLocalParameters4fvEXT(program, target, index, params.remaining() >> 2, MemoryUtil.memAddress(params));
    }

    public static void glNamedProgramLocalParameterI4iEXT(int program, int target, int index, int x, int y, int z, int w) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParameterI4iEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, target, index, x, y, z, w);
    }

    public static void nglNamedProgramLocalParameterI4ivEXT(int program, int target, int index, long params) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParameterI4ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, target, index, params);
    }

    public static void glNamedProgramLocalParameterI4ivEXT(int program, int target, int index, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDirectStateAccess.nglNamedProgramLocalParameterI4ivEXT(program, target, index, MemoryUtil.memAddress(params));
    }

    public static void nglNamedProgramLocalParametersI4ivEXT(int program, int target, int index, int count, long params) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParametersI4ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, target, index, count, params);
    }

    public static void glNamedProgramLocalParametersI4ivEXT(int program, int target, int index, IntBuffer params) {
        EXTDirectStateAccess.nglNamedProgramLocalParametersI4ivEXT(program, target, index, params.remaining() >> 2, MemoryUtil.memAddress(params));
    }

    public static void glNamedProgramLocalParameterI4uiEXT(int program, int target, int index, int x, int y, int z, int w) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParameterI4uiEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, target, index, x, y, z, w);
    }

    public static void nglNamedProgramLocalParameterI4uivEXT(int program, int target, int index, long params) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParameterI4uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, target, index, params);
    }

    public static void glNamedProgramLocalParameterI4uivEXT(int program, int target, int index, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDirectStateAccess.nglNamedProgramLocalParameterI4uivEXT(program, target, index, MemoryUtil.memAddress(params));
    }

    public static void nglNamedProgramLocalParametersI4uivEXT(int program, int target, int index, int count, long params) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParametersI4uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, target, index, count, params);
    }

    public static void glNamedProgramLocalParametersI4uivEXT(int program, int target, int index, IntBuffer params) {
        EXTDirectStateAccess.nglNamedProgramLocalParametersI4uivEXT(program, target, index, params.remaining() >> 2, MemoryUtil.memAddress(params));
    }

    public static void nglGetNamedProgramLocalParameterIivEXT(int program, int target, int index, long params) {
        long __functionAddress = GL.getCapabilities().glGetNamedProgramLocalParameterIivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, target, index, params);
    }

    public static void glGetNamedProgramLocalParameterIivEXT(int program, int target, int index, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDirectStateAccess.nglGetNamedProgramLocalParameterIivEXT(program, target, index, MemoryUtil.memAddress(params));
    }

    public static void nglGetNamedProgramLocalParameterIuivEXT(int program, int target, int index, long params) {
        long __functionAddress = GL.getCapabilities().glGetNamedProgramLocalParameterIuivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, target, index, params);
    }

    public static void glGetNamedProgramLocalParameterIuivEXT(int program, int target, int index, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDirectStateAccess.nglGetNamedProgramLocalParameterIuivEXT(program, target, index, MemoryUtil.memAddress(params));
    }

    public static void glNamedRenderbufferStorageEXT(int renderbuffer, int internalformat, int width, int height) {
        long __functionAddress = GL.getCapabilities().glNamedRenderbufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, renderbuffer, internalformat, width, height);
    }

    public static void nglGetNamedRenderbufferParameterivEXT(int renderbuffer, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetNamedRenderbufferParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, renderbuffer, pname, params);
    }

    public static void glGetNamedRenderbufferParameterivEXT(int renderbuffer, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetNamedRenderbufferParameterivEXT(renderbuffer, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetNamedRenderbufferParameteriEXT(int renderbuffer, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDirectStateAccess.nglGetNamedRenderbufferParameterivEXT(renderbuffer, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glNamedRenderbufferStorageMultisampleEXT(int renderbuffer, int samples, int internalformat, int width, int height) {
        long __functionAddress = GL.getCapabilities().glNamedRenderbufferStorageMultisampleEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, renderbuffer, samples, internalformat, width, height);
    }

    public static void glNamedRenderbufferStorageMultisampleCoverageEXT(int renderbuffer, int coverageSamples, int colorSamples, int internalformat, int width, int height) {
        long __functionAddress = GL.getCapabilities().glNamedRenderbufferStorageMultisampleCoverageEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, renderbuffer, coverageSamples, colorSamples, internalformat, width, height);
    }

    public static int glCheckNamedFramebufferStatusEXT(int framebuffer, int target) {
        long __functionAddress = GL.getCapabilities().glCheckNamedFramebufferStatusEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callI(__functionAddress, framebuffer, target);
    }

    public static void glNamedFramebufferTexture1DEXT(int framebuffer, int attachment, int textarget, int texture, int level) {
        long __functionAddress = GL.getCapabilities().glNamedFramebufferTexture1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, framebuffer, attachment, textarget, texture, level);
    }

    public static void glNamedFramebufferTexture2DEXT(int framebuffer, int attachment, int textarget, int texture, int level) {
        long __functionAddress = GL.getCapabilities().glNamedFramebufferTexture2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, framebuffer, attachment, textarget, texture, level);
    }

    public static void glNamedFramebufferTexture3DEXT(int framebuffer, int attachment, int textarget, int texture, int level, int zoffset) {
        long __functionAddress = GL.getCapabilities().glNamedFramebufferTexture3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, framebuffer, attachment, textarget, texture, level, zoffset);
    }

    public static void glNamedFramebufferRenderbufferEXT(int framebuffer, int attachment, int renderbuffertarget, int renderbuffer) {
        long __functionAddress = GL.getCapabilities().glNamedFramebufferRenderbufferEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, framebuffer, attachment, renderbuffertarget, renderbuffer);
    }

    public static void nglGetNamedFramebufferAttachmentParameterivEXT(int framebuffer, int attachment, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetNamedFramebufferAttachmentParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, framebuffer, attachment, pname, params);
    }

    public static void glGetNamedFramebufferAttachmentParameterivEXT(int framebuffer, int attachment, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDirectStateAccess.nglGetNamedFramebufferAttachmentParameterivEXT(framebuffer, attachment, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetNamedFramebufferAttachmentParameteriEXT(int framebuffer, int attachment, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDirectStateAccess.nglGetNamedFramebufferAttachmentParameterivEXT(framebuffer, attachment, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGenerateTextureMipmapEXT(int texture, int target) {
        long __functionAddress = GL.getCapabilities().glGenerateTextureMipmapEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texture, target);
    }

    public static void glGenerateMultiTexMipmapEXT(int texunit, int target) {
        long __functionAddress = GL.getCapabilities().glGenerateMultiTexMipmapEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texunit, target);
    }

    public static void glFramebufferDrawBufferEXT(int framebuffer, int mode) {
        long __functionAddress = GL.getCapabilities().glFramebufferDrawBufferEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, framebuffer, mode);
    }

    public static void nglFramebufferDrawBuffersEXT(int framebuffer, int n, long bufs) {
        long __functionAddress = GL.getCapabilities().glFramebufferDrawBuffersEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, framebuffer, n, bufs);
    }

    public static void glFramebufferDrawBuffersEXT(int framebuffer, IntBuffer bufs) {
        EXTDirectStateAccess.nglFramebufferDrawBuffersEXT(framebuffer, bufs.remaining(), MemoryUtil.memAddress(bufs));
    }

    public static void glFramebufferReadBufferEXT(int framebuffer, int mode) {
        long __functionAddress = GL.getCapabilities().glFramebufferReadBufferEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, framebuffer, mode);
    }

    public static void nglGetFramebufferParameterivEXT(int framebuffer, int pname, long param) {
        long __functionAddress = GL.getCapabilities().glGetFramebufferParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, framebuffer, pname, param);
    }

    public static void glGetFramebufferParameterivEXT(int framebuffer, int pname, IntBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        EXTDirectStateAccess.nglGetFramebufferParameterivEXT(framebuffer, pname, MemoryUtil.memAddress(param));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetFramebufferParameteriEXT(int framebuffer, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer param = stack.callocInt(1);
            EXTDirectStateAccess.nglGetFramebufferParameterivEXT(framebuffer, pname, MemoryUtil.memAddress(param));
            int n = param.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glNamedCopyBufferSubDataEXT(int readBuffer, int writeBuffer, long readOffset, long writeOffset, long size) {
        long __functionAddress = GL.getCapabilities().glNamedCopyBufferSubDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, readBuffer, writeBuffer, readOffset, writeOffset, size);
    }

    public static void glNamedFramebufferTextureEXT(int framebuffer, int attachment, int texture, int level) {
        long __functionAddress = GL.getCapabilities().glNamedFramebufferTextureEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, framebuffer, attachment, texture, level);
    }

    public static void glNamedFramebufferTextureLayerEXT(int framebuffer, int attachment, int texture, int level, int layer) {
        long __functionAddress = GL.getCapabilities().glNamedFramebufferTextureLayerEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, framebuffer, attachment, texture, level, layer);
    }

    public static void glNamedFramebufferTextureFaceEXT(int framebuffer, int attachment, int texture, int level, int face) {
        long __functionAddress = GL.getCapabilities().glNamedFramebufferTextureFaceEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, framebuffer, attachment, texture, level, face);
    }

    public static void glTextureRenderbufferEXT(int texture, int target, int renderbuffer) {
        long __functionAddress = GL.getCapabilities().glTextureRenderbufferEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texture, target, renderbuffer);
    }

    public static void glMultiTexRenderbufferEXT(int texunit, int target, int renderbuffer) {
        long __functionAddress = GL.getCapabilities().glMultiTexRenderbufferEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, texunit, target, renderbuffer);
    }

    public static void glVertexArrayVertexOffsetEXT(int vaobj, int buffer, int size, int type, int stride, long offset) {
        long __functionAddress = GL.getCapabilities().glVertexArrayVertexOffsetEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, vaobj, buffer, size, type, stride, offset);
    }

    public static void glVertexArrayColorOffsetEXT(int vaobj, int buffer, int size, int type, int stride, long offset) {
        long __functionAddress = GL.getCapabilities().glVertexArrayColorOffsetEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, vaobj, buffer, size, type, stride, offset);
    }

    public static void glVertexArrayEdgeFlagOffsetEXT(int vaobj, int buffer, int stride, long offset) {
        long __functionAddress = GL.getCapabilities().glVertexArrayEdgeFlagOffsetEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, vaobj, buffer, stride, offset);
    }

    public static void glVertexArrayIndexOffsetEXT(int vaobj, int buffer, int type, int stride, long offset) {
        long __functionAddress = GL.getCapabilities().glVertexArrayIndexOffsetEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, vaobj, buffer, type, stride, offset);
    }

    public static void glVertexArrayNormalOffsetEXT(int vaobj, int buffer, int type, int stride, long offset) {
        long __functionAddress = GL.getCapabilities().glVertexArrayNormalOffsetEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, vaobj, buffer, type, stride, offset);
    }

    public static void glVertexArrayTexCoordOffsetEXT(int vaobj, int buffer, int size, int type, int stride, long offset) {
        long __functionAddress = GL.getCapabilities().glVertexArrayTexCoordOffsetEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, vaobj, buffer, size, type, stride, offset);
    }

    public static void glVertexArrayMultiTexCoordOffsetEXT(int vaobj, int buffer, int texunit, int size, int type, int stride, long offset) {
        long __functionAddress = GL.getCapabilities().glVertexArrayMultiTexCoordOffsetEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, vaobj, buffer, texunit, size, type, stride, offset);
    }

    public static void glVertexArrayFogCoordOffsetEXT(int vaobj, int buffer, int type, int stride, long offset) {
        long __functionAddress = GL.getCapabilities().glVertexArrayFogCoordOffsetEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, vaobj, buffer, type, stride, offset);
    }

    public static void glVertexArraySecondaryColorOffsetEXT(int vaobj, int buffer, int size, int type, int stride, long offset) {
        long __functionAddress = GL.getCapabilities().glVertexArraySecondaryColorOffsetEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, vaobj, buffer, size, type, stride, offset);
    }

    public static void glVertexArrayVertexAttribOffsetEXT(int vaobj, int buffer, int index, int size, int type, boolean normalized, int stride, long offset) {
        long __functionAddress = GL.getCapabilities().glVertexArrayVertexAttribOffsetEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, vaobj, buffer, index, size, type, normalized, stride, offset);
    }

    public static void glVertexArrayVertexAttribIOffsetEXT(int vaobj, int buffer, int index, int size, int type, int stride, long offset) {
        long __functionAddress = GL.getCapabilities().glVertexArrayVertexAttribIOffsetEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, vaobj, buffer, index, size, type, stride, offset);
    }

    public static void glEnableVertexArrayEXT(int vaobj, int array) {
        long __functionAddress = GL.getCapabilities().glEnableVertexArrayEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, vaobj, array);
    }

    public static void glDisableVertexArrayEXT(int vaobj, int array) {
        long __functionAddress = GL.getCapabilities().glDisableVertexArrayEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, vaobj, array);
    }

    public static void glEnableVertexArrayAttribEXT(int vaobj, int index) {
        long __functionAddress = GL.getCapabilities().glEnableVertexArrayAttribEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, vaobj, index);
    }

    public static void glDisableVertexArrayAttribEXT(int vaobj, int index) {
        long __functionAddress = GL.getCapabilities().glDisableVertexArrayAttribEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, vaobj, index);
    }

    public static void nglGetVertexArrayIntegervEXT(int vaobj, int pname, long param) {
        long __functionAddress = GL.getCapabilities().glGetVertexArrayIntegervEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, vaobj, pname, param);
    }

    public static void glGetVertexArrayIntegervEXT(int vaobj, int pname, IntBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        EXTDirectStateAccess.nglGetVertexArrayIntegervEXT(vaobj, pname, MemoryUtil.memAddress(param));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetVertexArrayIntegerEXT(int vaobj, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer param = stack.callocInt(1);
            EXTDirectStateAccess.nglGetVertexArrayIntegervEXT(vaobj, pname, MemoryUtil.memAddress(param));
            int n = param.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetVertexArrayPointervEXT(int vaobj, int pname, long param) {
        long __functionAddress = GL.getCapabilities().glGetVertexArrayPointervEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, vaobj, pname, param);
    }

    public static void glGetVertexArrayPointervEXT(int vaobj, int pname, PointerBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(param, 1);
        }
        EXTDirectStateAccess.nglGetVertexArrayPointervEXT(vaobj, pname, MemoryUtil.memAddress(param));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetVertexArrayPointerEXT(int vaobj, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer param = stack.callocPointer(1);
            EXTDirectStateAccess.nglGetVertexArrayPointervEXT(vaobj, pname, MemoryUtil.memAddress(param));
            long l = param.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetVertexArrayIntegeri_vEXT(int vaobj, int index, int pname, long param) {
        long __functionAddress = GL.getCapabilities().glGetVertexArrayIntegeri_vEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, vaobj, index, pname, param);
    }

    public static void glGetVertexArrayIntegeri_vEXT(int vaobj, int index, int pname, IntBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        EXTDirectStateAccess.nglGetVertexArrayIntegeri_vEXT(vaobj, index, pname, MemoryUtil.memAddress(param));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetVertexArrayIntegeriEXT(int vaobj, int index, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer param = stack.callocInt(1);
            EXTDirectStateAccess.nglGetVertexArrayIntegeri_vEXT(vaobj, index, pname, MemoryUtil.memAddress(param));
            int n = param.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetVertexArrayPointeri_vEXT(int vaobj, int index, int pname, long param) {
        long __functionAddress = GL.getCapabilities().glGetVertexArrayPointeri_vEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, vaobj, index, pname, param);
    }

    public static void glGetVertexArrayPointeri_vEXT(int vaobj, int index, int pname, PointerBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(param, 1);
        }
        EXTDirectStateAccess.nglGetVertexArrayPointeri_vEXT(vaobj, index, pname, MemoryUtil.memAddress(param));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetVertexArrayPointeriEXT(int vaobj, int index, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer param = stack.callocPointer(1);
            EXTDirectStateAccess.nglGetVertexArrayPointeri_vEXT(vaobj, index, pname, MemoryUtil.memAddress(param));
            long l = param.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nglMapNamedBufferRangeEXT(int buffer, long offset, long length, int access) {
        long __functionAddress = GL.getCapabilities().glMapNamedBufferRangeEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPPP(__functionAddress, buffer, offset, length, access);
    }

    public static ByteBuffer glMapNamedBufferRangeEXT(int buffer, long offset, long length, int access) {
        long __result = EXTDirectStateAccess.nglMapNamedBufferRangeEXT(buffer, offset, length, access);
        return MemoryUtil.memByteBuffer(__result, (int)length);
    }

    public static ByteBuffer glMapNamedBufferRangeEXT(int buffer, long offset, long length, int access, ByteBuffer old_buffer) {
        long __result = EXTDirectStateAccess.nglMapNamedBufferRangeEXT(buffer, offset, length, access);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, (int)length) : MemoryUtil.memSetupBuffer(old_buffer, __result, (int)length);
    }

    public static void glFlushMappedNamedBufferRangeEXT(int buffer, long offset, long length) {
        long __functionAddress = GL.getCapabilities().glFlushMappedNamedBufferRangeEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, buffer, offset, length);
    }

    public static void glMatrixLoadfEXT(int matrixMode, float[] m) {
        long __functionAddress = GL.getCapabilities().glMatrixLoadfEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(m, 16);
        }
        JNI.callPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixLoaddEXT(int matrixMode, double[] m) {
        long __functionAddress = GL.getCapabilities().glMatrixLoaddEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(m, 16);
        }
        JNI.callPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixMultfEXT(int matrixMode, float[] m) {
        long __functionAddress = GL.getCapabilities().glMatrixMultfEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(m, 16);
        }
        JNI.callPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixMultdEXT(int matrixMode, double[] m) {
        long __functionAddress = GL.getCapabilities().glMatrixMultdEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(m, 16);
        }
        JNI.callPV(__functionAddress, matrixMode, m);
    }

    public static void glTextureParameterivEXT(int texture, int target, int pname, int[] param) {
        long __functionAddress = GL.getCapabilities().glTextureParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(param, 4);
        }
        JNI.callPV(__functionAddress, texture, target, pname, param);
    }

    public static void glTextureParameterfvEXT(int texture, int target, int pname, float[] param) {
        long __functionAddress = GL.getCapabilities().glTextureParameterfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(param, 4);
        }
        JNI.callPV(__functionAddress, texture, target, pname, param);
    }

    public static void glTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, border, format, type, pixels);
    }

    public static void glTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, border, format, type, pixels);
    }

    public static void glTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, border, format, type, pixels);
    }

    public static void glTextureImage1DEXT(int texture, int target, int level, int internalformat, int width, int border, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, border, format, type, pixels);
    }

    public static void glTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glTextureImage2DEXT(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureSubImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, width, format, type, pixels);
    }

    public static void glTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureSubImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, width, format, type, pixels);
    }

    public static void glTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureSubImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, width, format, type, pixels);
    }

    public static void glTextureSubImage1DEXT(int texture, int target, int level, int xoffset, int width, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureSubImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, width, format, type, pixels);
    }

    public static void glTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureSubImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureSubImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureSubImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glTextureSubImage2DEXT(int texture, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureSubImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glGetTextureImageEXT(int texture, int target, int level, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glGetTextureImageEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, format, type, pixels);
    }

    public static void glGetTextureImageEXT(int texture, int target, int level, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glGetTextureImageEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, format, type, pixels);
    }

    public static void glGetTextureImageEXT(int texture, int target, int level, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glGetTextureImageEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, format, type, pixels);
    }

    public static void glGetTextureImageEXT(int texture, int target, int level, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glGetTextureImageEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, format, type, pixels);
    }

    public static void glGetTextureParameterfvEXT(int texture, int target, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetTextureParameterfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texture, target, pname, params);
    }

    public static void glGetTextureParameterivEXT(int texture, int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetTextureParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texture, target, pname, params);
    }

    public static void glGetTextureLevelParameterfvEXT(int texture, int target, int level, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetTextureLevelParameterfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texture, target, level, pname, params);
    }

    public static void glGetTextureLevelParameterivEXT(int texture, int target, int level, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetTextureLevelParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texture, target, level, pname, params);
    }

    public static void glTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glTextureImage3DEXT(int texture, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureSubImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureSubImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureSubImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glTextureSubImage3DEXT(int texture, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glTextureSubImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glMultiTexCoordPointerEXT(int texunit, int size, int type, int stride, short[] pointer) {
        long __functionAddress = GL.getCapabilities().glMultiTexCoordPointerEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, size, type, stride, pointer);
    }

    public static void glMultiTexCoordPointerEXT(int texunit, int size, int type, int stride, int[] pointer) {
        long __functionAddress = GL.getCapabilities().glMultiTexCoordPointerEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, size, type, stride, pointer);
    }

    public static void glMultiTexCoordPointerEXT(int texunit, int size, int type, int stride, float[] pointer) {
        long __functionAddress = GL.getCapabilities().glMultiTexCoordPointerEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, size, type, stride, pointer);
    }

    public static void glMultiTexEnvfvEXT(int texunit, int target, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glMultiTexEnvfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glMultiTexEnvivEXT(int texunit, int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glMultiTexEnvivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glMultiTexGendvEXT(int texunit, int coord, int pname, double[] params) {
        long __functionAddress = GL.getCapabilities().glMultiTexGendvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, texunit, coord, pname, params);
    }

    public static void glMultiTexGenfvEXT(int texunit, int coord, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glMultiTexGenfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, texunit, coord, pname, params);
    }

    public static void glMultiTexGenivEXT(int texunit, int coord, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glMultiTexGenivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, texunit, coord, pname, params);
    }

    public static void glGetMultiTexEnvfvEXT(int texunit, int target, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexEnvfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glGetMultiTexEnvivEXT(int texunit, int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexEnvivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glGetMultiTexGendvEXT(int texunit, int coord, int pname, double[] params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexGendvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texunit, coord, pname, params);
    }

    public static void glGetMultiTexGenfvEXT(int texunit, int coord, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexGenfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texunit, coord, pname, params);
    }

    public static void glGetMultiTexGenivEXT(int texunit, int coord, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexGenivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texunit, coord, pname, params);
    }

    public static void glMultiTexParameterivEXT(int texunit, int target, int pname, int[] param) {
        long __functionAddress = GL.getCapabilities().glMultiTexParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(param, 4);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, param);
    }

    public static void glMultiTexParameterfvEXT(int texunit, int target, int pname, float[] param) {
        long __functionAddress = GL.getCapabilities().glMultiTexParameterfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(param, 4);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, param);
    }

    public static void glMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, border, format, type, pixels);
    }

    public static void glMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, border, format, type, pixels);
    }

    public static void glMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, border, format, type, pixels);
    }

    public static void glMultiTexImage1DEXT(int texunit, int target, int level, int internalformat, int width, int border, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, border, format, type, pixels);
    }

    public static void glMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glMultiTexImage2DEXT(int texunit, int target, int level, int internalformat, int width, int height, int border, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexSubImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, width, format, type, pixels);
    }

    public static void glMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexSubImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, width, format, type, pixels);
    }

    public static void glMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexSubImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, width, format, type, pixels);
    }

    public static void glMultiTexSubImage1DEXT(int texunit, int target, int level, int xoffset, int width, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexSubImage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, width, format, type, pixels);
    }

    public static void glMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexSubImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexSubImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexSubImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glMultiTexSubImage2DEXT(int texunit, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexSubImage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glGetMultiTexImageEXT(int texunit, int target, int level, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexImageEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, format, type, pixels);
    }

    public static void glGetMultiTexImageEXT(int texunit, int target, int level, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexImageEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, format, type, pixels);
    }

    public static void glGetMultiTexImageEXT(int texunit, int target, int level, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexImageEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, format, type, pixels);
    }

    public static void glGetMultiTexImageEXT(int texunit, int target, int level, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexImageEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, format, type, pixels);
    }

    public static void glGetMultiTexParameterfvEXT(int texunit, int target, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexParameterfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glGetMultiTexParameterivEXT(int texunit, int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glGetMultiTexLevelParameterfvEXT(int texunit, int target, int level, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexLevelParameterfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texunit, target, level, pname, params);
    }

    public static void glGetMultiTexLevelParameterivEXT(int texunit, int target, int level, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexLevelParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texunit, target, level, pname, params);
    }

    public static void glMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glMultiTexImage3DEXT(int texunit, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexSubImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexSubImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexSubImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glMultiTexSubImage3DEXT(int texunit, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, double[] pixels) {
        long __functionAddress = GL.getCapabilities().glMultiTexSubImage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glGetFloatIndexedvEXT(int target, int index, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetFloatIndexedvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, target, index, params);
    }

    public static void glGetDoubleIndexedvEXT(int target, int index, double[] params) {
        long __functionAddress = GL.getCapabilities().glGetDoubleIndexedvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, target, index, params);
    }

    public static void glGetFloati_vEXT(int pname, int index, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetFloati_vEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, pname, index, params);
    }

    public static void glGetDoublei_vEXT(int pname, int index, double[] params) {
        long __functionAddress = GL.getCapabilities().glGetDoublei_vEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, pname, index, params);
    }

    public static void glGetIntegerIndexedvEXT(int target, int index, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetIntegerIndexedvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, target, index, params);
    }

    public static void glNamedProgramLocalParameter4dvEXT(int program, int target, int index, double[] params) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParameter4dvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, program, target, index, params);
    }

    public static void glNamedProgramLocalParameter4fvEXT(int program, int target, int index, float[] params) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParameter4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, program, target, index, params);
    }

    public static void glGetNamedProgramLocalParameterdvEXT(int program, int target, int index, double[] params) {
        long __functionAddress = GL.getCapabilities().glGetNamedProgramLocalParameterdvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, program, target, index, params);
    }

    public static void glGetNamedProgramLocalParameterfvEXT(int program, int target, int index, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetNamedProgramLocalParameterfvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, program, target, index, params);
    }

    public static void glGetNamedProgramivEXT(int program, int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetNamedProgramivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, program, target, pname, params);
    }

    public static void glMatrixLoadTransposefEXT(int matrixMode, float[] m) {
        long __functionAddress = GL.getCapabilities().glMatrixLoadTransposefEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(m, 16);
        }
        JNI.callPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixLoadTransposedEXT(int matrixMode, double[] m) {
        long __functionAddress = GL.getCapabilities().glMatrixLoadTransposedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(m, 16);
        }
        JNI.callPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixMultTransposefEXT(int matrixMode, float[] m) {
        long __functionAddress = GL.getCapabilities().glMatrixMultTransposefEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(m, 16);
        }
        JNI.callPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixMultTransposedEXT(int matrixMode, double[] m) {
        long __functionAddress = GL.getCapabilities().glMatrixMultTransposedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(m, 16);
        }
        JNI.callPV(__functionAddress, matrixMode, m);
    }

    public static void glNamedBufferDataEXT(int buffer, short[] data, int usage) {
        long __functionAddress = GL.getCapabilities().glNamedBufferDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, buffer, (long)(data.length << 1), data, usage);
    }

    public static void glNamedBufferDataEXT(int buffer, int[] data, int usage) {
        long __functionAddress = GL.getCapabilities().glNamedBufferDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, buffer, (long)(data.length << 2), data, usage);
    }

    public static void glNamedBufferDataEXT(int buffer, float[] data, int usage) {
        long __functionAddress = GL.getCapabilities().glNamedBufferDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, buffer, (long)(data.length << 2), data, usage);
    }

    public static void glNamedBufferDataEXT(int buffer, double[] data, int usage) {
        long __functionAddress = GL.getCapabilities().glNamedBufferDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, buffer, (long)(data.length << 3), data, usage);
    }

    public static void glNamedBufferSubDataEXT(int buffer, long offset, short[] data) {
        long __functionAddress = GL.getCapabilities().glNamedBufferSubDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, buffer, offset, (long)(data.length << 1), data);
    }

    public static void glNamedBufferSubDataEXT(int buffer, long offset, int[] data) {
        long __functionAddress = GL.getCapabilities().glNamedBufferSubDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, buffer, offset, (long)(data.length << 2), data);
    }

    public static void glNamedBufferSubDataEXT(int buffer, long offset, float[] data) {
        long __functionAddress = GL.getCapabilities().glNamedBufferSubDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, buffer, offset, (long)(data.length << 2), data);
    }

    public static void glNamedBufferSubDataEXT(int buffer, long offset, double[] data) {
        long __functionAddress = GL.getCapabilities().glNamedBufferSubDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, buffer, offset, (long)(data.length << 3), data);
    }

    public static void glGetNamedBufferParameterivEXT(int buffer, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetNamedBufferParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, buffer, pname, params);
    }

    public static void glGetNamedBufferSubDataEXT(int buffer, long offset, short[] data) {
        long __functionAddress = GL.getCapabilities().glGetNamedBufferSubDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, buffer, offset, (long)(data.length << 1), data);
    }

    public static void glGetNamedBufferSubDataEXT(int buffer, long offset, int[] data) {
        long __functionAddress = GL.getCapabilities().glGetNamedBufferSubDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, buffer, offset, (long)(data.length << 2), data);
    }

    public static void glGetNamedBufferSubDataEXT(int buffer, long offset, float[] data) {
        long __functionAddress = GL.getCapabilities().glGetNamedBufferSubDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, buffer, offset, (long)(data.length << 2), data);
    }

    public static void glGetNamedBufferSubDataEXT(int buffer, long offset, double[] data) {
        long __functionAddress = GL.getCapabilities().glGetNamedBufferSubDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, buffer, offset, (long)(data.length << 3), data);
    }

    public static void glProgramUniform1fvEXT(int program, int location, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length, value);
    }

    public static void glProgramUniform2fvEXT(int program, int location, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 1, value);
    }

    public static void glProgramUniform3fvEXT(int program, int location, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 3, value);
    }

    public static void glProgramUniform4fvEXT(int program, int location, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, value);
    }

    public static void glProgramUniform1ivEXT(int program, int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length, value);
    }

    public static void glProgramUniform2ivEXT(int program, int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 1, value);
    }

    public static void glProgramUniform3ivEXT(int program, int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 3, value);
    }

    public static void glProgramUniform4ivEXT(int program, int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, value);
    }

    public static void glProgramUniformMatrix2fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, transpose, value);
    }

    public static void glProgramUniformMatrix3fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 9, transpose, value);
    }

    public static void glProgramUniformMatrix4fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 4, transpose, value);
    }

    public static void glProgramUniformMatrix2x3fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2x3fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 6, transpose, value);
    }

    public static void glProgramUniformMatrix3x2fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3x2fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 6, transpose, value);
    }

    public static void glProgramUniformMatrix2x4fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix2x4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 3, transpose, value);
    }

    public static void glProgramUniformMatrix4x2fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4x2fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 3, transpose, value);
    }

    public static void glProgramUniformMatrix3x4fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix3x4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 12, transpose, value);
    }

    public static void glProgramUniformMatrix4x3fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniformMatrix4x3fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 12, transpose, value);
    }

    public static void glTextureParameterIivEXT(int texture, int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glTextureParameterIivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, texture, target, pname, params);
    }

    public static void glTextureParameterIuivEXT(int texture, int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glTextureParameterIuivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, texture, target, pname, params);
    }

    public static void glGetTextureParameterIivEXT(int texture, int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetTextureParameterIivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texture, target, pname, params);
    }

    public static void glGetTextureParameterIuivEXT(int texture, int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetTextureParameterIuivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texture, target, pname, params);
    }

    public static void glMultiTexParameterIivEXT(int texunit, int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glMultiTexParameterIivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glMultiTexParameterIuivEXT(int texunit, int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glMultiTexParameterIuivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glGetMultiTexParameterIivEXT(int texunit, int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexParameterIivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glGetMultiTexParameterIuivEXT(int texunit, int target, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetMultiTexParameterIuivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, texunit, target, pname, params);
    }

    public static void glProgramUniform1uivEXT(int program, int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform1uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length, value);
    }

    public static void glProgramUniform2uivEXT(int program, int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform2uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 1, value);
    }

    public static void glProgramUniform3uivEXT(int program, int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform3uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 3, value);
    }

    public static void glProgramUniform4uivEXT(int program, int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glProgramUniform4uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, value);
    }

    public static void glNamedProgramLocalParameters4fvEXT(int program, int target, int index, float[] params) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParameters4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, target, index, params.length >> 2, params);
    }

    public static void glNamedProgramLocalParameterI4ivEXT(int program, int target, int index, int[] params) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParameterI4ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, program, target, index, params);
    }

    public static void glNamedProgramLocalParametersI4ivEXT(int program, int target, int index, int[] params) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParametersI4ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, target, index, params.length >> 2, params);
    }

    public static void glNamedProgramLocalParameterI4uivEXT(int program, int target, int index, int[] params) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParameterI4uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, program, target, index, params);
    }

    public static void glNamedProgramLocalParametersI4uivEXT(int program, int target, int index, int[] params) {
        long __functionAddress = GL.getCapabilities().glNamedProgramLocalParametersI4uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, target, index, params.length >> 2, params);
    }

    public static void glGetNamedProgramLocalParameterIivEXT(int program, int target, int index, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetNamedProgramLocalParameterIivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, program, target, index, params);
    }

    public static void glGetNamedProgramLocalParameterIuivEXT(int program, int target, int index, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetNamedProgramLocalParameterIuivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, program, target, index, params);
    }

    public static void glGetNamedRenderbufferParameterivEXT(int renderbuffer, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetNamedRenderbufferParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, renderbuffer, pname, params);
    }

    public static void glGetNamedFramebufferAttachmentParameterivEXT(int framebuffer, int attachment, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetNamedFramebufferAttachmentParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, framebuffer, attachment, pname, params);
    }

    public static void glFramebufferDrawBuffersEXT(int framebuffer, int[] bufs) {
        long __functionAddress = GL.getCapabilities().glFramebufferDrawBuffersEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, framebuffer, bufs.length, bufs);
    }

    public static void glGetFramebufferParameterivEXT(int framebuffer, int pname, int[] param) {
        long __functionAddress = GL.getCapabilities().glGetFramebufferParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(param, 1);
        }
        JNI.callPV(__functionAddress, framebuffer, pname, param);
    }

    public static void glGetVertexArrayIntegervEXT(int vaobj, int pname, int[] param) {
        long __functionAddress = GL.getCapabilities().glGetVertexArrayIntegervEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(param, 1);
        }
        JNI.callPV(__functionAddress, vaobj, pname, param);
    }

    public static void glGetVertexArrayIntegeri_vEXT(int vaobj, int index, int pname, int[] param) {
        long __functionAddress = GL.getCapabilities().glGetVertexArrayIntegeri_vEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(param, 1);
        }
        JNI.callPV(__functionAddress, vaobj, index, pname, param);
    }
}

