/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLX;
import org.lwjgl.opengl.GLXCapabilities;
import org.lwjgl.opengl.WGL;
import org.lwjgl.opengl.WGLCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.ThreadLocalUtil;
import org.lwjgl.system.linux.X11;
import org.lwjgl.system.macosx.MacOSXLibrary;
import org.lwjgl.system.windows.GDI32;
import org.lwjgl.system.windows.PIXELFORMATDESCRIPTOR;
import org.lwjgl.system.windows.User32;
import org.lwjgl.system.windows.WNDCLASSEX;
import org.lwjgl.system.windows.WindowsLibrary;
import org.lwjgl.system.windows.WindowsUtil;

public final class GL {
    private static final APIUtil.APIVersion MAX_VERSION = APIUtil.apiParseVersion(Configuration.OPENGL_MAXVERSION);
    private static FunctionProvider functionProvider;
    private static final CapabilitiesState capabilitiesState;
    private static WGLCapabilities capabilitiesWGL;
    private static GLXCapabilities capabilitiesGLXClient;
    private static GLXCapabilities capabilitiesGLX;

    private GL() {
    }

    public static void create() {
        SharedLibrary GL2;
        switch (Platform.get()) {
            case LINUX: {
                GL2 = Library.loadNative(Configuration.OPENGL_LIBRARY_NAME, "libGL.so.1", "libGL.so");
                break;
            }
            case MACOSX: {
                GL2 = Configuration.OPENGL_LIBRARY_NAME.get() != null ? Library.loadNative(Configuration.OPENGL_LIBRARY_NAME, new String[0]) : MacOSXLibrary.getWithIdentifier("com.apple.opengl");
                break;
            }
            case WINDOWS: {
                GL2 = Library.loadNative(Configuration.OPENGL_LIBRARY_NAME, "opengl32");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        GL.create(GL2);
    }

    public static void create(String libName) {
        GL.create(Library.loadNative(libName));
    }

    private static void create(SharedLibrary OPENGL) {
        try {
            SharedLibraryGL functionProvider;
            switch (Platform.get()) {
                case WINDOWS: {
                    functionProvider = new SharedLibraryGL(OPENGL){
                        private final long wglGetProcAddress;
                        {
                            this.wglGetProcAddress = this.library.getFunctionAddress("wglGetProcAddress");
                        }

                        @Override
                        long getExtensionAddress(long name) {
                            return JNI.callPP(this.wglGetProcAddress, name);
                        }
                    };
                    break;
                }
                case LINUX: {
                    functionProvider = new SharedLibraryGL(OPENGL){
                        private final long glXGetProcAddress;
                        {
                            long GetProcAddress = this.library.getFunctionAddress("glXGetProcAddress");
                            if (GetProcAddress == 0L) {
                                GetProcAddress = this.library.getFunctionAddress("glXGetProcAddressARB");
                            }
                            this.glXGetProcAddress = GetProcAddress;
                        }

                        @Override
                        long getExtensionAddress(long name) {
                            return this.glXGetProcAddress == 0L ? 0L : JNI.callPP(this.glXGetProcAddress, name);
                        }
                    };
                    break;
                }
                case MACOSX: {
                    functionProvider = new SharedLibraryGL(OPENGL){

                        @Override
                        long getExtensionAddress(long name) {
                            return 0L;
                        }
                    };
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            GL.create((FunctionProvider)functionProvider);
        }
        catch (RuntimeException e) {
            OPENGL.free();
            throw e;
        }
    }

    public static void create(FunctionProvider functionProvider) {
        if (GL.functionProvider != null) {
            throw new IllegalStateException("OpenGL has already been created.");
        }
        GL.functionProvider = functionProvider;
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        capabilitiesWGL = null;
        capabilitiesGLX = null;
        if (functionProvider instanceof NativeResource) {
            ((NativeResource)((Object)functionProvider)).free();
        }
        functionProvider = null;
    }

    public static FunctionProvider getFunctionProvider() {
        return functionProvider;
    }

    public static void setCapabilities(GLCapabilities caps) {
        capabilitiesState.set(caps);
    }

    public static GLCapabilities getCapabilities() {
        GLCapabilities caps = capabilitiesState.get();
        if (caps == null) {
            throw new IllegalStateException("No GLCapabilities instance set for the current thread. Possible solutions:\n\ta) Call GL.createCapabilities() after making a context current in the current thread.\n\tb) Call GL.setCapabilities() if a GLCapabilities instance already exists for the current context.");
        }
        return caps;
    }

    public static WGLCapabilities getCapabilitiesWGL() {
        if (capabilitiesWGL == null) {
            capabilitiesWGL = GL.createCapabilitiesWGLDummy();
        }
        return capabilitiesWGL;
    }

    static GLXCapabilities getCapabilitiesGLXClient() {
        if (capabilitiesGLXClient == null) {
            capabilitiesGLXClient = GL.initCapabilitiesGLX(true);
        }
        return capabilitiesGLXClient;
    }

    public static GLXCapabilities getCapabilitiesGLX() {
        if (capabilitiesGLX == null) {
            capabilitiesGLX = GL.initCapabilitiesGLX(false);
        }
        return capabilitiesGLX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GLXCapabilities initCapabilitiesGLX(boolean client) {
        long display = X11.nXOpenDisplay(0L);
        try {
            GLXCapabilities gLXCapabilities = GL.createCapabilitiesGLX(display, client ? -1 : X11.XDefaultScreen(display));
            return gLXCapabilities;
        }
        finally {
            X11.XCloseDisplay(display);
        }
    }

    public static GLCapabilities createCapabilities() {
        return GL.createCapabilities(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static GLCapabilities createCapabilities(boolean forwardCompatible) {
        caps = null;
        try {
            GetError = GL.functionProvider.getFunctionAddress("glGetError");
            GetString = GL.functionProvider.getFunctionAddress("glGetString");
            GetIntegerv = GL.functionProvider.getFunctionAddress("glGetIntegerv");
            if (GetError == 0L || GetString == 0L || GetIntegerv == 0L) {
                throw new IllegalStateException("Core OpenGL functions could not be found. Make sure that the OpenGL library has been loaded correctly.");
            }
            errorCode = JNI.callI(GetError);
            if (errorCode != 0) {
                APIUtil.apiLog(String.format("An OpenGL context was in an error state before the creation of its capabilities instance. Error: 0x%X", new Object[]{errorCode}));
            }
            stack = MemoryStack.stackPush();
            var12_7 = null;
            try {
                version = stack.ints(0);
                JNI.callPV(GetIntegerv, 33307, MemoryUtil.memAddress(version));
                if (JNI.callI(GetError) == 0 && 3 <= (majorVersion = version.get(0))) {
                    JNI.callPV(GetIntegerv, 33308, MemoryUtil.memAddress(version));
                    minorVersion = version.get(0);
                } else {
                    versionString = JNI.callP(GetString, 7938);
                    if (versionString == 0L || JNI.callI(GetError) != 0) {
                        throw new IllegalStateException("There is no OpenGL context current in the current thread.");
                    }
                    apiVersion = APIUtil.apiParseVersion(MemoryUtil.memUTF8(versionString));
                    majorVersion = apiVersion.major;
                    minorVersion = apiVersion.minor;
                }
            }
            catch (Throwable version) {
                var12_7 = version;
                throw version;
            }
            finally {
                if (stack != null) {
                    if (var12_7 != null) {
                        try {
                            stack.close();
                        }
                        catch (Throwable version) {
                            var12_7.addSuppressed(version);
                        }
                    } else {
                        stack.close();
                    }
                }
            }
            if (majorVersion < 1 || majorVersion == 1 && minorVersion < 1) {
                throw new IllegalStateException("OpenGL 1.1 is required.");
            }
            GL_VERSIONS = new int[]{5, 1, 3, 5};
            supportedExtensions = new HashSet<String>(512);
            maxMajor = Math.min(majorVersion, GL_VERSIONS.length);
            if (GL.MAX_VERSION != null) {
                maxMajor = Math.min(GL.MAX_VERSION.major, maxMajor);
            }
            for (M = 1; M <= maxMajor; ++M) {
                maxMinor = GL_VERSIONS[M - 1];
                if (M == majorVersion) {
                    maxMinor = Math.min(minorVersion, maxMinor);
                }
                if (GL.MAX_VERSION != null && M == GL.MAX_VERSION.major) {
                    maxMinor = Math.min(GL.MAX_VERSION.minor, maxMinor);
                }
                v0 = m = M == 1 ? 1 : 0;
                while (m <= maxMinor) {
                    supportedExtensions.add(String.format("OpenGL%d%d", new Object[]{M, m}));
                    ++m;
                }
            }
            if (majorVersion < 3) {
                extensionsString = MemoryUtil.memASCII(Checks.checkPointer(JNI.callP(GetString, 7939)));
                tokenizer = new StringTokenizer(extensionsString);
                while (tokenizer.hasMoreTokens()) {
                    supportedExtensions.add(tokenizer.nextToken());
                }
            } else {
                stack = MemoryStack.stackPush();
                var15_27 = null;
                try {
                    pi = stack.ints(0);
                    JNI.callPV(GetIntegerv, 33309, MemoryUtil.memAddress(pi));
                    extensionCount = pi.get(0);
                    GetStringi = APIUtil.apiGetFunctionAddress(GL.functionProvider, "glGetStringi");
                    for (i = 0; i < extensionCount; ++i) {
                        supportedExtensions.add(MemoryUtil.memASCII(JNI.callP(GetStringi, 7939, i)));
                    }
                    JNI.callPV(GetIntegerv, 33310, MemoryUtil.memAddress(pi));
                    if ((pi.get(0) & 1) != 0) {
                        forwardCompatible = true;
                    }
                    if (3 >= majorVersion && 1 > minorVersion) ** GOTO lbl107
                    if (3 < majorVersion || 2 <= minorVersion) {
                        JNI.callPV(GetIntegerv, 37158, MemoryUtil.memAddress(pi));
                        if ((pi.get(0) & 1) == 0) ** GOTO lbl107
                        forwardCompatible = true;
                    }
                    forwardCompatible = supportedExtensions.contains("GL_ARB_compatibility") == false;
                }
                catch (Throwable var16_20) {
                    var15_27 = var16_20;
                    throw var16_20;
                }
                finally {
                    if (stack != null) {
                        if (var15_27 != null) {
                            try {
                                stack.close();
                            }
                            catch (Throwable var16_19) {
                                var15_27.addSuppressed(var16_19);
                            }
                        } else {
                            stack.close();
                        }
                    }
                }
            }
lbl107:
            // 6 sources

            var14_16 = caps = new GLCapabilities(GL.getFunctionProvider(), supportedExtensions, forwardCompatible);
        }
        catch (Throwable var23_31) {
            GL.setCapabilities(caps);
            throw var23_31;
        }
        GL.setCapabilities(caps);
        return var14_16;
    }

    /*
     * Loose catch block
     */
    private static WGLCapabilities createCapabilitiesWGLDummy() {
        long hdc = WGL.wglGetCurrentDC();
        if (hdc != 0L) {
            return GL.createCapabilitiesWGL(hdc);
        }
        int classAtom = 0;
        long hwnd = 0L;
        long hglrc = 0L;
        try {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PIXELFORMATDESCRIPTOR pfd;
                WNDCLASSEX wc = WNDCLASSEX.callocStack(stack).cbSize(WNDCLASSEX.SIZEOF).style(3).hInstance(WindowsLibrary.HINSTANCE).lpszClassName(stack.UTF16("WGL"));
                WNDCLASSEX.nlpfnWndProc(wc.address(), User32.Functions.DefWindowProc);
                classAtom = User32.RegisterClassEx(wc);
                if (classAtom == 0) {
                    throw new IllegalStateException("Failed to register WGL window class");
                }
                hwnd = Checks.checkPointer(User32.nCreateWindowEx(0, classAtom & 0xFFFF, 0L, 114229248, 0, 0, 1, 1, 0L, 0L, 0L, 0L));
                hdc = Checks.checkPointer(User32.GetDC(hwnd));
                int pixelFormat = GDI32.ChoosePixelFormat(hdc, pfd = PIXELFORMATDESCRIPTOR.callocStack(stack).nSize((short)PIXELFORMATDESCRIPTOR.SIZEOF).nVersion((short)1).dwFlags(32));
                if (pixelFormat == 0) {
                    WindowsUtil.windowsThrowException("Failed to choose an OpenGL-compatible pixel format");
                }
                if (GDI32.DescribePixelFormat(hdc, pixelFormat, pfd) == 0) {
                    WindowsUtil.windowsThrowException("Failed to obtain pixel format information");
                }
                if (!GDI32.SetPixelFormat(hdc, pixelFormat, pfd)) {
                    WindowsUtil.windowsThrowException("Failed to set the pixel format");
                }
                hglrc = Checks.checkPointer(WGL.wglCreateContext(hdc));
                WGL.wglMakeCurrent(hdc, hglrc);
                WGLCapabilities wGLCapabilities = GL.createCapabilitiesWGL(hdc);
                return wGLCapabilities;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (hglrc != 0L) {
                WGL.wglMakeCurrent(0L, 0L);
                WGL.wglDeleteContext(hglrc);
            }
            if (hwnd != 0L) {
                User32.DestroyWindow(hwnd);
            }
            if (classAtom != 0) {
                User32.nUnregisterClass(classAtom & 0xFFFF, WindowsLibrary.HINSTANCE);
            }
        }
    }

    public static WGLCapabilities createCapabilitiesWGL() {
        long hdc = WGL.wglGetCurrentDC();
        if (hdc == 0L) {
            throw new IllegalStateException("Failed to retrieve the device context of the current OpenGL context");
        }
        return GL.createCapabilitiesWGL(hdc);
    }

    private static WGLCapabilities createCapabilitiesWGL(long hdc) {
        String extensionsString = null;
        long wglGetExtensionsString = functionProvider.getFunctionAddress("wglGetExtensionsStringARB");
        if (wglGetExtensionsString != 0L) {
            extensionsString = MemoryUtil.memASCII(JNI.callPP(wglGetExtensionsString, hdc));
        } else {
            wglGetExtensionsString = functionProvider.getFunctionAddress("wglGetExtensionsStringEXT");
            if (wglGetExtensionsString != 0L) {
                extensionsString = MemoryUtil.memASCII(JNI.callP(wglGetExtensionsString));
            }
        }
        HashSet<String> supportedExtensions = new HashSet<String>(32);
        if (extensionsString != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensionsString);
            while (tokenizer.hasMoreTokens()) {
                supportedExtensions.add(tokenizer.nextToken());
            }
        }
        return new WGLCapabilities(functionProvider, supportedExtensions);
    }

    public static GLXCapabilities createCapabilitiesGLX(long display) {
        return GL.createCapabilitiesGLX(display, X11.XDefaultScreen(display));
    }

    public static GLXCapabilities createCapabilitiesGLX(long display, int screen) {
        int minorVersion;
        int majorVersion;
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer piMajor = stack.ints(0);
            IntBuffer piMinor = stack.ints(0);
            if (GLX.glXQueryVersion(display, piMajor, piMinor) == 0) {
                throw new IllegalStateException("Failed to query GLX version");
            }
            majorVersion = piMajor.get(0);
            minorVersion = piMinor.get(0);
            if (majorVersion != 1) {
                throw new IllegalStateException("Invalid GLX major version: " + majorVersion);
            }
        }
        HashSet<String> supportedExtensions = new HashSet<String>(32);
        int[][] GLX_VERSIONS = new int[][]{{1, 2, 3, 4}};
        for (int major = 1; major <= GLX_VERSIONS.length; ++major) {
            int[] minors;
            for (int minor : minors = GLX_VERSIONS[major - 1]) {
                if (major >= majorVersion && (major != majorVersion || minor > minorVersion)) continue;
                supportedExtensions.add("GLX" + Integer.toString(major) + Integer.toString(minor));
            }
        }
        if (1 <= minorVersion) {
            long extensionsString;
            if (screen == -1) {
                long glXGetClientString = functionProvider.getFunctionAddress("glXGetClientString");
                extensionsString = JNI.callPP(glXGetClientString, display, 3);
            } else {
                long glXQueryExtensionsString = functionProvider.getFunctionAddress("glXQueryExtensionsString");
                extensionsString = JNI.callPP(glXQueryExtensionsString, display, screen);
            }
            StringTokenizer tokenizer = new StringTokenizer(MemoryUtil.memASCII(extensionsString));
            while (tokenizer.hasMoreTokens()) {
                supportedExtensions.add(tokenizer.nextToken());
            }
        }
        return new GLXCapabilities(functionProvider, supportedExtensions);
    }

    static {
        String capsStateType = Configuration.OPENGL_CAPABILITIES_STATE.get("ThreadLocal");
        if ("static".equals(capsStateType)) {
            capabilitiesState = new StaticCapabilitiesState();
        } else if ("ThreadLocal".equals(capsStateType)) {
            capabilitiesState = new TLCapabilitiesState();
        } else {
            throw new IllegalStateException("Invalid " + Configuration.OPENGL_CAPABILITIES_STATE.getProperty() + " specified.");
        }
        if (!Configuration.OPENGL_EXPLICIT_INIT.get(false).booleanValue()) {
            GL.create();
        }
    }

    private static class StaticCapabilitiesState
    implements CapabilitiesState {
        private static final List<Field> flags;
        private static final List<Field> funcs;
        private static GLCapabilities tempCaps;

        private StaticCapabilitiesState() {
        }

        @Override
        public void set(GLCapabilities caps) {
            if (Checks.DEBUG) {
                StaticCapabilitiesState.checkCapabilities(caps);
            }
            tempCaps = caps;
        }

        private static void checkCapabilities(GLCapabilities caps) {
            if (caps != null && tempCaps != null && !APIUtil.apiCompareCapabilities(flags, funcs, tempCaps, caps)) {
                APIUtil.apiLog("An OpenGL context with different functionality detected! The ThreadLocal capabilities state must be used.");
            }
        }

        @Override
        public GLCapabilities get() {
            return WriteOnce.caps;
        }

        static /* synthetic */ GLCapabilities access$300() {
            return tempCaps;
        }

        static {
            if (Checks.DEBUG) {
                Field[] fields = GLCapabilities.class.getFields();
                flags = new ArrayList<Field>(512);
                funcs = new ArrayList<Field>(256);
                for (Field f : fields) {
                    (f.getType() == Boolean.TYPE ? flags : funcs).add(f);
                }
            } else {
                flags = null;
                funcs = null;
            }
        }

        private static final class WriteOnce {
            private static final GLCapabilities caps = StaticCapabilitiesState.access$300();

            private WriteOnce() {
            }

            static {
                if (caps == null) {
                    throw new IllegalStateException("The static GLCapabilities instance is null");
                }
            }
        }
    }

    private static class TLCapabilitiesState
    implements CapabilitiesState {
        private TLCapabilitiesState() {
        }

        @Override
        public void set(GLCapabilities caps) {
            ThreadLocalUtil.tlsGet().capsGL = caps;
        }

        @Override
        public GLCapabilities get() {
            return ThreadLocalUtil.tlsGet().capsGL;
        }
    }

    private static interface CapabilitiesState {
        public void set(GLCapabilities var1);

        public GLCapabilities get();
    }

    private static abstract class SharedLibraryGL
    extends SharedLibrary.Delegate {
        SharedLibraryGL(SharedLibrary library) {
            super(library);
        }

        abstract long getExtensionAddress(long var1);

        @Override
        public long getFunctionAddress(ByteBuffer functionName) {
            long address = this.getExtensionAddress(MemoryUtil.memAddress(functionName));
            if (address == 0L && (address = this.library.getFunctionAddress(functionName)) == 0L && Checks.DEBUG_FUNCTIONS) {
                APIUtil.apiLog("Failed to locate address for GL function " + MemoryUtil.memASCII(functionName));
            }
            return address;
        }
    }
}

