/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GL31 {
    public static final int GL_R8_SNORM = 36756;
    public static final int GL_RG8_SNORM = 36757;
    public static final int GL_RGB8_SNORM = 36758;
    public static final int GL_RGBA8_SNORM = 36759;
    public static final int GL_R16_SNORM = 36760;
    public static final int GL_RG16_SNORM = 36761;
    public static final int GL_RGB16_SNORM = 36762;
    public static final int GL_RGBA16_SNORM = 36763;
    public static final int GL_SIGNED_NORMALIZED = 36764;
    public static final int GL_SAMPLER_BUFFER = 36290;
    public static final int GL_INT_SAMPLER_2D_RECT = 36301;
    public static final int GL_INT_SAMPLER_BUFFER = 36304;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_RECT = 36309;
    public static final int GL_UNSIGNED_INT_SAMPLER_BUFFER = 36312;
    public static final int GL_COPY_READ_BUFFER = 36662;
    public static final int GL_COPY_WRITE_BUFFER = 36663;
    public static final int GL_PRIMITIVE_RESTART = 36765;
    public static final int GL_PRIMITIVE_RESTART_INDEX = 36766;
    public static final int GL_TEXTURE_BUFFER = 35882;
    public static final int GL_MAX_TEXTURE_BUFFER_SIZE = 35883;
    public static final int GL_TEXTURE_BINDING_BUFFER = 35884;
    public static final int GL_TEXTURE_BUFFER_DATA_STORE_BINDING = 35885;
    public static final int GL_TEXTURE_RECTANGLE = 34037;
    public static final int GL_TEXTURE_BINDING_RECTANGLE = 34038;
    public static final int GL_PROXY_TEXTURE_RECTANGLE = 34039;
    public static final int GL_MAX_RECTANGLE_TEXTURE_SIZE = 34040;
    public static final int GL_SAMPLER_2D_RECT = 35683;
    public static final int GL_SAMPLER_2D_RECT_SHADOW = 35684;
    public static final int GL_UNIFORM_BUFFER = 35345;
    public static final int GL_UNIFORM_BUFFER_BINDING = 35368;
    public static final int GL_UNIFORM_BUFFER_START = 35369;
    public static final int GL_UNIFORM_BUFFER_SIZE = 35370;
    public static final int GL_MAX_VERTEX_UNIFORM_BLOCKS = 35371;
    public static final int GL_MAX_GEOMETRY_UNIFORM_BLOCKS = 35372;
    public static final int GL_MAX_FRAGMENT_UNIFORM_BLOCKS = 35373;
    public static final int GL_MAX_COMBINED_UNIFORM_BLOCKS = 35374;
    public static final int GL_MAX_UNIFORM_BUFFER_BINDINGS = 35375;
    public static final int GL_MAX_UNIFORM_BLOCK_SIZE = 35376;
    public static final int GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = 35377;
    public static final int GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = 35378;
    public static final int GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = 35379;
    public static final int GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = 35380;
    public static final int GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = 35381;
    public static final int GL_ACTIVE_UNIFORM_BLOCKS = 35382;
    public static final int GL_UNIFORM_TYPE = 35383;
    public static final int GL_UNIFORM_SIZE = 35384;
    public static final int GL_UNIFORM_NAME_LENGTH = 35385;
    public static final int GL_UNIFORM_BLOCK_INDEX = 35386;
    public static final int GL_UNIFORM_OFFSET = 35387;
    public static final int GL_UNIFORM_ARRAY_STRIDE = 35388;
    public static final int GL_UNIFORM_MATRIX_STRIDE = 35389;
    public static final int GL_UNIFORM_IS_ROW_MAJOR = 35390;
    public static final int GL_UNIFORM_BLOCK_BINDING = 35391;
    public static final int GL_UNIFORM_BLOCK_DATA_SIZE = 35392;
    public static final int GL_UNIFORM_BLOCK_NAME_LENGTH = 35393;
    public static final int GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = 35394;
    public static final int GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 35395;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 35396;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER = 35397;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 35398;
    public static final int GL_INVALID_INDEX = -1;

    protected GL31() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glDrawArraysInstanced, caps.glDrawElementsInstanced, caps.glCopyBufferSubData, caps.glPrimitiveRestartIndex, caps.glTexBuffer, caps.glGetUniformIndices, caps.glGetActiveUniformsiv, caps.glGetActiveUniformName, caps.glGetUniformBlockIndex, caps.glGetActiveUniformBlockiv, caps.glGetActiveUniformBlockName, caps.glUniformBlockBinding);
    }

    public static void glDrawArraysInstanced(int mode, int first, int count, int primcount) {
        long __functionAddress = GL.getCapabilities().glDrawArraysInstanced;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, mode, first, count, primcount);
    }

    public static void nglDrawElementsInstanced(int mode, int count, int type, long indices, int primcount) {
        long __functionAddress = GL.getCapabilities().glDrawElementsInstanced;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, count, type, indices, primcount);
    }

    public static void glDrawElementsInstanced(int mode, int count, int type, long indices, int primcount) {
        GL31.nglDrawElementsInstanced(mode, count, type, indices, primcount);
    }

    public static void glDrawElementsInstanced(int mode, int type, ByteBuffer indices, int primcount) {
        GL31.nglDrawElementsInstanced(mode, indices.remaining() >> GLChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstanced(int mode, ByteBuffer indices, int primcount) {
        GL31.nglDrawElementsInstanced(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstanced(int mode, ShortBuffer indices, int primcount) {
        GL31.nglDrawElementsInstanced(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstanced(int mode, IntBuffer indices, int primcount) {
        GL31.nglDrawElementsInstanced(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glCopyBufferSubData(int readTarget, int writeTarget, long readOffset, long writeOffset, long size) {
        long __functionAddress = GL.getCapabilities().glCopyBufferSubData;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, readTarget, writeTarget, readOffset, writeOffset, size);
    }

    public static void glPrimitiveRestartIndex(int index) {
        long __functionAddress = GL.getCapabilities().glPrimitiveRestartIndex;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index);
    }

    public static void glTexBuffer(int target, int internalformat, int buffer) {
        long __functionAddress = GL.getCapabilities().glTexBuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, target, internalformat, buffer);
    }

    public static void nglGetUniformIndices(int program, int uniformCount, long uniformNames, long uniformIndices) {
        long __functionAddress = GL.getCapabilities().glGetUniformIndices;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, program, uniformCount, uniformNames, uniformIndices);
    }

    public static void glGetUniformIndices(int program, PointerBuffer uniformNames, IntBuffer uniformIndices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformIndices, uniformNames.remaining());
        }
        GL31.nglGetUniformIndices(program, uniformNames.remaining(), MemoryUtil.memAddress(uniformNames), MemoryUtil.memAddress(uniformIndices));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glGetUniformIndices(int program, CharSequence[] uniformNames, IntBuffer uniformIndices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformIndices, uniformNames.length);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long uniformNamesAddress = APIUtil.apiArray(stack, MemoryUtil::memASCII, uniformNames);
            GL31.nglGetUniformIndices(program, uniformNames.length, uniformNamesAddress, MemoryUtil.memAddress(uniformIndices));
            APIUtil.apiArrayFree(uniformNamesAddress, uniformNames.length);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformIndices(int program, CharSequence uniformName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long uniformNamesAddress = APIUtil.apiArray(stack, MemoryUtil::memASCII, uniformName);
            IntBuffer uniformIndices = stack.callocInt(1);
            GL31.nglGetUniformIndices(program, 1, uniformNamesAddress, MemoryUtil.memAddress(uniformIndices));
            APIUtil.apiArrayFree(uniformNamesAddress, 1);
            int n = uniformIndices.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveUniformsiv(int program, int uniformCount, long uniformIndices, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformsiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, program, uniformCount, uniformIndices, pname, params);
    }

    public static void glGetActiveUniformsiv(int program, IntBuffer uniformIndices, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, uniformIndices.remaining());
        }
        GL31.nglGetActiveUniformsiv(program, uniformIndices.remaining(), MemoryUtil.memAddress(uniformIndices), pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetActiveUniformsi(int program, int uniformIndex, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            IntBuffer uniformIndices = stack.ints(uniformIndex);
            GL31.nglGetActiveUniformsiv(program, 1, MemoryUtil.memAddress(uniformIndices), pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveUniformName(int program, int uniformIndex, int bufSize, long length, long uniformName) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, program, uniformIndex, bufSize, length, uniformName);
    }

    public static void glGetActiveUniformName(int program, int uniformIndex, IntBuffer length, ByteBuffer uniformName) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)length, 1);
        }
        GL31.nglGetActiveUniformName(program, uniformIndex, uniformName.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(uniformName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniformName(int program, int uniformIndex, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer uniformName = stack.malloc(bufSize);
            GL31.nglGetActiveUniformName(program, uniformIndex, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(uniformName));
            String string = MemoryUtil.memASCII(uniformName, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniformName(int program, int uniformIndex) {
        int bufSize = GL31.glGetActiveUniformsi(program, uniformIndex, 35385);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer uniformName = stack.malloc(bufSize);
            GL31.nglGetActiveUniformName(program, uniformIndex, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(uniformName));
            String string = MemoryUtil.memASCII(uniformName, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nglGetUniformBlockIndex(int program, long uniformBlockName) {
        long __functionAddress = GL.getCapabilities().glGetUniformBlockIndex;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, program, uniformBlockName);
    }

    public static int glGetUniformBlockIndex(int program, ByteBuffer uniformBlockName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(uniformBlockName);
        }
        return GL31.nglGetUniformBlockIndex(program, MemoryUtil.memAddress(uniformBlockName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformBlockIndex(int program, CharSequence uniformBlockName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer uniformBlockNameEncoded = stack.ASCII(uniformBlockName);
            int n = GL31.nglGetUniformBlockIndex(program, MemoryUtil.memAddress(uniformBlockNameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformBlockiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, uniformBlockIndex, pname, params);
    }

    public static void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL31.nglGetActiveUniformBlockiv(program, uniformBlockIndex, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetActiveUniformBlocki(int program, int uniformBlockIndex, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL31.nglGetActiveUniformBlockiv(program, uniformBlockIndex, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize, long length, long uniformBlockName) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformBlockName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, program, uniformBlockIndex, bufSize, length, uniformBlockName);
    }

    public static void glGetActiveUniformBlockName(int program, int uniformBlockIndex, IntBuffer length, ByteBuffer uniformBlockName) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)length, 1);
        }
        GL31.nglGetActiveUniformBlockName(program, uniformBlockIndex, uniformBlockName.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(uniformBlockName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer uniformBlockName = stack.malloc(bufSize);
            GL31.nglGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(uniformBlockName));
            String string = MemoryUtil.memASCII(uniformBlockName, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniformBlockName(int program, int uniformBlockIndex) {
        int bufSize = GL31.glGetActiveUniformBlocki(program, uniformBlockIndex, 35393);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer uniformBlockName = stack.malloc(bufSize);
            GL31.nglGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(uniformBlockName));
            String string = MemoryUtil.memASCII(uniformBlockName, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glUniformBlockBinding(int program, int uniformBlockIndex, int uniformBlockBinding) {
        long __functionAddress = GL.getCapabilities().glUniformBlockBinding;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, uniformBlockIndex, uniformBlockBinding);
    }

    public static void glGetUniformIndices(int program, PointerBuffer uniformNames, int[] uniformIndices) {
        long __functionAddress = GL.getCapabilities().glGetUniformIndices;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(uniformIndices, uniformNames.remaining());
        }
        JNI.callPPV(__functionAddress, program, uniformNames.remaining(), MemoryUtil.memAddress(uniformNames), uniformIndices);
    }

    public static void glGetActiveUniformsiv(int program, int[] uniformIndices, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformsiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, uniformIndices.length);
        }
        JNI.callPPV(__functionAddress, program, uniformIndices.length, uniformIndices, pname, params);
    }

    public static void glGetActiveUniformName(int program, int uniformIndex, int[] length, ByteBuffer uniformName) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBufferSafe(length, 1);
        }
        JNI.callPPV(__functionAddress, program, uniformIndex, uniformName.remaining(), length, MemoryUtil.memAddress(uniformName));
    }

    public static void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformBlockiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, program, uniformBlockIndex, pname, params);
    }

    public static void glGetActiveUniformBlockName(int program, int uniformBlockIndex, int[] length, ByteBuffer uniformBlockName) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformBlockName;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBufferSafe(length, 1);
        }
        JNI.callPPV(__functionAddress, program, uniformBlockIndex, uniformBlockName.remaining(), length, MemoryUtil.memAddress(uniformBlockName));
    }
}

