/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class GL44 {
    public static final int GL_MAX_VERTEX_ATTRIB_STRIDE = 33509;
    public static final int GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED = 33313;
    public static final int GL_TEXTURE_BUFFER_BINDING = 35882;
    public static final int GL_MAP_PERSISTENT_BIT = 64;
    public static final int GL_MAP_COHERENT_BIT = 128;
    public static final int GL_DYNAMIC_STORAGE_BIT = 256;
    public static final int GL_CLIENT_STORAGE_BIT = 512;
    public static final int GL_BUFFER_IMMUTABLE_STORAGE = 33311;
    public static final int GL_BUFFER_STORAGE_FLAGS = 33312;
    public static final int GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT = 16384;
    public static final int GL_CLEAR_TEXTURE = 37733;
    public static final int GL_LOCATION_COMPONENT = 37706;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_INDEX = 37707;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE = 37708;
    public static final int GL_QUERY_RESULT_NO_WAIT = 37268;
    public static final int GL_QUERY_BUFFER = 37266;
    public static final int GL_QUERY_BUFFER_BINDING = 37267;
    public static final int GL_QUERY_BUFFER_BARRIER_BIT = 32768;
    public static final int GL_MIRROR_CLAMP_TO_EDGE = 34627;

    protected GL44() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glBufferStorage, caps.glClearTexSubImage, caps.glClearTexImage, caps.glBindBuffersBase, caps.glBindBuffersRange, caps.glBindTextures, caps.glBindSamplers, caps.glBindImageTextures, caps.glBindVertexBuffers);
    }

    public static void nglBufferStorage(int target, long size, long data, int flags) {
        long __functionAddress = GL.getCapabilities().glBufferStorage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, target, size, data, flags);
    }

    public static void glBufferStorage(int target, long size, int flags) {
        GL44.nglBufferStorage(target, size, 0L, flags);
    }

    public static void glBufferStorage(int target, ByteBuffer data, int flags) {
        GL44.nglBufferStorage(target, data.remaining(), MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorage(int target, ShortBuffer data, int flags) {
        GL44.nglBufferStorage(target, data.remaining() << 1, MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorage(int target, IntBuffer data, int flags) {
        GL44.nglBufferStorage(target, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorage(int target, FloatBuffer data, int flags) {
        GL44.nglBufferStorage(target, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorage(int target, DoubleBuffer data, int flags) {
        GL44.nglBufferStorage(target, data.remaining() << 3, MemoryUtil.memAddress(data), flags);
    }

    public static void nglClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long data) {
        long __functionAddress = GL.getCapabilities().glClearTexSubImage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data);
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer data) {
        GL44.nglClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer data) {
        GL44.nglClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer data) {
        GL44.nglClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer data) {
        GL44.nglClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, DoubleBuffer data) {
        GL44.nglClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void nglClearTexImage(int texture, int level, int format, int type, long data) {
        long __functionAddress = GL.getCapabilities().glClearTexImage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, level, format, type, data);
    }

    public static void glClearTexImage(int texture, int level, int format, int type, ByteBuffer data) {
        GL44.nglClearTexImage(texture, level, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexImage(int texture, int level, int format, int type, ShortBuffer data) {
        GL44.nglClearTexImage(texture, level, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexImage(int texture, int level, int format, int type, IntBuffer data) {
        GL44.nglClearTexImage(texture, level, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexImage(int texture, int level, int format, int type, FloatBuffer data) {
        GL44.nglClearTexImage(texture, level, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexImage(int texture, int level, int format, int type, DoubleBuffer data) {
        GL44.nglClearTexImage(texture, level, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void nglBindBuffersBase(int target, int first, int count, long buffers) {
        long __functionAddress = GL.getCapabilities().glBindBuffersBase;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, first, count, buffers);
    }

    public static void glBindBuffersBase(int target, int first, IntBuffer buffers) {
        GL44.nglBindBuffersBase(target, first, Checks.remainingSafe(buffers), MemoryUtil.memAddressSafe(buffers));
    }

    public static void nglBindBuffersRange(int target, int first, int count, long buffers, long offsets, long sizes) {
        long __functionAddress = GL.getCapabilities().glBindBuffersRange;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, target, first, count, buffers, offsets, sizes);
    }

    public static void glBindBuffersRange(int target, int first, IntBuffer buffers, PointerBuffer offsets, PointerBuffer sizes) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe(offsets, Checks.remainingSafe(buffers));
            Checks.checkBufferSafe(sizes, Checks.remainingSafe(buffers));
        }
        GL44.nglBindBuffersRange(target, first, Checks.remainingSafe(buffers), MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(sizes));
    }

    public static void nglBindTextures(int first, int count, long textures) {
        long __functionAddress = GL.getCapabilities().glBindTextures;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, count, textures);
    }

    public static void glBindTextures(int first, IntBuffer textures) {
        GL44.nglBindTextures(first, Checks.remainingSafe(textures), MemoryUtil.memAddressSafe(textures));
    }

    public static void nglBindSamplers(int first, int count, long samplers) {
        long __functionAddress = GL.getCapabilities().glBindSamplers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, count, samplers);
    }

    public static void glBindSamplers(int first, IntBuffer samplers) {
        GL44.nglBindSamplers(first, Checks.remainingSafe(samplers), MemoryUtil.memAddressSafe(samplers));
    }

    public static void nglBindImageTextures(int first, int count, long textures) {
        long __functionAddress = GL.getCapabilities().glBindImageTextures;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, count, textures);
    }

    public static void glBindImageTextures(int first, IntBuffer textures) {
        GL44.nglBindImageTextures(first, Checks.remainingSafe(textures), MemoryUtil.memAddressSafe(textures));
    }

    public static void nglBindVertexBuffers(int first, int count, long buffers, long offsets, long strides) {
        long __functionAddress = GL.getCapabilities().glBindVertexBuffers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, first, count, buffers, offsets, strides);
    }

    public static void glBindVertexBuffers(int first, IntBuffer buffers, PointerBuffer offsets, IntBuffer strides) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe(offsets, Checks.remainingSafe(buffers));
            Checks.checkBufferSafe((Buffer)strides, Checks.remainingSafe(buffers));
        }
        GL44.nglBindVertexBuffers(first, Checks.remainingSafe(buffers), MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(strides));
    }

    public static void glBufferStorage(int target, short[] data, int flags) {
        long __functionAddress = GL.getCapabilities().glBufferStorage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, target, (long)(data.length << 1), data, flags);
    }

    public static void glBufferStorage(int target, int[] data, int flags) {
        long __functionAddress = GL.getCapabilities().glBufferStorage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, target, (long)(data.length << 2), data, flags);
    }

    public static void glBufferStorage(int target, float[] data, int flags) {
        long __functionAddress = GL.getCapabilities().glBufferStorage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, target, (long)(data.length << 2), data, flags);
    }

    public static void glBufferStorage(int target, double[] data, int flags) {
        long __functionAddress = GL.getCapabilities().glBufferStorage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, target, (long)(data.length << 3), data, flags);
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, short[] data) {
        long __functionAddress = GL.getCapabilities().glClearTexSubImage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data);
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int[] data) {
        long __functionAddress = GL.getCapabilities().glClearTexSubImage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data);
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, float[] data) {
        long __functionAddress = GL.getCapabilities().glClearTexSubImage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data);
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, double[] data) {
        long __functionAddress = GL.getCapabilities().glClearTexSubImage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data);
    }

    public static void glClearTexImage(int texture, int level, int format, int type, short[] data) {
        long __functionAddress = GL.getCapabilities().glClearTexImage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, level, format, type, data);
    }

    public static void glClearTexImage(int texture, int level, int format, int type, int[] data) {
        long __functionAddress = GL.getCapabilities().glClearTexImage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, level, format, type, data);
    }

    public static void glClearTexImage(int texture, int level, int format, int type, float[] data) {
        long __functionAddress = GL.getCapabilities().glClearTexImage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, level, format, type, data);
    }

    public static void glClearTexImage(int texture, int level, int format, int type, double[] data) {
        long __functionAddress = GL.getCapabilities().glClearTexImage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, texture, level, format, type, data);
    }

    public static void glBindBuffersBase(int target, int first, int[] buffers) {
        long __functionAddress = GL.getCapabilities().glBindBuffersBase;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, first, Checks.lengthSafe(buffers), buffers);
    }

    public static void glBindBuffersRange(int target, int first, int[] buffers, PointerBuffer offsets, PointerBuffer sizes) {
        long __functionAddress = GL.getCapabilities().glBindBuffersRange;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBufferSafe(offsets, Checks.lengthSafe(buffers));
            Checks.checkBufferSafe(sizes, Checks.lengthSafe(buffers));
        }
        JNI.callPPPV(__functionAddress, target, first, Checks.lengthSafe(buffers), buffers, MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(sizes));
    }

    public static void glBindTextures(int first, int[] textures) {
        long __functionAddress = GL.getCapabilities().glBindTextures;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, Checks.lengthSafe(textures), textures);
    }

    public static void glBindSamplers(int first, int[] samplers) {
        long __functionAddress = GL.getCapabilities().glBindSamplers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, Checks.lengthSafe(samplers), samplers);
    }

    public static void glBindImageTextures(int first, int[] textures) {
        long __functionAddress = GL.getCapabilities().glBindImageTextures;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, Checks.lengthSafe(textures), textures);
    }

    public static void glBindVertexBuffers(int first, int[] buffers, PointerBuffer offsets, int[] strides) {
        long __functionAddress = GL.getCapabilities().glBindVertexBuffers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBufferSafe(offsets, Checks.lengthSafe(buffers));
            Checks.checkBufferSafe(strides, Checks.lengthSafe(buffers));
        }
        JNI.callPPPV(__functionAddress, first, Checks.lengthSafe(buffers), buffers, MemoryUtil.memAddressSafe(offsets), strides);
    }
}

