/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLXCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XVisualInfo;

public class GLX13 {
    public static final int GLX_WINDOW_BIT = 1;
    public static final int GLX_PIXMAP_BIT = 2;
    public static final int GLX_PBUFFER_BIT = 4;
    public static final int GLX_RGBA_BIT = 1;
    public static final int GLX_COLOR_INDEX_BIT = 2;
    public static final int GLX_PBUFFER_CLOBBER_MASK = 0x8000000;
    public static final int GLX_FRONT_LEFT_BUFFER_BIT = 1;
    public static final int GLX_FRONT_RIGHT_BUFFER_BIT = 2;
    public static final int GLX_BACK_LEFT_BUFFER_BIT = 4;
    public static final int GLX_BACK_RIGHT_BUFFER_BIT = 8;
    public static final int GLX_AUX_BUFFERS_BIT = 16;
    public static final int GLX_DEPTH_BUFFER_BIT = 32;
    public static final int GLX_STENCIL_BUFFER_BIT = 64;
    public static final int GLX_ACCUM_BUFFER_BIT = 128;
    public static final int GLX_CONFIG_CAVEAT = 32;
    public static final int GLX_X_VISUAL_TYPE = 34;
    public static final int GLX_TRANSPARENT_TYPE = 35;
    public static final int GLX_TRANSPARENT_INDEX_VALUE = 36;
    public static final int GLX_TRANSPARENT_RED_VALUE = 37;
    public static final int GLX_TRANSPARENT_GREEN_VALUE = 38;
    public static final int GLX_TRANSPARENT_BLUE_VALUE = 39;
    public static final int GLX_TRANSPARENT_ALPHA_VALUE = 40;
    public static final int GLX_DONT_CARE = -1;
    public static final int GLX_NONE = 32768;
    public static final int GLX_SLOW_CONFIG = 32769;
    public static final int GLX_TRUE_COLOR = 32770;
    public static final int GLX_DIRECT_COLOR = 32771;
    public static final int GLX_PSEUDO_COLOR = 32772;
    public static final int GLX_STATIC_COLOR = 32773;
    public static final int GLX_GRAY_SCALE = 32774;
    public static final int GLX_STATIC_GRAY = 32775;
    public static final int GLX_TRANSPARENT_RGB = 32776;
    public static final int GLX_TRANSPARENT_INDEX = 32777;
    public static final int GLX_VISUAL_ID = 32779;
    public static final int GLX_SCREEN = 32780;
    public static final int GLX_NON_CONFORMANT_CONFIG = 32781;
    public static final int GLX_DRAWABLE_TYPE = 32784;
    public static final int GLX_RENDER_TYPE = 32785;
    public static final int GLX_X_RENDERABLE = 32786;
    public static final int GLX_FBCONFIG_ID = 32787;
    public static final int GLX_RGBA_TYPE = 32788;
    public static final int GLX_COLOR_INDEX_TYPE = 32789;
    public static final int GLX_MAX_PBUFFER_WIDTH = 32790;
    public static final int GLX_MAX_PBUFFER_HEIGHT = 32791;
    public static final int GLX_MAX_PBUFFER_PIXELS = 32792;
    public static final int GLX_PRESERVED_CONTENTS = 32795;
    public static final int GLX_LARGEST_PBUFFER = 32796;
    public static final int GLX_WIDTH = 32797;
    public static final int GLX_HEIGHT = 32798;
    public static final int GLX_EVENT_MASK = 32799;
    public static final int GLX_DAMAGED = 32800;
    public static final int GLX_SAVED = 32801;
    public static final int GLX_WINDOW = 32802;
    public static final int GLX_PBUFFER = 32803;
    public static final int GLX_PBUFFER_HEIGHT = 32832;
    public static final int GLX_PBUFFER_WIDTH = 32833;

    protected GLX13() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLXCapabilities caps) {
        return Checks.checkFunctions(caps.glXGetFBConfigs, caps.glXChooseFBConfig, caps.glXGetFBConfigAttrib, caps.glXGetVisualFromFBConfig, caps.glXCreateWindow, caps.glXCreatePixmap, caps.glXDestroyPixmap, caps.glXCreatePbuffer, caps.glXDestroyPbuffer, caps.glXQueryDrawable, caps.glXCreateNewContext, caps.glXMakeContextCurrent, caps.glXGetCurrentReadDrawable, caps.glXQueryContext, caps.glXSelectEvent, caps.glXGetSelectedEvent);
    }

    public static long nglXGetFBConfigs(long display, int screen, long nelements) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetFBConfigs;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
        }
        return JNI.callPPP(__functionAddress, display, screen, nelements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer glXGetFBConfigs(long display, int screen) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer nelements = stack.callocInt(1);
        try {
            long __result = GLX13.nglXGetFBConfigs(display, screen, MemoryUtil.memAddress(nelements));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBuffer(__result, nelements.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nglXChooseFBConfig(long display, int screen, long attrib_list, long nelements) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXChooseFBConfig;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
        }
        return JNI.callPPPP(__functionAddress, display, screen, attrib_list, nelements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer glXChooseFBConfig(long display, int screen, IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer nelements = stack.callocInt(1);
        try {
            long __result = GLX13.nglXChooseFBConfig(display, screen, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddress(nelements));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBuffer(__result, nelements.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nglXGetFBConfigAttrib(long display, long config, int attribute, long value) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetFBConfigAttrib;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return JNI.callPPPI(__functionAddress, display, config, attribute, value);
    }

    public static int glXGetFBConfigAttrib(long display, long config, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return GLX13.nglXGetFBConfigAttrib(display, config, attribute, MemoryUtil.memAddress(value));
    }

    public static long nglXGetVisualFromFBConfig(long display, long config) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetVisualFromFBConfig;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return JNI.callPPP(__functionAddress, display, config);
    }

    public static XVisualInfo glXGetVisualFromFBConfig(long display, long config) {
        long __result = GLX13.nglXGetVisualFromFBConfig(display, config);
        return XVisualInfo.create(__result);
    }

    public static long nglXCreateWindow(long display, long config, long win, long attrib_list) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXCreateWindow;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return JNI.callPPPPP(__functionAddress, display, config, win, attrib_list);
    }

    public static long glXCreateWindow(long display, long config, long win, IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list);
        }
        return GLX13.nglXCreateWindow(display, config, win, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long nglXCreatePixmap(long display, long config, long pixmap, long attrib_list) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXCreatePixmap;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return JNI.callPPPPP(__functionAddress, display, config, pixmap, attrib_list);
    }

    public static long glXCreatePixmap(long display, long config, long pixmap, IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list);
        }
        return GLX13.nglXCreatePixmap(display, config, pixmap, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static void glXDestroyPixmap(long display, long pixmap) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXDestroyPixmap;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(pixmap);
        }
        JNI.callPPV(__functionAddress, display, pixmap);
    }

    public static long nglXCreatePbuffer(long display, long config, long attrib_list) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXCreatePbuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return JNI.callPPPP(__functionAddress, display, config, attrib_list);
    }

    public static long glXCreatePbuffer(long display, long config, IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list);
        }
        return GLX13.nglXCreatePbuffer(display, config, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static void glXDestroyPbuffer(long display, long pbuf) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXDestroyPbuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(pbuf);
        }
        JNI.callPPV(__functionAddress, display, pbuf);
    }

    public static void nglXQueryDrawable(long display, long draw, int attribute, long value) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryDrawable;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(draw);
        }
        JNI.callPPPV(__functionAddress, display, draw, attribute, value);
    }

    public static void glXQueryDrawable(long display, long draw, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GLX13.nglXQueryDrawable(display, draw, attribute, MemoryUtil.memAddress(value));
    }

    public static long glXCreateNewContext(long display, long config, int render_type, long share_list, int direct) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXCreateNewContext;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return JNI.callPPPP(__functionAddress, display, config, render_type, share_list, direct);
    }

    public static int glXMakeContextCurrent(long display, long draw, long read, long ctx) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXMakeContextCurrent;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
        }
        return JNI.callPPPPI(__functionAddress, display, draw, read, ctx);
    }

    public static long glXGetCurrentReadDrawable() {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetCurrentReadDrawable;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callP(__functionAddress);
    }

    public static int nglXQueryContext(long display, long ctx, int attribute, long value) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryContext;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(ctx);
        }
        return JNI.callPPPI(__functionAddress, display, ctx, attribute, value);
    }

    public static int glXQueryContext(long display, long ctx, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return GLX13.nglXQueryContext(display, ctx, attribute, MemoryUtil.memAddress(value));
    }

    public static void glXSelectEvent(long display, long draw, long event_mask) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXSelectEvent;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(draw);
        }
        JNI.callPPPV(__functionAddress, display, draw, event_mask);
    }

    public static void nglXGetSelectedEvent(long display, long draw, long event_mask) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetSelectedEvent;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(draw);
        }
        JNI.callPPPV(__functionAddress, display, draw, event_mask);
    }

    public static void glXGetSelectedEvent(long display, long draw, PointerBuffer event_mask) {
        GLX13.nglXGetSelectedEvent(display, draw, MemoryUtil.memAddress(event_mask));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer glXChooseFBConfig(long display, int screen, int[] attrib_list) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXChooseFBConfig;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkNTSafe(attrib_list);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer nelements = stack.callocInt(1);
        try {
            long __result = JNI.callPPPP(__functionAddress, display, screen, attrib_list, MemoryUtil.memAddress(nelements));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBuffer(__result, nelements.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int glXGetFBConfigAttrib(long display, long config, int attribute, int[] value) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetFBConfigAttrib;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
            Checks.checkBuffer(value, 1);
        }
        return JNI.callPPPI(__functionAddress, display, config, attribute, value);
    }

    public static long glXCreateWindow(long display, long config, long win, int[] attrib_list) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXCreateWindow;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
            Checks.checkNTSafe(attrib_list);
        }
        return JNI.callPPPPP(__functionAddress, display, config, win, attrib_list);
    }

    public static long glXCreatePixmap(long display, long config, long pixmap, int[] attrib_list) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXCreatePixmap;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
            Checks.checkNTSafe(attrib_list);
        }
        return JNI.callPPPPP(__functionAddress, display, config, pixmap, attrib_list);
    }

    public static long glXCreatePbuffer(long display, long config, int[] attrib_list) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXCreatePbuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
            Checks.checkNTSafe(attrib_list);
        }
        return JNI.callPPPP(__functionAddress, display, config, attrib_list);
    }

    public static void glXQueryDrawable(long display, long draw, int attribute, int[] value) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryDrawable;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(draw);
            Checks.checkBuffer(value, 1);
        }
        JNI.callPPPV(__functionAddress, display, draw, attribute, value);
    }

    public static int glXQueryContext(long display, long ctx, int attribute, int[] value) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryContext;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(ctx);
            Checks.checkBuffer(value, 1);
        }
        return JNI.callPPPI(__functionAddress, display, ctx, attribute, value);
    }
}

