/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class KHRDebug {
    public static final int GL_DEBUG_OUTPUT = 37600;
    public static final int GL_DEBUG_OUTPUT_SYNCHRONOUS = 33346;
    public static final int GL_CONTEXT_FLAG_DEBUG_BIT = 2;
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES = 37189;
    public static final int GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = 33347;
    public static final int GL_MAX_DEBUG_GROUP_STACK_DEPTH = 33388;
    public static final int GL_DEBUG_GROUP_STACK_DEPTH = 33389;
    public static final int GL_MAX_LABEL_LENGTH = 33512;
    public static final int GL_DEBUG_CALLBACK_FUNCTION = 33348;
    public static final int GL_DEBUG_CALLBACK_USER_PARAM = 33349;
    public static final int GL_DEBUG_SOURCE_API = 33350;
    public static final int GL_DEBUG_SOURCE_WINDOW_SYSTEM = 33351;
    public static final int GL_DEBUG_SOURCE_SHADER_COMPILER = 33352;
    public static final int GL_DEBUG_SOURCE_THIRD_PARTY = 33353;
    public static final int GL_DEBUG_SOURCE_APPLICATION = 33354;
    public static final int GL_DEBUG_SOURCE_OTHER = 33355;
    public static final int GL_DEBUG_TYPE_ERROR = 33356;
    public static final int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = 33357;
    public static final int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = 33358;
    public static final int GL_DEBUG_TYPE_PORTABILITY = 33359;
    public static final int GL_DEBUG_TYPE_PERFORMANCE = 33360;
    public static final int GL_DEBUG_TYPE_OTHER = 33361;
    public static final int GL_DEBUG_TYPE_MARKER = 33384;
    public static final int GL_DEBUG_TYPE_PUSH_GROUP = 33385;
    public static final int GL_DEBUG_TYPE_POP_GROUP = 33386;
    public static final int GL_DEBUG_SEVERITY_HIGH = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW = 37192;
    public static final int GL_DEBUG_SEVERITY_NOTIFICATION = 33387;
    public static final int GL_BUFFER = 33504;
    public static final int GL_SHADER = 33505;
    public static final int GL_PROGRAM = 33506;
    public static final int GL_QUERY = 33507;
    public static final int GL_PROGRAM_PIPELINE = 33508;
    public static final int GL_SAMPLER = 33510;
    public static final int GL_DISPLAY_LIST = 33511;

    protected KHRDebug() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glDebugMessageControl, caps.glDebugMessageInsert, caps.glDebugMessageCallback, caps.glGetDebugMessageLog, caps.glPushDebugGroup, caps.glPopDebugGroup, caps.glObjectLabel, caps.glGetObjectLabel, caps.glObjectPtrLabel, caps.glGetObjectPtrLabel);
    }

    public static void nglDebugMessageControl(int source, int type, int severity, int count, long ids, boolean enabled) {
        long __functionAddress = GL.getCapabilities().glDebugMessageControl;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, source, type, severity, count, ids, enabled);
    }

    public static void glDebugMessageControl(int source, int type, int severity, IntBuffer ids, boolean enabled) {
        KHRDebug.nglDebugMessageControl(source, type, severity, Checks.remainingSafe(ids), MemoryUtil.memAddressSafe(ids), enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageControl(int source, int type, int severity, int id, boolean enabled) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.ints(id);
            KHRDebug.nglDebugMessageControl(source, type, severity, 1, MemoryUtil.memAddress(ids), enabled);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDebugMessageInsert(int source, int type, int id, int severity, int length, long message) {
        long __functionAddress = GL.getCapabilities().glDebugMessageInsert;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, source, type, id, severity, length, message);
    }

    public static void glDebugMessageInsert(int source, int type, int id, int severity, ByteBuffer message) {
        KHRDebug.nglDebugMessageInsert(source, type, id, severity, message.remaining(), MemoryUtil.memAddress(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageInsert(int source, int type, int id, int severity, CharSequence message) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer messageEncoded = stack.UTF8(message, false);
            int messageEncodedLen = messageEncoded.capacity();
            KHRDebug.nglDebugMessageInsert(source, type, id, severity, messageEncodedLen, MemoryUtil.memAddress(messageEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDebugMessageCallback(long callback, long userParam) {
        long __functionAddress = GL.getCapabilities().glDebugMessageCallback;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, callback, userParam);
    }

    public static void glDebugMessageCallback(GLDebugMessageCallbackI callback, long userParam) {
        KHRDebug.nglDebugMessageCallback(MemoryUtil.memAddressSafe(callback), userParam);
    }

    public static int nglGetDebugMessageLog(int count, int bufsize, long sources, long types, long ids, long severities, long lengths, long messageLog) {
        long __functionAddress = GL.getCapabilities().glGetDebugMessageLog;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPPPPPPI(__functionAddress, count, bufsize, sources, types, ids, severities, lengths, messageLog);
    }

    public static int glGetDebugMessageLog(int count, IntBuffer sources, IntBuffer types, IntBuffer ids, IntBuffer severities, IntBuffer lengths, ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)sources, count);
            Checks.checkBufferSafe((Buffer)types, count);
            Checks.checkBufferSafe((Buffer)ids, count);
            Checks.checkBufferSafe((Buffer)severities, count);
            Checks.checkBufferSafe((Buffer)lengths, count);
        }
        return KHRDebug.nglGetDebugMessageLog(count, Checks.remainingSafe(messageLog), MemoryUtil.memAddressSafe(sources), MemoryUtil.memAddressSafe(types), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static void nglPushDebugGroup(int source, int id, int length, long message) {
        long __functionAddress = GL.getCapabilities().glPushDebugGroup;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, source, id, length, message);
    }

    public static void glPushDebugGroup(int source, int id, ByteBuffer message) {
        KHRDebug.nglPushDebugGroup(source, id, message.remaining(), MemoryUtil.memAddress(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glPushDebugGroup(int source, int id, CharSequence message) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer messageEncoded = stack.UTF8(message, false);
            int messageEncodedLen = messageEncoded.capacity();
            KHRDebug.nglPushDebugGroup(source, id, messageEncodedLen, MemoryUtil.memAddress(messageEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glPopDebugGroup() {
        long __functionAddress = GL.getCapabilities().glPopDebugGroup;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress);
    }

    public static void nglObjectLabel(int identifier, int name, int length, long label) {
        long __functionAddress = GL.getCapabilities().glObjectLabel;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, identifier, name, length, label);
    }

    public static void glObjectLabel(int identifier, int name, ByteBuffer label) {
        KHRDebug.nglObjectLabel(identifier, name, label.remaining(), MemoryUtil.memAddress(label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glObjectLabel(int identifier, int name, CharSequence label) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer labelEncoded = stack.UTF8(label, false);
            int labelEncodedLen = labelEncoded.capacity();
            KHRDebug.nglObjectLabel(identifier, name, labelEncodedLen, MemoryUtil.memAddress(labelEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetObjectLabel(int identifier, int name, int bufSize, long length, long label) {
        long __functionAddress = GL.getCapabilities().glGetObjectLabel;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, identifier, name, bufSize, length, label);
    }

    public static void glGetObjectLabel(int identifier, int name, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)length, 1);
        }
        KHRDebug.nglGetObjectLabel(identifier, name, label.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectLabel(int identifier, int name, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            KHRDebug.nglGetObjectLabel(identifier, name, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(label));
            String string = MemoryUtil.memUTF8(label, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectLabel(int identifier, int name) {
        int bufSize = GL11.glGetInteger(33512);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            KHRDebug.nglGetObjectLabel(identifier, name, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(label));
            String string = MemoryUtil.memUTF8(label, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglObjectPtrLabel(long ptr, int length, long label) {
        long __functionAddress = GL.getCapabilities().glObjectPtrLabel;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(ptr);
        }
        JNI.callPPV(__functionAddress, ptr, length, label);
    }

    public static void glObjectPtrLabel(long ptr, ByteBuffer label) {
        KHRDebug.nglObjectPtrLabel(ptr, label.remaining(), MemoryUtil.memAddress(label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glObjectPtrLabel(long ptr, CharSequence label) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer labelEncoded = stack.UTF8(label, false);
            int labelEncodedLen = labelEncoded.capacity();
            KHRDebug.nglObjectPtrLabel(ptr, labelEncodedLen, MemoryUtil.memAddress(labelEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetObjectPtrLabel(long ptr, int bufSize, long length, long label) {
        long __functionAddress = GL.getCapabilities().glGetObjectPtrLabel;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(ptr);
        }
        JNI.callPPPV(__functionAddress, ptr, bufSize, length, label);
    }

    public static void glGetObjectPtrLabel(long ptr, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)length, 1);
        }
        KHRDebug.nglGetObjectPtrLabel(ptr, label.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectPtrLabel(long ptr, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            KHRDebug.nglGetObjectPtrLabel(ptr, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(label));
            String string = MemoryUtil.memUTF8(label, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectPtrLabel(long ptr) {
        int bufSize = GL11.glGetInteger(33512);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            KHRDebug.nglGetObjectPtrLabel(ptr, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(label));
            String string = MemoryUtil.memUTF8(label, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDebugMessageControl(int source, int type, int severity, int[] ids, boolean enabled) {
        long __functionAddress = GL.getCapabilities().glDebugMessageControl;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, source, type, severity, Checks.lengthSafe(ids), ids, enabled);
    }

    public static int glGetDebugMessageLog(int count, int[] sources, int[] types, int[] ids, int[] severities, int[] lengths, ByteBuffer messageLog) {
        long __functionAddress = GL.getCapabilities().glGetDebugMessageLog;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBufferSafe(sources, count);
            Checks.checkBufferSafe(types, count);
            Checks.checkBufferSafe(ids, count);
            Checks.checkBufferSafe(severities, count);
            Checks.checkBufferSafe(lengths, count);
        }
        return JNI.callPPPPPPI(__functionAddress, count, Checks.remainingSafe(messageLog), sources, types, ids, severities, lengths, MemoryUtil.memAddressSafe(messageLog));
    }

    public static void glGetObjectLabel(int identifier, int name, int[] length, ByteBuffer label) {
        long __functionAddress = GL.getCapabilities().glGetObjectLabel;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBufferSafe(length, 1);
        }
        JNI.callPPV(__functionAddress, identifier, name, label.remaining(), length, MemoryUtil.memAddress(label));
    }

    public static void glGetObjectPtrLabel(long ptr, int[] length, ByteBuffer label) {
        long __functionAddress = GL.getCapabilities().glGetObjectPtrLabel;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(ptr);
            Checks.checkBufferSafe(length, 1);
        }
        JNI.callPPPV(__functionAddress, ptr, label.remaining(), length, MemoryUtil.memAddress(label));
    }
}

