/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class KHRRobustness {
    public static final int GL_NO_ERROR = 0;
    public static final int GL_GUILTY_CONTEXT_RESET = 33363;
    public static final int GL_INNOCENT_CONTEXT_RESET = 33364;
    public static final int GL_UNKNOWN_CONTEXT_RESET = 33365;
    public static final int GL_CONTEXT_ROBUST_ACCESS = 37107;
    public static final int GL_RESET_NOTIFICATION_STRATEGY = 33366;
    public static final int GL_LOSE_CONTEXT_ON_RESET = 33362;
    public static final int GL_NO_RESET_NOTIFICATION = 33377;
    public static final int GL_CONTEXT_LOST = 1287;

    protected KHRRobustness() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glGetGraphicsResetStatus, caps.glReadnPixels, caps.glGetnUniformfv, caps.glGetnUniformiv, caps.glGetnUniformuiv);
    }

    public static int glGetGraphicsResetStatus() {
        long __functionAddress = GL.getCapabilities().glGetGraphicsResetStatus;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static void nglReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, long pixels) {
        long __functionAddress = GL.getCapabilities().glReadnPixels;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, bufSize, pixels);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, long pixels) {
        KHRRobustness.nglReadnPixels(x, y, width, height, format, type, bufSize, pixels);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        KHRRobustness.nglReadnPixels(x, y, width, height, format, type, pixels.remaining(), MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, ShortBuffer pixels) {
        KHRRobustness.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 1, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, IntBuffer pixels) {
        KHRRobustness.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, FloatBuffer pixels) {
        KHRRobustness.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void nglGetnUniformfv(int program, int location, int bufSize, long params) {
        long __functionAddress = GL.getCapabilities().glGetnUniformfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformfv(int program, int location, FloatBuffer params) {
        KHRRobustness.nglGetnUniformfv(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformf(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            KHRRobustness.nglGetnUniformfv(program, location, 1, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetnUniformiv(int program, int location, int bufSize, long params) {
        long __functionAddress = GL.getCapabilities().glGetnUniformiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformiv(int program, int location, FloatBuffer params) {
        KHRRobustness.nglGetnUniformiv(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformi(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            KHRRobustness.nglGetnUniformiv(program, location, 1, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetnUniformuiv(int program, int location, int bufSize, long params) {
        long __functionAddress = GL.getCapabilities().glGetnUniformuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformuiv(int program, int location, FloatBuffer params) {
        KHRRobustness.nglGetnUniformuiv(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformui(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            KHRRobustness.nglGetnUniformuiv(program, location, 1, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, short[] pixels) {
        long __functionAddress = GL.getCapabilities().glReadnPixels;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, pixels.length << 1, pixels);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, int[] pixels) {
        long __functionAddress = GL.getCapabilities().glReadnPixels;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, pixels.length << 2, pixels);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, float[] pixels) {
        long __functionAddress = GL.getCapabilities().glReadnPixels;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, pixels.length << 2, pixels);
    }

    public static void glGetnUniformfv(int program, int location, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetnUniformfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, params.length, params);
    }

    public static void glGetnUniformiv(int program, int location, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetnUniformiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, params.length, params);
    }

    public static void glGetnUniformuiv(int program, int location, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetnUniformuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, params.length, params);
    }
}

