/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class NVTransformFeedback {
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_NV = 35982;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_START_NV = 35972;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV = 35973;
    public static final int GL_TRANSFORM_FEEDBACK_RECORD_NV = 35974;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV = 35983;
    public static final int GL_INTERLEAVED_ATTRIBS_NV = 35980;
    public static final int GL_SEPARATE_ATTRIBS_NV = 35981;
    public static final int GL_PRIMITIVES_GENERATED_NV = 35975;
    public static final int GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV = 35976;
    public static final int GL_RASTERIZER_DISCARD_NV = 35977;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV = 35978;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV = 35979;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV = 35968;
    public static final int GL_TRANSFORM_FEEDBACK_ATTRIBS_NV = 35966;
    public static final int GL_ACTIVE_VARYINGS_NV = 35969;
    public static final int GL_ACTIVE_VARYING_MAX_LENGTH_NV = 35970;
    public static final int GL_TRANSFORM_FEEDBACK_VARYINGS_NV = 35971;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV = 35967;
    public static final int GL_BACK_PRIMARY_COLOR_NV = 35959;
    public static final int GL_BACK_SECONDARY_COLOR_NV = 35960;
    public static final int GL_TEXTURE_COORD_NV = 35961;
    public static final int GL_CLIP_DISTANCE_NV = 35962;
    public static final int GL_VERTEX_ID_NV = 35963;
    public static final int GL_PRIMITIVE_ID_NV = 35964;
    public static final int GL_GENERIC_ATTRIB_NV = 35965;
    public static final int GL_SECONDARY_COLOR_NV = 34093;
    public static final int GL_LAYER_NV = 36266;

    protected NVTransformFeedback() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glBeginTransformFeedbackNV, caps.glEndTransformFeedbackNV, caps.glTransformFeedbackAttribsNV, caps.glBindBufferRangeNV, caps.glBindBufferOffsetNV, caps.glBindBufferBaseNV, caps.glTransformFeedbackVaryingsNV, caps.glActiveVaryingNV, caps.glGetVaryingLocationNV, caps.glGetActiveVaryingNV, caps.glGetTransformFeedbackVaryingNV, caps.glTransformFeedbackStreamAttribsNV);
    }

    public static void glBeginTransformFeedbackNV(int primitiveMode) {
        long __functionAddress = GL.getCapabilities().glBeginTransformFeedbackNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, primitiveMode);
    }

    public static void glEndTransformFeedbackNV() {
        long __functionAddress = GL.getCapabilities().glEndTransformFeedbackNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress);
    }

    public static void nglTransformFeedbackAttribsNV(int count, long attribs, int bufferMode) {
        long __functionAddress = GL.getCapabilities().glTransformFeedbackAttribsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, count, attribs, bufferMode);
    }

    public static void glTransformFeedbackAttribsNV(IntBuffer attribs, int bufferMode) {
        NVTransformFeedback.nglTransformFeedbackAttribsNV(attribs.remaining(), MemoryUtil.memAddress(attribs), bufferMode);
    }

    public static void glBindBufferRangeNV(int target, int index, int buffer, long offset, long size) {
        long __functionAddress = GL.getCapabilities().glBindBufferRangeNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, target, index, buffer, offset, size);
    }

    public static void glBindBufferOffsetNV(int target, int index, int buffer, long offset) {
        long __functionAddress = GL.getCapabilities().glBindBufferOffsetNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, index, buffer, offset);
    }

    public static void glBindBufferBaseNV(int target, int index, int buffer) {
        long __functionAddress = GL.getCapabilities().glBindBufferBaseNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, target, index, buffer);
    }

    public static void nglTransformFeedbackVaryingsNV(int program, int count, long locations, int bufferMode) {
        long __functionAddress = GL.getCapabilities().glTransformFeedbackVaryingsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, count, locations, bufferMode);
    }

    public static void glTransformFeedbackVaryingsNV(int program, IntBuffer locations, int bufferMode) {
        NVTransformFeedback.nglTransformFeedbackVaryingsNV(program, locations.remaining(), MemoryUtil.memAddress(locations), bufferMode);
    }

    public static void nglActiveVaryingNV(int program, long name) {
        long __functionAddress = GL.getCapabilities().glActiveVaryingNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, name);
    }

    public static void glActiveVaryingNV(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        NVTransformFeedback.nglActiveVaryingNV(program, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glActiveVaryingNV(int program, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            NVTransformFeedback.nglActiveVaryingNV(program, MemoryUtil.memAddress(nameEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nglGetVaryingLocationNV(int program, long name) {
        long __functionAddress = GL.getCapabilities().glGetVaryingLocationNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, program, name);
    }

    public static int glGetVaryingLocationNV(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return NVTransformFeedback.nglGetVaryingLocationNV(program, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetVaryingLocationNV(int program, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = NVTransformFeedback.nglGetVaryingLocationNV(program, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveVaryingNV(int program, int index, int bufSize, long length, long size, long type, long name) {
        long __functionAddress = GL.getCapabilities().glGetActiveVaryingNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPPV(__functionAddress, program, index, bufSize, length, size, type, name);
    }

    public static void glGetActiveVaryingNV(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((Buffer)length, 1);
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        NVTransformFeedback.nglGetActiveVaryingNV(program, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static void nglGetTransformFeedbackVaryingNV(int program, int index, long location) {
        long __functionAddress = GL.getCapabilities().glGetTransformFeedbackVaryingNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, index, location);
    }

    public static void glGetTransformFeedbackVaryingNV(int program, int index, IntBuffer location) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)location, 1);
        }
        NVTransformFeedback.nglGetTransformFeedbackVaryingNV(program, index, MemoryUtil.memAddress(location));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTransformFeedbackVaryingNV(int program, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer location = stack.callocInt(1);
            NVTransformFeedback.nglGetTransformFeedbackVaryingNV(program, index, MemoryUtil.memAddress(location));
            int n = location.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglTransformFeedbackStreamAttribsNV(int count, long attribs, int nbuffers, long bufstreams, int bufferMode) {
        long __functionAddress = GL.getCapabilities().glTransformFeedbackStreamAttribsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, count, attribs, nbuffers, bufstreams, bufferMode);
    }

    public static void glTransformFeedbackStreamAttribsNV(IntBuffer attribs, IntBuffer bufstreams, int bufferMode) {
        NVTransformFeedback.nglTransformFeedbackStreamAttribsNV(attribs.remaining(), MemoryUtil.memAddress(attribs), bufstreams.remaining(), MemoryUtil.memAddress(bufstreams), bufferMode);
    }

    public static void glTransformFeedbackAttribsNV(int[] attribs, int bufferMode) {
        long __functionAddress = GL.getCapabilities().glTransformFeedbackAttribsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, attribs.length, attribs, bufferMode);
    }

    public static void glTransformFeedbackVaryingsNV(int program, int[] locations, int bufferMode) {
        long __functionAddress = GL.getCapabilities().glTransformFeedbackVaryingsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, locations.length, locations, bufferMode);
    }

    public static void glGetActiveVaryingNV(int program, int index, int[] length, int[] size, int[] type, ByteBuffer name) {
        long __functionAddress = GL.getCapabilities().glGetActiveVaryingNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBufferSafe(length, 1);
            Checks.checkBuffer(size, 1);
            Checks.checkBuffer(type, 1);
        }
        JNI.callPPPPV(__functionAddress, program, index, name.remaining(), length, size, type, MemoryUtil.memAddress(name));
    }

    public static void glGetTransformFeedbackVaryingNV(int program, int index, int[] location) {
        long __functionAddress = GL.getCapabilities().glGetTransformFeedbackVaryingNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(location, 1);
        }
        JNI.callPV(__functionAddress, program, index, location);
    }

    public static void glTransformFeedbackStreamAttribsNV(int[] attribs, int[] bufstreams, int bufferMode) {
        long __functionAddress = GL.getCapabilities().glTransformFeedbackStreamAttribsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, attribs.length, attribs, bufstreams.length, bufstreams, bufferMode);
    }
}

