/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.StructBuffer;

public final class Checks {
    public static final boolean CHECKS = Configuration.DISABLE_CHECKS.get(false) == false;
    public static final boolean DEBUG = Configuration.DEBUG.get(false);
    public static final boolean DEBUG_FUNCTIONS = Configuration.DEBUG_FUNCTIONS.get(false);

    private Checks() {
    }

    public static int lengthSafe(short[] array) {
        return array == null ? 0 : array.length;
    }

    public static int lengthSafe(int[] array) {
        return array == null ? 0 : array.length;
    }

    public static int lengthSafe(long[] array) {
        return array == null ? 0 : array.length;
    }

    public static int remainingSafe(Buffer buffer) {
        return buffer == null ? 0 : buffer.remaining();
    }

    public static int remainingSafe(CustomBuffer<?> buffer) {
        return buffer == null ? 0 : buffer.remaining();
    }

    public static boolean checkFunctions(long ... functions) {
        for (long pointer : functions) {
            if (pointer != 0L) continue;
            return false;
        }
        return true;
    }

    public static long checkFunctionAddress(long pointer) {
        if (pointer == 0L) {
            throw new IllegalStateException("This function is not available.");
        }
        return pointer;
    }

    public static long checkPointer(long pointer) {
        if (pointer == 0L) {
            throw new NullPointerException();
        }
        return pointer;
    }

    public static void checkNT(int[] buf) {
        Checks.checkNT(buf, 0);
    }

    public static void checkNT(int[] buf, int terminator) {
        Checks.checkBuffer(buf, 1);
        if (buf[buf.length - 1] != terminator) {
            throw new IllegalArgumentException("Missing termination");
        }
    }

    public static void checkNT(long[] buf) {
        Checks.checkBuffer(buf, 1);
        if (buf[buf.length - 1] != 0L) {
            throw new IllegalArgumentException("Missing termination");
        }
    }

    public static void checkNT(float[] buf) {
        Checks.checkBuffer(buf, 1);
        if (buf[buf.length - 1] != 0.0f) {
            throw new IllegalArgumentException("Missing termination");
        }
    }

    public static void checkNT1(ByteBuffer buf) {
        Checks.checkBuffer((Buffer)buf, 1);
        if (buf.get(buf.limit() - 1) != 0) {
            throw new IllegalArgumentException("Missing null termination");
        }
    }

    public static void checkNT2(ByteBuffer buf) {
        Checks.checkBuffer((Buffer)buf, 2);
        if (buf.getShort(buf.limit() - 2) != 0) {
            throw new IllegalArgumentException("Missing null termination");
        }
    }

    public static void checkNT(IntBuffer buf) {
        Checks.checkNT(buf, 0);
    }

    public static void checkNT(IntBuffer buf, int terminator) {
        Checks.checkBuffer((Buffer)buf, 1);
        if (buf.get(buf.limit() - 1) != terminator) {
            throw new IllegalArgumentException("Missing termination");
        }
    }

    public static void checkNT(LongBuffer buf) {
        Checks.checkBuffer((Buffer)buf, 1);
        if (buf.get(buf.limit() - 1) != 0L) {
            throw new IllegalArgumentException("Missing termination");
        }
    }

    public static void checkNT(FloatBuffer buf) {
        Checks.checkBuffer((Buffer)buf, 1);
        if (buf.get(buf.limit() - 1) != 0.0f) {
            throw new IllegalArgumentException("Missing termination");
        }
    }

    public static void checkNT(PointerBuffer buf) {
        Checks.checkNT(buf, 0L);
    }

    public static void checkNT(PointerBuffer buf, long terminator) {
        Checks.checkBuffer(buf, 1);
        if (buf.get(buf.limit() - 1) != terminator) {
            throw new IllegalArgumentException("Missing termination");
        }
    }

    public static void checkNTSafe(int[] buf) {
        if (buf != null) {
            Checks.checkNT(buf);
        }
    }

    public static void checkNTSafe(int[] buf, int terminator) {
        if (buf != null) {
            Checks.checkNT(buf, terminator);
        }
    }

    public static void checkNTSafe(long[] buf) {
        if (buf != null) {
            Checks.checkNT(buf);
        }
    }

    public static void checkNTSafe(float[] buf) {
        if (buf != null) {
            Checks.checkNT(buf);
        }
    }

    public static void checkNT1Safe(ByteBuffer buf) {
        if (buf != null) {
            Checks.checkNT1(buf);
        }
    }

    public static void checkNT2Safe(ByteBuffer buf) {
        if (buf != null) {
            Checks.checkNT2(buf);
        }
    }

    public static void checkNTSafe(IntBuffer buf) {
        if (buf != null) {
            Checks.checkNT(buf);
        }
    }

    public static void checkNTSafe(IntBuffer buf, int terminator) {
        if (buf != null) {
            Checks.checkNT(buf, terminator);
        }
    }

    public static void checkNTSafe(LongBuffer buf) {
        if (buf != null) {
            Checks.checkNT(buf);
        }
    }

    public static void checkNTSafe(FloatBuffer buf) {
        if (buf != null) {
            Checks.checkNT(buf);
        }
    }

    public static void checkNTSafe(PointerBuffer buf) {
        if (buf != null) {
            Checks.checkNT(buf);
        }
    }

    public static void checkNTSafe(PointerBuffer buf, long terminator) {
        if (buf != null) {
            Checks.checkNT(buf, terminator);
        }
    }

    public static void checkBuffer(short[] buf, int size) {
        if (buf.length < size) {
            Checks.throwSizeException(buf, size);
        }
    }

    public static void checkBuffer(int[] buf, int size) {
        if (buf.length < size) {
            Checks.throwSizeException(buf, size);
        }
    }

    public static void checkBuffer(long[] buf, int size) {
        if (buf.length < size) {
            Checks.throwSizeException(buf, size);
        }
    }

    public static void checkBuffer(float[] buf, int size) {
        if (buf.length < size) {
            Checks.throwSizeException(buf, size);
        }
    }

    public static void checkBuffer(double[] buf, int size) {
        if (buf.length < size) {
            Checks.throwSizeException(buf, size);
        }
    }

    public static void checkBuffer(CharSequence text, int size) {
        if (text.length() < size) {
            Checks.throwSizeException(text, size);
        }
    }

    public static void checkBuffer(Buffer buf, int size) {
        if (buf.remaining() < size) {
            Checks.throwSizeException(buf, size);
        }
    }

    public static void checkBuffer(Buffer buf, long size) {
        Checks.checkBuffer(buf, (int)size);
    }

    public static void checkBuffer(CustomBuffer<?> buf, int size) {
        if (buf.remaining() < size) {
            Checks.throwSizeException(buf, size);
        }
    }

    public static void checkBuffer(CustomBuffer<?> buf, long size) {
        Checks.checkBuffer(buf, (int)size);
    }

    public static void checkBufferSafe(short[] buf, int size) {
        if (buf != null) {
            Checks.checkBuffer(buf, size);
        }
    }

    public static void checkBufferSafe(int[] buf, int size) {
        if (buf != null) {
            Checks.checkBuffer(buf, size);
        }
    }

    public static void checkBufferSafe(long[] buf, int size) {
        if (buf != null) {
            Checks.checkBuffer(buf, size);
        }
    }

    public static void checkBufferSafe(float[] buf, int size) {
        if (buf != null) {
            Checks.checkBuffer(buf, size);
        }
    }

    public static void checkBufferSafe(double[] buf, int size) {
        if (buf != null) {
            Checks.checkBuffer(buf, size);
        }
    }

    public static void checkBufferSafe(Buffer buf, int size) {
        if (buf != null) {
            Checks.checkBuffer(buf, size);
        }
    }

    public static void checkBufferSafe(Buffer buf, long size) {
        if (buf != null) {
            Checks.checkBuffer(buf, size);
        }
    }

    public static void checkBufferSafe(CustomBuffer<?> buf, int size) {
        if (buf != null) {
            Checks.checkBuffer(buf, size);
        }
    }

    public static void checkArray(Object[] array, int size) {
        if (array.length < size) {
            Checks.throwSizeException(array, size);
        }
    }

    public static void checkBufferGT(Buffer buf, int size) {
        if (size < buf.remaining()) {
            Checks.throwBufferSizeGTException(buf, size);
        }
    }

    public static void checkBufferGT(CustomBuffer<?> buf, int size) {
        if (size < buf.remaining()) {
            Checks.throwBufferSizeGTException(buf, size);
        }
    }

    public static void checkBufferGT(StructBuffer<?, ?> buf, int size) {
        if (size < buf.remaining()) {
            Checks.throwBufferSizeGTException(buf, size);
        }
    }

    private static void throwSizeException(Buffer buf, int size) {
        throw new IllegalArgumentException("Number of remaining buffer elements is " + buf.remaining() + ", must be at least " + size);
    }

    private static void throwSizeException(CustomBuffer<?> buf, int size) {
        throw new IllegalArgumentException("Number of remaining buffer elements is " + buf.remaining() + ", must be at least " + size);
    }

    private static void throwSizeException(Object[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwSizeException(short[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwSizeException(int[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwSizeException(long[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwSizeException(float[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwSizeException(double[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwSizeException(CharSequence text, int size) {
        throw new IllegalArgumentException("Number of characters is " + text.length() + ", must be at least " + size);
    }

    private static void throwBufferSizeGTException(Buffer buf, int size) {
        throw new IllegalArgumentException("Number of remaining buffer elements is " + buf.remaining() + ", must be at most " + size + ".");
    }

    private static void throwBufferSizeGTException(CustomBuffer<?> buf, int size) {
        throw new IllegalArgumentException("Number of remaining buffer elements is " + buf.remaining() + ", must be at most " + size + ".");
    }

    static {
        if (DEBUG_FUNCTIONS && !DEBUG) {
            APIUtil.DEBUG_STREAM.println("[LWJGL] The DEBUG_FUNCTIONS option requires DEBUG to produce output.");
        }
    }
}

