/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.regex.Pattern;
import org.lwjgl.Version;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.SharedLibraryLoader;

public final class Library {
    public static final String JNI_LIBRARY_NAME = Configuration.LIBRARY_NAME.get(System.getProperty("os.arch").contains("64") ? "lwjgl" : "lwjgl32");
    private static final String JAVA_LIBRARY_PATH = "java.library.path";
    private static final Pattern PATH_SEPARATOR = Pattern.compile(File.pathSeparator);

    private Library() {
    }

    public static void initialize() {
    }

    public static void loadSystem(String name) throws UnsatisfiedLinkError {
        String paths;
        String libName;
        block26: {
            APIUtil.apiLog("Loading library (system): " + name);
            if (Paths.get(name, new String[0]).isAbsolute()) {
                System.load(name);
                APIUtil.apiLog("\tSuccess");
                return;
            }
            libName = Platform.get().mapLibraryName(name);
            URL libURL = Library.class.getResource("/" + libName);
            if (libURL == null) {
                if (Library.loadSystem(libName, Configuration.LIBRARY_PATH)) {
                    return;
                }
            } else {
                boolean debugLoader = Configuration.DEBUG_LOADER.get(false);
                try {
                    if (debugLoader) {
                        APIUtil.apiLog("\tUsing SharedLibraryLoader...");
                    }
                    try (FileChannel ignored = SharedLibraryLoader.load(name, libName, libURL);){
                        if (Library.loadSystem(libName, Configuration.LIBRARY_PATH)) {
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    if (!debugLoader) break block26;
                    e.printStackTrace(APIUtil.DEBUG_STREAM);
                }
            }
        }
        if ((paths = System.getProperty(JAVA_LIBRARY_PATH)) != null) {
            try {
                System.loadLibrary(name);
                Path libFile = Library.findLibrary(paths, libName);
                if (libFile != null) {
                    APIUtil.apiLog(String.format("\tLoaded from %s: %s", JAVA_LIBRARY_PATH, libFile));
                    Library.checkHash(libFile);
                }
                return;
            }
            catch (Exception e) {
                APIUtil.apiLog(String.format("\t%s not found in %s=%s", libName, JAVA_LIBRARY_PATH, paths));
            }
        }
        Library.printError();
        throw new UnsatisfiedLinkError("Failed to locate library: " + libName);
    }

    private static boolean loadSystem(String libName, Configuration<String> property) {
        String paths = property.get();
        return paths != null && Library.loadSystem(libName, property.getProperty(), paths);
    }

    private static boolean loadSystem(String libName, String property, String paths) {
        Path libFile = Library.findLibrary(paths, libName);
        if (libFile == null) {
            APIUtil.apiLog(String.format("\t%s not found in %s=%s", libName, property, paths));
            return false;
        }
        System.load(libFile.toAbsolutePath().toString());
        APIUtil.apiLog(String.format("\tLoaded from %s: %s", property, libFile));
        Library.checkHash(libFile);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SharedLibrary loadNative(String name) {
        String paths;
        SharedLibrary lib;
        String libName;
        block22: {
            APIUtil.apiLog("Loading library: " + name);
            if (new File(name).isAbsolute()) {
                SharedLibrary lib2 = APIUtil.apiCreateLibrary(name);
                APIUtil.apiLog("\tSuccess");
                return lib2;
            }
            libName = Platform.get().mapLibraryName(name);
            URL libURL = Library.class.getResource("/" + libName);
            if (libURL == null) {
                lib = Library.loadNative(libName, Configuration.LIBRARY_PATH);
                if (lib != null) {
                    return lib;
                }
            } else {
                boolean debugLoader = Configuration.DEBUG_LOADER.get(false);
                try {
                    if (debugLoader) {
                        APIUtil.apiLog("\tUsing SharedLibraryLoader...");
                    }
                    try (FileChannel ignored = SharedLibraryLoader.load(name, libName, libURL);){
                        SharedLibrary sharedLibrary = Library.loadNative(libName, Configuration.LIBRARY_PATH);
                        return sharedLibrary;
                    }
                }
                catch (Exception e) {
                    if (!debugLoader) break block22;
                    e.printStackTrace(APIUtil.DEBUG_STREAM);
                }
            }
        }
        if ((paths = System.getProperty(JAVA_LIBRARY_PATH)) != null && (lib = Library.loadNative(libName, JAVA_LIBRARY_PATH, paths)) != null) {
            return lib;
        }
        try {
            lib = APIUtil.apiCreateLibrary(libName);
            APIUtil.apiLog("\tLoaded from system paths");
            return lib;
        }
        catch (UnsatisfiedLinkError e) {
            APIUtil.apiLog(String.format("\t%s not found in system paths", libName));
            Library.printError();
            throw new UnsatisfiedLinkError("Failed to locate library: " + libName);
        }
    }

    private static SharedLibrary loadNative(String libName, Configuration<String> property) {
        SharedLibrary lib;
        String paths = property.get();
        if (paths != null && (lib = Library.loadNative(libName, property.getProperty(), paths)) != null) {
            return lib;
        }
        return null;
    }

    private static SharedLibrary loadNative(String libName, String property, String paths) {
        Path libFile = Library.findLibrary(paths, libName);
        if (libFile == null) {
            APIUtil.apiLog(String.format("\t%s not found in %s=%s", libName, property, paths));
            return null;
        }
        SharedLibrary lib = APIUtil.apiCreateLibrary(libFile.toString());
        APIUtil.apiLog(String.format("\tLoaded from %s: %s", property, libFile));
        Library.checkHash(libFile);
        return lib;
    }

    public static SharedLibrary loadNative(Configuration<String> name, String ... defaultNames) {
        SharedLibrary library;
        block8: {
            if (name.get() != null) {
                return Library.loadNative(name.get());
            }
            if (defaultNames.length <= 1) {
                if (defaultNames.length == 0) {
                    throw new RuntimeException("No default names specified.");
                }
                return Library.loadNative(defaultNames[0]);
            }
            library = null;
            try {
                library = Library.loadNative(defaultNames[0]);
            }
            catch (Throwable t) {
                for (int i = 1; i < defaultNames.length; ++i) {
                    try {
                        library = Library.loadNative(defaultNames[i]);
                        break;
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                }
                if (library != null) break block8;
                throw t;
            }
        }
        return library;
    }

    private static Path findLibrary(String path, String libName) {
        for (String directory : PATH_SEPARATOR.split(path)) {
            Path p = Paths.get(directory, libName);
            if (!Files.isExecutable(p)) continue;
            return p;
        }
        return null;
    }

    private static void printError() {
        APIUtil.DEBUG_STREAM.println("[LWJGL] Failed to load a library. Possible solutions:\n\ta) Set -Djava.library.path or -Dorg.lwjgl.librarypath to the directory that contains the shared libraries.\n\tb) Add the JAR(s) containing the shared libraries to the classpath.");
        if (!Checks.DEBUG) {
            APIUtil.DEBUG_STREAM.println("[LWJGL] Enable debug mode with -Dorg.lwjgl.util.Debug=true for better diagnostics.");
            if (!Configuration.DEBUG_LOADER.get(false).booleanValue()) {
                APIUtil.DEBUG_STREAM.println("[LWJGL] Enable the SharedLibraryLoader debug mode with -Dorg.lwjgl.util.DebugLoader=true for better diagnostics.");
            }
        }
    }

    private static void checkHash(Path libFile) {
        block34: {
            if (!Checks.DEBUG) {
                return;
            }
            URL sha1URL = Library.class.getResource("/" + libFile.getFileName() + ".sha1");
            if (sha1URL == null) {
                return;
            }
            try {
                String expected;
                Serializable buffer;
                try (Object sha1 = sha1URL.openStream();){
                    buffer = new StringBuilder(40);
                    for (int i = 0; i < 40; ++i) {
                        ((StringBuilder)buffer).append((char)((InputStream)sha1).read());
                    }
                    expected = ((StringBuilder)buffer).toString();
                }
                sha1 = MessageDigest.getInstance("SHA-1");
                FileChannel fc = FileChannel.open(libFile, new OpenOption[0]);
                buffer = null;
                try {
                    MappedByteBuffer buffer2 = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
                    ((MessageDigest)sha1).update(buffer2);
                }
                catch (Throwable buffer2) {
                    buffer = buffer2;
                    throw buffer2;
                }
                finally {
                    if (fc != null) {
                        if (buffer != null) {
                            try {
                                fc.close();
                            }
                            catch (Throwable buffer2) {
                                ((Throwable)buffer).addSuppressed(buffer2);
                            }
                        } else {
                            fc.close();
                        }
                    }
                }
                byte[] digest = ((MessageDigest)sha1).digest();
                StringBuilder actual = new StringBuilder(40);
                for (int i = 0; i < digest.length; ++i) {
                    int b = digest[i] & 0xFF;
                    if (b < 16) {
                        actual.append('0');
                    }
                    actual.append(Integer.toHexString(b));
                }
                if (!expected.contentEquals(actual)) {
                    APIUtil.DEBUG_STREAM.println("[LWJGL] [WARNING] Mismatch detected between the Java and native libraries.");
                }
            }
            catch (Exception e) {
                if (!Checks.DEBUG) break block34;
                APIUtil.apiLog("Failed to verify native library.");
                e.printStackTrace();
            }
        }
    }

    static {
        if (Checks.DEBUG) {
            APIUtil.apiLog("Version: " + Version.getVersion());
            APIUtil.apiLog("\t OS: " + System.getProperty("os.name") + " v" + System.getProperty("os.version"));
            APIUtil.apiLog("\tJRE: " + System.getProperty("java.version") + " " + System.getProperty("os.arch"));
            APIUtil.apiLog("\tJVM: " + System.getProperty("java.vm.name") + " v" + System.getProperty("java.vm.version") + " by " + System.getProperty("java.vm.vendor"));
        }
        Library.loadSystem(JNI_LIBRARY_NAME);
    }
}

