/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryAccessJNI;
import org.lwjgl.system.MemoryTextUtil;
import org.lwjgl.system.MemoryUtil;
import sun.misc.Unsafe;

final class MemoryAccess {
    private MemoryAccess() {
    }

    static MemoryAccessor getInstance() {
        MemoryAccessor accessor;
        try {
            accessor = new MemoryAccessorUnsafe();
        }
        catch (Throwable t) {
            APIUtil.DEBUG_STREAM.println("[LWJGL] [MemoryAccessor] Unsupported JVM detected, this will likely result in low performance. Please inform LWJGL developers.");
            accessor = new MemoryAccessorJNI();
        }
        return accessor;
    }

    private static native void memset(long var0, int var2, long var3);

    private static native void memcpy(long var0, long var2, long var4);

    static native int getPointerSize();

    static native long getDirectBufferAddress(Buffer var0);

    static native ByteBuffer newDirectByteBuffer(long var0, int var2);

    static Field getDeclaredField(Class<?> root, String fieldName) throws NoSuchFieldException {
        Class<?> type = root;
        while (true) {
            try {
                Field field = type.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                if ((type = type.getSuperclass()) != null) continue;
                throw new NoSuchFieldException(fieldName + " does not exist in " + root.getSimpleName() + " or any of its superclasses.");
            }
            break;
        }
    }

    static Field getField(Buffer buffer, Object value) throws NoSuchFieldException {
        Class<?> type = buffer.getClass();
        do {
            for (Field field : type.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || !field.getType().isAssignableFrom(value.getClass())) continue;
                field.setAccessible(true);
                try {
                    Object fieldValue = field.get(buffer);
                    if (fieldValue != value) continue;
                    return field;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        } while ((type = type.getSuperclass()) != null);
        throw new NoSuchFieldException(String.format("The specified value does not exist as a field in %s or any of its superclasses.", buffer.getClass().getSimpleName()));
    }

    static Unsafe getUnsafeInstance() {
        Field[] fields;
        for (Field field : fields = Unsafe.class.getDeclaredFields()) {
            int modifiers;
            if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
            field.setAccessible(true);
            try {
                return (Unsafe)field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                break;
            }
        }
        throw new UnsupportedOperationException();
    }

    static {
        Library.initialize();
    }

    private static final class MemoryAccessorUnsafe
    implements MemoryAccessor {
        private static final Class<? extends ByteBuffer> BYTE_BUFFER;
        private static final Class<? extends ShortBuffer> SHORT_BUFFER;
        private static final Class<? extends CharBuffer> CHAR_BUFFER;
        private static final Class<? extends IntBuffer> INT_BUFFER;
        private static final Class<? extends LongBuffer> LONG_BUFFER;
        private static final Class<? extends FloatBuffer> FLOAT_BUFFER;
        private static final Class<? extends DoubleBuffer> DOUBLE_BUFFER;
        private static final Unsafe UNSAFE;
        private static final long ADDRESS;
        private static final long CAPACITY;
        private static final long CLEANER;
        private static final long PARENT_BYTE;
        private static final long PARENT_SHORT;
        private static final long PARENT_CHAR;
        private static final long PARENT_INT;
        private static final long PARENT_LONG;
        private static final long PARENT_FLOAT;
        private static final long PARENT_DOUBLE;

        MemoryAccessorUnsafe() {
        }

        @Override
        public int getPageSize() {
            return UNSAFE.pageSize();
        }

        @Override
        public long memAddress0(Buffer buffer) {
            return UNSAFE.getLong(buffer, ADDRESS);
        }

        @Override
        public ByteBuffer memByteBuffer(long address, int capacity) {
            try {
                ByteBuffer buffer = (ByteBuffer)UNSAFE.allocateInstance(BYTE_BUFFER);
                buffer.order(ByteOrder.nativeOrder());
                return this.memSetupBuffer(buffer, address, capacity);
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        public ShortBuffer memShortBuffer(long address, int capacity) {
            try {
                return this.memSetupBuffer((ShortBuffer)UNSAFE.allocateInstance(SHORT_BUFFER), address, capacity);
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        public CharBuffer memCharBuffer(long address, int capacity) {
            try {
                return this.memSetupBuffer((CharBuffer)UNSAFE.allocateInstance(CHAR_BUFFER), address, capacity);
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        public IntBuffer memIntBuffer(long address, int capacity) {
            try {
                return this.memSetupBuffer((IntBuffer)UNSAFE.allocateInstance(INT_BUFFER), address, capacity);
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        public LongBuffer memLongBuffer(long address, int capacity) {
            try {
                return this.memSetupBuffer((LongBuffer)UNSAFE.allocateInstance(LONG_BUFFER), address, capacity);
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        public FloatBuffer memFloatBuffer(long address, int capacity) {
            try {
                return this.memSetupBuffer((FloatBuffer)UNSAFE.allocateInstance(FLOAT_BUFFER), address, capacity);
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        public DoubleBuffer memDoubleBuffer(long address, int capacity) {
            try {
                return this.memSetupBuffer((DoubleBuffer)UNSAFE.allocateInstance(DOUBLE_BUFFER), address, capacity);
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        private static <T extends Buffer> T setup(T buffer, long address, int capacity, long parentField) {
            UNSAFE.putLong(buffer, ADDRESS, address);
            UNSAFE.putInt(buffer, CAPACITY, capacity);
            UNSAFE.putObject(buffer, parentField, null);
            buffer.clear();
            return buffer;
        }

        @Override
        public ByteBuffer memSetupBuffer(ByteBuffer buffer, long address, int capacity) {
            if (Checks.DEBUG && UNSAFE.getObject(buffer, CLEANER) != null) {
                throw new IllegalArgumentException("Instances created through ByteBuffer.allocateDirect cannot be modified.");
            }
            return MemoryAccessorUnsafe.setup(buffer, address, capacity, PARENT_BYTE);
        }

        @Override
        public ShortBuffer memSetupBuffer(ShortBuffer buffer, long address, int capacity) {
            return MemoryAccessorUnsafe.setup(buffer, address, capacity, PARENT_SHORT);
        }

        @Override
        public CharBuffer memSetupBuffer(CharBuffer buffer, long address, int capacity) {
            return MemoryAccessorUnsafe.setup(buffer, address, capacity, PARENT_CHAR);
        }

        @Override
        public IntBuffer memSetupBuffer(IntBuffer buffer, long address, int capacity) {
            return MemoryAccessorUnsafe.setup(buffer, address, capacity, PARENT_INT);
        }

        @Override
        public LongBuffer memSetupBuffer(LongBuffer buffer, long address, int capacity) {
            return MemoryAccessorUnsafe.setup(buffer, address, capacity, PARENT_LONG);
        }

        @Override
        public FloatBuffer memSetupBuffer(FloatBuffer buffer, long address, int capacity) {
            return MemoryAccessorUnsafe.setup(buffer, address, capacity, PARENT_FLOAT);
        }

        @Override
        public DoubleBuffer memSetupBuffer(DoubleBuffer buffer, long address, int capacity) {
            return MemoryAccessorUnsafe.setup(buffer, address, capacity, PARENT_DOUBLE);
        }

        private static long shl(long value, int bytes) {
            if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
                return value << (bytes << 3);
            }
            return value >>> (bytes << 3);
        }

        private static long shr(long value, int bytes) {
            if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
                return value >>> (bytes << 3);
            }
            return value << (bytes << 3);
        }

        private static long merge(long a, long b, long mask) {
            return a ^ (a ^ b) & mask;
        }

        private static long fill(byte value) {
            long fill = value;
            if (value != 0) {
                fill |= fill << 8;
                fill |= fill << 16;
                fill |= fill << 32;
            }
            return fill;
        }

        @Override
        public void memSet(long dst, int value, int bytes) {
            if (bytes < 192) {
                this.memSetLoop(dst, (byte)(value & 0xFF), bytes);
            } else {
                MemoryAccess.memset(dst, value, bytes);
            }
        }

        private void memSetLoop(long dst, byte value, int bytes) {
            int i = 0;
            int misalignment = (int)dst & 7;
            long fill = MemoryAccessorUnsafe.fill(value);
            if (8 <= bytes) {
                if (misalignment != 0) {
                    this.memPutLong(dst - (long)misalignment, MemoryAccessorUnsafe.merge(this.memGetLong(dst - (long)misalignment), fill, MemoryAccessorUnsafe.shr(-1L, misalignment)));
                    i += 8 - misalignment;
                }
                while (i <= bytes - 8) {
                    this.memPutLong(dst + (long)i, fill);
                    i += 8;
                }
            } else if (misalignment != 0 && 0 < bytes) {
                this.memPutLong(dst - (long)misalignment, MemoryAccessorUnsafe.merge(this.memGetLong(dst - (long)misalignment), fill, MemoryAccessorUnsafe.shr(MemoryAccessorUnsafe.shl(-1L, 8 - bytes), misalignment)));
                i += 8 - misalignment;
            }
            if (i < bytes) {
                this.memPutLong(dst + (long)i, MemoryAccessorUnsafe.merge(this.memGetLong(dst + (long)i), fill, MemoryAccessorUnsafe.shl(-1L, 8 - (bytes - i))));
            }
        }

        @Override
        public void memCopy(long src, long dst, int bytes) {
            if (bytes < 64 && ((int)src & 7) == 0 && ((int)dst & 7) == 0) {
                this.memCopyAligned(src, dst, bytes);
            } else if (bytes < 384) {
                UNSAFE.copyMemory(src, dst, bytes);
            } else {
                MemoryAccess.memcpy(dst, src, bytes);
            }
        }

        private void memCopyAligned(long src, long dst, int bytes) {
            int i;
            for (i = 0; i <= bytes - 8; i += 8) {
                this.memPutLong(dst + (long)i, this.memGetLong(src + (long)i));
            }
            if (i < bytes) {
                this.memPutLong(dst + (long)i, MemoryAccessorUnsafe.merge(this.memGetLong(dst + (long)i), this.memGetLong(src + (long)i), MemoryAccessorUnsafe.shl(-1L, 8 - (bytes - i))));
            }
        }

        @Override
        public byte memGetByte(long ptr) {
            return UNSAFE.getByte(ptr);
        }

        @Override
        public short memGetShort(long ptr) {
            return UNSAFE.getShort(ptr);
        }

        @Override
        public int memGetInt(long ptr) {
            return UNSAFE.getInt(ptr);
        }

        @Override
        public long memGetLong(long ptr) {
            return UNSAFE.getLong(ptr);
        }

        @Override
        public float memGetFloat(long ptr) {
            return UNSAFE.getFloat(ptr);
        }

        @Override
        public double memGetDouble(long ptr) {
            return UNSAFE.getDouble(ptr);
        }

        @Override
        public long memGetAddress(long ptr) {
            return UNSAFE.getAddress(ptr);
        }

        @Override
        public void memPutByte(long ptr, byte value) {
            UNSAFE.putByte(ptr, value);
        }

        @Override
        public void memPutShort(long ptr, short value) {
            UNSAFE.putShort(ptr, value);
        }

        @Override
        public void memPutInt(long ptr, int value) {
            UNSAFE.putInt(ptr, value);
        }

        @Override
        public void memPutLong(long ptr, long value) {
            UNSAFE.putLong(ptr, value);
        }

        @Override
        public void memPutFloat(long ptr, float value) {
            UNSAFE.putFloat(ptr, value);
        }

        @Override
        public void memPutDouble(long ptr, double value) {
            UNSAFE.putDouble(ptr, value);
        }

        @Override
        public void memPutAddress(long ptr, long value) {
            UNSAFE.putAddress(ptr, value);
        }

        @Override
        public MemoryTextUtil getTextUtil() {
            return new MemoryTextUtil(){

                @Override
                int strlen64NT1(long address, int maxLength) {
                    int i;
                    if (8 <= maxLength) {
                        long v;
                        int misalignment = (int)address & 7;
                        if (misalignment != 0) {
                            int len = 8 - misalignment;
                            for (i = 0; i < len; ++i) {
                                if (this.memGetByte(address + (long)i) != 0) continue;
                                return i;
                            }
                        }
                        while (((v = this.memGetLong(address + (long)i)) - 0x101010101010101L & (v ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L) == 0L && (i += 8) <= maxLength - 8) {
                        }
                    }
                    while (i < maxLength && this.memGetByte(address + (long)i) != 0) {
                        ++i;
                    }
                    return i;
                }

                @Override
                int strlen64NT2(long address, int maxLength) {
                    int i;
                    if (8 <= maxLength) {
                        long v;
                        int misalignment = (int)address & 7;
                        if (misalignment != 0) {
                            int len = 8 - misalignment;
                            for (i = 0; i < len; i += 2) {
                                if (this.memGetShort(address + (long)i) != 0) continue;
                                return i;
                            }
                        }
                        while (((v = this.memGetLong(address + (long)i)) - 0x1000100010001L & (v ^ 0xFFFFFFFFFFFFFFFFL) & 0x8000800080008000L) == 0L && (i += 8) <= maxLength - 8) {
                        }
                    }
                    while (i < maxLength && this.memGetShort(address + (long)i) != 0) {
                        i += 2;
                    }
                    return i;
                }

                @Override
                int strlen32NT1(long address, int maxLength) {
                    int i;
                    if (4 <= maxLength) {
                        int v;
                        int misalignment = (int)address & 3;
                        if (misalignment != 0) {
                            int len = 4 - misalignment;
                            for (i = 0; i < len; ++i) {
                                if (this.memGetByte(address + (long)i) != 0) continue;
                                return i;
                            }
                        }
                        while (((v = this.memGetInt(address + (long)i)) - 0x1010101 & ~v & 0x80808080) == 0 && (i += 4) <= maxLength - 4) {
                        }
                    }
                    while (i < maxLength && this.memGetByte(address + (long)i) != 0) {
                        ++i;
                    }
                    return i;
                }

                @Override
                int strlen32NT2(long address, int maxLength) {
                    int i;
                    if (4 <= maxLength) {
                        int v;
                        int misalignment = (int)address & 3;
                        if (misalignment != 0) {
                            int len = 4 - misalignment;
                            for (i = 0; i < len; i += 2) {
                                if (this.memGetShort(address + (long)i) != 0) continue;
                                return i;
                            }
                        }
                        while (((v = this.memGetInt(address + (long)i)) - 65537 & ~v & 0x80008000) == 0 && (i += 4) <= maxLength - 4) {
                        }
                    }
                    while (i < maxLength && this.memGetShort(address + (long)i) != 0) {
                        i += 2;
                    }
                    return i;
                }

                @Override
                int encodeASCII(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
                    return this.encodeASCII(text, nullTerminated, MemoryUtil.memAddress(target) + (long)offset);
                }

                private int encodeASCII(CharSequence text, boolean nullTerminated, long target) {
                    int p;
                    int len = text.length();
                    for (p = 0; p < len; ++p) {
                        this.memPutByte(target + (long)p, (byte)text.charAt(p));
                    }
                    if (nullTerminated) {
                        this.memPutByte(target + (long)p++, (byte)0);
                    }
                    return p;
                }

                @Override
                int encodeUTF8(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
                    return this.encodeUTF8(text, nullTerminated, MemoryUtil.memAddress(target) + (long)offset);
                }

                private int encodeUTF8(CharSequence text, boolean nullTerminated, long target) {
                    int c;
                    int i;
                    int len = text.length();
                    int p = 0;
                    for (i = 0; i < len && (c = text.charAt(i)) < 128; ++i) {
                        this.memPutByte(target + (long)p++, (byte)c);
                    }
                    while (i < len) {
                        if ((c = text.charAt(i++)) < 128) {
                            this.memPutByte(target + (long)p++, (byte)c);
                            continue;
                        }
                        int cp = c;
                        if (c < 2048) {
                            this.memPutByte(target + (long)p++, (byte)(0xC0 | cp >> 6));
                        } else {
                            if (!Character.isHighSurrogate((char)c)) {
                                this.memPutByte(target + (long)p++, (byte)(0xE0 | cp >> 12));
                            } else {
                                cp = Character.toCodePoint((char)c, text.charAt(i++));
                                this.memPutByte(target + (long)p++, (byte)(0xF0 | cp >> 18));
                                this.memPutByte(target + (long)p++, (byte)(0x80 | cp >> 12 & 0x3F));
                            }
                            this.memPutByte(target + (long)p++, (byte)(0x80 | cp >> 6 & 0x3F));
                        }
                        this.memPutByte(target + (long)p++, (byte)(0x80 | cp & 0x3F));
                    }
                    if (nullTerminated) {
                        this.memPutByte(target + (long)p, (byte)0);
                    }
                    return p;
                }

                @Override
                int encodeUTF16(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
                    return this.encodeUTF16(text, nullTerminated, MemoryUtil.memAddress(target) + (long)offset);
                }

                private int encodeUTF16(CharSequence text, boolean nullTerminated, long target) {
                    int p = 0;
                    int len = text.length();
                    int i = 0;
                    while (i < len) {
                        this.memPutShort(target + (long)p, (short)text.charAt(i));
                        ++i;
                        p += 2;
                    }
                    if (nullTerminated) {
                        this.memPutShort(target + (long)p, (short)0);
                        p += 2;
                    }
                    return p;
                }
            };
        }

        static {
            ByteBuffer bb = ByteBuffer.allocateDirect(0).order(ByteOrder.nativeOrder());
            ShortBuffer sb = bb.asShortBuffer();
            CharBuffer cb = bb.asCharBuffer();
            IntBuffer ib = bb.asIntBuffer();
            LongBuffer lb = bb.asLongBuffer();
            FloatBuffer fb = bb.asFloatBuffer();
            DoubleBuffer db = bb.asDoubleBuffer();
            BYTE_BUFFER = bb.getClass();
            SHORT_BUFFER = sb.getClass();
            CHAR_BUFFER = cb.getClass();
            INT_BUFFER = ib.getClass();
            LONG_BUFFER = lb.getClass();
            FLOAT_BUFFER = fb.getClass();
            DOUBLE_BUFFER = db.getClass();
            try {
                UNSAFE = MemoryAccess.getUnsafeInstance();
                ADDRESS = UNSAFE.objectFieldOffset(MemoryAccess.getDeclaredField(Buffer.class, "address"));
                CAPACITY = UNSAFE.objectFieldOffset(MemoryAccess.getDeclaredField(Buffer.class, "capacity"));
                CLEANER = UNSAFE.objectFieldOffset(MemoryAccess.getDeclaredField(BYTE_BUFFER, "cleaner"));
                PARENT_BYTE = UNSAFE.objectFieldOffset(MemoryAccess.getField(bb.slice(), bb));
                PARENT_SHORT = UNSAFE.objectFieldOffset(MemoryAccess.getField(sb, bb));
                PARENT_CHAR = UNSAFE.objectFieldOffset(MemoryAccess.getField(cb, bb));
                PARENT_INT = UNSAFE.objectFieldOffset(MemoryAccess.getField(ib, bb));
                PARENT_LONG = UNSAFE.objectFieldOffset(MemoryAccess.getField(lb, bb));
                PARENT_FLOAT = UNSAFE.objectFieldOffset(MemoryAccess.getField(fb, bb));
                PARENT_DOUBLE = UNSAFE.objectFieldOffset(MemoryAccess.getField(db, bb));
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    private static final class MemoryAccessorJNI
    implements MemoryAccessor {
        private MemoryAccessorJNI() {
        }
    }

    static interface MemoryAccessor {
        default public int getPageSize() {
            return 4096;
        }

        default public int getCacheLineSize() {
            return 64;
        }

        default public long memAddress0(Buffer buffer) {
            return MemoryAccess.getDirectBufferAddress(buffer);
        }

        default public ByteBuffer memByteBuffer(long address, int capacity) {
            return MemoryAccess.newDirectByteBuffer(address, capacity).order(ByteOrder.nativeOrder());
        }

        default public ShortBuffer memShortBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 1).asShortBuffer();
        }

        default public CharBuffer memCharBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 1).asCharBuffer();
        }

        default public IntBuffer memIntBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 2).asIntBuffer();
        }

        default public LongBuffer memLongBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 3).asLongBuffer();
        }

        default public FloatBuffer memFloatBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 2).asFloatBuffer();
        }

        default public DoubleBuffer memDoubleBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 3).asDoubleBuffer();
        }

        default public ByteBuffer memSetupBuffer(ByteBuffer buffer, long address, int capacity) {
            return this.memByteBuffer(address, capacity);
        }

        default public ShortBuffer memSetupBuffer(ShortBuffer buffer, long address, int capacity) {
            return this.memShortBuffer(address, capacity);
        }

        default public CharBuffer memSetupBuffer(CharBuffer buffer, long address, int capacity) {
            return this.memCharBuffer(address, capacity);
        }

        default public IntBuffer memSetupBuffer(IntBuffer buffer, long address, int capacity) {
            return this.memIntBuffer(address, capacity);
        }

        default public LongBuffer memSetupBuffer(LongBuffer buffer, long address, int capacity) {
            return this.memLongBuffer(address, capacity);
        }

        default public FloatBuffer memSetupBuffer(FloatBuffer buffer, long address, int capacity) {
            return this.memFloatBuffer(address, capacity);
        }

        default public DoubleBuffer memSetupBuffer(DoubleBuffer buffer, long address, int capacity) {
            return this.memDoubleBuffer(address, capacity);
        }

        default public void memSet(long dst, int value, int bytes) {
            MemoryAccess.memset(dst, value, bytes);
        }

        default public void memCopy(long src, long dst, int bytes) {
            MemoryAccess.memcpy(dst, src, bytes);
        }

        default public byte memGetByte(long ptr) {
            return MemoryAccessJNI.getByte(ptr);
        }

        default public short memGetShort(long ptr) {
            return MemoryAccessJNI.getShort(ptr);
        }

        default public int memGetInt(long ptr) {
            return MemoryAccessJNI.getInt(ptr);
        }

        default public long memGetLong(long ptr) {
            return MemoryAccessJNI.getLong(ptr);
        }

        default public float memGetFloat(long ptr) {
            return MemoryAccessJNI.getFloat(ptr);
        }

        default public double memGetDouble(long ptr) {
            return MemoryAccessJNI.getDouble(ptr);
        }

        default public long memGetAddress(long ptr) {
            return MemoryAccessJNI.getAddress(ptr);
        }

        default public void memPutByte(long ptr, byte value) {
            MemoryAccessJNI.putByte(ptr, value);
        }

        default public void memPutShort(long ptr, short value) {
            MemoryAccessJNI.putShort(ptr, value);
        }

        default public void memPutInt(long ptr, int value) {
            MemoryAccessJNI.putInt(ptr, value);
        }

        default public void memPutLong(long ptr, long value) {
            MemoryAccessJNI.putLong(ptr, value);
        }

        default public void memPutFloat(long ptr, float value) {
            MemoryAccessJNI.putFloat(ptr, value);
        }

        default public void memPutDouble(long ptr, double value) {
            MemoryAccessJNI.putDouble(ptr, value);
        }

        default public void memPutAddress(long ptr, long value) {
            MemoryAccessJNI.putAddress(ptr, value);
        }

        default public MemoryTextUtil getTextUtil() {
            return new MemoryTextUtil();
        }
    }
}

