/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;

class MemoryAccessJNI {
    static final long malloc;
    static final long calloc;
    static final long realloc;
    static final long free;
    static final long aligned_alloc;
    static final long aligned_free;

    private MemoryAccessJNI() {
        throw new UnsupportedOperationException();
    }

    private static native long malloc();

    private static native long calloc();

    private static native long realloc();

    private static native long free();

    private static native long aligned_alloc();

    private static native long aligned_free();

    static native byte ngetByte(long var0);

    static byte getByte(long ptr) {
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        return MemoryAccessJNI.ngetByte(ptr);
    }

    static native short ngetShort(long var0);

    static short getShort(long ptr) {
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        return MemoryAccessJNI.ngetShort(ptr);
    }

    static native int ngetInt(long var0);

    static int getInt(long ptr) {
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        return MemoryAccessJNI.ngetInt(ptr);
    }

    static native long ngetLong(long var0);

    static long getLong(long ptr) {
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        return MemoryAccessJNI.ngetLong(ptr);
    }

    static native float ngetFloat(long var0);

    static float getFloat(long ptr) {
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        return MemoryAccessJNI.ngetFloat(ptr);
    }

    static native double ngetDouble(long var0);

    static double getDouble(long ptr) {
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        return MemoryAccessJNI.ngetDouble(ptr);
    }

    static native long ngetAddress(long var0);

    static long getAddress(long ptr) {
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        return MemoryAccessJNI.ngetAddress(ptr);
    }

    static native void nputByte(long var0, byte var2);

    static void putByte(long ptr, byte value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        MemoryAccessJNI.nputByte(ptr, value);
    }

    static native void nputShort(long var0, short var2);

    static void putShort(long ptr, short value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        MemoryAccessJNI.nputShort(ptr, value);
    }

    static native void nputInt(long var0, int var2);

    static void putInt(long ptr, int value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        MemoryAccessJNI.nputInt(ptr, value);
    }

    static native void nputLong(long var0, long var2);

    static void putLong(long ptr, long value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        MemoryAccessJNI.nputLong(ptr, value);
    }

    static native void nputFloat(long var0, float var2);

    static void putFloat(long ptr, float value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        MemoryAccessJNI.nputFloat(ptr, value);
    }

    static native void nputDouble(long var0, double var2);

    static void putDouble(long ptr, double value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        MemoryAccessJNI.nputDouble(ptr, value);
    }

    static native void nputAddress(long var0, long var2);

    static void putAddress(long ptr, long value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        MemoryAccessJNI.nputAddress(ptr, value);
    }

    static {
        Library.initialize();
        malloc = MemoryAccessJNI.malloc();
        calloc = MemoryAccessJNI.calloc();
        realloc = MemoryAccessJNI.realloc();
        free = MemoryAccessJNI.free();
        aligned_alloc = MemoryAccessJNI.aligned_alloc();
        aligned_free = MemoryAccessJNI.aligned_free();
    }
}

