/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.MemoryAccessJNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.libc.Stdlib;

final class MemoryManage {
    private MemoryManage() {
    }

    static MemoryUtil.MemoryAllocator getInstance() {
        Object allocator = Configuration.MEMORY_ALLOCATOR.get("jemalloc");
        if (allocator instanceof MemoryUtil.MemoryAllocator) {
            return (MemoryUtil.MemoryAllocator)allocator;
        }
        if (!"system".equals(allocator)) {
            String className = "jemalloc".equals(allocator) ? "org.lwjgl.system.jemalloc.JEmallocAllocator" : allocator.toString();
            try {
                Class<?> allocatorClass = Class.forName(className);
                return (MemoryUtil.MemoryAllocator)allocatorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                if (Checks.DEBUG) {
                    t.printStackTrace(APIUtil.DEBUG_STREAM);
                }
                APIUtil.apiLog(String.format("Failed to instantiate memory allocator: %s", className));
            }
        }
        return new StdlibAllocator();
    }

    static class DebugAllocator
    implements MemoryUtil.MemoryAllocator {
        private static final ConcurrentMap<Long, Allocation> ALLOCATIONS = new ConcurrentHashMap<Long, Allocation>();
        private static final ConcurrentMap<Long, String> THREADS = new ConcurrentHashMap<Long, String>();
        private final MemoryUtil.MemoryAllocator allocator;

        DebugAllocator(MemoryUtil.MemoryAllocator allocator) {
            this.allocator = allocator;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (ALLOCATIONS.isEmpty()) {
                        return;
                    }
                    for (Map.Entry entry : ALLOCATIONS.entrySet()) {
                        Long address = (Long)entry.getKey();
                        Allocation allocation = (Allocation)entry.getValue();
                        APIUtil.DEBUG_STREAM.format("[LWJGL] %d bytes leaked, thread %d (%s), address: 0x%s\n", allocation.size, allocation.threadId, THREADS.get(allocation.threadId), Long.toHexString(address).toUpperCase());
                        for (StackTraceElement el : allocation.stackTrace) {
                            APIUtil.DEBUG_STREAM.format("\tat %s\n", el.toString());
                        }
                    }
                }
            });
        }

        @Override
        public long getMalloc() {
            return this.allocator.getMalloc();
        }

        @Override
        public long getCalloc() {
            return this.allocator.getCalloc();
        }

        @Override
        public long getRealloc() {
            return this.allocator.getRealloc();
        }

        @Override
        public long getFree() {
            return this.allocator.getFree();
        }

        @Override
        public long getAlignedAlloc() {
            return this.allocator.getAlignedAlloc();
        }

        @Override
        public long getAlignedFree() {
            return this.allocator.getAlignedFree();
        }

        @Override
        public long malloc(long size) {
            return DebugAllocator.track(this.allocator.malloc(size), size);
        }

        @Override
        public long calloc(long num, long size) {
            return DebugAllocator.track(this.allocator.calloc(num, size), num * size);
        }

        @Override
        public long realloc(long ptr, long size) {
            long address = this.allocator.realloc(ptr, size);
            if (size == 0L) {
                if (ptr != 0L) {
                    DebugAllocator.untrack(ptr);
                }
            } else if (address != 0L) {
                if (ptr != 0L) {
                    DebugAllocator.untrack(ptr);
                }
                DebugAllocator.track(address, size);
            }
            return address;
        }

        @Override
        public void free(long ptr) {
            this.allocator.free(ptr);
            DebugAllocator.untrack(ptr);
        }

        @Override
        public long aligned_alloc(long alignment, long size) {
            return DebugAllocator.track(this.allocator.aligned_alloc(alignment, size), size);
        }

        @Override
        public void aligned_free(long ptr) {
            this.allocator.aligned_free(ptr);
            DebugAllocator.untrack(ptr);
        }

        static long track(long address, long size) {
            if (address != 0L) {
                int depth;
                Thread t = Thread.currentThread();
                Long threadId = t.getId();
                if (!THREADS.containsKey(threadId)) {
                    THREADS.put(threadId, t.getName());
                }
                StackTraceElement[] stackTrace = t.getStackTrace();
                for (depth = Math.min(stackTrace.length, 4); depth < stackTrace.length && "org.lwjgl.system.MemoryUtil".equals(stackTrace[depth].getClassName()); ++depth) {
                }
                Allocation allocation = ALLOCATIONS.put(address, new Allocation(Arrays.copyOfRange(stackTrace, depth, stackTrace.length), size));
                if (allocation != null) {
                    throw new IllegalStateException("The memory address specified is already being tracked");
                }
            }
            return address;
        }

        static void untrack(long address) {
            if (address == 0L) {
                return;
            }
            Allocation allocation = (Allocation)ALLOCATIONS.remove(address);
            if (allocation == null) {
                throw new IllegalStateException("The memory address specified is not being tracked");
            }
        }

        static void report(MemoryUtil.MemoryAllocationReport report) {
            for (Allocation allocation : ALLOCATIONS.values()) {
                report.invoke(allocation.size, allocation.threadId, (String)THREADS.get(allocation.threadId), allocation.stackTrace);
            }
        }

        private static <T> void aggregate(T t, long size, Map<T, AtomicLong> map) {
            AtomicLong node = map.get(t);
            if (node == null) {
                node = new AtomicLong();
                map.put(t, node);
            }
            node.set(node.get() + size);
        }

        static void report(MemoryUtil.MemoryAllocationReport report, MemoryUtil.MemoryAllocationReport.Aggregate groupByStackTrace, boolean groupByThread) {
            switch (groupByStackTrace) {
                case ALL: {
                    if (groupByThread) {
                        HashMap mapThread = new HashMap();
                        for (Allocation allocation : ALLOCATIONS.values()) {
                            DebugAllocator.aggregate(allocation.threadId, allocation.size, mapThread);
                        }
                        for (Map.Entry entry : mapThread.entrySet()) {
                            report.invoke(((AtomicLong)entry.getValue()).get(), (Long)entry.getKey(), (String)THREADS.get(entry.getKey()), null);
                        }
                        break;
                    }
                    long total = 0L;
                    for (Allocation allocation : ALLOCATIONS.values()) {
                        total += allocation.size;
                    }
                    report.invoke(total, 0L, null, null);
                    break;
                }
                case GROUP_BY_METHOD: {
                    if (groupByThread) {
                        HashMap mapThreadMethod = new HashMap();
                        for (Allocation allocation : ALLOCATIONS.values()) {
                            HashMap mapMethod = (HashMap)mapThreadMethod.get(allocation.threadId);
                            if (mapMethod == null) {
                                mapMethod = new HashMap();
                                mapThreadMethod.put(allocation.threadId, mapMethod);
                            }
                            DebugAllocator.aggregate(allocation.stackTrace[0], allocation.size, mapMethod);
                        }
                        for (Map.Entry entry : mapThreadMethod.entrySet()) {
                            long threadId = (Long)entry.getKey();
                            Map mapmapMethod = (Map)entry.getValue();
                            for (Map.Entry ms : mapmapMethod.entrySet()) {
                                report.invoke(((AtomicLong)ms.getValue()).get(), threadId, (String)THREADS.get(threadId), (StackTraceElement)ms.getKey());
                            }
                        }
                    } else {
                        HashMap mapMethod = new HashMap();
                        for (Allocation allocation : ALLOCATIONS.values()) {
                            DebugAllocator.aggregate(allocation.stackTrace[0], allocation.size, mapMethod);
                        }
                        for (Map.Entry entry : mapMethod.entrySet()) {
                            report.invoke(((AtomicLong)entry.getValue()).get(), 0L, null, (StackTraceElement)entry.getKey());
                        }
                    }
                    break;
                }
                case GROUP_BY_STACKTRACE: {
                    if (groupByThread) {
                        HashMap mapThreadStackTrace = new HashMap();
                        for (Allocation allocation : ALLOCATIONS.values()) {
                            HashMap mapStackTrace = (HashMap)mapThreadStackTrace.get(allocation.threadId);
                            if (mapStackTrace == null) {
                                mapStackTrace = new HashMap();
                                mapThreadStackTrace.put(allocation.threadId, mapStackTrace);
                            }
                            DebugAllocator.aggregate(allocation, allocation.size, mapStackTrace);
                        }
                        for (Map.Entry entry : mapThreadStackTrace.entrySet()) {
                            long threadId = (Long)entry.getKey();
                            Map mapStackTrace = (Map)entry.getValue();
                            for (Map.Entry ss : mapStackTrace.entrySet()) {
                                report.invoke(((AtomicLong)ss.getValue()).get(), threadId, (String)THREADS.get(threadId), ((Allocation)ss.getKey()).stackTrace);
                            }
                        }
                    } else {
                        HashMap mapStackTrace = new HashMap();
                        for (Allocation allocation : ALLOCATIONS.values()) {
                            DebugAllocator.aggregate(allocation, allocation.size, mapStackTrace);
                        }
                        for (Map.Entry entry : mapStackTrace.entrySet()) {
                            report.invoke(((AtomicLong)entry.getValue()).get(), 0L, null, ((Allocation)entry.getKey()).stackTrace);
                        }
                    }
                    break;
                }
            }
        }

        private static class Allocation {
            final StackTraceElement[] stackTrace;
            final long size;
            final long threadId;

            Allocation(StackTraceElement[] stackTrace, long size) {
                this.stackTrace = stackTrace;
                this.size = size;
                this.threadId = Thread.currentThread().getId();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Allocation that = (Allocation)o;
                return Arrays.equals(this.stackTrace, that.stackTrace);
            }

            public int hashCode() {
                return Arrays.hashCode(this.stackTrace);
            }
        }
    }

    private static class StdlibAllocator
    implements MemoryUtil.MemoryAllocator {
        private StdlibAllocator() {
        }

        @Override
        public long getMalloc() {
            return MemoryAccessJNI.malloc;
        }

        @Override
        public long getCalloc() {
            return MemoryAccessJNI.calloc;
        }

        @Override
        public long getRealloc() {
            return MemoryAccessJNI.realloc;
        }

        @Override
        public long getFree() {
            return MemoryAccessJNI.free;
        }

        @Override
        public long getAlignedAlloc() {
            return MemoryAccessJNI.aligned_alloc;
        }

        @Override
        public long getAlignedFree() {
            return MemoryAccessJNI.aligned_free;
        }

        @Override
        public long malloc(long size) {
            return Stdlib.nmalloc(size);
        }

        @Override
        public long calloc(long num, long size) {
            return Stdlib.ncalloc(num, size);
        }

        @Override
        public long realloc(long ptr, long size) {
            return Stdlib.nrealloc(ptr, size);
        }

        @Override
        public void free(long ptr) {
            Stdlib.nfree(ptr);
        }

        @Override
        public long aligned_alloc(long alignment, long size) {
            return Stdlib.naligned_alloc(alignment, size);
        }

        @Override
        public void aligned_free(long ptr) {
            Stdlib.naligned_free(ptr);
        }
    }
}

