/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.dyncall;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class DynLoad {
    protected DynLoad() {
        throw new UnsupportedOperationException();
    }

    public static native long ndlLoadLibrary(long var0);

    public static long dlLoadLibrary(ByteBuffer libpath) {
        if (Checks.CHECKS) {
            Checks.checkNT1(libpath);
        }
        return DynLoad.ndlLoadLibrary(MemoryUtil.memAddress(libpath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long dlLoadLibrary(CharSequence libpath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer libpathEncoded = stack.ASCII(libpath);
            long l = DynLoad.ndlLoadLibrary(MemoryUtil.memAddress(libpathEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void ndlFreeLibrary(long var0);

    public static void dlFreeLibrary(long pLib) {
        if (Checks.CHECKS) {
            Checks.checkPointer(pLib);
        }
        DynLoad.ndlFreeLibrary(pLib);
    }

    public static native long ndlFindSymbol(long var0, long var2);

    public static long dlFindSymbol(long pLib, ByteBuffer pSymbolName) {
        if (Checks.CHECKS) {
            Checks.checkPointer(pLib);
            Checks.checkNT1(pSymbolName);
        }
        return DynLoad.ndlFindSymbol(pLib, MemoryUtil.memAddress(pSymbolName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long dlFindSymbol(long pLib, CharSequence pSymbolName) {
        if (Checks.CHECKS) {
            Checks.checkPointer(pLib);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pSymbolNameEncoded = stack.ASCII(pSymbolName);
            long l = DynLoad.ndlFindSymbol(pLib, MemoryUtil.memAddress(pSymbolNameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long ndlSymsInit(long var0);

    public static long dlSymsInit(ByteBuffer libPath) {
        if (Checks.CHECKS) {
            Checks.checkNT1(libPath);
        }
        return DynLoad.ndlSymsInit(MemoryUtil.memAddress(libPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long dlSymsInit(CharSequence libPath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer libPathEncoded = stack.ASCII(libPath);
            long l = DynLoad.ndlSymsInit(MemoryUtil.memAddress(libPathEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void ndlSymsCleanup(long var0);

    public static void dlSymsCleanup(long pSyms) {
        if (Checks.CHECKS) {
            Checks.checkPointer(pSyms);
        }
        DynLoad.ndlSymsCleanup(pSyms);
    }

    public static native int ndlSymsCount(long var0);

    public static int dlSymsCount(long pSyms) {
        if (Checks.CHECKS) {
            Checks.checkPointer(pSyms);
        }
        return DynLoad.ndlSymsCount(pSyms);
    }

    public static native long ndlSymsName(long var0, int var2);

    public static String dlSymsName(long pSyms, int index) {
        if (Checks.CHECKS) {
            Checks.checkPointer(pSyms);
        }
        long __result = DynLoad.ndlSymsName(pSyms, index);
        return MemoryUtil.memASCII(__result);
    }

    public static native long ndlSymsNameFromValue(long var0, long var2);

    public static String dlSymsNameFromValue(long pSyms, long value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(pSyms);
            Checks.checkPointer(value);
        }
        long __result = DynLoad.ndlSymsNameFromValue(pSyms, value);
        return MemoryUtil.memASCII(__result);
    }

    static {
        Library.initialize();
    }
}

