/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libc;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class Stdio {
    public static final long sscanf;
    public static final long sprintf;
    public static final long snprintf;

    protected Stdio() {
        throw new UnsupportedOperationException();
    }

    private static native long sscanf();

    public static native int nvsscanf(long var0, long var2, long var4);

    public static int vsscanf(ByteBuffer buffer, ByteBuffer format, long vlist) {
        if (Checks.CHECKS) {
            Checks.checkNT1(format);
            Checks.checkPointer(vlist);
        }
        return Stdio.nvsscanf(MemoryUtil.memAddress(buffer), MemoryUtil.memAddress(format), vlist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int vsscanf(ByteBuffer buffer, CharSequence format, long vlist) {
        if (Checks.CHECKS) {
            Checks.checkPointer(vlist);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer formatEncoded = stack.ASCII(format);
            int n = Stdio.nvsscanf(MemoryUtil.memAddress(buffer), MemoryUtil.memAddress(formatEncoded), vlist);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    private static native long sprintf();

    private static native long snprintf();

    public static native int nvsnprintf(long var0, long var2, long var4, long var6);

    public static int vsnprintf(ByteBuffer buffer, ByteBuffer format, long vlist) {
        if (Checks.CHECKS) {
            Checks.checkNT1(format);
            Checks.checkPointer(vlist);
        }
        return Stdio.nvsnprintf(MemoryUtil.memAddressSafe(buffer), Checks.remainingSafe(buffer), MemoryUtil.memAddress(format), vlist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int vsnprintf(ByteBuffer buffer, CharSequence format, long vlist) {
        if (Checks.CHECKS) {
            Checks.checkPointer(vlist);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer formatEncoded = stack.ASCII(format);
            int n = Stdio.nvsnprintf(MemoryUtil.memAddressSafe(buffer), Checks.remainingSafe(buffer), MemoryUtil.memAddress(formatEncoded), vlist);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    static {
        Library.initialize();
        sscanf = Stdio.sscanf();
        sprintf = Stdio.sprintf();
        snprintf = Stdio.snprintf();
    }
}

